/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.util;

import com.google.common.base.Function;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.collections.setlist.SetLists;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.exporter.CXTExporter;
import java.io.File;
import java.util.Iterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.ujmp.core.booleanmatrix.BooleanMatrix;

public class OWLUtil {
    public static final String toString(OWLClassExpression classExpression) {
        if (classExpression.isOWLNothing()) {
            return "\u22a5";
        }
        if (classExpression.isOWLThing()) {
            return "\u22a4";
        }
        StringBuilder s = new StringBuilder();
        if (classExpression instanceof OWLClass) {
            OWLClass c = (OWLClass)classExpression;
            s.append(c.toString().substring(1, c.toString().length() - 1));
        } else if (classExpression instanceof OWLObjectComplementOf) {
            OWLObjectComplementOf c = (OWLObjectComplementOf)classExpression;
            s.append("\u00ac");
            s.append(OWLUtil.toString(c.getOperand()));
        } else if (classExpression instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf c = (OWLObjectIntersectionOf)classExpression;
            if (c.getOperands().isEmpty()) {
                return "\u22a4";
            }
            if (c.getOperands().size() == 1) {
                return OWLUtil.toString((OWLClassExpression)c.getOperands().iterator().next());
            }
            s.append("(");
            Iterator i = c.getOperands().iterator();
            s.append(OWLUtil.toString((OWLClassExpression)i.next()));
            while (i.hasNext()) {
                s.append("\u2293" + OWLUtil.toString((OWLClassExpression)i.next()));
            }
            s.append(")");
        } else if (classExpression instanceof OWLObjectUnionOf) {
            OWLObjectUnionOf c = (OWLObjectUnionOf)classExpression;
            if (c.getOperands().isEmpty()) {
                return "\u22a5";
            }
            if (c.getOperands().size() == 1) {
                return OWLUtil.toString((OWLClassExpression)c.getOperands().iterator().next());
            }
            s.append("(");
            Iterator i = c.getOperands().iterator();
            s.append(OWLUtil.toString((OWLClassExpression)i.next()));
            while (i.hasNext()) {
                s.append("\u2294" + OWLUtil.toString((OWLClassExpression)i.next()));
            }
            s.append(")");
        } else if (classExpression instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom c = (OWLObjectSomeValuesFrom)classExpression;
            s.append("\u2203");
            s.append(OWLUtil.toString((OWLObjectPropertyExpression)c.getProperty()));
            s.append(".");
            s.append(OWLUtil.toString((OWLClassExpression)c.getFiller()));
        } else if (classExpression instanceof OWLObjectAllValuesFrom) {
            OWLObjectAllValuesFrom c = (OWLObjectAllValuesFrom)classExpression;
            s.append("\u2200");
            s.append(OWLUtil.toString((OWLObjectPropertyExpression)c.getProperty()));
            s.append(".");
            s.append(OWLUtil.toString((OWLClassExpression)c.getFiller()));
        } else if (classExpression instanceof OWLObjectHasSelf) {
            OWLObjectHasSelf c = (OWLObjectHasSelf)classExpression;
            s.append("\u2203");
            s.append(OWLUtil.toString((OWLObjectPropertyExpression)c.getProperty()));
            s.append(".");
            s.append("Self");
        } else if (classExpression instanceof OWLObjectMinCardinality) {
            OWLObjectMinCardinality c = (OWLObjectMinCardinality)classExpression;
            s.append("\u2265");
            s.append(c.getCardinality());
            s.append(".");
            s.append(OWLUtil.toString((OWLObjectPropertyExpression)c.getProperty()));
            s.append(".");
            s.append(OWLUtil.toString((OWLClassExpression)c.getFiller()));
        } else if (classExpression instanceof OWLObjectMaxCardinality) {
            OWLObjectMaxCardinality c = (OWLObjectMaxCardinality)classExpression;
            s.append("\u2264");
            s.append(c.getCardinality());
            s.append(".");
            s.append(OWLUtil.toString((OWLObjectPropertyExpression)c.getProperty()));
            s.append(".");
            s.append(OWLUtil.toString((OWLClassExpression)c.getFiller()));
        } else if (classExpression instanceof OWLObjectExactCardinality) {
            OWLObjectExactCardinality c = (OWLObjectExactCardinality)classExpression;
            s.append("=");
            s.append(c.getCardinality());
            s.append(".");
            s.append(OWLUtil.toString((OWLObjectPropertyExpression)c.getProperty()));
            s.append(".");
            s.append(OWLUtil.toString((OWLClassExpression)c.getFiller()));
        } else {
            s.append(classExpression.toString());
        }
        return s.toString();
    }

    public static final String toString(OWLObjectPropertyExpression propertyExpression) {
        return propertyExpression.toString().substring(1, propertyExpression.toString().length() - 1);
    }

    public static final String toString(OWLAxiom axiom) {
        StringBuilder s = new StringBuilder();
        if (axiom instanceof OWLSubClassOfAxiom) {
            OWLSubClassOfAxiom a = (OWLSubClassOfAxiom)axiom;
            s.append(OWLUtil.toString(a.getSubClass()));
            s.append("\u2291");
            s.append(OWLUtil.toString(a.getSuperClass()));
        } else if (axiom instanceof OWLEquivalentClassesAxiom) {
            OWLEquivalentClassesAxiom a = (OWLEquivalentClassesAxiom)axiom;
            Iterator i = a.getClassExpressions().iterator();
            if (i.hasNext()) {
                s.append(OWLUtil.toString((OWLClassExpression)i.next()));
                while (i.hasNext()) {
                    s.append("\u2263" + OWLUtil.toString((OWLClassExpression)i.next()));
                }
            }
        } else if (axiom instanceof OWLSubObjectPropertyOfAxiom) {
            OWLSubObjectPropertyOfAxiom a = (OWLSubObjectPropertyOfAxiom)axiom;
            s.append(OWLUtil.toString((OWLObjectPropertyExpression)a.getSubProperty()));
            s.append("\u2291");
            s.append(OWLUtil.toString((OWLObjectPropertyExpression)a.getSuperProperty()));
        } else if (axiom instanceof OWLSubPropertyChainOfAxiom) {
            OWLSubPropertyChainOfAxiom a = (OWLSubPropertyChainOfAxiom)axiom;
            Iterator i = a.getPropertyChain().iterator();
            if (i.hasNext()) {
                s.append(OWLUtil.toString((OWLObjectPropertyExpression)i.next()));
            }
            while (i.hasNext()) {
                s.append("\u25e6");
                s.append(OWLUtil.toString((OWLObjectPropertyExpression)i.next()));
            }
            s.append("\u2291");
            s.append(OWLUtil.toString(a.getSuperProperty()));
        } else {
            s.append(axiom.toString());
        }
        return s.toString();
    }

    public static final String toLaTeX(OWLClassExpression clazz) {
        StringBuilder str = new StringBuilder();
        if (clazz instanceof OWLObjectSomeValuesFrom) {
            str.append("(");
            OWLObjectSomeValuesFrom exrest = (OWLObjectSomeValuesFrom)clazz;
            String r = ((OWLObjectPropertyExpression)exrest.getProperty()).toString();
            r = r.substring(r.indexOf("#") + 1);
            r = r.substring(0, r.length() - 1);
            OWLClassExpression c = (OWLClassExpression)exrest.getFiller();
            str.append("\\exists ");
            str.append(r + ".");
            str.append(OWLUtil.toLaTeX(c));
            str.append(")");
        } else if (clazz instanceof OWLObjectComplementOf) {
            str.append("\\neg(");
            str.append(OWLUtil.toLaTeX(((OWLObjectComplementOf)clazz).getOperand()));
            str.append(")");
        } else if (clazz instanceof OWLObjectAllValuesFrom) {
            OWLObjectAllValuesFrom vr = (OWLObjectAllValuesFrom)clazz;
            str.append("(\\forall ");
            str.append(((OWLObjectPropertyExpression)vr.getProperty()).toString() + ".");
            str.append(OWLUtil.toLaTeX((OWLClassExpression)vr.getFiller()) + ")");
        } else if (clazz instanceof OWLObjectMinCardinality) {
            OWLObjectMinCardinality qgr = (OWLObjectMinCardinality)clazz;
            str.append("(\\geq ");
            str.append(qgr.getCardinality());
            str.append(" " + qgr.getProperty() + ".");
            str.append(OWLUtil.toLaTeX((OWLClassExpression)qgr.getFiller()) + ")");
        } else if (clazz instanceof OWLObjectMaxCardinality) {
            OWLObjectMaxCardinality qlr = (OWLObjectMaxCardinality)clazz;
            str.append("(\\leq ");
            str.append(qlr.getCardinality());
            str.append(" " + qlr.getProperty() + ".");
            str.append(OWLUtil.toLaTeX((OWLClassExpression)qlr.getFiller()) + ")");
        } else if (clazz instanceof OWLObjectExactCardinality) {
            OWLObjectExactCardinality qer = (OWLObjectExactCardinality)clazz;
            str.append("(= ");
            str.append(qer.getCardinality());
            str.append(" " + qer.getProperty() + ".");
            str.append(OWLUtil.toLaTeX((OWLClassExpression)qer.getFiller()) + ")");
        } else if (clazz instanceof OWLObjectHasSelf) {
            OWLObjectHasSelf sr = (OWLObjectHasSelf)clazz;
            str.append("\\exists ");
            str.append(sr.getProperty() + ".");
            str.append("\\mathrm{Self}");
        } else if (clazz instanceof OWLObjectIntersectionOf) {
            str.append("(");
            OWLObjectIntersectionOf conj = (OWLObjectIntersectionOf)clazz;
            if (conj.asConjunctSet().size() == 1) {
                str.append(OWLUtil.toLaTeX((OWLClassExpression)conj.asConjunctSet().iterator().next()));
            }
            boolean first = true;
            for (OWLClassExpression c : conj.asConjunctSet()) {
                if (first) {
                    first = false;
                } else {
                    str.append("\\cap");
                }
                str.append(OWLUtil.toLaTeX(c));
            }
            str.append(")");
        } else if (clazz instanceof OWLClass) {
            OWLClass c = (OWLClass)clazz;
            String string = c.toString();
            string = string.substring(string.indexOf("#") + 1);
            str.append(string.substring(0, string.length() - 1));
        }
        return str.toString();
    }

    public static final MatrixContext<String, String> toLaTeXContext(MatrixContext<OWLNamedIndividual, OWLClassExpression> context) {
        BooleanMatrix matrix = context.matrix();
        SetList<String> domain = SetLists.transform(context.rowHeads(), new Function<OWLNamedIndividual, String>(){

            public final String apply(OWLNamedIndividual input) {
                String string = input.toString();
                string = string.substring(string.indexOf("#") + 1);
                return string.substring(0, string.length() - 1);
            }
        });
        SetList<String> codomain = SetLists.transform(context.colHeads(), new Function<OWLClassExpression, String>(){

            public final String apply(OWLClassExpression input) {
                return OWLUtil.toLaTeX(input);
            }
        });
        MatrixContext<String, String> latexContext = new MatrixContext<String, String>(domain, codomain, matrix, false);
        return latexContext;
    }

    public static final void exportLaTeXContext(MatrixContext<OWLNamedIndividual, OWLClassExpression> context, File outputFile) {
        CXTExporter.export(OWLUtil.toLaTeXContext(context), outputFile);
    }
}

