/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.xml;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.xml.BooleanData;
import conexp.fx.core.xml.BooleanListData;
import conexp.fx.core.xml.CompoundData;
import conexp.fx.core.xml.CompoundListData;
import conexp.fx.core.xml.Data;
import conexp.fx.core.xml.Datatype;
import conexp.fx.core.xml.FloatData;
import conexp.fx.core.xml.FloatListData;
import conexp.fx.core.xml.IntegerData;
import conexp.fx.core.xml.IntegerListData;
import conexp.fx.core.xml.JsoupUtil;
import conexp.fx.core.xml.Key;
import conexp.fx.core.xml.Metadata;
import conexp.fx.core.xml.StringData;
import conexp.fx.core.xml.StringListData;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoup.nodes.Element;

public abstract class AbstractCompoundData
extends Data<Map<String, Data<?>>>
implements Map<String, Data<?>> {
    private static final Function<Element, String> ELEMENT_TO_TEXT_FUNCTION = new Function<Element, String>(){

        public final String apply(Element element) {
            return element.text();
        }
    };

    public AbstractCompoundData(Datatype type, String key) {
        super(type, key, new ConcurrentHashMap());
    }

    public AbstractCompoundData(Datatype type, String key, Map<String, Data<?>> value) {
        super(type, key, new ConcurrentHashMap(value));
    }

    public AbstractCompoundData(Datatype type, String key, Element element, Metadata metadata) throws NullPointerException, IndexOutOfBoundsException {
        super(type, key, AbstractCompoundData.readDataFromElement(element, metadata));
    }

    protected static final synchronized Map<String, Data<?>> readDataFromElement(Element element, Metadata metadata) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        for (Map.Entry<String, Pair<Datatype, Metadata>> entry : metadata.getKeyDatatypeMap().entrySet()) {
            String key = entry.getKey();
            Datatype type = entry.getValue().first();
            Metadata _metadata = entry.getValue().second();
            Element data = JsoupUtil.firstElement(element, Key.toArray(key));
            switch (type) {
                case BOOLEAN: {
                    map.put(key, new BooleanData(key, data.text()));
                    break;
                }
                case INTEGER: {
                    map.put(key, new IntegerData(key, data.text()));
                    break;
                }
                case FLOAT: {
                    map.put(key, new FloatData(key, data.text()));
                    break;
                }
                case STRING: {
                    try {
                        map.put(key, new StringData(key, data.text()));
                    }
                    catch (Exception e) {
                        System.err.println(data);
                        e.printStackTrace();
                    }
                    break;
                }
                case COMPOUND: {
                    map.put(key, new CompoundData(key, data, entry.getValue().second()));
                    break;
                }
                case BOOLEAN_LIST: {
                    map.put(key, new BooleanListData(key, _metadata.getSubkey(), null, AbstractCompoundData.readStringDataFromElement(data, _metadata)));
                    break;
                }
                case INTEGER_LIST: {
                    map.put(key, new IntegerListData(key, _metadata.getSubkey(), null, AbstractCompoundData.readStringDataFromElement(data, _metadata)));
                    break;
                }
                case FLOAT_LIST: {
                    map.put(key, new FloatListData(key, _metadata.getSubkey(), null, AbstractCompoundData.readStringDataFromElement(data, _metadata)));
                    break;
                }
                case STRING_LIST: {
                    map.put(key, new StringListData(key, _metadata.getSubkey(), AbstractCompoundData.readStringDataFromElement(data, _metadata)));
                    break;
                }
                case COMPOUND_LIST: {
                    map.put(key, new CompoundListData(key, _metadata.getSubkey(), data, _metadata));
                }
            }
        }
        return map;
    }

    protected static List<String> readStringDataFromElement(Element element, Metadata metadata) {
        LinkedList<String> list = new LinkedList<String>();
        for (String value : Iterables.transform(JsoupUtil.childrenByTag(element, metadata.getSubkey()), ELEMENT_TO_TEXT_FUNCTION)) {
            list.add(value);
        }
        return Collections.synchronizedList(list);
    }

    @Override
    public final boolean isEmpty() {
        return ((Map)this.value).isEmpty();
    }

    @Override
    public final int size() {
        return ((Map)this.value).size();
    }

    @Override
    public final void clear() {
        ((Map)this.value).clear();
    }

    @Override
    public final boolean containsKey(Object key) {
        return ((Map)this.value).containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return ((Map)this.value).containsValue(value);
    }

    @Override
    public final Data<?> get(Object key) {
        return (Data)((Map)this.value).get(key);
    }

    @Override
    public final Data<?> put(String key, Data<?> value) {
        return ((Map)this.value).put(key, value);
    }

    @Override
    public final void putAll(Map<? extends String, ? extends Data<?>> m) {
        ((Map)this.value).putAll(m);
    }

    @Override
    public final Data<?> remove(Object key) {
        return (Data)((Map)this.value).remove(key);
    }

    @Override
    public final Set<String> keySet() {
        return ((Map)this.value).keySet();
    }

    @Override
    public final Collection<Data<?>> values() {
        return ((Map)this.value).values();
    }

    @Override
    public final Set<Map.Entry<String, Data<?>>> entrySet() {
        return ((Map)this.value).entrySet();
    }
}

