/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class JsoupUtil {
    private static final String USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1309.0 Safari/537.17";
    private static final int CONNECTION_TIMEOUT = 60000;

    public static final Document getDocument(String url) throws MalformedURLException, IOException {
        return JsoupUtil.getDocument(new URL(url));
    }

    public static final Document getDocument(URL url) throws IOException {
        return Jsoup.connect((String)url.toString()).ignoreContentType(true).timeout(60000).userAgent(USER_AGENT).get();
    }

    public static final Element firstElement(Element element, String ... tags) {
        Element _element = element;
        for (String tag : tags) {
            _element = JsoupUtil.firstChildByTag(_element, tag);
        }
        return _element;
    }

    public static final Element firstOrAppendElement(Element element, String ... tags) {
        Element _element = element;
        for (String tag : tags) {
            _element = !JsoupUtil.childrenByTag(_element, tag).iterator().hasNext() ? _element.appendElement(tag) : JsoupUtil.firstChildByTag(_element, tag);
        }
        return _element;
    }

    public static final Iterable<Element> childrenByTag(Element element, final String tag) {
        return Iterables.filter((Iterable)element.children(), (Predicate)new Predicate<Element>(){

            public final boolean apply(Element _element) {
                return _element.tagName().equals(tag);
            }
        });
    }

    public static final Element firstChildByTag(Element element, String tag) {
        return (Element)Iterables.getFirst(JsoupUtil.childrenByTag(element, tag), null);
    }
}

