/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import conexp.fx.core.builder.Requests;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.util.FileFormat;
import conexp.fx.core.xml.Data;
import conexp.fx.core.xml.StringData;
import conexp.fx.core.xml.StringListData;
import conexp.fx.core.xml.XMLFile;
import conexp.fx.gui.assistent.ConstructAssistent;
import conexp.fx.gui.assistent.ExportAssistent;
import conexp.fx.gui.dataset.Dataset;
import conexp.fx.gui.dataset.DatasetView;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.dataset.RDFDataset;
import conexp.fx.gui.dialog.ErrorDialog;
import conexp.fx.gui.dialog.FXDialog;
import conexp.fx.gui.dialog.InfoDialog;
import conexp.fx.gui.task.BlockingExecutor;
import conexp.fx.gui.task.ExecutorStatusBar;
import conexp.fx.gui.task.TimeTask;
import conexp.fx.gui.util.AppUserModelIdUtility;
import conexp.fx.gui.util.FXControls;
import conexp.fx.gui.util.Platform2;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MenuItemBuilder;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class ConExpFX
extends Application {
    public static ConExpFX instance;
    public Stage primaryStage;
    private final StackPane stackPane = new StackPane();
    private final BorderPane rootPane = new BorderPane();
    private final AnchorPane overlayPane = new AnchorPane();
    private final SplitPane contentPane = new SplitPane();
    private final SplitPane splitPane = new SplitPane();
    public final DatasetTreeView treeView = new DatasetTreeView();
    public final ExecutorStatusBar executorStatusBar = new ExecutorStatusBar(this.overlayPane);
    public final BlockingExecutor executor = new BlockingExecutor();
    public final XMLFile configuration = this.initConfiguration();
    public final ListProperty<File> fileHistory = new SimpleListProperty(FXCollections.observableArrayList());
    public File lastDirectory;
    public final ObservableList<MatrixContext<?, ?>> contexts = FXCollections.observableList((List)Lists.transform(Collections3.filter(this.treeView.getDatasets(), dataset -> dataset instanceof FCADataset), dataset -> ((FCADataset)dataset).context));
    public final ObservableList<MatrixContext<?, ?>> orders = FXCollections.observableList(Collections3.filter(this.contexts, context -> context.isHomogen()));

    public static final void main(String[] args) {
        System.setProperty("file.encoding", "UTF-8");
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            AppUserModelIdUtility.setCurrentProcessExplicitAppUserModelID("conexp-fx");
        }
        ConExpFX.launch((String[])args);
    }

    public static final void execute(TimeTask<?> task) {
        ConExpFX.instance.executor.execute(task);
    }

    public static final ExecutorService getThreadPool() {
        return ConExpFX.instance.executor.tpe;
    }

    public final void start(Stage primaryStage) {
        instance = this;
        Platform.setImplicitExit((boolean)true);
        this.primaryStage = primaryStage;
        this.primaryStage.initStyle(StageStyle.DECORATED);
        this.primaryStage.setTitle("Concept Explorer FX");
        this.primaryStage.getIcons().add((Object)new Image(ConExpFX.class.getResourceAsStream("image/conexp-fx.png")));
        this.primaryStage.setScene(new Scene((Parent)this.rootPane, 1280.0, 800.0));
        this.primaryStage.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode().equals((Object)KeyCode.F11)) {
                this.primaryStage.setFullScreen(!this.primaryStage.isFullScreen());
            }
        });
        this.primaryStage.setOnCloseRequest(e -> this.stop());
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        this.primaryStage.setX(bounds.getMinX());
        this.primaryStage.setY(bounds.getMinY());
        this.primaryStage.setWidth(bounds.getWidth());
        this.primaryStage.setHeight(bounds.getHeight());
        this.stackPane.getChildren().addAll((Object[])new Node[]{this.splitPane, this.overlayPane});
        this.overlayPane.setMouseTransparent(true);
        this.rootPane.setCenter((Node)this.stackPane);
        this.rootPane.setBottom((Node)this.executorStatusBar.statusBar);
        this.splitPane.setOrientation(Orientation.HORIZONTAL);
        this.splitPane.getItems().add((Object)this.contentPane);
        new CFXMenuBar();
        this.executorStatusBar.setOnMouseExitedHandler(this.primaryStage.getScene());
        this.executorStatusBar.bindTo(this.executor);
        this.primaryStage.show();
        Platform.runLater(() -> {
            this.splitPane.setDividerPositions(new double[]{0.1618});
            this.readConfiguration();
        });
    }

    private final XMLFile initConfiguration() {
        try {
            File file = new File(System.getProperty("user.home"), ".conexp-fx.xml");
            if (!file.exists()) {
                try {
                    XMLFile.createEmptyConfiguration(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Cannot create file " + file.getAbsolutePath());
                    System.out.println("Creating temporary file instead.");
                    file = new File(File.createTempFile("conexp-fx", "tmp").getParent(), "conexp-fx.xml");
                }
            }
            if (!file.exists()) {
                XMLFile.createEmptyConfiguration(file);
            }
            System.out.println("configuration file: " + file.getAbsolutePath());
            return new XMLFile(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void readConfiguration() {
        if (this.configuration.containsKey("file_history")) {
            this.fileHistory.addAll((Collection)Lists.transform(((Data)this.configuration.get("file_history")).getStringListValue(), File::new));
        }
        if (this.configuration.containsKey("last_directory") && new File(((Data)this.configuration.get("last_directory")).getStringValue()).exists() && new File(((Data)this.configuration.get("last_directory")).getStringValue()).isDirectory()) {
            this.lastDirectory = new File(((Data)this.configuration.get("last_directory")).getStringValue());
        }
        if (this.configuration.containsKey("last_opened_files")) {
            for (String last_opened_file : ((Data)this.configuration.get("last_opened_files")).getStringListValue()) {
                if (!new File(last_opened_file).exists() || !new File(last_opened_file).isFile()) continue;
                this.openFile(FileFormat.of(new File(last_opened_file)));
            }
        }
    }

    private final void writeConfiguration() throws IOException {
        if (this.lastDirectory != null) {
            this.configuration.put("last_directory", new StringData("last_directory", this.lastDirectory.toString()));
        }
        this.configuration.put("last_opened_files", new StringListData("last_opened_files", "last_opened_file", new String[0]));
        for (Dataset d : this.treeView.datasets) {
            if (d.file == null) continue;
            ((Data)this.configuration.get("last_opened_files")).getStringListValue().add(d.file.toString());
        }
        this.configuration.put("file_history", new StringListData("file_history", "file", Lists.transform(this.fileHistory, File::toString)));
        this.configuration.store();
    }

    private final void showOpenFileDialog() {
        Pair<File, FileFormat> ffile = this.showOpenFileDialog("Open Dataset", FileFormat.CXT, FileFormat.CFX, FileFormat.CSVB, FileFormat.NT, FileFormat.CSVT);
        if (ffile != null) {
            this.openFile(ffile);
        }
    }

    public final synchronized Pair<File, FileFormat> showOpenFileDialog(String title, FileFormat ... fileFormats) {
        FileChooser fc = new FileChooser();
        fc.setTitle(title);
        if (this.lastDirectory != null) {
            fc.setInitialDirectory(this.lastDirectory);
        }
        for (FileFormat ff : fileFormats) {
            fc.getExtensionFilters().add((Object)ff.extensionFilter);
        }
        File file = fc.showOpenDialog((Window)this.primaryStage);
        if (file == null) {
            return null;
        }
        FileFormat fileFormat = null;
        for (FileFormat ff : fileFormats) {
            if (!fc.getSelectedExtensionFilter().equals(ff.extensionFilter)) continue;
            fileFormat = ff;
            break;
        }
        if (fileFormat == null) {
            return null;
        }
        this.lastDirectory = file.getParentFile();
        return FileFormat.of(file, fileFormat);
    }

    private void openFile(Pair<File, FileFormat> ffile) {
        this.fileHistory.remove((Object)ffile.first());
        this.fileHistory.add(0, (Object)ffile.first());
        switch (ffile.second()) {
            case CFX: {
                this.treeView.addDataset(new FCADataset<String, String>(null, new Requests.Import.ImportCFX(ffile.first())));
                break;
            }
            case CXT: {
                this.treeView.addDataset(new FCADataset<String, String>(null, new Requests.Import.ImportCXT(ffile.first())));
                break;
            }
            case CSVB: {
                this.treeView.addDataset(new FCADataset<String, String>(null, new Requests.Import.ImportCSVB(ffile.first())));
                break;
            }
            case NT: {
                this.treeView.addDataset(new RDFDataset(ffile.first(), ffile.second()));
                break;
            }
            case CSVT: {
                this.treeView.addDataset(new RDFDataset(ffile.first(), ffile.second()));
            }
        }
    }

    private final void askForUnsavedChanges() {
        this.treeView.getDatasets().forEach(this::askForUnsavedChanges);
    }

    private final void askForUnsavedChanges(Dataset dataset) {
        if (dataset.unsavedChanges.get() && new FXDialog(this.primaryStage, FXDialog.Style.QUESTION, "Unsaved Changes", (String)dataset.id.get() + " has unsaved changes. Do you want to save?", null).showAndWait().result().equals((Object)FXDialog.Answer.YES)) {
            dataset.save();
        }
    }

    public final void stop() {
        this.askForUnsavedChanges();
        try {
            this.writeConfiguration();
            this.primaryStage.close();
            System.exit(0);
        }
        catch (IOException e) {
            System.err.println("Could not write configuration to " + this.configuration.getFile());
            e.printStackTrace();
            this.primaryStage.close();
            System.exit(1);
        }
    }

    public final class DatasetTreeView
    extends TreeView<Control> {
        private final ObservableList<Dataset> datasets = FXCollections.observableArrayList();
        public final ObjectProperty<Dataset> activeDataset = new SimpleObjectProperty(null);
        private final ToolBar toolBar = new ToolBar();

        private DatasetTreeView() {
            Button newButton = new Button("New", (Node)FXControls.newImageView("image/16x16/new_page.png"));
            newButton.setOnAction(e -> new ConstructAssistent().showAndWait());
            Button openButton = new Button("Open", (Node)FXControls.newImageView("image/16x16/folder.png"));
            openButton.setOnAction(e -> ConExpFX.this.showOpenFileDialog());
            this.toolBar.getItems().addAll((Object[])new Node[]{newButton, openButton});
            this.setRoot(new TreeItem());
            this.setShowRoot(false);
            ((MultipleSelectionModel)this.selectionModelProperty().get()).setSelectionMode(SelectionMode.MULTIPLE);
            this.activeDataset.bind((ObservableValue)Bindings.createObjectBinding(() -> {
                Dataset active = null;
                Iterator it = this.getSelectionModel().getSelectedItems().iterator();
                if (it.hasNext()) {
                    TreeItem selectedItem = (TreeItem)it.next();
                    if (selectedItem.isLeaf()) {
                        selectedItem = selectedItem.getParent();
                    }
                    if (selectedItem instanceof Dataset.DatasetTreeItem) {
                        active = ((Dataset.DatasetTreeItem)selectedItem).getDataset();
                        while (it.hasNext()) {
                            selectedItem = (TreeItem)it.next();
                            if (selectedItem.isLeaf()) {
                                selectedItem = selectedItem.getParent();
                            }
                            if (!(selectedItem instanceof Dataset.DatasetTreeItem) || active.equals(((Dataset.DatasetTreeItem)selectedItem).getDataset())) continue;
                            active = null;
                            break;
                        }
                    }
                }
                return active;
            }, (Observable[])new Observable[]{this.getSelectionModel().getSelectedItems()}));
            this.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<TreeItem<Control>>(){

                public synchronized void onChanged(ListChangeListener.Change<? extends TreeItem<Control>> c) {
                    while (c.next()) {
                        if (c.wasAdded()) {
                            c.getAddedSubList().stream().filter(item -> item instanceof DatasetView.DatasetViewTreeItem).map(item -> (DatasetView.DatasetViewTreeItem)((Object)item)).forEach(item -> ConExpFX.this.contentPane.getItems().add((Object)item.getDatasetView().getContentNode()));
                        }
                        if (!c.wasRemoved()) continue;
                        c.getRemoved().stream().filter(item -> item instanceof DatasetView.DatasetViewTreeItem).map(item -> (DatasetView.DatasetViewTreeItem)((Object)item)).forEach(item -> ConExpFX.this.contentPane.getItems().remove((Object)item.getDatasetView().getContentNode()));
                    }
                    Platform2.runOnFXThreadAndWaitTryCatch(() -> {
                        double pos = ConExpFX.this.contentPane.getItems().isEmpty() ? 0.0 : 1.0 / (double)ConExpFX.this.contentPane.getItems().size();
                        for (int i = 0; i < ConExpFX.this.contentPane.getItems().size(); ++i) {
                            ConExpFX.this.contentPane.setDividerPosition(i, pos * (double)(i + 1));
                        }
                    });
                }
            });
            this.datasets.addListener((ListChangeListener)new ListChangeListener<Dataset>(){

                public void onChanged(ListChangeListener.Change<? extends Dataset> c) {
                    while (c.next()) {
                        if (c.wasAdded()) {
                            c.getAddedSubList().forEach(dataset -> dataset.addToTree(DatasetTreeView.this));
                        }
                        if (!c.wasRemoved()) continue;
                        c.getRemoved().forEach(dataset -> {
                            dataset.views.forEach(view -> ConExpFX.this.contentPane.getItems().remove((Object)view.getContentNode()));
                            TreeItem<Control> parentItem = DatasetTreeView.this.getParentItem((Dataset)dataset);
                            parentItem.getChildren().parallelStream().filter(treeItem -> treeItem instanceof Dataset.DatasetTreeItem).map(treeItem -> (Dataset.DatasetTreeItem)((Object)((Object)treeItem))).filter(treeItem -> treeItem.getDataset().equals(dataset)).findAny().ifPresent(treeItem -> parentItem.getChildren().remove((Object)treeItem));
                        });
                    }
                }
            });
            ConExpFX.this.splitPane.getItems().add((Object)new BorderPane((Node)this, (Node)this.toolBar, null, null, null));
        }

        public final ObservableList<Dataset> getDatasets() {
            return this.datasets;
        }

        public final ObjectProperty<Dataset> getActiveDataset() {
            return this.activeDataset;
        }

        public final void addDataset(Dataset dataset) {
            Platform2.runOnFXThread(() -> this.datasets.add((Object)dataset));
        }

        public final void close(Dataset dataset) {
            ConExpFX.this.askForUnsavedChanges(dataset);
            this.getSelectionModel().clearSelection();
            this.datasets.remove((Object)dataset);
            ConExpFX.execute(TimeTask.create(dataset, "Closing " + (String)dataset.id.get(), () -> Platform2.runOnFXThread(() -> ConExpFX.this.executor.cancel(dataset))));
        }

        public final void closeActiveDataset() {
            if (this.activeDataset.isNotNull().get()) {
                this.close((Dataset)this.activeDataset.get());
            }
        }

        public final TreeItem<Control> getParentItem(Dataset dataset) {
            if (dataset.parent != null) {
                return dataset.parent.treeItem;
            }
            return this.getRoot();
        }
    }

    private final class CFXMenuBar {
        private final MenuBar menuBar = new MenuBar();
        private final Menu contextMenu = new Menu("_Context");
        private final Menu viewMenu = new Menu("_View");
        private final Menu helpMenu = new Menu("?");

        private CFXMenuBar() {
            HBox.setHgrow((Node)this.menuBar, (Priority)Priority.ALWAYS);
            this.buildContextMenu();
            this.buildViewMenu();
            this.buildHelpMenu();
            this.menuBar.getMenus().addAll((Object[])new Menu[]{this.contextMenu, this.viewMenu, this.helpMenu});
            this.menuBar.setUseSystemMenuBar(true);
            ConExpFX.this.rootPane.setTop((Node)this.menuBar);
        }

        private final void buildViewMenu() {
            this.viewMenu.getItems().add((Object)FXControls.newMenuItem("Fullscreen", "image/16x16/new_page.png", (EventHandler<ActionEvent>)((EventHandler)e -> ConExpFX.this.primaryStage.setFullScreen(!ConExpFX.this.primaryStage.isFullScreen()))));
        }

        private final void buildContextMenu() {
            MenuItem newMenuItem = FXControls.newMenuItem("New", "image/16x16/new_page.png", (EventHandler<ActionEvent>)((EventHandler)e -> new ConstructAssistent().showAndWait()));
            MenuItem openMenuItem = FXControls.newMenuItem("Open", "image/16x16/folder.png", (EventHandler<ActionEvent>)((EventHandler)e -> ConExpFX.this.showOpenFileDialog()));
            final MenuItem saveMenuItem = FXControls.newMenuItem("Save", "image/16x16/save.png", true, (EventHandler<ActionEvent>)((EventHandler)e -> ((Dataset)ConExpFX.this.treeView.getActiveDataset().get()).save()));
            final MenuItem saveAsMenuItem = FXControls.newMenuItem("Save As", "image/16x16/save.png", true, (EventHandler<ActionEvent>)((EventHandler)e -> ((Dataset)ConExpFX.this.treeView.getActiveDataset().get()).saveAs()));
            final MenuItem exportMenuItem = FXControls.newMenuItem("Export", "image/16x16/briefcase.png", true, (EventHandler<ActionEvent>)((EventHandler)e -> {
                if (ConExpFX.this.treeView.getActiveDataset().get() instanceof FCADataset) {
                    new ExportAssistent(ConExpFX.this.primaryStage, (FCADataset)ConExpFX.this.treeView.getActiveDataset().get()).showAndWait();
                }
            }));
            final MenuItem closeMenuItem = FXControls.newMenuItem("Close", "image/16x16/delete.png", true, (EventHandler<ActionEvent>)((EventHandler)e -> ConExpFX.this.treeView.closeActiveDataset()));
            final Menu historyMenu = new Menu("History", (Node)FXControls.newImageView("image/16x16/clock.png"));
            MenuItem exitMenuItem = FXControls.newMenuItem("Exit", "image/16x16/delete.png", (EventHandler<ActionEvent>)((EventHandler)e -> ConExpFX.this.stop()));
            ConExpFX.this.treeView.getActiveDataset().addListener((ChangeListener)new ChangeListener<Dataset>(){

                public final void changed(ObservableValue<? extends Dataset> observable, Dataset oldSelectedTab, Dataset newSelectedTab) {
                    Platform.runLater(() -> {
                        saveMenuItem.disableProperty().unbind();
                        if (newSelectedTab == null) {
                            saveMenuItem.setDisable(true);
                            saveAsMenuItem.setDisable(true);
                            exportMenuItem.setDisable(true);
                            closeMenuItem.setDisable(true);
                        } else {
                            saveMenuItem.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !newSelectedTab.unsavedChanges.get(), (Observable[])new Observable[]{newSelectedTab.unsavedChanges}));
                            saveAsMenuItem.setDisable(false);
                            exportMenuItem.setDisable(false);
                            closeMenuItem.setDisable(false);
                        }
                    });
                }
            });
            historyMenu.disableProperty().bind((ObservableValue)ConExpFX.this.fileHistory.emptyProperty());
            ConExpFX.this.fileHistory.addListener((ListChangeListener)new ListChangeListener<File>(){

                public final void onChanged(ListChangeListener.Change<? extends File> c) {
                    historyMenu.getItems().clear();
                    historyMenu.getItems().addAll(Collections2.transform(ConExpFX.this.fileHistory, file -> MenuItemBuilder.create().text(file.toString()).onAction(e -> Platform.runLater(() -> {
                        if (file.exists() && file.isFile()) {
                            ConExpFX.this.openFile(FileFormat.of(file));
                        }
                    })).build()));
                }
            });
            this.contextMenu.getItems().addAll((Object[])new MenuItem[]{newMenuItem, openMenuItem, saveMenuItem, saveAsMenuItem, exportMenuItem, closeMenuItem, new SeparatorMenuItem(), historyMenu, new SeparatorMenuItem(), exitMenuItem});
        }

        private final void buildHelpMenu() {
            if (Desktop.isDesktopSupported()) {
                MenuItem helpMenuItem = FXControls.newMenuItem("Help", "image/16x16/help.png", (EventHandler<ActionEvent>)((EventHandler)ev -> {
                    try {
                        Desktop.getDesktop().browse(new URI("http://lat.inf.tu-dresden.de/~francesco/conexp-fx/conexp-fx.html"));
                    }
                    catch (Exception e) {
                        new ErrorDialog(ConExpFX.this.primaryStage, e).showAndWait();
                    }
                }));
                this.helpMenu.getItems().add((Object)helpMenuItem);
            }
            MenuItem infoMenuItem = FXControls.newMenuItem("Info", "image/16x16/info.png", (EventHandler<ActionEvent>)((EventHandler)e -> new InfoDialog(ConExpFX.this).showAndWait()));
            this.helpMenu.getItems().addAll((Object[])new MenuItem[]{infoMenuItem});
        }
    }
}

