/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.assistent;

import com.google.common.base.Function;
import conexp.fx.gui.assistent.AssistentPage;
import conexp.fx.gui.util.ColorScheme;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.InsetsBuilder;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SceneBuilder;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderPaneBuilder;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.StackPaneBuilder;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradientBuilder;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.paint.StopBuilder;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.scene.text.FontBuilder;
import javafx.scene.text.Text;
import javafx.scene.text.TextBuilder;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageBuilder;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class Assistent<T>
extends AssistentPage<T> {
    protected final int width = 500;
    protected final int height = 700;
    protected final Stage stage = StageBuilder.create().build();
    protected final BorderPane pane = BorderPaneBuilder.create().build();
    protected final Text title = TextBuilder.create().font(FontBuilder.create().size(20.0).build()).build();
    protected final Text text = TextBuilder.create().font(FontBuilder.create().size(16.0).build()).wrappingWidth(450.0).build();
    protected final Map<String, AssistentPage<?>> availablePages = new ConcurrentHashMap();
    protected final ObjectProperty<AssistentPage<?>> currentPage = new SimpleObjectProperty((Object)this);
    protected final ObjectProperty<Object> currentResultProperty = new SimpleObjectProperty();
    protected final StringProperty currentNextPageIdProperty = new SimpleStringProperty();
    protected final ListProperty<AssistentPage<?>> previousPages = new SimpleListProperty(FXCollections.observableArrayList());
    protected final Stage owner;

    public Assistent(Stage owner, String stageTitle, String title, String text, Node content, Function<T, String> nextPageIdFunction) {
        super(title, text, content, nextPageIdFunction);
        this.owner = owner;
        this.stage.setTitle(stageTitle);
        this.stage.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode().equals((Object)KeyCode.ESCAPE)) {
                this.stage.close();
            }
        });
    }

    protected void initialize() {
        this.contentProperty.set((Object)this.createInitialNode());
        if (this.owner != null) {
            this.stage.initOwner((Window)this.owner);
        }
        this.stage.initStyle(StageStyle.UTILITY);
        this.stage.initModality(Modality.WINDOW_MODAL);
        this.stage.setScene(SceneBuilder.create().width(500.0).height(700.0).root((Parent)this.pane).build());
        this.createPages();
        this.createTop();
        this.createBottom();
        this.title.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                return (String)((AssistentPage)Assistent.this.currentPage.get()).titleProperty.get();
            }
        });
        this.text.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                return (String)((AssistentPage)Assistent.this.currentPage.get()).textProperty.get();
            }
        });
        this.pane.centerProperty().bind((ObservableValue)new ObjectBinding<Node>(){

            protected Node computeValue() {
                return (Node)((AssistentPage)Assistent.this.currentPage.get()).contentProperty.get();
            }
        });
        this.currentPage.set((Object)this);
        this.currentResultProperty.bind(((AssistentPage)this.currentPage.get()).resultProperty);
        this.currentNextPageIdProperty.bind((ObservableValue)((AssistentPage)this.currentPage.get()).nextPageIdBinding);
    }

    public void showAndWait() {
        this.stage.showAndWait();
    }

    protected abstract Node createInitialNode();

    protected abstract void createPages();

    protected final void next() {
        ((AssistentPage)this.currentPage.get()).onNext();
        this.previousPages.add(this.currentPage.get());
        if (((AssistentPage)this.currentPage.get()).nextPageIdBinding.get() != null) {
            this.currentPage.set(this.availablePages.get(((AssistentPage)this.currentPage.get()).nextPageIdBinding.get()));
            this.currentResultProperty.bind(((AssistentPage)this.currentPage.get()).resultProperty);
            this.currentNextPageIdProperty.bind((ObservableValue)((AssistentPage)this.currentPage.get()).nextPageIdBinding);
        } else {
            this.stage.close();
        }
    }

    protected final void previous() {
        this.currentPage.set(this.previousPages.remove(this.previousPages.size() - 1));
        this.currentResultProperty.bind(((AssistentPage)this.currentPage.get()).resultProperty);
        this.currentNextPageIdProperty.bind((ObservableValue)((AssistentPage)this.currentPage.get()).nextPageIdBinding);
    }

    protected final void cancel() {
        this.stage.close();
    }

    protected final void createTop() {
        Rectangle background = ((RectangleBuilder)RectangleBuilder.create().fill((Paint)LinearGradientBuilder.create().startX(0.0).startY(0.0).endX(0.0).endY(1.0).cycleMethod(CycleMethod.NO_CYCLE).proportional(true).stops(new Stop[]{StopBuilder.create().color(ColorScheme.JAVA_FX.getColor(4)).offset(0.0).build(), StopBuilder.create().color(Color.WHITE).offset(1.0).build()}).build())).height(80.0).width(500.0).build();
        this.pane.setTop((Node)((StackPaneBuilder)StackPaneBuilder.create().children(new Node[]{background, ((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().alignment(Pos.TOP_LEFT).padding(InsetsBuilder.create().top(10.0).left(10.0).build())).children(new Node[]{this.title, this.text})).build()})).build());
    }

    protected final void createBottom() {
        Rectangle background = ((RectangleBuilder)RectangleBuilder.create().fill((Paint)LinearGradientBuilder.create().startX(0.0).startY(0.0).endX(0.0).endY(1.0).cycleMethod(CycleMethod.NO_CYCLE).proportional(true).stops(new Stop[]{StopBuilder.create().color(Color.LIGHTGRAY).offset(1.0).build(), StopBuilder.create().color(Color.WHITE).offset(0.0).build()}).build())).height(50.0).width(500.0).build();
        Button cancel = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("Cancel")).minHeight(20.0)).minWidth(100.0)).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Assistent.this.cancel();
            }
        })).build();
        Button previous = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("< Previous")).minHeight(20.0)).minWidth(100.0)).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Assistent.this.previous();
            }
        })).build();
        previous.disableProperty().bind((ObservableValue)new BooleanBinding(){

            protected boolean computeValue() {
                return Assistent.this.previousPages.isEmpty();
            }
        });
        Button next = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("Next >")).minHeight(20.0)).minWidth(100.0)).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Assistent.this.next();
            }
        })).build();
        next.disableProperty().bind((ObservableValue)new BooleanBinding(){

            protected boolean computeValue() {
                return Assistent.this.currentResultProperty.isNull().get();
            }
        });
        next.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                if (Assistent.this.currentResultProperty.isNotNull().get() && Assistent.this.currentNextPageIdProperty.isNull().get()) {
                    return "Finish";
                }
                return "Next >";
            }
        });
        this.pane.setBottom((Node)((StackPaneBuilder)StackPaneBuilder.create().children(new Node[]{background, ((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_RIGHT).spacing(10.0).padding(InsetsBuilder.create().right(30.0).build())).children(new Node[]{cancel, previous, next})).build()})).build());
    }
}

