/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.assistent;

import com.google.common.base.Function;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;

public abstract class AssistentPage<T> {
    public final StringProperty titleProperty;
    public final StringProperty textProperty;
    public final ObjectProperty<Node> contentProperty;
    public final ObjectProperty<T> resultProperty = new SimpleObjectProperty();
    public final StringBinding nextPageIdBinding;

    public AssistentPage(String title, String text, Node content, final Function<T, String> nextPageIdFunction) {
        this.titleProperty = new SimpleStringProperty(title);
        this.textProperty = new SimpleStringProperty(text);
        this.contentProperty = new SimpleObjectProperty((Object)content);
        this.nextPageIdBinding = new StringBinding(){
            {
                super.bind(new Observable[]{AssistentPage.this.resultProperty});
            }

            protected String computeValue() {
                if (nextPageIdFunction == null || AssistentPage.this.resultProperty.isNull().get()) {
                    return null;
                }
                return (String)nextPageIdFunction.apply(AssistentPage.this.resultProperty.get());
            }
        };
    }

    protected abstract void onNext();
}

