/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.assistent;

import conexp.fx.core.builder.Request;
import conexp.fx.core.builder.Requests;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.dl.Constructor;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.assistent.Assistent;
import conexp.fx.gui.dataset.DLDataset;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.task.TimeTask;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import jfxtras.scene.control.ListSpinner;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;

public class InducedContextAssistent
extends Assistent<Result> {
    private final DLDataset dataset;
    private final ListSpinner<Integer> roleDepthSpinner = new ListSpinner(0, 3);
    private final ListSpinner<Integer> maxCardinalitySpinner = new ListSpinner(1, 10);
    private final ListView<Constructor> constructorListView = new ListView(FXCollections.observableList(Arrays.asList(Constructor.values())));

    public InducedContextAssistent(DLDataset dataset) {
        super(ConExpFX.instance.primaryStage, "Induced Context Wizard", "Description Logic", "Select Description Logic Constructors", null, r -> null);
        this.dataset = dataset;
        this.initialize();
        this.resultProperty.set((Object)new Result());
    }

    @Override
    protected Node createInitialNode() {
        BorderPane pane = new BorderPane();
        pane.setPadding(new Insets(4.0));
        this.roleDepthSpinner.setValue((Object)1);
        this.maxCardinalitySpinner.setValue((Object)3);
        Label roleDepthLabel = new Label("Role Depth");
        roleDepthLabel.setPadding(new Insets(4.0));
        Label maxCardinalityLabel = new Label("Maximal Cardinality in Number Restrictions");
        maxCardinalityLabel.setPadding(new Insets(4.0));
        Label constructorLabel = new Label("Constructors");
        constructorLabel.setPadding(new Insets(4.0, 4.0, 1.0, 4.0));
        roleDepthLabel.setMinWidth(100.0);
        maxCardinalityLabel.setMinWidth(100.0);
        roleDepthLabel.minWidthProperty().bind((ObservableValue)maxCardinalityLabel.widthProperty());
        HBox rbox = new HBox(new Node[]{roleDepthLabel, this.roleDepthSpinner});
        HBox cbox = new HBox(new Node[]{maxCardinalityLabel, this.maxCardinalitySpinner});
        VBox vbox = new VBox(new Node[]{rbox, cbox, constructorLabel, this.constructorListView});
        pane.setCenter((Node)vbox);
        this.constructorListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.constructorListView.getSelectionModel().select((Object)Constructor.CONJUNCTION);
        this.constructorListView.getSelectionModel().select((Object)Constructor.EXISTENTIAL_RESTRICTION);
        return pane;
    }

    @Override
    protected void createPages() {
    }

    @Override
    protected void onNext() {
        ((Result)this.resultProperty.get()).selectedRoleDepth = (Integer)this.roleDepthSpinner.getValue();
        ((Result)this.resultProperty.get()).selectedMaxCardinality = (Integer)this.maxCardinalitySpinner.getValue();
        ((Result)this.resultProperty.get()).selectedConstructors = (Constructor[])this.constructorListView.getSelectionModel().getSelectedItems().toArray((Object[])new Constructor[0]);
        ConExpFX.instance.executor.execute(new TimeTask<Void>("Creating new Induced Context"){

            protected Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                final Context inducedContext = ((InducedContextAssistent)InducedContextAssistent.this).dataset.interpretation.getInducedContext((Collection<IRI>)((InducedContextAssistent)InducedContextAssistent.this).dataset.interpretation.getDomain(), (int)((Result)InducedContextAssistent.this.resultProperty.get()).selectedRoleDepth, (int)((Result)InducedContextAssistent.this.resultProperty.get()).selectedMaxCardinality, ((Result)InducedContextAssistent.this.resultProperty.get()).selectedConstructors);
                ConExpFX.instance.treeView.addDataset(new FCADataset<IRI, OWLClassExpression>(InducedContextAssistent.this.dataset, new Request<IRI, OWLClassExpression>(Requests.Type.INDUCED_CONTEXT, Requests.Source.NULL){

                    @Override
                    public MatrixContext<IRI, OWLClassExpression> createContext() {
                        MatrixContext<IRI, OWLClassExpression> cxt = new MatrixContext<IRI, OWLClassExpression>(false);
                        return cxt;
                    }

                    @Override
                    public void setContent() {
                        this.context.rowHeads().addAll(inducedContext.rowHeads());
                        this.context.colHeads().addAll(inducedContext.colHeads());
                        this.context.addAll(inducedContext);
                    }
                }));
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
    }

    public static class Result {
        public Integer selectedRoleDepth;
        public Integer selectedMaxCardinality;
        public Constructor[] selectedConstructors;
    }
}

