/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.assistent;

import com.google.common.collect.Collections2;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.assistent.Assistent;
import conexp.fx.gui.dataset.RDFDataset;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.semanticweb.owlapi.model.IRI;

public class ModelAssistent
extends Assistent<Result> {
    private final RDFDataset dataset;
    final ListView<IRI> conceptListView = new ListView();
    final ListView<IRI> roleListView = new ListView();
    final ChoiceBox<IRI> isaRoleChoiceBox = new ChoiceBox();

    public ModelAssistent(RDFDataset dataset) {
        super(ConExpFX.instance.primaryStage, "Model Wizard", "Select Model Signature", "Extract a Model from a Dataset of RDF Triples (" + dataset.file.getName() + ")", null, r -> null);
        this.dataset = dataset;
        this.initialize();
        this.resultProperty.set((Object)new Result());
        Platform.runLater(() -> {
            Optional<IRI> typeRole = dataset.getRoles().parallelStream().filter(role -> role.toString().contains("type")).findAny();
            if (typeRole.isPresent()) {
                this.isaRoleChoiceBox.getSelectionModel().select((Object)typeRole.get());
            } else {
                this.isaRoleChoiceBox.getSelectionModel().selectFirst();
            }
        });
    }

    @Override
    public void showAndWait() {
        this.stage.showAndWait();
    }

    @Override
    protected void onNext() {
        ((Result)this.resultProperty.get()).selectedConceptNames = this.conceptListView.getSelectionModel().getSelectedItems();
        ((Result)this.resultProperty.get()).selectedRoleNames = this.roleListView.getSelectionModel().getSelectedItems();
        ((Result)this.resultProperty.get()).selectedIsARoleName = (IRI)this.isaRoleChoiceBox.getSelectionModel().getSelectedItem();
        this.dataset.createDLModel((List<IRI>)this.conceptListView.getSelectionModel().getSelectedItems(), (List<IRI>)this.roleListView.getSelectionModel().getSelectedItems(), (IRI)this.isaRoleChoiceBox.getSelectionModel().getSelectedItem());
    }

    @Override
    protected Node createInitialNode() {
        BorderPane pane = new BorderPane();
        pane.setPadding(new Insets(4.0));
        Label isARoleLabel = new Label("IS-A Role Name");
        isARoleLabel.setPadding(new Insets(4.0));
        Label conceptLabel = new Label("Concept Names");
        conceptLabel.setPadding(new Insets(4.0, 4.0, 1.0, 4.0));
        Label roleLabel = new Label("Role Names");
        roleLabel.setPadding(new Insets(4.0, 4.0, 1.0, 4.0));
        this.conceptListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.roleListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        try {
            this.isaRoleChoiceBox.setItems(FXCollections.observableArrayList(this.dataset.getRoles()));
        }
        catch (NullPointerException e) {
            System.out.println();
        }
        HBox rbox = new HBox(new Node[]{isARoleLabel, this.isaRoleChoiceBox});
        VBox vbox = new VBox(new Node[]{rbox, conceptLabel, this.conceptListView, roleLabel, this.roleListView});
        pane.setCenter((Node)vbox);
        this.isaRoleChoiceBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            List concepts = this.dataset.getTriples().parallelStream().filter(triple -> IRI.create((String)triple.getPredicate().stringValue()).equals(newValue)).map(triple -> IRI.create((String)triple.getObject().stringValue())).distinct().sorted().collect(Collectors.toList());
            this.conceptListView.setItems(FXCollections.observableArrayList(concepts));
            this.roleListView.setItems(FXCollections.observableArrayList((Collection)Collections2.filter(this.dataset.getRoles(), role -> !role.equals(newValue))));
            this.conceptListView.getSelectionModel().selectAll();
            this.roleListView.getSelectionModel().selectAll();
        });
        return pane;
    }

    @Override
    protected void createPages() {
    }

    public static class Result {
        public List<IRI> selectedConceptNames;
        public List<IRI> selectedRoleNames;
        public IRI selectedIsARoleName;
    }
}

