/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.cellpane;

import conexp.fx.core.collections.IntPair;
import conexp.fx.core.util.IdGenerator;
import conexp.fx.gui.cellpane.CellPane;
import conexp.fx.gui.cellpane.Constants;
import conexp.fx.gui.cellpane.TransitionType;
import conexp.fx.gui.util.ColorScheme;
import conexp.fx.gui.util.Platform2;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.animation.FadeTransitionBuilder;
import javafx.animation.FillTransition;
import javafx.animation.FillTransitionBuilder;
import javafx.animation.TranslateTransition;
import javafx.animation.TranslateTransitionBuilder;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadowBuilder;
import javafx.scene.effect.Effect;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBuilder;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;

public abstract class Cell<TCell extends Cell<TCell, TCellPane>, TCellPane extends CellPane<TCellPane, TCell>> {
    public static final DataFormat CELL_COORDINATES_DATA_FORMAT = new DataFormat(new String[]{"CellCoordinates"});
    public Color dehighlightColor = Color.TRANSPARENT;
    protected final TCellPane cellPane;
    public final ReadOnlyLongProperty id = new ReadOnlyLongWrapper(IdGenerator.getNextId()).getReadOnlyProperty();
    public final ReadOnlyObjectProperty<IntPair> gridCoordinates;
    public final ObjectBinding<IntPair> contentCoordinates;
    protected final ObjectBinding<IntPair> snapToCoordinates;
    protected final ObservableList<IntPair> scrollDeltaCoordinatesQueue = FXCollections.observableList(Collections.synchronizedList(new LinkedList()));
    public final DoubleProperty width = new SimpleDoubleProperty();
    public final DoubleProperty height = new SimpleDoubleProperty();
    public final IntegerProperty textSize = new SimpleIntegerProperty();
    public final StringBinding textStyle = new StringBinding(){

        public String computeValue() {
            return "-fx-font-size: " + Cell.this.textSize.get() + ";";
        }
    };
    public final StringProperty textContent = new SimpleStringProperty();
    public final DoubleProperty opacity = new SimpleDoubleProperty();
    public final BooleanProperty highlight = new SimpleBooleanProperty();
    public final BooleanProperty animate = new SimpleBooleanProperty();
    protected final ObjectProperty<CellInteractionPane> interactionPane = new SimpleObjectProperty((Object)new CellInteractionPane());
    public final ObjectProperty<CellContentPane> contentPane = new SimpleObjectProperty((Object)new CellContentPane());
    private boolean runningLoop = false;
    private ObjectProperty<TranslateTransition> translateTransition = new SimpleObjectProperty((Object)TranslateTransitionBuilder.create().build());
    private ObjectProperty<FillTransition> fillTransition = new SimpleObjectProperty((Object)FillTransitionBuilder.create().build());
    private ObjectProperty<FadeTransition> fadeTransition = new SimpleObjectProperty((Object)FadeTransitionBuilder.create().build());
    private ChangeListener<IntPair> snapToCoordinatesChangeListener;
    private ListChangeListener<IntPair> scrollDeltaCoordinatesQueueChangeListener;
    private ChangeListener<IntPair> contentCoordinatesChangeListener;
    private ChangeListener<String> textContentChangeListener;
    private ChangeListener<Number> opacityChangeListener;
    private ChangeListener<Boolean> highlightChangeListener;
    private ChangeListener<TranslateTransition> translateTransitionChangeListener;
    private ChangeListener<FillTransition> fillTransitionChangeListener;
    private ChangeListener<FadeTransition> fadeTransitionChangeListener;
    private EventHandler<MouseEvent> mouseEnteredEventHandler;
    private EventHandler<MouseEvent> mouseExitedEventHandler;
    private EventHandler<MouseEvent> dragDetectedEventHandler;
    private EventHandler<DragEvent> dragOverEventHandler;
    private EventHandler<DragEvent> dragEnteredEventHandler;
    private EventHandler<DragEvent> dragExitedEventHandler;
    private EventHandler<DragEvent> dragDroppedEventHandler;
    private EventHandler<DragEvent> dragDoneEventHandler;
    private ChangeListener<IntPair> scrollDeltaCoordinatesChangeListener;

    public Cell(final TCellPane cellPane, final int gridRow, final int gridColumn, Pos alignment, TextAlignment textAlignment, boolean rotated, EventHandler<ActionEvent> onFinishedEventHandler, boolean createTextSizeListener) {
        this.cellPane = cellPane;
        this.width.bind((ObservableValue)((CellPane)((Object)cellPane)).columnWidth);
        this.height.bind((ObservableValue)((CellPane)((Object)cellPane)).rowHeight);
        this.textSize.bind((ObservableValue)((CellPane)((Object)cellPane)).textSize);
        this.highlight.bind((ObservableValue)new BooleanBinding((CellPane)((Object)cellPane), gridRow, gridColumn){
            final /* synthetic */ CellPane val$cellPane;
            final /* synthetic */ int val$gridRow;
            final /* synthetic */ int val$gridColumn;
            {
                this.val$cellPane = cellPane;
                this.val$gridRow = n;
                this.val$gridColumn = n2;
                super.bind(new Observable[]{this.val$cellPane.highlightRowMap, this.val$cellPane.highlightColumnMap});
            }

            protected boolean computeValue() {
                Boolean highlightedRow = (Boolean)this.val$cellPane.highlightRowMap.get((Object)this.val$gridRow);
                Boolean highlightedColumn = (Boolean)this.val$cellPane.highlightColumnMap.get((Object)this.val$gridColumn);
                if (this.val$cellPane.highlightConcept.get()) {
                    return highlightedRow != null && highlightedRow != false && highlightedColumn != null && highlightedColumn != false;
                }
                return highlightedRow != null && highlightedRow != false || highlightedColumn != null && highlightedColumn != false;
            }
        });
        this.animate.bind((ObservableValue)((CellPane)((Object)cellPane)).animate);
        this.gridCoordinates = new ReadOnlyObjectWrapper((Object)new IntPair(gridRow, gridColumn)).getReadOnlyProperty();
        this.snapToCoordinates = new ObjectBinding<IntPair>(){
            {
                super.bind(new Observable[]{cellPane.dragRowMap, cellPane.dragColumnMap});
            }

            protected IntPair computeValue() {
                Integer row = (Integer)cellPane.dragRowMap.get((Object)gridRow);
                Integer column = (Integer)cellPane.dragColumnMap.get((Object)gridColumn);
                return IntPair.valueOf(row == null ? gridRow : row, column == null ? gridColumn : column);
            }
        };
        this.contentCoordinates = new ObjectBinding<IntPair>(){
            {
                super.bind(new Observable[]{Cell.this.gridCoordinates, cellPane.minRow, cellPane.minColumn, cellPane.rowMap, cellPane.columnMap});
            }

            protected IntPair computeValue() {
                int gridRow = cellPane.minRow.get() + (Integer)((IntPair)Cell.this.gridCoordinates.get()).x();
                int gridColumn = cellPane.minColumn.get() + (Integer)((IntPair)Cell.this.gridCoordinates.get()).y();
                Integer contentRow = (Integer)cellPane.rowMap.get((Object)gridRow);
                Integer contentColumn = (Integer)cellPane.columnMap.get((Object)gridColumn);
                return IntPair.valueOf(contentRow == null ? gridRow : contentRow, contentColumn == null ? gridColumn : contentColumn);
            }
        };
        this.opacity.bind((ObservableValue)new DoubleBinding((CellPane)((Object)cellPane)){
            final /* synthetic */ CellPane val$cellPane;
            {
                this.val$cellPane = cellPane;
                super.bind(new Observable[]{Cell.this.contentCoordinates, this.val$cellPane.rowOpacityMap, this.val$cellPane.columnOpacityMap});
            }

            protected double computeValue() {
                Double rowOpacity = (Double)this.val$cellPane.rowOpacityMap.get(((IntPair)Cell.this.contentCoordinates.get()).x());
                Double columnOpacity = (Double)this.val$cellPane.columnOpacityMap.get(((IntPair)Cell.this.contentCoordinates.get()).y());
                return Math.min(rowOpacity == null ? 1.0 : rowOpacity, columnOpacity == null ? 1.0 : columnOpacity);
            }
        });
        ((CellContentPane)((Object)this.contentPane.get())).setAlignment(alignment);
        ((CellContentPane)((Object)this.contentPane.get())).setOpacity(0.5);
        ((CellContentPane)((Object)this.contentPane.get())).getChildren().addAll((Object[])new Node[]{((CellContentPane)((Object)this.contentPane.get())).background, ((CellContentPane)((Object)this.contentPane.get())).text});
        ((CellContentPane)((Object)this.contentPane.get())).text.setTextAlignment(textAlignment);
        ((CellContentPane)((Object)this.contentPane.get())).text.styleProperty().bind((ObservableValue)this.textStyle);
        ((CellInteractionPane)((Object)this.interactionPane.get())).setCenter((Node)((CellInteractionPane)((Object)this.interactionPane.get())).interactionRectangle);
        ((CellInteractionPane)((Object)this.interactionPane.get())).minWidthProperty().bind((ObservableValue)this.width);
        ((CellInteractionPane)((Object)this.interactionPane.get())).maxWidthProperty().bind((ObservableValue)this.width);
        ((CellInteractionPane)((Object)this.interactionPane.get())).interactionRectangle.widthProperty().bind((ObservableValue)this.width);
        ((CellInteractionPane)((Object)this.interactionPane.get())).minHeightProperty().bind((ObservableValue)this.height);
        ((CellInteractionPane)((Object)this.interactionPane.get())).maxHeightProperty().bind((ObservableValue)this.height);
        ((CellInteractionPane)((Object)this.interactionPane.get())).interactionRectangle.heightProperty().bind((ObservableValue)this.height);
        if (rotated) {
            ((CellContentPane)((Object)this.contentPane.get())).minWidthProperty().bind((ObservableValue)this.height);
            ((CellContentPane)((Object)this.contentPane.get())).maxWidthProperty().bind((ObservableValue)this.height);
            ((CellContentPane)((Object)this.contentPane.get())).background.widthProperty().bind((ObservableValue)this.height);
            ((CellContentPane)((Object)this.contentPane.get())).minHeightProperty().bind((ObservableValue)this.width);
            ((CellContentPane)((Object)this.contentPane.get())).maxHeightProperty().bind((ObservableValue)this.width);
            ((CellContentPane)((Object)this.contentPane.get())).background.heightProperty().bind((ObservableValue)this.width);
            this.createRotation();
        } else {
            ((CellContentPane)((Object)this.contentPane.get())).minWidthProperty().bind((ObservableValue)this.width);
            ((CellContentPane)((Object)this.contentPane.get())).maxWidthProperty().bind((ObservableValue)this.width);
            ((CellContentPane)((Object)this.contentPane.get())).background.widthProperty().bind((ObservableValue)this.width);
            ((CellContentPane)((Object)this.contentPane.get())).minHeightProperty().bind((ObservableValue)this.height);
            ((CellContentPane)((Object)this.contentPane.get())).maxHeightProperty().bind((ObservableValue)this.height);
            ((CellContentPane)((Object)this.contentPane.get())).background.heightProperty().bind((ObservableValue)this.height);
        }
        ((CellContentPane)((Object)this.contentPane.get())).text.effectProperty().bind((ObservableValue)new ObjectBinding<Effect>(){

            protected Effect computeValue() {
                if (Cell.this.animate.get()) {
                    return DropShadowBuilder.create().radius(1.0).blurType(BlurType.GAUSSIAN).color(Color.ALICEBLUE).spread(1.0).build();
                }
                return null;
            }
        });
        this.createPropertyListeners();
        this.createMouseHandlers();
        if (((CellPane)((Object)cellPane)).interactive) {
            this.createDragAndDropHandlers();
        }
        ((CellPane)((Object)cellPane)).rows.put((Object)gridRow, (Object)this);
        ((CellPane)((Object)cellPane)).columns.put((Object)gridColumn, (Object)this);
        ((CellPane)((Object)cellPane)).contentPane.add((Node)this.getContentPane(), gridColumn, gridRow);
        ((CellPane)((Object)cellPane)).interactionPane.add((Node)this.getInteractionPane(), gridColumn, gridRow);
        this.fade(0.5, this.opacity.getValue() == null ? 1.0 : this.opacity.get(), TransitionType.SMOOTH, onFinishedEventHandler);
        if (createTextSizeListener && (((CellPane)((Object)cellPane)).autoSizeRows.get() || ((CellPane)((Object)cellPane)).autoSizeColumns.get())) {
            ((CellContentPane)((Object)this.contentPane.get())).text.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

                public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                    double width = newValue.getWidth();
                    if (width > cellPane.maximalTextWidth.get()) {
                        cellPane.maximalTextWidth.set(width);
                    }
                }
            });
        }
    }

    private final void createRotation() {
        Rotate rotate = new Rotate(-90.0);
        Translate translate = new Translate(0.0, 0.0);
        rotate.pivotXProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return Cell.this.height.get() / 2.0;
            }
        });
        rotate.pivotYProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return Cell.this.width.get() / 2.0;
            }
        });
        translate.yProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return (Cell.this.width.get() - Cell.this.height.get()) / 2.0;
            }
        });
        ((CellContentPane)((Object)this.contentPane.get())).getTransforms().addAll((Object[])new Transform[]{rotate, translate});
    }

    private final void createPropertyListeners() {
        this.snapToCoordinatesChangeListener = new ChangeListener<IntPair>(){

            public void changed(ObservableValue<? extends IntPair> observable, IntPair oldValue, IntPair newValue) {
                if (((CellPane)((Object)Cell.this.cellPane)).isDragging.get() && !((CellPane)((Object)Cell.this.cellPane)).isDropping.get()) {
                    Cell.this.snapToGrid(newValue, TransitionType.SMOOTH, (EventHandler<ActionEvent>)null);
                } else {
                    Cell.this.snapToGrid(newValue, TransitionType.DISCRETE, (EventHandler<ActionEvent>)null);
                    Cell.this.updateContent();
                }
            }
        };
        this.scrollDeltaCoordinatesChangeListener = new ChangeListener<IntPair>(){

            public void changed(ObservableValue<? extends IntPair> observable, IntPair oldValue, IntPair newValue) {
                Cell.this.scrollDeltaCoordinatesQueue.add((Object)newValue);
            }
        };
        this.scrollDeltaCoordinatesQueueChangeListener = new ListChangeListener<IntPair>(){

            public void onChanged(ListChangeListener.Change<? extends IntPair> c) {
                if (c.next() && c.wasAdded()) {
                    Cell.this.scrollLoop();
                }
            }
        };
        this.contentCoordinatesChangeListener = new ChangeListener<IntPair>(){

            public void changed(ObservableValue<? extends IntPair> observable, IntPair oldValue, IntPair newValue) {
                if (!((CellPane)((Object)Cell.this.cellPane)).isDragging.get() && !((CellPane)((Object)Cell.this.cellPane)).isDropping.get()) {
                    Cell.this.updateContent();
                }
            }
        };
        this.textContentChangeListener = new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                Platform2.runOnFXThread(new Runnable(){

                    @Override
                    public void run() {
                        ((CellContentPane)((Object)Cell.this.contentPane.get())).text.setText(newValue);
                    }
                });
            }
        };
        this.opacityChangeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Cell.this.fade(oldValue.doubleValue(), newValue.doubleValue(), TransitionType.DEFAULT, (EventHandler<ActionEvent>)null);
            }
        };
        this.highlightChangeListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Cell.this.highlight(newValue, TransitionType.DISCRETE, (EventHandler<ActionEvent>)null);
            }
        };
        this.translateTransitionChangeListener = new ChangeListener<TranslateTransition>(){

            public void changed(ObservableValue<? extends TranslateTransition> observable, TranslateTransition oldValue, TranslateTransition newValue) {
                try {
                    oldValue.jumpTo(Constants.ANIMATION_DURATION);
                    oldValue.stop();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    newValue.play();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        this.fillTransitionChangeListener = new ChangeListener<FillTransition>(){

            public void changed(ObservableValue<? extends FillTransition> observable, FillTransition oldValue, FillTransition newValue) {
                oldValue.jumpTo(Constants.ANIMATION_DURATION);
                oldValue.stop();
                newValue.play();
            }
        };
        this.fadeTransitionChangeListener = new ChangeListener<FadeTransition>(){

            public void changed(ObservableValue<? extends FadeTransition> observable, FadeTransition oldValue, FadeTransition newValue) {
                oldValue.jumpTo(Constants.ANIMATION_DURATION);
                oldValue.stop();
                newValue.play();
            }
        };
        this.snapToCoordinates.addListener(this.snapToCoordinatesChangeListener);
        ((CellPane)((Object)this.cellPane)).scrollDeltaCoordinates.addListener(this.scrollDeltaCoordinatesChangeListener);
        this.scrollDeltaCoordinatesQueue.addListener(this.scrollDeltaCoordinatesQueueChangeListener);
        this.contentCoordinates.addListener(this.contentCoordinatesChangeListener);
        this.textContent.addListener(this.textContentChangeListener);
        this.opacity.addListener(this.opacityChangeListener);
        this.highlight.addListener(this.highlightChangeListener);
        this.translateTransition.addListener(this.translateTransitionChangeListener);
        this.fillTransition.addListener(this.fillTransitionChangeListener);
        this.fadeTransition.addListener(this.fadeTransitionChangeListener);
    }

    private final void createMouseHandlers() {
        this.mouseEnteredEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ((CellPane)((Object)Cell.this.cellPane)).highlight((Cell)Cell.this);
            }
        };
        this.getInteractionPane().setOnMouseEntered(this.mouseEnteredEventHandler);
    }

    private final void createDragAndDropHandlers() {
        this.dragDetectedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ((CellPane)((Object)Cell.this.cellPane)).highlight((Cell)Cell.this);
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.put((Object)CELL_COORDINATES_DATA_FORMAT, (Object)new CellCoordinates((String)((CellPane)((Object)Cell.this.cellPane)).id.get(), event.getButton().equals((Object)MouseButton.PRIMARY) ? MouseEventType.SCROLL : MouseEventType.DRAG, (Integer)((IntPair)Cell.this.gridCoordinates.get()).x(), (Integer)((IntPair)Cell.this.gridCoordinates.get()).y(), (Integer)((IntPair)Cell.this.contentCoordinates.get()).x(), (Integer)((IntPair)Cell.this.contentCoordinates.get()).y()));
                ((CellContentPane)((Object)Cell.this.contentPane.get())).startDragAndDrop(new TransferMode[]{TransferMode.MOVE}).setContent((Map)clipboardContent);
                event.consume();
            }
        };
        this.dragOverEventHandler = new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                String sourceCellPaneId = ((CellCoordinates)event.getDragboard().getContent((DataFormat)Cell.CELL_COORDINATES_DATA_FORMAT)).cellPaneId;
                String targetCellPaneId = (String)((CellPane)((Object)Cell.this.cellPane)).id.get();
                if (sourceCellPaneId.equals(targetCellPaneId)) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                } else {
                    event.acceptTransferModes(TransferMode.NONE);
                }
                event.consume();
            }
        };
        this.dragEnteredEventHandler = new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard dragboard = event.getDragboard();
                CellCoordinates sourceCellCoordinates = (CellCoordinates)dragboard.getContent(CELL_COORDINATES_DATA_FORMAT);
                String sourceId = sourceCellCoordinates.cellPaneId;
                String targetId = (String)((CellPane)((Object)Cell.this.cellPane)).id.get();
                if (sourceId.equals(targetId)) {
                    switch (sourceCellCoordinates.mouseEventType) {
                        case SCROLL: {
                            ((CellPane)((Object)Cell.this.cellPane)).highlight((Cell)Cell.this);
                            int rowDelta = (Integer)((IntPair)Cell.this.gridCoordinates.get()).x() - sourceCellCoordinates.gridRow;
                            int columnDelta = (Integer)((IntPair)Cell.this.gridCoordinates.get()).y() - sourceCellCoordinates.gridColumn;
                            sourceCellCoordinates.gridRow = (Integer)((IntPair)Cell.this.gridCoordinates.get()).x();
                            sourceCellCoordinates.gridColumn = (Integer)((IntPair)Cell.this.gridCoordinates.get()).y();
                            dragboard.setContent(Collections.singletonMap(CELL_COORDINATES_DATA_FORMAT, sourceCellCoordinates));
                            ((CellPane)((Object)Cell.this.cellPane)).minCoordinates.add(-rowDelta, -columnDelta);
                            break;
                        }
                        case DRAG: {
                            ((CellPane)((Object)Cell.this.cellPane)).drag(sourceCellCoordinates.gridRow, sourceCellCoordinates.gridColumn, (Integer)((IntPair)Cell.this.gridCoordinates.get()).x(), (Integer)((IntPair)Cell.this.gridCoordinates.get()).y());
                        }
                    }
                }
                event.consume();
            }
        };
        this.dragExitedEventHandler = new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                event.consume();
            }
        };
        this.dragDroppedEventHandler = new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                ((CellPane)((Object)Cell.this.cellPane)).dehighlight();
                Dragboard dragboard = event.getDragboard();
                CellCoordinates sourceCellCoordinates = (CellCoordinates)dragboard.getContent(CELL_COORDINATES_DATA_FORMAT);
                switch (sourceCellCoordinates.mouseEventType) {
                    case SCROLL: {
                        break;
                    }
                    case DRAG: {
                        ((CellPane)((Object)Cell.this.cellPane)).drop(sourceCellCoordinates.gridRow, sourceCellCoordinates.gridColumn, (Integer)((IntPair)Cell.this.gridCoordinates.get()).x(), (Integer)((IntPair)Cell.this.gridCoordinates.get()).y());
                    }
                }
                event.setDropCompleted(true);
                event.consume();
            }
        };
        this.dragDoneEventHandler = new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                System.out.println("drag done!");
                event.consume();
            }
        };
        this.getInteractionPane().setOnDragDetected(this.dragDetectedEventHandler);
        this.getInteractionPane().setOnDragOver(this.dragOverEventHandler);
        this.getInteractionPane().setOnDragEntered(this.dragEnteredEventHandler);
        this.getInteractionPane().setOnDragExited(this.dragExitedEventHandler);
        this.getInteractionPane().setOnDragDropped(this.dragDroppedEventHandler);
        this.getInteractionPane().setOnDragDone(this.dragDoneEventHandler);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Cell && ((Cell)obj).id == this.id;
    }

    public int hashCode() {
        return (int)this.id.get();
    }

    public final CellContentPane getContentPane() {
        return (CellContentPane)((Object)this.contentPane.get());
    }

    public final CellInteractionPane getInteractionPane() {
        return (CellInteractionPane)((Object)this.interactionPane.get());
    }

    protected abstract void updateContent();

    public final void dispose() {
        this.fadeOut(TransitionType.SMOOTH, new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ((CellPane)((Object)Cell.this.cellPane)).contentPane.getChildren().remove((Object)Cell.this.getContentPane());
                ((CellPane)((Object)Cell.this.cellPane)).interactionPane.getChildren().remove((Object)Cell.this.getInteractionPane());
                ((CellPane)((Object)Cell.this.cellPane)).rows.remove(((IntPair)Cell.this.gridCoordinates.get()).x(), (Object)Cell.this);
                ((CellPane)((Object)Cell.this.cellPane)).columns.remove(((IntPair)Cell.this.gridCoordinates.get()).y(), (Object)Cell.this);
                Cell.this.contentCoordinates.dispose();
                Cell.this.snapToCoordinates.dispose();
                Cell.this.scrollDeltaCoordinatesQueue.clear();
                Cell.this.textStyle.dispose();
                Cell.this.snapToCoordinates.removeListener(Cell.this.snapToCoordinatesChangeListener);
                ((CellPane)((Object)Cell.this.cellPane)).scrollDeltaCoordinates.removeListener(Cell.this.scrollDeltaCoordinatesChangeListener);
                Cell.this.scrollDeltaCoordinatesQueue.removeListener(Cell.this.scrollDeltaCoordinatesQueueChangeListener);
                Cell.this.contentCoordinates.removeListener(Cell.this.contentCoordinatesChangeListener);
                Cell.this.textContent.removeListener(Cell.this.textContentChangeListener);
                Cell.this.opacity.removeListener(Cell.this.opacityChangeListener);
                Cell.this.highlight.removeListener(Cell.this.highlightChangeListener);
                Cell.this.translateTransition.removeListener(Cell.this.translateTransitionChangeListener);
                Cell.this.fillTransition.removeListener(Cell.this.fillTransitionChangeListener);
                Cell.this.fadeTransition.removeListener(Cell.this.fadeTransitionChangeListener);
                if (((CellPane)((Object)Cell.this.cellPane)).interactive) {
                    Cell.this.getInteractionPane().removeEventHandler(MouseEvent.MOUSE_ENTERED, Cell.this.mouseEnteredEventHandler);
                    Cell.this.getInteractionPane().removeEventHandler(MouseEvent.DRAG_DETECTED, Cell.this.dragDetectedEventHandler);
                    Cell.this.getInteractionPane().removeEventHandler(DragEvent.DRAG_OVER, Cell.this.dragOverEventHandler);
                    Cell.this.getInteractionPane().removeEventHandler(DragEvent.DRAG_ENTERED, Cell.this.dragEnteredEventHandler);
                    Cell.this.getInteractionPane().removeEventHandler(DragEvent.DRAG_EXITED, Cell.this.dragExitedEventHandler);
                    Cell.this.getInteractionPane().removeEventHandler(DragEvent.DRAG_DROPPED, Cell.this.dragDroppedEventHandler);
                    Cell.this.getInteractionPane().removeEventHandler(DragEvent.DRAG_DONE, Cell.this.dragDoneEventHandler);
                }
            }
        });
    }

    private final void scrollLoop() {
        if (!this.animate.get()) {
            return;
        }
        if (this.runningLoop) {
            return;
        }
        this.runningLoop = true;
        this._scrollLoop();
    }

    private final void _scrollLoop() {
        IntPair deltaCoordinates = this.cummulateScrollDeltaCoordinates();
        Integer deltaX = (Integer)deltaCoordinates.x();
        Integer deltaY = (Integer)deltaCoordinates.y();
        if (deltaX != 0 || deltaY != 0) {
            this.snapToGrid((Integer)((IntPair)this.gridCoordinates.get()).x() + deltaX, (Integer)((IntPair)this.gridCoordinates.get()).y() + deltaY, TransitionType.SMOOTH, new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Cell.this.resetGridPosition();
                        }
                    });
                }
            });
            this._scrollLoop();
        } else {
            this.runningLoop = false;
        }
    }

    protected void resetGridPosition() {
        this.snapToGrid((IntPair)this.gridCoordinates.get(), TransitionType.DISCRETE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IntPair cummulateScrollDeltaCoordinates() {
        int deltaRowSum = 0;
        int deltaColumnSum = 0;
        ObservableList<IntPair> observableList = this.scrollDeltaCoordinatesQueue;
        synchronized (observableList) {
            Iterator iterator = this.scrollDeltaCoordinatesQueue.iterator();
            while (iterator.hasNext()) {
                IntPair nextDeltaCoordinates = (IntPair)iterator.next();
                deltaRowSum += ((Integer)nextDeltaCoordinates.x()).intValue();
                deltaColumnSum += ((Integer)nextDeltaCoordinates.y()).intValue();
                iterator.remove();
            }
        }
        return IntPair.valueOf(deltaRowSum, deltaColumnSum);
    }

    private final void snapToGrid(IntPair coordinates, TransitionType translationType, EventHandler<ActionEvent> onFinishedEventHandler) {
        this.snapToGrid((Integer)coordinates.x(), (Integer)coordinates.y(), translationType, onFinishedEventHandler);
    }

    private final void snapToGrid(int row, int column, TransitionType translationType, EventHandler<ActionEvent> onFinishedEventHandler) {
        this.translateTo((double)column * this.width.get(), (double)row * this.height.get(), translationType, onFinishedEventHandler);
    }

    private final void translateTo(double minXInParent, double minYInParent, TransitionType translationType, EventHandler<ActionEvent> onFinishedEventHandler) {
        ((TranslateTransition)this.translateTransition.get()).jumpTo(Constants.ANIMATION_DURATION);
        ((TranslateTransition)this.translateTransition.get()).stop();
        Bounds boundsInLocal = ((CellContentPane)((Object)this.contentPane.get())).getBoundsInLocal();
        Bounds boundsInParent = ((CellContentPane)((Object)this.contentPane.get())).getBoundsInParent();
        double deltaX = minXInParent - (boundsInParent.getMinX() - boundsInLocal.getMinX());
        double deltaY = minYInParent - (boundsInParent.getMinY() - boundsInLocal.getMinY());
        this.translateBy(deltaX, deltaY, translationType, onFinishedEventHandler);
    }

    private final void translateBy(double x, double y, TransitionType translationType, EventHandler<ActionEvent> onFinishedEventHandler) {
        boolean smooth = translationType == TransitionType.SMOOTH || translationType == TransitionType.DEFAULT && this.animate.get();
        this.translateTransition.set((Object)((TranslateTransitionBuilder)TranslateTransitionBuilder.create().duration(smooth ? Constants.ANIMATION_DURATION : Duration.ONE).byX(x).byY(y).node((Node)this.contentPane.get()).onFinished(onFinishedEventHandler)).build());
    }

    protected final void toFront() {
        ((CellContentPane)((Object)this.contentPane.get())).toFront();
    }

    private final void highlight(boolean highlight, TransitionType translationType, EventHandler<ActionEvent> onFinishedEventHandler) {
        if (highlight) {
            this.toFront();
        }
        boolean smooth = translationType == TransitionType.SMOOTH || translationType == TransitionType.DEFAULT && this.animate.get();
        this.fillTransition.set((Object)((FillTransitionBuilder)FillTransitionBuilder.create().fromValue(highlight ? this.dehighlightColor : ((ColorScheme)((CellPane)((Object)this.cellPane)).colorScheme.get()).getColor(4)).toValue(highlight ? ((ColorScheme)((CellPane)((Object)this.cellPane)).colorScheme.get()).getColor(4) : this.dehighlightColor).duration(smooth ? Constants.ANIMATION_DURATION : Duration.ONE).shape((Shape)((CellContentPane)((Object)this.contentPane.get())).background).onFinished(onFinishedEventHandler)).build());
    }

    private final void fadeIn(TransitionType translationType, EventHandler<ActionEvent> onFinishedEventHandler) {
        this.fade(0.5, 1.0, translationType, onFinishedEventHandler);
    }

    private final void fadeOut(TransitionType translationType, EventHandler<ActionEvent> onFinishedEventHandler) {
        this.fade(1.0, 0.5, translationType, onFinishedEventHandler);
    }

    private final void fade(double fromValue, double toValue, TransitionType translationType, EventHandler<ActionEvent> onFinishedEventHandler) {
        boolean smooth = translationType == TransitionType.SMOOTH || translationType == TransitionType.DEFAULT && this.animate.get();
        this.fadeTransition.set((Object)((FadeTransitionBuilder)FadeTransitionBuilder.create().node((Node)this.contentPane.get()).duration(smooth ? Constants.ANIMATION_DURATION : Duration.ONE).fromValue(fromValue).toValue(toValue).onFinished(onFinishedEventHandler)).build());
    }

    public class CellInteractionPane
    extends BorderPane {
        public final Rectangle interactionRectangle = ((RectangleBuilder)RectangleBuilder.create().fill((Paint)Color.TRANSPARENT)).build();
    }

    public class CellContentPane
    extends StackPane {
        public final Rectangle background;
        public final Text text;

        public CellContentPane() {
            this.background = ((RectangleBuilder)RectangleBuilder.create().fill((Paint)Cell.this.dehighlightColor)).build();
            this.text = TextBuilder.create().build();
        }
    }

    public static final class CellCoordinates
    implements Serializable {
        private static final long serialVersionUID = 8412756602066000809L;
        public final String cellPaneId;
        public final MouseEventType mouseEventType;
        public int gridRow;
        public int gridColumn;
        public int contentRow;
        public int contentColumn;

        protected CellCoordinates(String cellPaneId, MouseEventType mouseEventType, int gridRow, int gridColumn, int contentRow, int contentColumn) {
            this.cellPaneId = cellPaneId;
            this.mouseEventType = mouseEventType;
            this.gridRow = gridRow;
            this.gridColumn = gridColumn;
            this.contentRow = contentRow;
            this.contentColumn = contentColumn;
        }
    }

    public static enum MouseEventType {
        SCROLL,
        DRAG;

    }
}

