/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.cellpane;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import conexp.fx.core.collections.IntPair;
import conexp.fx.gui.cellpane.Cell;
import conexp.fx.gui.cellpane.InteractionMode;
import conexp.fx.gui.properties.BoundedIntPairProperty;
import conexp.fx.gui.properties.SimpleIntPairProperty;
import conexp.fx.gui.util.ColorScheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;

public abstract class CellPane<TCellPane extends CellPane<TCellPane, TCell>, TCell extends Cell<TCell, TCellPane>>
extends GridPane {
    public final ReadOnlyStringProperty id;
    protected final StackPane contentAndInteractionStackPane = new StackPane(){

        @Deprecated
        public final BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
            1 var3_3 = this;
            synchronized (var3_3) {
                while (true) {
                    try {
                        return super.impl_computeGeomBounds(baseBounds, baseTransform);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
            }
        }
    };
    protected final GridPane contentPane = new GridPane(){

        @Deprecated
        public final BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
            2 var3_3 = this;
            synchronized (var3_3) {
                while (true) {
                    try {
                        return super.impl_computeGeomBounds(baseBounds, baseTransform);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
            }
        }
    };
    protected final GridPane interactionPane = new GridPane(){

        @Deprecated
        public final BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
            3 var3_3 = this;
            synchronized (var3_3) {
                while (true) {
                    try {
                        return super.impl_computeGeomBounds(baseBounds, baseTransform);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
            }
        }
    };
    private final EventHandler<MouseEvent> dehighlightEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            CellPane.this.dehighlight();
        }
    };
    public final IntegerProperty maxRows = new SimpleIntegerProperty();
    public final IntegerProperty maxColumns = new SimpleIntegerProperty();
    public final BooleanProperty autoSizeRows = new SimpleBooleanProperty(false);
    public final BooleanProperty autoSizeColumns = new SimpleBooleanProperty(false);
    public final IntegerProperty rowHeightDefault = new SimpleIntegerProperty();
    public final IntegerProperty columnWidthDefault = new SimpleIntegerProperty();
    public final IntegerProperty textSizeDefault = new SimpleIntegerProperty();
    public final DoubleProperty zoomFactor = new SimpleDoubleProperty(1.0);
    public final DoubleProperty maximalTextWidth = new SimpleDoubleProperty(0.0);
    public final IntegerBinding rowHeight = new IntegerBinding(){

        protected int computeValue() {
            if (CellPane.this.autoSizeRows.get()) {
                return (int)CellPane.this.maximalTextWidth.get() + 10;
            }
            return (int)(CellPane.this.zoomFactor.get() * (double)CellPane.this.rowHeightDefault.get());
        }
    };
    public final IntegerBinding columnWidth = new IntegerBinding(){

        protected int computeValue() {
            if (CellPane.this.autoSizeColumns.get()) {
                return (int)CellPane.this.maximalTextWidth.get() + 10;
            }
            return (int)(CellPane.this.zoomFactor.get() * (double)CellPane.this.columnWidthDefault.get());
        }
    };
    public final IntegerBinding textSize = new IntegerBinding(){

        protected int computeValue() {
            return (int)(CellPane.this.zoomFactor.get() * (double)CellPane.this.textSizeDefault.get());
        }
    };
    protected final DoubleBinding prefHeight = new DoubleBinding(){

        protected double computeValue() {
            return CellPane.this.maxRows.doubleValue() * CellPane.this.rowHeight.doubleValue();
        }
    };
    protected final DoubleBinding prefWidth = new DoubleBinding(){

        protected double computeValue() {
            return CellPane.this.maxColumns.doubleValue() * CellPane.this.columnWidth.doubleValue();
        }
    };
    public final IntegerBinding visibleRows = new IntegerBinding(){

        protected int computeValue() {
            if (CellPane.this.rowHeight.intValue() == 0) {
                return 0;
            }
            return Math.min(CellPane.this.contentAndInteractionStackPane.heightProperty().intValue() / CellPane.this.rowHeight.intValue(), CellPane.this.maxRows.intValue());
        }
    };
    public final IntegerBinding visibleColumns = new IntegerBinding(){

        protected int computeValue() {
            if (CellPane.this.columnWidth.intValue() == 0) {
                return 0;
            }
            return Math.min(CellPane.this.contentAndInteractionStackPane.widthProperty().intValue() / CellPane.this.columnWidth.intValue(), CellPane.this.maxColumns.intValue());
        }
    };
    public final ObjectProperty<InteractionMode> interactionMode = new SimpleObjectProperty();
    public final ObjectProperty<ColorScheme> colorScheme = new SimpleObjectProperty((Object)ColorScheme.DEFAULT);
    public final BooleanProperty animate = new SimpleBooleanProperty();
    public final BooleanProperty highlight = new SimpleBooleanProperty();
    protected final BooleanProperty isDragging = new SimpleBooleanProperty(false);
    protected final BooleanProperty isDropping = new SimpleBooleanProperty(false);
    protected final RowScrollBar rowScrollBar = new RowScrollBar();
    protected final ColumnScrollBar columnScrollBar = new ColumnScrollBar();
    protected int actualRows = 0;
    protected int actualColumns = 0;
    protected final SetMultimap<Integer, TCell> rows = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    protected final SetMultimap<Integer, TCell> columns = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    public final SimpleMapProperty<Integer, Integer> rowMap = new SimpleMapProperty(FXCollections.observableMap(new ConcurrentHashMap()));
    public final SimpleMapProperty<Integer, Integer> columnMap = new SimpleMapProperty(FXCollections.observableMap(new ConcurrentHashMap()));
    public final SimpleMapProperty<Integer, Double> rowOpacityMap = new SimpleMapProperty(FXCollections.observableMap(new ConcurrentHashMap()));
    public final SimpleMapProperty<Integer, Double> columnOpacityMap = new SimpleMapProperty(FXCollections.observableMap(new ConcurrentHashMap()));
    protected final BoundedIntPairProperty minCoordinates = new BoundedIntPairProperty(IntPair.zero(), new ObjectBinding<IntPair>(){

        protected IntPair computeValue() {
            return IntPair.zero();
        }
    }, new ObjectBinding<IntPair>(){

        protected IntPair computeValue() {
            return IntPair.valueOf((int)CellPane.this.rowScrollBar.getMax(), (int)CellPane.this.columnScrollBar.getMax());
        }
    });
    public final IntegerBinding minRow = new IntegerBinding(){

        protected int computeValue() {
            return CellPane.this.rowScrollBar.valueProperty().intValue();
        }
    };
    public final IntegerBinding maxRow = new IntegerBinding(){

        protected int computeValue() {
            return CellPane.this.minRow.intValue() + CellPane.this.visibleRows.intValue() - 1;
        }
    };
    public final IntegerBinding minColumn = new IntegerBinding(){

        protected int computeValue() {
            return CellPane.this.columnScrollBar.valueProperty().intValue();
        }
    };
    public final IntegerBinding maxColumn = new IntegerBinding(){

        protected int computeValue() {
            return CellPane.this.minColumn.intValue() + CellPane.this.visibleColumns.intValue() - 1;
        }
    };
    protected final RowConstraints rowConstraints = new RowConstraints();
    protected final ColumnConstraints columnConstraints = new ColumnConstraints();
    public final boolean interactive;
    protected final SimpleIntPairProperty scrollDeltaCoordinates = new SimpleIntPairProperty();
    protected final SimpleMapProperty<Integer, Integer> dragRowMap = new SimpleMapProperty(FXCollections.observableMap(new ConcurrentHashMap()));
    protected final SimpleMapProperty<Integer, Integer> dragColumnMap = new SimpleMapProperty(FXCollections.observableMap(new ConcurrentHashMap()));
    protected final SimpleMapProperty<Integer, Boolean> highlightRowMap = new SimpleMapProperty(FXCollections.observableMap(new ConcurrentHashMap()));
    protected final SimpleMapProperty<Integer, Boolean> highlightColumnMap = new SimpleMapProperty(FXCollections.observableMap(new ConcurrentHashMap()));
    public final SimpleBooleanProperty highlightConcept = new SimpleBooleanProperty(false);

    protected CellPane(String id, InteractionMode interactionMode) {
        this(id, interactionMode, true);
    }

    protected CellPane(String id, InteractionMode interactionMode, boolean interactive) {
        this.id = new ReadOnlyStringWrapper(id).getReadOnlyProperty();
        this.interactionMode.set((Object)interactionMode);
        this.interactive = interactive;
        this.zoomFactor.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                CellPane.this.maximalTextWidth.set(CellPane.this.maximalTextWidth.get() * (newValue.doubleValue() / oldValue.doubleValue()));
            }
        });
        this.minCoordinates.addListener((ChangeListener)new ChangeListener<IntPair>(){

            public void changed(ObservableValue<? extends IntPair> observable, IntPair oldValue, IntPair newValue) {
                if (CellPane.this.rowScrollBar.getValue() != (double)((Integer)newValue.x()).intValue()) {
                    CellPane.this.rowScrollBar.setValue(Math.min((double)((Integer)newValue.x()).intValue(), CellPane.this.rowScrollBar.getMax()));
                }
                if (CellPane.this.columnScrollBar.getValue() != (double)((Integer)newValue.y()).intValue()) {
                    CellPane.this.columnScrollBar.setValue(Math.min((double)((Integer)newValue.y()).intValue(), CellPane.this.columnScrollBar.getMax()));
                }
            }
        });
        this.rowScrollBar.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (((Integer)((IntPair)CellPane.this.minCoordinates.get()).x()).intValue() != newValue.intValue()) {
                    CellPane.this.minCoordinates.set(newValue.intValue(), (Integer)((IntPair)CellPane.this.minCoordinates.get()).y());
                }
            }
        });
        this.columnScrollBar.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (((Integer)((IntPair)CellPane.this.minCoordinates.get()).y()).intValue() != newValue.intValue()) {
                    CellPane.this.minCoordinates.set((Integer)((IntPair)CellPane.this.minCoordinates.get()).x(), newValue.intValue());
                }
            }
        });
        this.interactionPane.setOnScroll(event -> {
            if (event.getDeltaX() > 0.0) {
                this.columnScrollBar.decrement();
            } else if (event.getDeltaX() < 0.0) {
                this.columnScrollBar.increment();
            }
            if (event.getDeltaY() > 0.0) {
                this.rowScrollBar.decrement();
            } else if (event.getDeltaY() < 0.0) {
                this.rowScrollBar.increment();
            }
        });
        this.minCoordinates.addListener((ChangeListener)new ChangeListener<IntPair>(){

            public void changed(ObservableValue<? extends IntPair> observable, IntPair oldValue, IntPair newValue) {
                CellPane.this.scroll((Integer)newValue.x() - (Integer)oldValue.x(), (Integer)newValue.y() - (Integer)oldValue.y());
            }
        });
        this.minHeightProperty().bind((ObservableValue)this.rowHeight);
        this.prefHeightProperty().bind((ObservableValue)this.prefHeight);
        this.maxHeightProperty().bind((ObservableValue)this.prefHeight);
        this.contentPane.minHeightProperty().bind((ObservableValue)this.rowHeight);
        this.contentPane.prefHeightProperty().bind((ObservableValue)this.prefHeight);
        this.contentPane.maxHeightProperty().bind((ObservableValue)this.prefHeight);
        this.interactionPane.minHeightProperty().bind((ObservableValue)this.rowHeight);
        this.interactionPane.prefHeightProperty().bind((ObservableValue)this.prefHeight);
        this.interactionPane.maxHeightProperty().bind((ObservableValue)this.prefHeight);
        this.contentAndInteractionStackPane.minHeightProperty().bind((ObservableValue)this.rowHeight);
        this.contentAndInteractionStackPane.prefHeightProperty().bind((ObservableValue)this.prefHeight);
        this.contentAndInteractionStackPane.maxHeightProperty().bind((ObservableValue)this.prefHeight);
        this.rowConstraints.minHeightProperty().bind((ObservableValue)this.rowHeight);
        this.rowConstraints.maxHeightProperty().bind((ObservableValue)this.rowHeight);
        this.minWidthProperty().bind((ObservableValue)this.columnWidth);
        this.prefWidthProperty().bind((ObservableValue)this.prefWidth);
        this.maxWidthProperty().bind((ObservableValue)this.prefWidth);
        this.contentPane.minWidthProperty().bind((ObservableValue)this.columnWidth);
        this.contentPane.prefWidthProperty().bind((ObservableValue)this.prefWidth);
        this.contentPane.maxWidthProperty().bind((ObservableValue)this.prefWidth);
        this.interactionPane.minWidthProperty().bind((ObservableValue)this.columnWidth);
        this.interactionPane.prefWidthProperty().bind((ObservableValue)this.prefWidth);
        this.interactionPane.maxWidthProperty().bind((ObservableValue)this.prefWidth);
        this.contentAndInteractionStackPane.minWidthProperty().bind((ObservableValue)this.columnWidth);
        this.contentAndInteractionStackPane.prefWidthProperty().bind((ObservableValue)this.prefWidth);
        this.contentAndInteractionStackPane.maxWidthProperty().bind((ObservableValue)this.prefWidth);
        this.columnConstraints.minWidthProperty().bind((ObservableValue)this.columnWidth);
        this.columnConstraints.maxWidthProperty().bind((ObservableValue)this.columnWidth);
        this.visibleColumns.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int deltaColumns = newValue.intValue() - oldValue.intValue();
                CellPane.this.adjustColumns(deltaColumns);
            }
        });
        this.visibleRows.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int deltaRows = newValue.intValue() - oldValue.intValue();
                CellPane.this.adjustRows(deltaRows);
            }
        });
        this.interactionPane.addEventHandler(MouseEvent.MOUSE_EXITED, this.dehighlightEventHandler);
        this.contentAndInteractionStackPane.getChildren().addAll((Object[])new Node[]{this.contentPane, this.interactionPane});
        this.add((Node)this.contentAndInteractionStackPane, 0, 0);
        this.add((Node)this.rowScrollBar, 1, 0);
        this.add((Node)this.columnScrollBar, 0, 1);
        this.contentAndInteractionStackPane.toFront();
        this.interactionPane.toFront();
    }

    public final StackPane getContentAndInteractionStackPane() {
        return this.contentAndInteractionStackPane;
    }

    public final GridPane getContentPane() {
        return this.contentPane;
    }

    public final GridPane getInteractionPane() {
        return this.interactionPane;
    }

    public RowScrollBar getRowScrollBar() {
        return this.rowScrollBar;
    }

    public ColumnScrollBar getColumnScrollBar() {
        return this.columnScrollBar;
    }

    public final Set<TCell> getCellsByGridRow(int gridRow) {
        return this.rows.get((Object)gridRow);
    }

    public final Set<TCell> getCellsByGridColumn(int gridColumn) {
        return this.columns.get((Object)gridColumn);
    }

    public final TCell getCellByGridCoordinates(IntPair coordinates) {
        return this.getCellByGridCoordinates((Integer)coordinates.x(), (Integer)coordinates.y());
    }

    public final TCell getCellByGridCoordinates(int row, int column) {
        return (TCell)((Cell)Iterables.getOnlyElement((Iterable)Sets.intersection(this.getCellsByGridRow(row), this.getCellsByGridColumn(column))));
    }

    public final Collection<TCell> getCellsByContentRow(int contentRow) {
        return Collections2.filter((Collection)this.rows.values(), (Predicate)new ContentRowPredicate(contentRow));
    }

    public final Collection<TCell> getCellsByContentColumn(int contentColumn) {
        return Collections2.filter((Collection)this.rows.values(), (Predicate)new ContentColumnPredicate(contentColumn));
    }

    public final TCell getCellByContentCoordinates(IntPair coordinates) {
        return this.getCellByContentCoordinates((Integer)coordinates.x(), (Integer)coordinates.y());
    }

    public final TCell getCellByContentCoordinates(int row, final int column) {
        return (TCell)((Cell)Iterables.getOnlyElement((Iterable)Iterables.filter(this.getCellsByContentRow(row), (Predicate)new Predicate<TCell>(){

            public boolean apply(TCell cell) {
                return CellPane.this.getCellsByContentColumn(column).contains(cell);
            }
        })));
    }

    public final void bind(CellPane<?, ?> anotherSuperPane, InteractionMode interactionMode) {
        if (interactionMode.isRowsEnabled()) {
            this.maxRows.bind((ObservableValue)anotherSuperPane.maxRows);
            this.rowHeightDefault.bind((ObservableValue)anotherSuperPane.rowHeightDefault);
            this.animate.bind((ObservableValue)anotherSuperPane.animate);
            this.isDragging.bindBidirectional((Property)anotherSuperPane.isDragging);
            this.isDropping.bindBidirectional((Property)anotherSuperPane.isDropping);
            this.highlightRowMap.bindBidirectional(anotherSuperPane.highlightRowMap);
            this.rowOpacityMap.bindBidirectional(anotherSuperPane.rowOpacityMap);
            this.dragRowMap.bindBidirectional(anotherSuperPane.dragRowMap);
            this.rowMap.bindBidirectional(anotherSuperPane.rowMap);
            this.rowScrollBar.valueProperty().bindBidirectional((Property)anotherSuperPane.rowScrollBar.valueProperty());
        }
        if (interactionMode.isColumnsEnabled()) {
            this.maxColumns.bind((ObservableValue)anotherSuperPane.maxColumns);
            this.columnWidthDefault.bind((ObservableValue)anotherSuperPane.columnWidthDefault);
            this.animate.bind((ObservableValue)anotherSuperPane.animate);
            this.isDragging.bindBidirectional((Property)anotherSuperPane.isDragging);
            this.isDropping.bindBidirectional((Property)anotherSuperPane.isDropping);
            this.highlightColumnMap.bindBidirectional(anotherSuperPane.highlightColumnMap);
            this.columnOpacityMap.bindBidirectional(anotherSuperPane.columnOpacityMap);
            this.dragColumnMap.bindBidirectional(anotherSuperPane.dragColumnMap);
            this.columnMap.bindBidirectional(anotherSuperPane.columnMap);
            this.columnScrollBar.valueProperty().bindBidirectional((Property)anotherSuperPane.columnScrollBar.valueProperty());
        }
    }

    public final void updateContent() {
        for (Cell cell : this.rows.values()) {
            cell.updateContent();
        }
    }

    protected abstract TCell createCell(int var1, int var2);

    protected void addCell(int gridRow, int gridColumn) {
        this.createCell(gridRow, gridColumn);
    }

    private final void removeCell(TCell cell) {
        ((Cell)cell).dispose();
    }

    private final void adjustRows(int deltaValue) {
        block4: {
            block3: {
                if (deltaValue <= 0) break block3;
                int upShift = Math.max(0, this.maxRow.get() + deltaValue - this.maxRows.get());
                if (upShift > 0) {
                    this.rowScrollBar.setValue(Math.max(0.0, this.rowScrollBar.getValue() - (double)upShift));
                }
                for (int i = 0; i < deltaValue; ++i) {
                    this.appendRow();
                }
                break block4;
            }
            if (deltaValue >= 0) break block4;
            for (int i = 0; i < -deltaValue; ++i) {
                this.removeRow();
            }
        }
    }

    private final void appendRow() {
        this.contentPane.getRowConstraints().add((Object)this.rowConstraints);
        this.interactionPane.getRowConstraints().add((Object)this.rowConstraints);
        int interactionRow = this.actualRows++;
        for (int interactionColumn = 0; interactionColumn < this.actualColumns; ++interactionColumn) {
            this.addCell(interactionRow, interactionColumn);
        }
    }

    private final void removeRow() {
        block1: {
            int row;
            --this.actualRows;
            if ((row = this.actualRows++) == -1) break block1;
            for (Cell cell : this.getCellsByGridRow(row)) {
                this.removeCell(cell);
            }
            this.contentPane.getRowConstraints().remove(row);
            this.interactionPane.getRowConstraints().remove(row);
        }
    }

    private final void adjustColumns(int deltaValue) {
        block4: {
            block3: {
                if (deltaValue <= 0) break block3;
                int leftShift = Math.max(0, this.maxColumn.get() + deltaValue - this.maxColumns.get());
                if (leftShift > 0) {
                    this.columnScrollBar.setValue(Math.max(0.0, this.columnScrollBar.getValue() - (double)leftShift));
                }
                for (int i = 0; i < deltaValue; ++i) {
                    this.appendColumn();
                }
                break block4;
            }
            if (deltaValue >= 0) break block4;
            for (int i = 0; i < -deltaValue; ++i) {
                this.removeColumn();
            }
        }
    }

    private final void appendColumn() {
        this.contentPane.getColumnConstraints().add((Object)this.columnConstraints);
        this.interactionPane.getColumnConstraints().add((Object)this.columnConstraints);
        int interactionColumn = this.actualColumns++;
        for (int interactionRow = 0; interactionRow < this.actualRows; ++interactionRow) {
            this.addCell(interactionRow, interactionColumn);
        }
    }

    private final void removeColumn() {
        block1: {
            int column;
            --this.actualColumns;
            if ((column = this.actualColumns++) == -1) break block1;
            for (Cell cell : this.getCellsByGridColumn(column)) {
                this.removeCell(cell);
            }
            this.contentPane.getColumnConstraints().remove(column);
            this.interactionPane.getColumnConstraints().remove(column);
        }
    }

    private final IntPair flipRow(IntPair gridCoordinates) {
        return IntPair.valueOf(this.flipRow((Integer)gridCoordinates.x()), (Integer)gridCoordinates.y());
    }

    private final int flipRow(int row) {
        return this.maxRow.get() - row;
    }

    private final IntPair flipColumn(IntPair gridCoordinates) {
        return IntPair.valueOf((Integer)gridCoordinates.x(), this.flipColumn((Integer)gridCoordinates.y()));
    }

    private final int flipColumn(int column) {
        return this.maxColumn.get() - column;
    }

    private final IntPair flipBoth(IntPair gridCoordinates) {
        return IntPair.valueOf(this.flipRow((Integer)gridCoordinates.x()), this.flipColumn((Integer)gridCoordinates.y()));
    }

    protected final void scroll(int rowDelta, int columnDelta) {
        switch (MovementDirection.valueOf(rowDelta, columnDelta)) {
            case UP: {
                for (int row = 0; row < this.actualRows; ++row) {
                    for (Cell cell : this.getCellsByGridRow(row)) {
                        cell.scrollDeltaCoordinatesQueue.add((Object)new IntPair(-rowDelta, -columnDelta));
                    }
                }
                break;
            }
            case UP_LEFT: {
                ArrayList cantorianSortedCells = Lists.newArrayList((Iterable)this.rows.values());
                Collections.sort(cantorianSortedCells, new Comparator<TCell>(){

                    @Override
                    public int compare(TCell o1, TCell o2) {
                        return IntPair.POSITIVE_CANTORIAN_COMPARATOR.compare((IntPair)((Cell)o1).gridCoordinates.get(), (IntPair)((Cell)o2).gridCoordinates.get());
                    }
                });
                for (Cell cell : cantorianSortedCells) {
                    cell.scrollDeltaCoordinatesQueue.add((Object)new IntPair(-rowDelta, -columnDelta));
                }
                cantorianSortedCells.clear();
                break;
            }
            case LEFT: {
                for (int column = 0; column < this.actualColumns; ++column) {
                    for (Cell cell : this.getCellsByGridColumn(column)) {
                        cell.scrollDeltaCoordinatesQueue.add((Object)new IntPair(-rowDelta, -columnDelta));
                    }
                }
                break;
            }
            case DOWN_LEFT: {
                ArrayList cantorianSortedCells = Lists.newArrayList((Iterable)this.rows.values());
                Collections.sort(cantorianSortedCells, new Comparator<TCell>(){

                    @Override
                    public int compare(TCell o1, TCell o2) {
                        return IntPair.POSITIVE_CANTORIAN_COMPARATOR.compare(CellPane.this.flipRow((IntPair)((Cell)o1).gridCoordinates.get()), CellPane.this.flipRow((IntPair)((Cell)o2).gridCoordinates.get()));
                    }
                });
                for (Cell cell : cantorianSortedCells) {
                    cell.scrollDeltaCoordinatesQueue.add((Object)new IntPair(-rowDelta, -columnDelta));
                }
                cantorianSortedCells.clear();
                break;
            }
            case DOWN: {
                for (int row = this.actualRows - 1; row >= 0; --row) {
                    for (Cell cell : this.getCellsByGridRow(row)) {
                        cell.scrollDeltaCoordinatesQueue.add((Object)new IntPair(-rowDelta, -columnDelta));
                    }
                }
                break;
            }
            case DOWN_RIGHT: {
                ArrayList cantorianSortedCells = Lists.newArrayList((Iterable)this.rows.values());
                Collections.sort(cantorianSortedCells, new Comparator<TCell>(){

                    @Override
                    public int compare(TCell o1, TCell o2) {
                        return IntPair.POSITIVE_CANTORIAN_COMPARATOR.compare(CellPane.this.flipBoth((IntPair)((Cell)o1).gridCoordinates.get()), CellPane.this.flipBoth((IntPair)((Cell)o2).gridCoordinates.get()));
                    }
                });
                for (Cell cell : cantorianSortedCells) {
                    cell.scrollDeltaCoordinatesQueue.add((Object)new IntPair(-rowDelta, -columnDelta));
                }
                cantorianSortedCells.clear();
                break;
            }
            case RIGHT: {
                for (int column = this.actualColumns - 1; column >= 0; --column) {
                    for (Cell cell : this.getCellsByGridColumn(column)) {
                        cell.scrollDeltaCoordinatesQueue.add((Object)new IntPair(-rowDelta, -columnDelta));
                    }
                }
                break;
            }
            case UP_RIGHT: {
                ArrayList cantorianSortedCells = Lists.newArrayList((Iterable)this.rows.values());
                Collections.sort(cantorianSortedCells, new Comparator<TCell>(){

                    @Override
                    public int compare(TCell o1, TCell o2) {
                        return IntPair.POSITIVE_CANTORIAN_COMPARATOR.compare(CellPane.this.flipColumn((IntPair)((Cell)o1).gridCoordinates.get()), CellPane.this.flipColumn((IntPair)((Cell)o2).gridCoordinates.get()));
                    }
                });
                for (Cell cell : cantorianSortedCells) {
                    cell.scrollDeltaCoordinatesQueue.add((Object)new IntPair(-rowDelta, -columnDelta));
                }
                cantorianSortedCells.clear();
                break;
            }
            default: {
                this.scrollDeltaCoordinates.set(-rowDelta, -columnDelta);
            }
        }
    }

    protected final void drag(int sourceRow, int sourceColumn, int targetRow, int targetColumn) {
        this.isDropping.set(false);
        this.isDragging.set(true);
        if (sourceRow != -1 && ((InteractionMode)((Object)this.interactionMode.get())).isRowsEnabled()) {
            this.dragRowMap.putAll(this.getRowChanges(sourceRow, targetRow, ChangeType.DRAG));
        }
        if (sourceColumn != -1 && ((InteractionMode)((Object)this.interactionMode.get())).isColumnsEnabled()) {
            this.dragColumnMap.putAll(this.getColumnChanges(sourceColumn, targetColumn, ChangeType.DRAG));
        }
    }

    public final void drop(int sourceRow, int sourceColumn, int targetRow, int targetColumn) {
        this.isDragging.set(false);
        this.isDropping.set(true);
        if (sourceRow != -1 && ((InteractionMode)((Object)this.interactionMode.get())).isRowsEnabled()) {
            this.rowMap.putAll(this.getRowChanges(sourceRow, targetRow, ChangeType.DROP));
        }
        if (sourceColumn != -1 && ((InteractionMode)((Object)this.interactionMode.get())).isColumnsEnabled()) {
            this.columnMap.putAll(this.getColumnChanges(sourceColumn, targetColumn, ChangeType.DROP));
        }
        if (sourceRow != -1 && ((InteractionMode)((Object)this.interactionMode.get())).isRowsEnabled()) {
            this.dragRowMap.clear();
        }
        if (sourceColumn != -1 && ((InteractionMode)((Object)this.interactionMode.get())).isColumnsEnabled()) {
            this.dragColumnMap.clear();
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CellPane.this.isDropping.set(false);
                    }
                });
            }
        });
    }

    private final Map<Integer, Integer> getRowChanges(int sourceRow, int targetRow, ChangeType type) {
        HashMap<Integer, Integer> changes = new HashMap<Integer, Integer>();
        int sgnRow = (int)Math.signum(targetRow - sourceRow);
        block4: for (int row = 0; row < this.actualRows; ++row) {
            int newDragRow = row;
            if (row == sourceRow) {
                newDragRow = targetRow;
            } else if (row * sgnRow >= (sourceRow + sgnRow) * sgnRow && row * sgnRow <= targetRow * sgnRow) {
                newDragRow = row - sgnRow;
            }
            switch (type) {
                case DRAG: {
                    changes.put(row, newDragRow);
                    continue block4;
                }
                case DROP: {
                    changes.put(this.minRow.get() + newDragRow, this.rowMap.containsKey((Object)(this.minRow.get() + row)) ? (Integer)this.rowMap.get((Object)(this.minRow.get() + row)) : Integer.valueOf(this.minRow.get() + row));
                }
            }
        }
        return changes;
    }

    private final Map<Integer, Integer> getColumnChanges(int sourceColumn, int targetColumn, ChangeType type) {
        HashMap<Integer, Integer> changes = new HashMap<Integer, Integer>();
        int sgnColumn = (int)Math.signum(targetColumn - sourceColumn);
        block4: for (int column = 0; column < this.actualColumns; ++column) {
            int newDragColumn = column;
            if (column == sourceColumn) {
                newDragColumn = targetColumn;
            } else if (column * sgnColumn >= (sourceColumn + sgnColumn) * sgnColumn && column * sgnColumn <= targetColumn * sgnColumn) {
                newDragColumn = column - sgnColumn;
            }
            switch (type) {
                case DRAG: {
                    changes.put(column, newDragColumn);
                    continue block4;
                }
                case DROP: {
                    changes.put(this.minColumn.get() + newDragColumn, this.columnMap.containsKey((Object)(this.minColumn.get() + column)) ? (Integer)this.columnMap.get((Object)(this.minColumn.get() + column)) : Integer.valueOf(this.minColumn.get() + column));
                }
            }
        }
        return changes;
    }

    public final void highlight(TCell cell) {
        if (this.highlight.get()) {
            switch ((InteractionMode)((Object)this.interactionMode.get())) {
                case NONE: {
                    break;
                }
                case ROWS: {
                    this.highlight(Collections.singleton(Integer.valueOf((Integer)((IntPair)((Cell)cell).gridCoordinates.get()).x())), null);
                    break;
                }
                case COLUMNS: {
                    this.highlight(null, Collections.singleton(Integer.valueOf((Integer)((IntPair)((Cell)cell).gridCoordinates.get()).y())));
                    break;
                }
                case ROWS_AND_COLUMNS: {
                    this.highlight(Collections.singleton(Integer.valueOf((Integer)((IntPair)((Cell)cell).gridCoordinates.get()).x())), Collections.singleton(Integer.valueOf((Integer)((IntPair)((Cell)cell).gridCoordinates.get()).y())));
                }
            }
        }
    }

    public final void highlight(Collection<Integer> rows, Collection<Integer> columns) {
        if (this.highlight.get()) {
            this.dehighlight(rows == null ? Collections.emptySet() : rows, columns == null ? Collections.emptySet() : columns);
            if (rows != null) {
                for (Integer row : rows) {
                    this.highlightRowMap.put((Object)row, (Object)true);
                }
            }
            if (columns != null) {
                for (Integer column : columns) {
                    this.highlightColumnMap.put((Object)column, (Object)true);
                }
            }
        }
    }

    public final void dehighlight() {
        this.highlightRowMap.clear();
        this.highlightColumnMap.clear();
    }

    protected final void dehighlight(Collection<Integer> ignoreRows, Collection<Integer> ignoreColumns) {
        this.highlightRowMap.keySet().retainAll(ignoreRows);
        this.highlightColumnMap.keySet().retainAll(ignoreColumns);
    }

    public void resetGridPositions() {
        for (Cell cell : this.rows.values()) {
            cell.resetGridPosition();
        }
    }

    private static enum ChangeType {
        DRAG,
        DROP;

    }

    protected static enum MovementDirection {
        UP,
        UP_LEFT,
        LEFT,
        DOWN_LEFT,
        DOWN,
        DOWN_RIGHT,
        RIGHT,
        UP_RIGHT;


        protected static final MovementDirection valueOf(int rowDelta, int columnDelta) {
            if (rowDelta > 0 && columnDelta == 0) {
                return UP;
            }
            if (rowDelta > 0 && columnDelta > 0) {
                return UP_LEFT;
            }
            if (rowDelta == 0 && columnDelta > 0) {
                return LEFT;
            }
            if (rowDelta < 0 && columnDelta > 0) {
                return DOWN_LEFT;
            }
            if (rowDelta < 0 && columnDelta == 0) {
                return DOWN;
            }
            if (rowDelta < 0 && columnDelta < 0) {
                return DOWN_RIGHT;
            }
            if (rowDelta == 0 && columnDelta < 0) {
                return RIGHT;
            }
            if (rowDelta > 0 && columnDelta < 0) {
                return UP_RIGHT;
            }
            return null;
        }
    }

    private final class ContentColumnPredicate
    implements Predicate<TCell> {
        private final int contentColumn;

        private ContentColumnPredicate(int contentColumn) {
            this.contentColumn = contentColumn;
        }

        public boolean apply(TCell cell) {
            return (Integer)((IntPair)((Cell)cell).contentCoordinates.get()).y() == this.contentColumn;
        }
    }

    private final class ContentRowPredicate
    implements Predicate<TCell> {
        private final int contentRow;

        private ContentRowPredicate(int contentRow) {
            this.contentRow = contentRow;
        }

        public boolean apply(TCell cell) {
            return (Integer)((IntPair)((Cell)cell).contentCoordinates.get()).x() == this.contentRow;
        }
    }

    protected final class ColumnScrollBar
    extends ScrollBar {
        private ColumnScrollBar() {
            this.setOrientation(Orientation.HORIZONTAL);
            this.minWidthProperty().bind((ObservableValue)CellPane.this.columnWidth);
            this.prefWidthProperty().bind((ObservableValue)CellPane.this.prefWidth);
            this.maxWidthProperty().bind((ObservableValue)CellPane.this.prefWidth);
            this.minHeightProperty().bind((ObservableValue)CellPane.this.rowHeight);
            this.prefHeightProperty().bind((ObservableValue)CellPane.this.rowHeight);
            this.maxHeightProperty().bind((ObservableValue)CellPane.this.rowHeight);
            this.setMin(0.0);
            this.visibleProperty().bind((ObservableValue)new BooleanBinding(){
                {
                    super.bind(new Observable[]{CellPane.this.visibleColumns, CellPane.this.maxColumns});
                }

                protected boolean computeValue() {
                    return CellPane.this.visibleColumns.get() < CellPane.this.maxColumns.get();
                }
            });
            this.maxProperty().bind((ObservableValue)new DoubleBinding(){
                {
                    super.bind(new Observable[]{CellPane.this.maxColumns, CellPane.this.visibleColumns});
                }

                protected double computeValue() {
                    return CellPane.this.maxColumns.doubleValue() - CellPane.this.visibleColumns.doubleValue();
                }
            });
            this.setUnitIncrement(1.0);
            this.blockIncrementProperty().bind((ObservableValue)new IntegerBinding(){
                {
                    super.bind(new Observable[]{CellPane.this.visibleColumns});
                }

                protected int computeValue() {
                    return (int)CellPane.this.visibleColumns.doubleValue() - 1;
                }
            });
            this.setValue(0.0);
            this.visibleAmountProperty().bind((ObservableValue)new DoubleBinding(){
                {
                    super.bind(new Observable[]{ColumnScrollBar.this.maxProperty(), CellPane.this.visibleColumns, CellPane.this.maxColumns});
                }

                protected double computeValue() {
                    if (CellPane.this.maxColumns.get() == 0) {
                        return 1.0;
                    }
                    return CellPane.this.visibleColumns.doubleValue() / CellPane.this.maxColumns.doubleValue() * ColumnScrollBar.this.maxProperty().doubleValue();
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, CellPane.this.dehighlightEventHandler);
            this.addEventHandler(MouseEvent.MOUSE_EXITED, CellPane.this.dehighlightEventHandler);
        }
    }

    protected final class RowScrollBar
    extends ScrollBar {
        private RowScrollBar() {
            this.setOrientation(Orientation.VERTICAL);
            this.minHeightProperty().bind((ObservableValue)CellPane.this.rowHeight);
            this.prefHeightProperty().bind((ObservableValue)CellPane.this.prefHeight);
            this.maxHeightProperty().bind((ObservableValue)CellPane.this.prefHeight);
            this.minWidthProperty().bind((ObservableValue)CellPane.this.columnWidth);
            this.prefWidthProperty().bind((ObservableValue)CellPane.this.columnWidth);
            this.maxWidthProperty().bind((ObservableValue)CellPane.this.columnWidth);
            this.setMin(0.0);
            this.visibleProperty().bind((ObservableValue)new BooleanBinding(){
                {
                    super.bind(new Observable[]{CellPane.this.visibleRows, CellPane.this.maxRows});
                }

                protected boolean computeValue() {
                    return CellPane.this.visibleRows.get() < CellPane.this.maxRows.get();
                }
            });
            this.maxProperty().bind((ObservableValue)new DoubleBinding(){
                {
                    super.bind(new Observable[]{CellPane.this.maxRows, CellPane.this.visibleRows});
                }

                protected double computeValue() {
                    return CellPane.this.maxRows.doubleValue() - CellPane.this.visibleRows.doubleValue();
                }
            });
            this.setUnitIncrement(1.0);
            this.blockIncrementProperty().bind((ObservableValue)new IntegerBinding(){
                {
                    super.bind(new Observable[]{CellPane.this.visibleRows});
                }

                protected int computeValue() {
                    return (int)CellPane.this.visibleRows.doubleValue() - 1;
                }
            });
            this.setValue(0.0);
            this.visibleAmountProperty().bind((ObservableValue)new DoubleBinding(){
                {
                    super.bind(new Observable[]{RowScrollBar.this.maxProperty(), CellPane.this.visibleRows, CellPane.this.maxRows});
                }

                protected double computeValue() {
                    if (CellPane.this.maxRows.get() == 0) {
                        return 1.0;
                    }
                    return CellPane.this.visibleRows.doubleValue() / CellPane.this.maxRows.doubleValue() * RowScrollBar.this.maxProperty().doubleValue();
                }
            });
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, CellPane.this.dehighlightEventHandler);
            this.addEventHandler(MouseEvent.MOUSE_EXITED, CellPane.this.dehighlightEventHandler);
        }
    }
}

