/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.context;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import conexp.fx.core.collections.IntPair;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.relation.RelationEvent;
import conexp.fx.core.collections.relation.RelationEventHandler;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.util.IdGenerator;
import conexp.fx.core.util.OWLUtil;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.cellpane.Cell;
import conexp.fx.gui.cellpane.CellPane;
import conexp.fx.gui.cellpane.InteractionMode;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.graph.ConceptGraph;
import conexp.fx.gui.util.ColorScheme;
import conexp.fx.gui.util.LaTeX;
import conexp.fx.gui.util.Platform2;
import de.tudresden.inf.tcs.fcalib.Implication;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.MapChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Slider;
import javafx.scene.control.SliderBuilder;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFieldBuilder;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.ImageViewBuilder;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import org.semanticweb.owlapi.model.OWLClassExpression;

public class MatrixContextWidget<G, M>
extends BorderPane {
    protected final FCADataset<G, M> dataset;
    protected final MatrixContext<G, M> context;
    protected final GridPane centerPane = new GridPane();
    public final RowHeaderPane rowHeaderPane;
    public final ColHeaderPane colHeaderPane;
    public final ContextPane contextPane;
    protected final ScrollBar rowScrollBar;
    protected final ScrollBar colScrollBar;
    public final Slider zoomSlider = SliderBuilder.create().min(-4.0).max(4.0).value(0.0).blockIncrement(0.25).build();
    public final DoubleProperty zoomFactor = new SimpleDoubleProperty(0.01);
    public final IntegerProperty rowHeaderSizeDefault = new SimpleIntegerProperty(40);
    public final IntegerProperty colHeaderSizeDefault = new SimpleIntegerProperty(40);
    public final IntegerProperty cellSizeDefault = new SimpleIntegerProperty(20);
    public final IntegerProperty textSizeDefault = new SimpleIntegerProperty(16);
    public final IntegerProperty incidenceSizeDefault = new SimpleIntegerProperty(20);
    public final IntegerBinding cellSize = new IntegerBinding(){

        protected int computeValue() {
            return (int)(MatrixContextWidget.this.zoomFactor.get() * MatrixContextWidget.this.cellSizeDefault.doubleValue());
        }
    };
    public final IntegerBinding textSize = new IntegerBinding(){

        protected int computeValue() {
            return (int)(MatrixContextWidget.this.zoomFactor.get() * MatrixContextWidget.this.textSizeDefault.doubleValue());
        }
    };
    public final IntegerBinding incidenceSize = new IntegerBinding(){

        protected int computeValue() {
            return (int)(MatrixContextWidget.this.zoomFactor.get() * MatrixContextWidget.this.incidenceSizeDefault.doubleValue());
        }
    };
    public final BooleanProperty animate = new SimpleBooleanProperty(false);
    public final BooleanProperty showArrows = new SimpleBooleanProperty();
    public final BooleanProperty showPaths = new SimpleBooleanProperty();
    public final ToggleButton highlightToggleButton = new ToggleButton();
    public final DoubleBinding height;

    public MatrixContextWidget(FCADataset<G, M> fcaInstance) {
        this(fcaInstance, true, new MatrixContext[0]);
    }

    @SafeVarargs
    public MatrixContextWidget(FCADataset<G, M> dataset, boolean withToolbar, MatrixContext<G, M> ... orContext) {
        this(dataset, withToolbar, true, orContext);
    }

    @SafeVarargs
    public MatrixContextWidget(final FCADataset<G, M> dataset, boolean withToolbar, boolean interactive, MatrixContext<G, M> ... orContext) {
        this.dataset = dataset;
        this.context = dataset == null && orContext[0] != null ? orContext[0] : dataset.context;
        this.rowHeaderPane = new RowHeaderPane(interactive);
        this.colHeaderPane = new ColHeaderPane(interactive);
        this.contextPane = new ContextPane(interactive);
        this.rowScrollBar = this.contextPane.getRowScrollBar();
        this.colScrollBar = this.contextPane.getColumnScrollBar();
        this.centerPane.setHgap(4.0);
        this.centerPane.setVgap(4.0);
        this.rowHeaderPane.colorScheme.setValue((Object)ColorScheme.JAVA_FX);
        this.colHeaderPane.colorScheme.setValue((Object)ColorScheme.JAVA_FX);
        this.contextPane.colorScheme.setValue((Object)ColorScheme.JAVA_FX);
        RowConstraints firstRowConstraints = new RowConstraints();
        firstRowConstraints.minHeightProperty().bind((ObservableValue)this.colHeaderPane.rowHeight);
        firstRowConstraints.maxHeightProperty().bind((ObservableValue)this.colHeaderPane.rowHeight);
        RowConstraints secondRowConstraints = new RowConstraints();
        secondRowConstraints.minHeightProperty().bind((ObservableValue)this.cellSize);
        secondRowConstraints.prefHeightProperty().bind((ObservableValue)new IntegerBinding(){

            protected final int computeValue() {
                return MatrixContextWidget.this.context.rowHeads().size() * MatrixContextWidget.this.cellSize.get();
            }
        });
        RowConstraints thirdRowConstraints = new RowConstraints();
        thirdRowConstraints.minHeightProperty().bind((ObservableValue)this.cellSize);
        thirdRowConstraints.maxHeightProperty().bind((ObservableValue)this.cellSize);
        this.centerPane.getRowConstraints().addAll((Object[])new RowConstraints[]{firstRowConstraints, secondRowConstraints, thirdRowConstraints});
        ColumnConstraints firstColumnConstraints = new ColumnConstraints();
        firstColumnConstraints.minWidthProperty().bind((ObservableValue)this.rowHeaderPane.columnWidth);
        firstColumnConstraints.maxWidthProperty().bind((ObservableValue)this.rowHeaderPane.columnWidth);
        ColumnConstraints secondColumnConstraints = new ColumnConstraints();
        secondColumnConstraints.minWidthProperty().bind((ObservableValue)this.cellSize);
        secondColumnConstraints.maxWidthProperty().bind((ObservableValue)new IntegerBinding(){

            protected final int computeValue() {
                return MatrixContextWidget.this.context.colHeads().size() * MatrixContextWidget.this.cellSize.get();
            }
        });
        ColumnConstraints thirdColumnConstraints = new ColumnConstraints();
        thirdColumnConstraints.minWidthProperty().bind((ObservableValue)this.cellSize);
        thirdColumnConstraints.maxWidthProperty().bind((ObservableValue)this.cellSize);
        this.centerPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{firstColumnConstraints, secondColumnConstraints, thirdColumnConstraints});
        this.centerPane.add((Node)this.contextPane.getContentAndInteractionStackPane(), 1, 1);
        this.centerPane.add((Node)this.rowHeaderPane.getContentAndInteractionStackPane(), 0, 1);
        this.centerPane.add((Node)this.colHeaderPane.getContentAndInteractionStackPane(), 1, 0);
        this.centerPane.add((Node)this.rowScrollBar, 2, 1);
        this.centerPane.add((Node)this.colScrollBar, 1, 2);
        this.setCenter((Node)this.centerPane);
        if (withToolbar) {
            this.createToolBar();
        } else {
            this.zoomFactor.set(Math.pow(2.0, 0.0));
        }
        ChangeListener<Boolean> updateContentListener = new ChangeListener<Boolean>(){

            public final void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                MatrixContextWidget.this.contextPane.updateContent();
            }
        };
        this.showArrows.addListener((ChangeListener)updateContentListener);
        this.showPaths.addListener((ChangeListener)updateContentListener);
        this.height = new DoubleBinding(){
            {
                this.bind(new Observable[]{MatrixContextWidget.this.colHeaderPane.heightProperty(), MatrixContextWidget.this.contextPane.heightProperty(), MatrixContextWidget.this.colHeaderPane.rowHeight, MatrixContextWidget.this.colHeaderPane.visibleRows, MatrixContextWidget.this.contextPane.rowHeight, MatrixContextWidget.this.contextPane.visibleRows});
            }

            protected double computeValue() {
                int h = MatrixContextWidget.this.colHeaderPane.rowHeight.get() * MatrixContextWidget.this.colHeaderPane.visibleRows.get() + MatrixContextWidget.this.contextPane.rowHeight.get() * MatrixContextWidget.this.contextPane.visibleRows.get();
                return h;
            }
        };
        this.rowHeaderPane.toFront();
        this.colHeaderPane.toFront();
        final Timeline t = new Timeline();
        t.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.zoomSlider.valueProperty(), (Object)0.0, Interpolator.EASE_IN)}));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                t.play();
            }
        });
        if (dataset != null && dataset.editable) {
            Button domainButton = ((ButtonBuilder)ButtonBuilder.create().onAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    dataset.addObject((dataset.context.isHomogen() ? "Element " : "Object ") + IdGenerator.getNextId(dataset), -1);
                }
            })).build();
            ImageView view = ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/add.png"))).build();
            view.scaleXProperty().bind((ObservableValue)this.zoomFactor);
            view.scaleYProperty().bind((ObservableValue)this.zoomFactor);
            domainButton.setGraphic((Node)view);
            domainButton.minWidthProperty().bind((ObservableValue)this.rowHeaderPane.columnWidth);
            domainButton.maxWidthProperty().bind((ObservableValue)this.rowHeaderPane.columnWidth);
            domainButton.minHeightProperty().bind((ObservableValue)this.cellSize);
            domainButton.maxHeightProperty().bind((ObservableValue)this.cellSize);
            domainButton.styleProperty().bind((ObservableValue)new StringBinding(){

                protected String computeValue() {
                    return "-fx-padding: 0; -fx-font-size: " + MatrixContextWidget.this.textSize.get() + ";";
                }
            });
            this.centerPane.add((Node)domainButton, 0, 2);
            Button codomainButton = ((ButtonBuilder)ButtonBuilder.create().onAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    dataset.addAttribute((dataset.context.isHomogen() ? "Element " : "Attribute ") + IdGenerator.getNextId(dataset), -1);
                }
            })).build();
            ImageView view2 = ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/add.png"))).build();
            view2.scaleXProperty().bind((ObservableValue)this.zoomFactor);
            view2.scaleYProperty().bind((ObservableValue)this.zoomFactor);
            codomainButton.setGraphic((Node)view2);
            codomainButton.rotateProperty().set(-90.0);
            codomainButton.minWidthProperty().bind((ObservableValue)this.colHeaderPane.rowHeight);
            codomainButton.maxWidthProperty().bind((ObservableValue)this.colHeaderPane.rowHeight);
            codomainButton.minHeightProperty().bind((ObservableValue)this.cellSize);
            codomainButton.maxHeightProperty().bind((ObservableValue)this.cellSize);
            codomainButton.translateXProperty().bind((ObservableValue)new DoubleBinding(){

                protected double computeValue() {
                    return (double)(-(MatrixContextWidget.this.colHeaderPane.rowHeight.get() - MatrixContextWidget.this.cellSize.get())) / 2.0;
                }
            });
            codomainButton.styleProperty().bind((ObservableValue)new StringBinding(){

                protected String computeValue() {
                    return "-fx-padding: 0; -fx-font-size: " + MatrixContextWidget.this.textSize.get() + ";";
                }
            });
            this.centerPane.add((Node)codomainButton, 2, 0);
        }
    }

    private final void createToolBar() {
        this.zoomFactor.bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{MatrixContextWidget.this.zoomSlider.valueProperty()});
            }

            protected double computeValue() {
                return Math.pow(2.0, MatrixContextWidget.this.zoomSlider.valueProperty().get());
            }
        });
        ToggleButton arrowsToggleButton = new ToggleButton("\u2199\u2197");
        arrowsToggleButton.setSelected(false);
        arrowsToggleButton.setMinHeight(24.0);
        this.showArrows.bind((ObservableValue)arrowsToggleButton.selectedProperty());
        final ToggleButton pathsToggleButton = new ToggleButton("\u2199\u2199");
        pathsToggleButton.setDisable(true);
        pathsToggleButton.setSelected(false);
        pathsToggleButton.setMinHeight(24.0);
        this.showPaths.bind((ObservableValue)pathsToggleButton.selectedProperty());
        arrowsToggleButton.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public final void handle(ActionEvent event) {
                if (MatrixContextWidget.this.showArrows.get()) {
                    pathsToggleButton.setDisable(false);
                } else {
                    pathsToggleButton.setSelected(false);
                    pathsToggleButton.setDisable(true);
                }
            }
        });
        this.highlightToggleButton.setSelected(false);
        this.highlightToggleButton.setMinHeight(24.0);
        this.highlightToggleButton.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/flag.png"))).build());
        this.rowHeaderPane.highlight.bind((ObservableValue)this.highlightToggleButton.selectedProperty());
        this.colHeaderPane.highlight.bind((ObservableValue)this.highlightToggleButton.selectedProperty());
        this.contextPane.highlight.bind((ObservableValue)this.highlightToggleButton.selectedProperty());
        arrowsToggleButton.setStyle("-fx-background-radius: 5 0 0 5, 5 0 0 5, 4 0 0 4, 3 0 0 3;");
        pathsToggleButton.setStyle("-fx-background-radius: 0, 0, 0, 0");
        this.highlightToggleButton.setStyle("-fx-background-radius: 0 5 5 0, 0 5 5 0, 0 4 4 0, 0 3 3 0;");
        HBox showBox = new HBox();
        showBox.setPadding(new Insets(0.0));
        showBox.getChildren().addAll((Object[])new Node[]{arrowsToggleButton, pathsToggleButton, this.highlightToggleButton});
        ToolBar toolBar = new ToolBar();
        toolBar.getItems().addAll((Object[])new Node[]{this.zoomSlider, showBox});
        this.setTop((Node)toolBar);
        toolBar.toFront();
    }

    protected final void update() {
        this.rowHeaderPane.updateContent();
        this.colHeaderPane.updateContent();
        this.contextPane.updateContent();
    }

    public final void dehighlight() {
        this.rowHeaderPane.dehighlight();
        this.colHeaderPane.dehighlight();
        this.contextPane.dehighlight();
        this.contextPane.highlightConcept.set(false);
    }

    public final void highlight(Concept<G, M> concept) {
        Collection<Integer> domainIndices = this.context.rowHeads().indicesOf((Collection<?>)concept.extent(), true);
        Collection<Integer> codomainIndices = this.context.colHeads().indicesOf((Collection<?>)concept.intent(), true);
        this.contextPane.highlightConcept.set(true);
        this.rowHeaderPane.highlightConcept(Collections2.transform(domainIndices, (Function)new Function<Integer, Integer>(){

            public final Integer apply(Integer index) {
                for (Map.Entry entry : MatrixContextWidget.this.contextPane.rowMap.get().entrySet()) {
                    if (!((Integer)entry.getValue()).equals(index)) continue;
                    return (Integer)entry.getKey();
                }
                return index;
            }
        }));
        this.colHeaderPane.highlightConcept(Collections2.transform(codomainIndices, (Function)new Function<Integer, Integer>(){

            public final Integer apply(Integer index) {
                for (Map.Entry entry : MatrixContextWidget.this.contextPane.columnMap.get().entrySet()) {
                    if (!((Integer)entry.getValue()).equals(index)) continue;
                    return (Integer)entry.getKey();
                }
                return index;
            }
        }));
    }

    public final void highlightImplication(Implication<M> implication) {
    }

    public final void addRowDecoration(G row, Node decoration) {
        this.rowHeaderPane.addDecoration(row, decoration);
    }

    private final class ContextCell
    extends Cell<ContextCell, ContextPane> {
        private ContextCell(int row, int column) {
            super(MatrixContextWidget.this.contextPane, row, column, Pos.CENTER, TextAlignment.CENTER, false, null, false);
            if (MatrixContextWidget.this.dataset != null) {
                ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                    public final void handle(MouseEvent event) {
                        Object g = MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)ContextCell.this.contentCoordinates.get()).x());
                        Object m = MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)ContextCell.this.contentCoordinates.get()).y());
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(false, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.dehighlight());
                        MatrixContextWidget.this.dataset.flip(g, m);
                        MatrixContextWidget.this.dataset.unsavedChanges.set(true);
                    }
                });
            } else {
                ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                    Object m;
                    Object g = MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x());
                    if (MatrixContextWidget.this.context.contains(g, m = MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)this.contentCoordinates.get()).y()))) {
                        MatrixContextWidget.this.context.remove(g, m);
                    } else {
                        MatrixContextWidget.this.context.add(g, m);
                    }
                });
            }
            if (MatrixContextWidget.this.dataset != null) {
                ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

                    public final void handle(MouseEvent event) {
                        if (MatrixContextWidget.this.contextPane.highlight.get()) {
                            Object g = MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)ContextCell.this.contentCoordinates.get()).x());
                            Object m = MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)ContextCell.this.contentCoordinates.get()).y());
                            if (MatrixContextWidget.this.context.selectedAttributes().contains(m)) {
                                if (((String)ContextCell.this.textContent.get()).equals("\u2715")) {
                                    MatrixContextWidget.this.dataset.conceptGraph.highlight(true, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.incidence(g, m));
                                } else if (((String)ContextCell.this.textContent.get()).equals("\u2199")) {
                                    MatrixContextWidget.this.dataset.conceptGraph.highlight(true, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.downArrow(g, m));
                                } else if (((String)ContextCell.this.textContent.get()).equals("\u2197")) {
                                    MatrixContextWidget.this.dataset.conceptGraph.highlight(true, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.upArrow(g, m));
                                } else if (((String)ContextCell.this.textContent.get()).equals("\u21c6")) {
                                    MatrixContextWidget.this.dataset.conceptGraph.highlight(true, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.bothArrow(g, m));
                                } else if (((String)ContextCell.this.textContent.get()).equals("\u00b7")) {
                                    MatrixContextWidget.this.dataset.conceptGraph.highlight(true, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.nonIncidence(g, m));
                                }
                            }
                        }
                    }
                });
            }
            MatrixContextWidget.this.context.addEventHandler(event -> this.updateContent(), RelationEvent.ANY);
            this.updateContent();
        }

        @Override
        public final void updateContent() {
            try {
                Object g = MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x());
                Object m = MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)this.contentCoordinates.get()).y());
                if (MatrixContextWidget.this.context.selectedAttributes().contains(m) && MatrixContextWidget.this.context.selectedObjects().contains(g)) {
                    Pair<MatrixContext.Incidence, MatrixContext.Incidence> p = MatrixContextWidget.this.context.selection.getValue(g, m, MatrixContextWidget.this.showArrows.get(), MatrixContextWidget.this.showPaths.get());
                    MatrixContext.Incidence first = p.first();
                    MatrixContext.Incidence second = p.second();
                    this.textContent.set((Object)(second != null && first == MatrixContext.Incidence.NO_CROSS ? "\u25cf" : first.toString()));
                    switch (first) {
                        case BOTH_ARROW: {
                            ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setRotate(-45.0);
                            break;
                        }
                        case DOWN_ARROW: 
                        case UP_ARROW: 
                        case CROSS: 
                        case NO_CROSS: {
                            ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setRotate(0.0);
                        }
                    }
                    if (second == null) {
                        ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setFill((Paint)Color.BLACK);
                    } else {
                        switch (second) {
                            case BOTH_PATH: {
                                ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setFill((Paint)ConceptGraph.COLOR_INTERVAL);
                                break;
                            }
                            case DOWN_PATH: {
                                ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setFill((Paint)ConceptGraph.COLOR_LOWER);
                                break;
                            }
                            case UP_PATH: {
                                ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setFill((Paint)ConceptGraph.COLOR_UPPER);
                            }
                        }
                    }
                } else {
                    this.textContent.set((Object)MatrixContextWidget.this.context.getValue(g, m, false).first().toString());
                    ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setRotate(0.0);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private final class ColHeaderCell
    extends Cell<ColHeaderCell, ColHeaderPane> {
        private ImageView view;

        private ColHeaderCell(int column) {
            super(MatrixContextWidget.this.colHeaderPane, 0, column, Pos.CENTER_LEFT, TextAlignment.LEFT, true, null, false);
            this.view = ImageViewBuilder.create().build();
            ((Cell.CellContentPane)((Object)this.contentPane.get())).getChildren().add((Object)this.view);
            ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setOpacity(0.0);
            if (((ColHeaderPane)this.cellPane).interactive) {
                ContextMenu contextMenu = new ContextMenu();
                MenuItem editItem = new MenuItem("Edit");
                MenuItem removeItem = new MenuItem("Remove");
                MenuItem selectItem = new MenuItem("Select");
                MenuItem insertItem = new MenuItem("Insert");
                if (MatrixContextWidget.this.dataset != null && MatrixContextWidget.this.dataset.editable) {
                    contextMenu.getItems().addAll((Object[])new MenuItem[]{editItem, removeItem, selectItem, insertItem});
                } else {
                    contextMenu.getItems().addAll((Object[])new MenuItem[]{removeItem, selectItem});
                }
                insertItem.setOnAction(__ -> {
                    MatrixContextWidget.this.dataset.addAttribute((MatrixContextWidget.this.dataset.context.isHomogen() ? "Element " : "Attribute ") + IdGenerator.getNextId(MatrixContextWidget.this.dataset), (Integer)((IntPair)this.contentCoordinates.get()).y());
                    MatrixContextWidget.this.colHeaderPane.columnOpacityMap.keySet().stream().sorted().filter(i -> i >= (Integer)((IntPair)this.contentCoordinates.get()).y()).forEach(i -> {
                        Double cfr_ignored_0 = (Double)MatrixContextWidget.this.colHeaderPane.columnOpacityMap.put((Object)(i + 1), MatrixContextWidget.this.colHeaderPane.columnOpacityMap.remove(i));
                    });
                });
                editItem.setOnAction(event -> {
                    if (MatrixContextWidget.this.dataset.editable) {
                        Object attribute = MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)this.contentCoordinates.get()).y());
                        final TextField textField = ((TextFieldBuilder)TextFieldBuilder.create().text((String)attribute)).build();
                        textField.addEventHandler(KeyEvent.KEY_RELEASED, keyEvent -> {
                            switch (keyEvent.getCode()) {
                                case ENTER: {
                                    MatrixContextWidget.this.dataset.renameAttribute((String)attribute, textField.getText().trim());
                                }
                                case ESCAPE: {
                                    ((Cell.CellInteractionPane)((Object)((Object)((Object)this.interactionPane.get())))).getChildren().remove((Object)textField);
                                }
                            }
                        });
                        textField.rotateProperty().set(-90.0);
                        textField.setMinSize((double)MatrixContextWidget.this.colHeaderPane.rowHeight.get(), (double)MatrixContextWidget.this.cellSize.get());
                        textField.setMaxSize((double)MatrixContextWidget.this.colHeaderPane.rowHeight.get(), (double)MatrixContextWidget.this.cellSize.get());
                        ((Cell.CellInteractionPane)((Object)((Object)this.interactionPane.get()))).getChildren().add((Object)textField);
                        textField.focusedProperty().addListener((observable, oldValue, newValue) -> new Timer().schedule(new TimerTask(){

                            @Override
                            public final void run() {
                                Platform.runLater(() -> textField.selectAll());
                            }
                        }, 20L));
                        textField.requestFocus();
                    }
                });
                removeItem.setOnAction(event -> {
                    MatrixContextWidget.this.dataset.removeAttribute(MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)this.contentCoordinates.get()).y()));
                    MatrixContextWidget.this.colHeaderPane.columnOpacityMap.remove(((IntPair)this.contentCoordinates.get()).y());
                    MatrixContextWidget.this.colHeaderPane.columnOpacityMap.keySet().stream().sorted().filter(i -> i > (Integer)((IntPair)this.contentCoordinates.get()).y()).forEach(i -> {
                        Double cfr_ignored_0 = (Double)MatrixContextWidget.this.colHeaderPane.columnOpacityMap.put((Object)(i - 1), MatrixContextWidget.this.colHeaderPane.columnOpacityMap.remove(i));
                    });
                });
                selectItem.setOnAction(event -> this.select());
                ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                    switch (event.getButton()) {
                        case PRIMARY: {
                            this.select();
                            break;
                        }
                        case SECONDARY: {
                            contextMenu.show((Node)this.interactionPane.getValue(), event.getScreenX(), event.getScreenY());
                        }
                    }
                });
            }
            if (MatrixContextWidget.this.dataset != null) {
                ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).addEventHandler(MouseEvent.MOUSE_ENTERED, event -> {
                    if (MatrixContextWidget.this.contextPane.highlight.get()) {
                        Object m = MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)this.contentCoordinates.get()).y());
                        if (MatrixContextWidget.this.context.selectedAttributes().contains(m)) {
                            MatrixContextWidget.this.dataset.conceptGraph.highlight(true, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.attribute(m));
                        }
                    }
                });
            }
            if (((ColHeaderPane)this.cellPane).autoSizeRows.get() || ((ColHeaderPane)this.cellPane).autoSizeColumns.get()) {
                this.view.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

                    public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                        double width = newValue.getWidth();
                        if (width > ((ColHeaderPane)((ColHeaderCell)ColHeaderCell.this).cellPane).maximalTextWidth.get()) {
                            ((ColHeaderPane)((ColHeaderCell)ColHeaderCell.this).cellPane).maximalTextWidth.set(width);
                        }
                    }
                });
            }
            MatrixContextWidget.this.context.addEventHandler(event -> Platform2.runOnFXThread(this::updateContent), RelationEvent.COLUMNS);
            this.updateContent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void select() {
            SimpleMapProperty simpleMapProperty = MatrixContextWidget.this.colHeaderPane.columnOpacityMap;
            synchronized (simpleMapProperty) {
                if (MatrixContextWidget.this.colHeaderPane.columnOpacityMap.containsKey(((IntPair)this.contentCoordinates.get()).y())) {
                    if (MatrixContextWidget.this.dataset != null) {
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(false, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.dehighlight());
                    }
                    MatrixContextWidget.this.colHeaderPane.columnOpacityMap.remove(((IntPair)this.contentCoordinates.get()).y());
                    if (MatrixContextWidget.this.dataset != null) {
                        MatrixContextWidget.this.dataset.selectAttribute(MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)this.contentCoordinates.get()).y()));
                    }
                } else {
                    if (MatrixContextWidget.this.dataset != null) {
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(false, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.dehighlight());
                    }
                    MatrixContextWidget.this.colHeaderPane.columnOpacityMap.put(((IntPair)this.contentCoordinates.get()).y(), (Object)0.191);
                    if (MatrixContextWidget.this.dataset != null) {
                        MatrixContextWidget.this.dataset.ignoreAttribute(MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)this.contentCoordinates.get()).y()));
                    }
                }
            }
        }

        @Override
        public final void updateContent() {
            try {
                Object m = MatrixContextWidget.this.context.colHeads().get((Integer)((IntPair)this.contentCoordinates.get()).y());
                String string = m instanceof OWLClassExpression ? OWLUtil.toString((OWLClassExpression)m) : m.toString();
                this.textContent.set((Object)string);
                this.view.setImage(LaTeX.toFXImage(string, (float)(16.0 * MatrixContextWidget.this.zoomFactor.get())));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private final class RowHeaderCell
    extends Cell<RowHeaderCell, RowHeaderPane> {
        private ImageView view;

        private RowHeaderCell(int row) {
            super(MatrixContextWidget.this.rowHeaderPane, row, 0, Pos.CENTER_RIGHT, TextAlignment.RIGHT, false, null, false);
            this.view = ImageViewBuilder.create().build();
            ((Cell.CellContentPane)((Object)this.contentPane.get())).getChildren().add((Object)this.view);
            ((Cell.CellContentPane)((Object)this.contentPane.get())).text.setOpacity(0.0);
            if (((RowHeaderPane)this.cellPane).interactive) {
                ContextMenu contextMenu = new ContextMenu();
                MenuItem editItem = new MenuItem("Edit");
                MenuItem removeItem = new MenuItem("Remove");
                MenuItem selectItem = new MenuItem("Select");
                MenuItem insertItem = new MenuItem("Insert");
                if (MatrixContextWidget.this.dataset != null && MatrixContextWidget.this.dataset.editable) {
                    contextMenu.getItems().addAll((Object[])new MenuItem[]{editItem, removeItem, selectItem, insertItem});
                } else {
                    contextMenu.getItems().addAll((Object[])new MenuItem[]{removeItem, selectItem});
                }
                insertItem.setOnAction(__ -> {
                    MatrixContextWidget.this.dataset.addObject((MatrixContextWidget.this.dataset.context.isHomogen() ? "Element " : "Object ") + IdGenerator.getNextId(MatrixContextWidget.this.dataset), (Integer)((IntPair)this.contentCoordinates.get()).x());
                    MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.keySet().stream().sorted().filter(i -> i >= (Integer)((IntPair)this.contentCoordinates.get()).x()).forEach(i -> {
                        Double cfr_ignored_0 = (Double)MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.put((Object)(i + 1), MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.remove(i));
                    });
                });
                editItem.setOnAction(__ -> {
                    if (MatrixContextWidget.this.dataset.editable) {
                        Object object = MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x());
                        final TextField textField = ((TextFieldBuilder)TextFieldBuilder.create().text((String)object)).build();
                        textField.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                            switch (event.getCode()) {
                                case ENTER: {
                                    MatrixContextWidget.this.dataset.renameObject((String)object, textField.getText().trim());
                                }
                                case ESCAPE: {
                                    ((Cell.CellInteractionPane)((Object)((Object)((Object)this.interactionPane.get())))).getChildren().remove((Object)textField);
                                }
                            }
                        });
                        ((Cell.CellInteractionPane)((Object)((Object)this.interactionPane.get()))).getChildren().add((Object)textField);
                        textField.focusedProperty().addListener((observable, oldValue, newValue) -> new Timer().schedule(new TimerTask(){

                            @Override
                            public final void run() {
                                Platform.runLater(() -> textField.selectAll());
                            }
                        }, 20L));
                        textField.requestFocus();
                    } else {
                        System.out.println("no instance of MatrixContextWidget");
                    }
                });
                removeItem.setOnAction(__ -> {
                    MatrixContextWidget.this.dataset.removeObject(MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x()));
                    MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.keySet().stream().sorted().filter(i -> i > (Integer)((IntPair)this.contentCoordinates.get()).x()).forEach(i -> {
                        Double cfr_ignored_0 = (Double)MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.put((Object)(i - 1), MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.remove(i));
                    });
                });
                selectItem.setOnAction(__ -> this.select());
                ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                    switch (event.getButton()) {
                        case PRIMARY: {
                            this.select();
                            break;
                        }
                        case SECONDARY: {
                            contextMenu.show((Node)this.interactionPane.getValue(), event.getScreenX(), event.getScreenY());
                        }
                    }
                });
            }
            if (MatrixContextWidget.this.dataset != null) {
                ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).addEventHandler(MouseEvent.MOUSE_ENTERED, event -> {
                    if (MatrixContextWidget.this.contextPane.highlight.get()) {
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(true, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.object(MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x())));
                    }
                });
            }
            if (((RowHeaderPane)this.cellPane).autoSizeRows.get() || ((RowHeaderPane)this.cellPane).autoSizeColumns.get()) {
                this.view.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

                    public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                        double decorationWidth = ((RowHeaderPane)((RowHeaderCell)RowHeaderCell.this).cellPane).decorations.containsKey(MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)RowHeaderCell.this.contentCoordinates.get()).x())) ? ((Bounds)((RowHeaderPane)((RowHeaderCell)RowHeaderCell.this).cellPane).decorations.get(MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)RowHeaderCell.this.contentCoordinates.get()).x())).layoutBoundsProperty().get()).getWidth() : 0.0;
                        double width = newValue.getWidth() + decorationWidth;
                        if (width > ((RowHeaderPane)((RowHeaderCell)RowHeaderCell.this).cellPane).maximalTextWidth.get()) {
                            ((RowHeaderPane)((RowHeaderCell)RowHeaderCell.this).cellPane).maximalTextWidth.set(width);
                        }
                    }
                });
            }
            MatrixContextWidget.this.context.addEventHandler(event -> Platform2.runOnFXThread(this::updateContent), RelationEvent.ROWS);
            this.updateContent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void select() {
            SimpleMapProperty simpleMapProperty = MatrixContextWidget.this.rowHeaderPane.rowOpacityMap;
            synchronized (simpleMapProperty) {
                if (MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.containsKey(((IntPair)this.contentCoordinates.get()).x())) {
                    if (MatrixContextWidget.this.dataset != null) {
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(false, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.dehighlight());
                    }
                    MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.remove(((IntPair)this.contentCoordinates.get()).x());
                    if (MatrixContextWidget.this.dataset != null) {
                        MatrixContextWidget.this.dataset.selectObject(MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x()));
                    }
                } else {
                    if (MatrixContextWidget.this.dataset != null) {
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(false, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.dehighlight());
                    }
                    MatrixContextWidget.this.rowHeaderPane.rowOpacityMap.put(((IntPair)this.contentCoordinates.get()).x(), (Object)0.191);
                    if (MatrixContextWidget.this.dataset != null) {
                        MatrixContextWidget.this.dataset.ignoreObject(MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x()));
                    }
                }
            }
        }

        @Override
        public final void updateContent() {
            try {
                String string = MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x()).toString();
                this.textContent.set((Object)string);
                this.view.setImage(LaTeX.toFXImage(string, (float)(16.0 * MatrixContextWidget.this.zoomFactor.get())));
                if (((RowHeaderPane)this.cellPane).decorations.containsKey(MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x()))) {
                    ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).getChildren().removeAll(((RowHeaderPane)this.cellPane).decorations.values());
                    ((Cell.CellInteractionPane)((Object)this.interactionPane.get())).setRight(((RowHeaderPane)this.cellPane).decorations.get(MatrixContextWidget.this.context.rowHeads().get((Integer)((IntPair)this.contentCoordinates.get()).x())));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public final class ContextPane
    extends CellPane<ContextPane, ContextCell> {
        private ContextPane(boolean interactive) {
            super("FormalContextPane", InteractionMode.ROWS_AND_COLUMNS, interactive);
            this.textSizeDefault.bind((ObservableValue)MatrixContextWidget.this.incidenceSizeDefault);
            this.zoomFactor.bind((ObservableValue)MatrixContextWidget.this.zoomFactor);
            this.bind(MatrixContextWidget.this.rowHeaderPane, InteractionMode.ROWS);
            this.bind(MatrixContextWidget.this.colHeaderPane, InteractionMode.COLUMNS);
            if (MatrixContextWidget.this.dataset != null) {
                this.rowMap.addListener((MapChangeListener)new MapChangeListener<Integer, Integer>(){

                    public final void onChanged(MapChangeListener.Change<? extends Integer, ? extends Integer> change) {
                        MatrixContextWidget.this.dataset.unsavedChanges.set(true);
                    }
                });
            }
            if (MatrixContextWidget.this.dataset != null) {
                this.columnMap.addListener((MapChangeListener)new MapChangeListener<Integer, Integer>(){

                    public final void onChanged(MapChangeListener.Change<? extends Integer, ? extends Integer> change) {
                        MatrixContextWidget.this.dataset.unsavedChanges.set(true);
                    }
                });
            }
            if (MatrixContextWidget.this.dataset != null) {
                this.interactionPane.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

                    public final void handle(MouseEvent event) {
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(false, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.dehighlight());
                    }
                });
            }
            this.zoomFactor.addListener((__, ___, ____) -> this.updateContent());
        }

        @Override
        protected final ContextCell createCell(int row, int column) {
            return new ContextCell(row, column);
        }
    }

    public final class ColHeaderPane
    extends CellPane<ColHeaderPane, ColHeaderCell> {
        private ColHeaderPane(boolean interactive) {
            super("CodomainPane", InteractionMode.COLUMNS, interactive);
            this.rowHeightDefault.bind((ObservableValue)MatrixContextWidget.this.colHeaderSizeDefault);
            this.columnWidthDefault.bind((ObservableValue)MatrixContextWidget.this.cellSizeDefault);
            this.zoomFactor.bind((ObservableValue)MatrixContextWidget.this.zoomFactor);
            this.textSizeDefault.bind((ObservableValue)MatrixContextWidget.this.textSizeDefault);
            this.animate.bind((ObservableValue)MatrixContextWidget.this.animate);
            this.autoSizeRows.set(true);
            this.autoSizeColumns.set(false);
            this.maxRows.set(1);
            this.maxColumns.set(MatrixContextWidget.this.context.colHeads().size());
            RelationEventHandler eventHandler = new RelationEventHandler<G, M>(){

                @Override
                public final void handle(RelationEvent<G, M> event) {
                    Platform2.runOnFXThread(new Runnable(){

                        @Override
                        public void run() {
                            ColHeaderPane.this.maxColumns.set(MatrixContextWidget.this.context.colHeads().size());
                        }
                    });
                }
            };
            MatrixContextWidget.this.context.addEventHandler(eventHandler, RelationEvent.COLUMNS);
            if (MatrixContextWidget.this.dataset != null) {
                this.interactionPane.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

                    public final void handle(MouseEvent event) {
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(false, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.dehighlight());
                    }
                });
            }
            this.zoomFactor.addListener((__, ___, ____) -> this.updateContent());
        }

        @Override
        protected final ColHeaderCell createCell(int row, int column) {
            return new ColHeaderCell(column);
        }

        public final void highlightConcept(Collection<Integer> codomainIndices) {
            this.highlight(null, codomainIndices);
        }
    }

    public final class RowHeaderPane
    extends CellPane<RowHeaderPane, RowHeaderCell> {
        protected final Map<G, Node> decorations;

        private RowHeaderPane(boolean interactive) {
            super("DomainPane", InteractionMode.ROWS, interactive);
            this.decorations = new ConcurrentHashMap();
            this.rowHeightDefault.bind((ObservableValue)MatrixContextWidget.this.cellSizeDefault);
            this.columnWidthDefault.bind((ObservableValue)MatrixContextWidget.this.rowHeaderSizeDefault);
            this.zoomFactor.bind((ObservableValue)MatrixContextWidget.this.zoomFactor);
            this.textSizeDefault.bind((ObservableValue)MatrixContextWidget.this.textSizeDefault);
            this.animate.bind((ObservableValue)MatrixContextWidget.this.animate);
            this.autoSizeRows.set(false);
            this.autoSizeColumns.set(true);
            this.maxColumns.set(1);
            this.maxRows.set(MatrixContextWidget.this.context.rowHeads().size());
            MatrixContextWidget.this.context.addEventHandler(__ -> Platform2.runOnFXThread(() -> this.maxRows.set(MatrixContextWidget.this.context.rowHeads().size())), RelationEvent.ROWS);
            if (MatrixContextWidget.this.dataset != null) {
                this.interactionPane.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

                    public final void handle(MouseEvent event) {
                        MatrixContextWidget.this.dataset.conceptGraph.highlight(false, MatrixContextWidget.this.dataset.conceptGraph.highlightRequests.dehighlight());
                    }
                });
            }
            this.zoomFactor.addListener((__, ___, ____) -> this.updateContent());
        }

        @Override
        protected final RowHeaderCell createCell(int row, int column) {
            return new RowHeaderCell(row);
        }

        public final void highlightConcept(Collection<Integer> domainIndices) {
            this.highlight(domainIndices, null);
        }

        public final void addDecoration(G row, Node decoration) {
            this.decorations.put(row, decoration);
        }
    }
}

