/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.dataset;

import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.dl.OWLInterpretation;
import conexp.fx.core.util.IdGenerator;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.assistent.InducedContextAssistent;
import conexp.fx.gui.dataset.Dataset;
import conexp.fx.gui.dataset.DatasetAction;
import conexp.fx.gui.dataset.DatasetView;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.semanticweb.owlapi.model.IRI;

public class DLDataset
extends Dataset {
    public final OWLInterpretation interpretation;

    public DLDataset(Dataset parent, OWLInterpretation interpretation) {
        super(parent);
        this.interpretation = interpretation;
        this.id.set((Object)("Model " + IdGenerator.getNextId((Object)ConExpFX.instance)));
        this.views.add(new DatasetView<Set<IRI>>("Individuals", (Node)new DomainWidget().contentPane, interpretation.getDomain()));
        this.views.add(new DatasetView<SetList<IRI>>("Concept Names", (Node)new ConceptWidget().contentPane, interpretation.getSignature().getConceptNames()));
        this.views.add(new DatasetView<SetList<IRI>>("Role Names", (Node)new RoleWidget().contentPane, interpretation.getSignature().getRoleNames()));
        this.defaultActiveViews.add("Individuals");
        this.actions.add(new DatasetAction("New Induced Context...", () -> new InducedContextAssistent(this).showAndWait()));
    }

    @Override
    public void save() {
    }

    @Override
    public void saveAs() {
    }

    @Override
    public void export() {
    }

    @Override
    public void close() {
    }

    public class RoleWidget {
        private final BorderPane contentPane = new BorderPane();

        public RoleWidget() {
            Label roleLabel = new Label("Role Name");
            ChoiceBox roleChoiceBox = new ChoiceBox();
            roleChoiceBox.getItems().addAll(DLDataset.this.interpretation.getSignature().getRoleNames());
            ListView listView = new ListView();
            roleChoiceBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                listView.getItems().clear();
                listView.getItems().addAll(DLDataset.this.interpretation.getRoleNameExtension((IRI)newValue));
            });
            this.contentPane.setTop((Node)new HBox(new Node[]{roleLabel, roleChoiceBox}));
            this.contentPane.setCenter((Node)listView);
            roleChoiceBox.getSelectionModel().selectFirst();
        }
    }

    public class ConceptWidget {
        private final BorderPane contentPane = new BorderPane();

        public ConceptWidget() {
            Label conceptLabel = new Label("Concept Name");
            ChoiceBox conceptChoiceBox = new ChoiceBox();
            conceptChoiceBox.getItems().addAll(DLDataset.this.interpretation.getSignature().getConceptNames());
            ListView listView = new ListView();
            conceptChoiceBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                listView.getItems().clear();
                listView.getItems().addAll(DLDataset.this.interpretation.getConceptNameExtension((IRI)newValue));
            });
            this.contentPane.setTop((Node)new HBox(new Node[]{conceptLabel, conceptChoiceBox}));
            this.contentPane.setCenter((Node)listView);
            conceptChoiceBox.getSelectionModel().selectFirst();
        }
    }

    public class DomainWidget {
        private final BorderPane contentPane = new BorderPane();

        public DomainWidget() {
            ListView listView = new ListView();
            listView.getItems().addAll(DLDataset.this.interpretation.getDomain());
            this.contentPane.setCenter((Node)listView);
        }
    }
}

