/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.dataset;

import conexp.fx.core.algorithm.exploration.AttributeExploration;
import conexp.fx.core.algorithm.exploration.ParallelAttributeExploration;
import conexp.fx.core.algorithm.lattice.IFox2;
import conexp.fx.core.algorithm.lattice.IPred;
import conexp.fx.core.algorithm.nextclosures.NextClosures2Bit;
import conexp.fx.core.builder.FileRequest;
import conexp.fx.core.builder.Request;
import conexp.fx.core.builder.Requests;
import conexp.fx.core.builder.StringRequest;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.relation.RelationEvent;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.exporter.CFXExporter;
import conexp.fx.core.exporter.CXTExporter;
import conexp.fx.core.exporter.HTMLExporter;
import conexp.fx.core.exporter.PDFExporter;
import conexp.fx.core.exporter.PNGExporter;
import conexp.fx.core.exporter.SVGExporter;
import conexp.fx.core.exporter.TeXExporter;
import conexp.fx.core.layout.AdditiveConceptLayout;
import conexp.fx.core.layout.ConceptMovement;
import conexp.fx.core.layout.GeneticLayouter;
import conexp.fx.core.layout.LayoutEvolution;
import conexp.fx.core.layout.QualityMeasure;
import conexp.fx.core.util.FileFormat;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.context.ConceptWidget;
import conexp.fx.gui.context.ImplicationWidget;
import conexp.fx.gui.context.MatrixContextWidget;
import conexp.fx.gui.dataset.Dataset;
import conexp.fx.gui.dataset.DatasetAction;
import conexp.fx.gui.dataset.DatasetView;
import conexp.fx.gui.dialog.FXDialog;
import conexp.fx.gui.dialog.TeXDialog;
import conexp.fx.gui.graph.CircularGraph;
import conexp.fx.gui.graph.ConceptGraph;
import conexp.fx.gui.graph.PolarGraph;
import conexp.fx.gui.task.TimeTask;
import conexp.fx.gui.util.Platform2;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public final class FCADataset<G, M>
extends Dataset {
    public final Request<G, M> request;
    public final MatrixContext<G, M> context;
    public final ConceptLattice<G, M> lattice;
    public final AdditiveConceptLayout<G, M> layout;
    public final ObservableList<Concept<G, M>> concepts = FXCollections.observableArrayList();
    public final ObservableList<Implication<G, M>> implications = FXCollections.observableArrayList();
    public final ObservableList<Implication<G, M>> partialImplications = FXCollections.observableArrayList();
    public final QualityMeasure<G, M, Pair<Concept<G, M>, Double>> conflictDistance = QualityMeasure.conflictDistance();
    public boolean editable = false;
    public final MatrixContextWidget<G, M> contextWidget;
    public final ConceptGraph<G, M> conceptGraph;
    public final ConceptWidget<G, M> conceptWidget;
    public final ImplicationWidget<G, M> implicationWidget;

    public FCADataset(Dataset parentDataset, Request<G, M> request) {
        super(parentDataset);
        this.request = request;
        this.context = request.createContext(MatrixContext.AutomaticMode.REDUCE);
        this.context.id.bind((ObservableValue)this.id);
        this.lattice = new ConceptLattice<G, M>(this.context);
        this.layout = new AdditiveConceptLayout<G, M>(this.lattice, null, null, AdditiveConceptLayout.Type.HYBRID);
        this.layout.observe();
        this.id.set((Object)request.getId());
        if (request.src != Requests.Source.FILE) {
            this.unsavedChanges.set(true);
        } else if (request instanceof FileRequest) {
            this.file = ((FileRequest)request).file;
        }
        if (request instanceof FileRequest) {
            this.editable = true;
        } else if (request instanceof StringRequest) {
            this.editable = true;
        }
        this.contextWidget = new MatrixContextWidget(this);
        this.conceptGraph = new ConceptGraph(this);
        this.conceptWidget = new ConceptWidget(this);
        this.implicationWidget = new ImplicationWidget(this);
        this.lattice.addEventHandler(event -> {
            this.concepts.clear();
            this.concepts.addAll(this.lattice.colHeads());
        }, RelationEvent.ALL_CHANGED);
        this.views.add(new DatasetView<MatrixContext<G, M>>("Context", (Node)this.contextWidget, this.context));
        this.views.add(new DatasetView<AdditiveConceptLayout<G, M>>("Lattice", (Node)this.conceptGraph, this.layout));
        this.views.add(new DatasetView<ObservableList<Concept<G, M>>>("Concepts", (Node)this.conceptWidget, this.concepts));
        this.views.add(new DatasetView<ObservableList<Implication<G, M>>>("Implications", (Node)this.implicationWidget, this.implications));
        this.defaultActiveViews.add("Lattice");
        this.actions.add(new DatasetAction("Polar Layout", () -> this.polarLayout()));
        this.actions.add(new DatasetAction("Circular Layout", () -> this.circularLayout()));
        if (this.editable) {
            this.actions.add(new DatasetAction("Explore...", () -> {
                this.implications.clear();
                try {
                    AttributeExploration.withHumanExpert((MatrixContext<String, String>)this.context.getSelection()).start();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }));
            this.actions.add(new DatasetAction("Explore (parallel)...", () -> {
                this.implications.clear();
                ConExpFX.execute(ParallelAttributeExploration.createExplorationTask(this));
            }));
        }
        this.actions.add(new DatasetAction("Refresh", () -> this.reinitializeWithNextClosures()));
        Platform2.runOnFXThread(() -> this.initializeWithNextClosures());
    }

    private final void polarLayout() {
        new PolarGraph<G, M>(this.lattice).show();
    }

    private final void circularLayout() {
        new CircularGraph<G, M>(this.lattice).show();
    }

    public final void initializeWithIFox() {
        ConExpFX.execute(TimeTask.create((Dataset)this, "Importing Formal Context", () -> {
            this.request.setContent();
            this.context.addEventHandler(__ -> Platform.runLater(() -> this.unsavedChanges.set(true)), RelationEvent.ROWS, RelationEvent.COLUMNS, RelationEvent.ENTRIES);
        }));
        ConExpFX.execute(new TimeTask<Void>("Initialization"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.1, 1.0);
                FCADataset.this.context.deselectAllAttributes();
                Concept top2 = new Concept(FCADataset.this.context.rowHeads(), Collections.emptySet());
                FCADataset.this.lattice.rowHeads().add(top2);
                this.updateProgress(0.2, 1.0);
                this.updateMessage("Computing Object Labels...");
                ObservableMap observableMap = FCADataset.this.lattice.objectConcepts;
                synchronized (observableMap) {
                    for (Object g : FCADataset.this.context.rowHeads()) {
                        FCADataset.this.lattice.objectConcepts.put(g, top2);
                    }
                }
                this.updateProgress(0.4, 1.0);
                FCADataset.this.layout.invalidate();
                int col = 0;
                while (col < FCADataset.this.context.colHeads().size()) {
                    final int _col = col++;
                    ConExpFX.execute(new TimeTask<Void>("Selecting " + _col){

                        protected Void call() {
                            this.updateProgress(0.0, 1.0);
                            if (this.isCancelled()) {
                                return null;
                            }
                            FCADataset.this.selectAttribute(FCADataset.this.context.colHeads().get(_col));
                            this.updateProgress(1.0, 1.0);
                            return null;
                        }
                    });
                }
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
    }

    public final void initializeWithNextClosures() {
        ConExpFX.execute(TimeTask.create((Dataset)this, "Importing Formal Context", () -> {
            this.request.setContent();
            this.context.addEventHandler(__ -> Platform.runLater(() -> this.unsavedChanges.set(true)), RelationEvent.ROWS, RelationEvent.COLUMNS, RelationEvent.ENTRIES);
        }));
        this._reinitializeWithNextClosures();
    }

    private final void reinitializeWithNextClosures() {
        ConExpFX.execute(TimeTask.create((Dataset)this, "Reinit", () -> {
            this.layout.seedsG.clear();
            this.layout.seedsM.clear();
            this.lattice.objectConcepts.clear();
            this.lattice.attributeConcepts.clear();
            this.conceptGraph.removeContent();
            this.lattice.rowHeads().clear();
            this.concepts.clear();
            this.implications.clear();
            this.partialImplications.clear();
        }, true));
        this._reinitializeWithNextClosures();
    }

    private final void _reinitializeWithNextClosures() {
        ConExpFX.execute(new TimeTask<Void>((Dataset)this, "Locking Graph"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.conceptGraph.controller.graphLock = true;
                FCADataset.this.conceptGraph.highlightLock = true;
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
        ConExpFX.execute(TimeTask.create((Dataset)this, "Reduce Formal Context", () -> this.context.pushAllChangedEvent()));
        ConExpFX.execute(NextClosures2Bit.createTask(this));
        ConExpFX.execute(TimeTask.create((Dataset)this, "Sorting Formal Concepts", () -> this.lattice.rowHeads().addAll(this.concepts.parallelStream().sorted((c1, c2) -> (int)Math.signum(c1.intent().size() - c2.intent().size())).collect(Collectors.toList()))));
        ConExpFX.execute(GeneticLayouter.initialSeeds(this));
        ConExpFX.execute(IPred.neighborhoodP(this));
        ConExpFX.execute(new TimeTask<Void>((Dataset)this, "Unlocking Graph"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.conceptGraph.controller.graphLock = false;
                FCADataset.this.conceptGraph.highlightLock = false;
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
        ConExpFX.execute(TimeTask.create((Dataset)this, "Initialize Concept Lattice Graph", () -> this.lattice.pushAllChangedEvent()));
        ConExpFX.execute(TimeTask.create((Dataset)this, "Computing Partial Implications", () -> this.implications.addAll(this.lattice.luxenburgerBase(0.0, true))));
        this.relayout(0, 64);
        ConExpFX.execute(TimeTask.create((Dataset)this, "Initialize Concept Lattice Graph", this.layout::invalidate, true));
    }

    public final void addObject(final G object, final int index) {
        ConExpFX.execute(new TimeTask<Void>((Dataset)this, "New Object"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                if (index == -1) {
                    FCADataset.this.context.rowHeads().add(object);
                } else {
                    FCADataset.this.context.rowHeads().add(index, object);
                }
                Platform2.runOnFXThread(() -> FCADataset.this.unsavedChanges.set(true));
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
        this.reinitializeWithNextClosures();
    }

    public final void addAttribute(final M attribute, final int index) {
        ConExpFX.execute(new TimeTask<Void>((Dataset)this, "New Attribute"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.conceptGraph.controller.graphLock = true;
                FCADataset.this.conceptGraph.highlightLock = true;
                Platform2.runOnFXThread(() -> FCADataset.this.unsavedChanges.set(true));
                if (index == -1) {
                    FCADataset.this.context.colHeads().add(attribute);
                } else {
                    FCADataset.this.context.colHeads().add(index, attribute);
                }
                FCADataset.this.context.deselectAttribute(attribute);
                FCADataset.this.context.pushAllChangedEvent();
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
        ConExpFX.execute(IFox2.select((String)this.id.get(), this.layout, attribute, this.conflictDistance, ConExpFX.getThreadPool()));
        ConExpFX.execute(new TimeTask<Void>((Dataset)this, "New Attribute"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.conceptGraph.controller.graphLock = false;
                FCADataset.this.conceptGraph.highlightLock = false;
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
    }

    public final void removeObject(final G object) {
        ConExpFX.execute(new TimeTask<Void>((Dataset)this, "Removing Object"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.context.rowHeads().remove(object);
                Platform2.runOnFXThread(() -> FCADataset.this.unsavedChanges.set(true));
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
        this.reinitializeWithNextClosures();
    }

    public final void removeAttribute(M attribute) {
        ConExpFX.execute(TimeTask.create((Dataset)this, "Removing Attribute", () -> {
            this.conceptGraph.controller.graphLock = true;
            this.conceptGraph.highlightLock = true;
            Platform2.runOnFXThread(() -> this.unsavedChanges.set(true));
        }));
        if (this.context.selectedAttributes().contains(attribute)) {
            ConExpFX.execute(IFox2.ignore((String)this.id.get(), this.layout, attribute, this.conflictDistance, ConExpFX.getThreadPool()));
        }
        ConExpFX.execute(TimeTask.create((Dataset)this, "Removing Attribute", () -> {
            this.context.colHeads().remove(attribute);
            this.context.pushAllChangedEvent();
            this.conceptGraph.controller.graphLock = false;
            this.conceptGraph.highlightLock = false;
        }));
    }

    public final void renameObject(G oldName, G newName) {
        if (oldName.equals(newName)) {
            return;
        }
        ConExpFX.execute(TimeTask.create((Dataset)this, "Renaming Object", () -> {
            this.context.rowHeads().set(oldName, newName);
            Platform2.runOnFXThread(() -> this.unsavedChanges.set(true));
        }));
        this.reinitializeWithNextClosures();
    }

    public final void renameAttribute(M oldName, M newName) {
        if (oldName.equals(newName)) {
            return;
        }
        ConExpFX.execute(TimeTask.create((Dataset)this, "Renaming Attribute", () -> {
            this.context.colHeads().set(oldName, newName);
            Platform2.runOnFXThread(() -> this.unsavedChanges.set(true));
        }));
        this.reinitializeWithNextClosures();
    }

    public final void flip(final G object, final M attribute) {
        if (!this.context.selectedAttributes().contains(attribute) || !this.context.selectedObjects().contains(object)) {
            if (this.context.contains(object, attribute)) {
                this.context.remove(object, attribute);
            } else {
                this.context.addFast(object, attribute);
            }
        } else {
            ConExpFX.execute(TimeTask.compose(this, "Flipping Incidence", new TimeTask<Void>((Dataset)this, "Flip Init"){

                protected final Void call() {
                    this.updateProgress(0.0, 1.0);
                    this.updateProgress(0.5, 1.0);
                    FCADataset.this.conceptGraph.controller.graphLock = true;
                    FCADataset.this.conceptGraph.highlightLock = true;
                    this.updateProgress(1.0, 1.0);
                    return null;
                }
            }, IFox2.ignore((String)this.id.get(), this.layout, attribute, this.conflictDistance, ConExpFX.getThreadPool()), new TimeTask<Void>((Dataset)this, "Context Flip"){

                protected final Void call() {
                    this.updateProgress(0.0, 1.0);
                    this.updateProgress(0.5, 1.0);
                    FCADataset.this.conceptGraph.controller.graphLock = false;
                    FCADataset.this.conceptGraph.highlightLock = false;
                    if (FCADataset.this.layout.lattice.context.contains(object, attribute)) {
                        FCADataset.this.layout.lattice.context.remove(object, attribute);
                    } else {
                        FCADataset.this.layout.lattice.context.addFast(object, attribute);
                    }
                    FCADataset.this.conceptGraph.controller.graphLock = true;
                    FCADataset.this.conceptGraph.highlightLock = true;
                    this.updateProgress(1.0, 1.0);
                    return null;
                }
            }, IFox2.select((String)this.id.get(), this.layout, attribute, this.conflictDistance, ConExpFX.getThreadPool()), new TimeTask<Void>((Dataset)this, "Flip Finish"){

                protected final Void call() {
                    this.updateProgress(0.0, 1.0);
                    this.updateProgress(0.5, 1.0);
                    FCADataset.this.conceptGraph.controller.graphLock = false;
                    FCADataset.this.conceptGraph.highlightLock = false;
                    this.updateProgress(1.0, 1.0);
                    return null;
                }
            }));
            this.relayout(2, 2);
        }
    }

    public final void selectObject(G object) {
        ConExpFX.execute(TimeTask.create((Dataset)this, "Selecting Object", () -> this.context.selectObject(object)));
        this.reinitializeWithNextClosures();
    }

    public final void ignoreObject(G object) {
        ConExpFX.execute(TimeTask.create((Dataset)this, "Unselecting Object", () -> this.context.deselectObject(object)));
        this.reinitializeWithNextClosures();
    }

    public final void selectAttribute(M attribute) {
        ConExpFX.execute(TimeTask.compose(this, "Selecting Attribute", new TimeTask<Void>((Dataset)this, "Select Init"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.conceptGraph.controller.graphLock = true;
                FCADataset.this.conceptGraph.highlightLock = true;
                this.updateProgress(1.0, 1.0);
                return null;
            }
        }, IFox2.select((String)this.id.get(), this.layout, attribute, this.conflictDistance, ConExpFX.getThreadPool()), new TimeTask<Void>((Dataset)this, "Select Finish"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.conceptGraph.controller.graphLock = false;
                FCADataset.this.conceptGraph.highlightLock = false;
                this.updateProgress(1.0, 1.0);
                return null;
            }
        }));
        this.relayout(2, 2);
    }

    public final void ignoreAttribute(M attribute) {
        ConExpFX.execute(TimeTask.compose(this, "Unselecting attribute", new TimeTask<Void>((Dataset)this, "Ignore Init"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.conceptGraph.controller.graphLock = true;
                FCADataset.this.conceptGraph.highlightLock = true;
                this.updateProgress(1.0, 1.0);
                return null;
            }
        }, IFox2.ignore((String)this.id.get(), this.layout, attribute, this.conflictDistance, ConExpFX.getThreadPool()), new TimeTask<Void>((Dataset)this, "Ignore Finish"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                FCADataset.this.conceptGraph.controller.graphLock = false;
                FCADataset.this.conceptGraph.highlightLock = false;
                this.updateProgress(1.0, 1.0);
                return null;
            }
        }));
        this.relayout(2, 2);
    }

    public final void relayout(int generationCount, int populationSize) {
        ConExpFX.execute(GeneticLayouter.seeds(this, false, generationCount, populationSize));
    }

    public final void refine(int generationCount) {
        ConExpFX.execute(GeneticLayouter.seeds(this, true, generationCount, 1));
    }

    public final LayoutEvolution<G, M> qualityChart(Concept<G, M> concept, ConceptMovement movement) {
        LayoutEvolution<G, M> qualityEvolution = new LayoutEvolution<G, M>(this.layout, concept, movement, 2.0, 2.0, 32, 1, 16, this.conflictDistance, ConExpFX.instance.executor.tpe);
        ConExpFX.execute(LayoutEvolution.calculate(qualityEvolution));
        return qualityEvolution;
    }

    public final void storeToFile() {
        ConExpFX.execute(new TimeTask<Void>((Dataset)this, "Store"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                switch (FileFormat.of(FCADataset.this.file, FileFormat.CFX, FileFormat.CXT).second()) {
                    case CXT: {
                        CXTExporter.export(FCADataset.this.context, (Map<Integer, Integer>)FCADataset.this.contextWidget.rowHeaderPane.rowMap, (Map<Integer, Integer>)FCADataset.this.contextWidget.colHeaderPane.columnMap, FCADataset.this.file);
                        break;
                    }
                    case CFX: {
                        CFXExporter.export(FCADataset.this.context, (Map<Integer, Integer>)FCADataset.this.contextWidget.rowHeaderPane.rowMap, (Map<Integer, Integer>)FCADataset.this.contextWidget.colHeaderPane.columnMap, FCADataset.this.layout, FCADataset.this.file);
                    }
                }
                Platform2.runOnFXThread(() -> {
                    FCADataset.this.id.set((Object)FCADataset.this.file.getName());
                    FCADataset.this.unsavedChanges.set(false);
                    ConExpFX.instance.fileHistory.remove((Object)FCADataset.this.file);
                    ConExpFX.instance.fileHistory.add(0, (Object)FCADataset.this.file);
                });
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
    }

    public void export(FileFormat svg, File file2) {
        this.exportToFile(file2);
    }

    public void exportTeX(TeXExporter.TeXOptions options) {
        try {
            new TeXExporter<G, M>(this.context, (Map<Integer, Integer>)this.contextWidget.rowHeaderPane.rowMap, (Map<Integer, Integer>)this.contextWidget.colHeaderPane.columnMap, this.layout, options).export();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void exportToFile(final File file) {
        ConExpFX.execute(new TimeTask<Void>((Dataset)this, "Export"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(0.5, 1.0);
                switch (FileFormat.of(file, FileFormat.TEX, FileFormat.PNG, FileFormat.SVG, FileFormat.PDF, FileFormat.HTML).second()) {
                    case TEX: {
                        FCADataset.this.exportTeX(new TeXExporter.TeXOptions(file, false, true, false, TeXExporter.ContextTeXPackage.Ganter, TeXExporter.DiagramTeXPackage.Ganter, new TeXExporter.FitScale(80, 120)));
                        break;
                    }
                    case PNG: {
                        PNGExporter.export(FCADataset.this.context, (Map<Integer, Integer>)FCADataset.this.contextWidget.rowHeaderPane.rowMap, (Map<Integer, Integer>)FCADataset.this.contextWidget.colHeaderPane.columnMap, FCADataset.this.layout, true, true, file);
                        break;
                    }
                    case SVG: {
                        SVGExporter.export(FCADataset.this.context, (Map<Integer, Integer>)FCADataset.this.contextWidget.rowHeaderPane.rowMap, (Map<Integer, Integer>)FCADataset.this.contextWidget.colHeaderPane.columnMap, FCADataset.this.layout, true, true, file);
                        break;
                    }
                    case PDF: {
                        PDFExporter.export(FCADataset.this.context, (Map<Integer, Integer>)FCADataset.this.contextWidget.rowHeaderPane.rowMap, (Map<Integer, Integer>)FCADataset.this.contextWidget.colHeaderPane.columnMap, FCADataset.this.layout, true, true, file);
                        break;
                    }
                    case HTML: {
                        HTMLExporter.export(FCADataset.this.context, (Map<Integer, Integer>)FCADataset.this.contextWidget.rowHeaderPane.rowMap, (Map<Integer, Integer>)FCADataset.this.contextWidget.colHeaderPane.columnMap, FCADataset.this.layout, true, true, file);
                    }
                }
                this.updateProgress(1.0, 1.0);
                return null;
            }
        });
    }

    @Override
    public final void save() {
        if (this.file == null) {
            this.saveAs();
        } else {
            this.storeToFile();
        }
    }

    @Override
    public final void saveAs() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Formal Context File");
        if (ConExpFX.instance.lastDirectory != null) {
            fileChooser.setInitialDirectory(ConExpFX.instance.lastDirectory);
        }
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Context & Lattice (ConExpFX Format, *.cfx)", new String[]{"*.cfx"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Only Context (Burmeister Format, *.cxt)", new String[]{"*.cxt"}));
        File file = fileChooser.showSaveDialog((Window)ConExpFX.instance.primaryStage);
        if (file != null) {
            this.file = file;
            ConExpFX.instance.lastDirectory = file.getParentFile();
            this.storeToFile();
        }
    }

    @Override
    public final void export() {
        FileChooser fileChooser = new FileChooser();
        if (ConExpFX.instance.lastDirectory != null) {
            fileChooser.setInitialDirectory(ConExpFX.instance.lastDirectory);
        }
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Context & Lattice (TeX - Ganter's fca.sty, *.tex)", new String[]{"*.tex"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Only Lattice (Portable Network Graphics, *.png)", new String[]{"*.png"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Only Lattice (Scalable Vector Graphics, *.svg)", new String[]{"*.svg"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Only Lattice (Portable Document Format, *.pdf)", new String[]{"*.pdf"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Only Context (Hypertext Markup Language, *.html)", new String[]{"*.html"}));
        File file = fileChooser.showSaveDialog((Window)ConExpFX.instance.primaryStage);
        if (file != null) {
            ConExpFX.instance.lastDirectory = file.getParentFile();
            this.exportToFile(file);
        }
    }

    @Deprecated
    public void exportTeX() {
        FXDialog.Return ret = new TeXDialog(ConExpFX.instance.primaryStage).showAndWait();
        if (ret.result().equals((Object)FXDialog.Answer.OK)) {
            FileChooser chooser = new FileChooser();
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("LaTeX File (*.tex)", new String[]{"*.tex"}));
            chooser.setInitialDirectory(ConExpFX.instance.lastDirectory);
            File file = chooser.showSaveDialog((Window)ConExpFX.instance.primaryStage);
            if (file == null) {
                return;
            }
            TeXExporter.TeXOptions value = (TeXExporter.TeXOptions)ret.value();
            value.file = file;
            this.exportTeX(value);
        }
    }

    public final void shutdown() {
    }

    @Override
    public void close() {
    }
}

