/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.dataset;

import conexp.fx.core.builder.Requests;
import conexp.fx.core.dl.OWLInterpretation;
import conexp.fx.core.importer.RDFImporter;
import conexp.fx.core.util.FileFormat;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.assistent.ModelAssistent;
import conexp.fx.gui.dataset.DLDataset;
import conexp.fx.gui.dataset.Dataset;
import conexp.fx.gui.dataset.DatasetAction;
import conexp.fx.gui.dataset.DatasetView;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.task.TimeTask;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.semanticweb.owlapi.model.IRI;

public class RDFDataset
extends Dataset {
    private final Repository repository = new SailRepository((Sail)new MemoryStore());
    private final ObservableList<Statement> statements = FXCollections.observableArrayList();

    public RDFDataset(File file, FileFormat format) {
        super(null, file, format);
        try {
            this.repository.initialize();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        this.views.add(new DatasetView<Repository>("Triples", (Node)this.createTriplesView(), this.repository));
        this.views.add(new DatasetView<Repository>("Query", (Node)this.createQueryView(), this.repository));
        this.defaultActiveViews.add("Triples");
        this.actions.add(new DatasetAction("New SPARQL Context...", () -> {}));
        this.actions.add(new DatasetAction("New DL Model...", () -> new ModelAssistent(this).showAndWait()));
        this.initialize();
    }

    public final void initialize() {
        if (this.format.equals((Object)FileFormat.CSVT)) {
            ConExpFX.execute(TimeTask.create((Dataset)this, "Importing RDF Dataset", () -> RDFImporter.readCSV(this.repository, this.file)));
        } else {
            ConExpFX.execute(TimeTask.create((Dataset)this, "Importing RDF Dataset", () -> RDFImporter.read(this.repository, this.file)));
        }
        ConExpFX.execute(TimeTask.create((Dataset)this, "Preparing Statements View", () -> {
            try {
                RepositoryConnection connection = this.repository.getConnection();
                Iterations.addAll((Iteration)connection.getStatements(null, null, null, true, new Resource[0]), this.statements);
                connection.close();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private final TableView<Statement> createTriplesView() {
        TableView table = new TableView(this.statements);
        TableColumn subjectColumn = new TableColumn("Subject");
        TableColumn predicateColumn = new TableColumn("Predicate");
        TableColumn objectColumn = new TableColumn("Object");
        subjectColumn.setCellValueFactory(f -> new ReadOnlyStringWrapper(((Statement)f.getValue()).getSubject().stringValue()));
        predicateColumn.setCellValueFactory(f -> new ReadOnlyStringWrapper(((Statement)f.getValue()).getPredicate().stringValue()));
        objectColumn.setCellValueFactory(f -> new ReadOnlyStringWrapper(((Statement)f.getValue()).getObject().stringValue()));
        table.getColumns().addAll((Object[])new TableColumn[]{subjectColumn, predicateColumn, objectColumn});
        return table;
    }

    private final Pane createQueryView() {
        BorderPane repositoryView = new BorderPane();
        TextArea queryArea = new TextArea();
        queryArea.setFont(Font.font((String)"Monospaced", (double)14.0));
        Button queryButton = new Button("Query");
        repositoryView.setTop((Node)new BorderPane((Node)queryArea, null, (Node)queryButton, null, null));
        TableView table = new TableView(FXCollections.observableArrayList());
        repositoryView.setCenter((Node)table);
        queryButton.setOnAction(__ -> {
            try {
                RepositoryConnection connection = this.repository.getConnection();
                TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, queryArea.getText());
                TupleQueryResult result = query.evaluate();
                table.getColumns().clear();
                result.getBindingNames().forEach(b -> {
                    TableColumn column = new TableColumn(b);
                    column.setCellValueFactory(f -> new ReadOnlyStringWrapper(((BindingSet)f.getValue()).getValue(b).stringValue()));
                    table.getColumns().add((Object)column);
                });
                table.getItems().clear();
                while (result.hasNext()) {
                    table.getItems().add(result.next());
                }
                result.close();
                connection.close();
            }
            catch (MalformedQueryException | QueryEvaluationException | RepositoryException e) {
                throw new RuntimeException(e);
            }
        });
        return repositoryView;
    }

    public final ObservableList<Statement> getTriples() {
        return this.statements;
    }

    public final Set<IRI> getRoles() {
        return this.statements.parallelStream().map(s -> IRI.create((String)s.getPredicate().stringValue())).collect(Collectors.toSet());
    }

    public final void createFormalContextFromSPARQLQuery(String query) {
        ConExpFX.execute(TimeTask.create((Dataset)this, "Extracting SPARQL Context", () -> ConExpFX.instance.treeView.addDataset(new FCADataset<String, String>(this, new Requests.Import.ImportSPARQLFromRepository(this.repository, query)))));
    }

    public final void createDLModel(List<IRI> selectedConceptNames, List<IRI> selectedRoleNames, IRI selectedIsARoleName) {
        ConExpFX.execute(TimeTask.create((Dataset)this, "Extracting DL Model", () -> {
            OWLInterpretation i = RDFImporter.extractInterpretation(this.statements, selectedConceptNames, selectedRoleNames, selectedIsARoleName);
            ConExpFX.instance.treeView.addDataset(new DLDataset(this, i));
        }));
    }

    @Override
    public void save() {
    }

    @Override
    public void saveAs() {
    }

    @Override
    public void export() {
    }

    @Override
    public void close() {
    }
}

