/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.dialog;

import conexp.fx.core.exporter.TeXExporter;
import conexp.fx.gui.dialog.FXDialog;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxBuilder;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioButtonBuilder;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToggleGroupBuilder;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import jfxtras.scene.control.ListSpinner;

public final class TeXDialog<G, M>
extends FXDialog<TeXExporter.TeXOptions> {
    public TeXDialog(Stage stage) {
        super(stage, FXDialog.Style.WARN, "TeX Export Wizard", "TeX Export Wizard Options", (Node)new VBox(), 270);
        VBox box = (VBox)this.pane.getCenter();
        box.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        box.setSpacing(4.0);
        this.value = new TeXExporter.TeXOptions(null, false, true, false, TeXExporter.ContextTeXPackage.None, TeXExporter.DiagramTeXPackage.ConExpFX, new TeXExporter.FitScale(80, 120));
        CheckBox arrowsCheckBox = ((CheckBoxBuilder)CheckBoxBuilder.create().text("Arrow Relations")).build();
        CheckBox labelsCheckBox = ((CheckBoxBuilder)CheckBoxBuilder.create().text("Concept Labels")).selected(true).build();
        CheckBox standAloneCheckBox = ((CheckBoxBuilder)((CheckBoxBuilder)CheckBoxBuilder.create().disable(true)).text("Stand-Alone Document")).build();
        RadioButton noneContextButton = ((RadioButtonBuilder)((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Context Package: None")).selected(true)).userData((Object)TeXExporter.ContextTeXPackage.None)).build();
        RadioButton ganterContextButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Context Package: Ganter")).userData((Object)TeXExporter.ContextTeXPackage.Ganter)).build();
        RadioButton tabularContextButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Context Package: Tabular")).userData((Object)TeXExporter.ContextTeXPackage.Tabular)).build();
        RadioButton noneDiagramButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Package: None")).userData((Object)TeXExporter.DiagramTeXPackage.None)).build();
        RadioButton ganterDiagramButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Package: Ganter")).userData((Object)TeXExporter.DiagramTeXPackage.Ganter)).build();
        RadioButton conExpFXDiagramButton = ((RadioButtonBuilder)((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Package: ConExpFX")).selected(true)).userData((Object)TeXExporter.DiagramTeXPackage.ConExpFX)).build();
        RadioButton fitButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Scale: Fit")).userData((Object)TeXExporter.ScaleEnum.Fit)).build();
        RadioButton fitWidthButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Scale: Fit Width")).userData((Object)TeXExporter.ScaleEnum.FitWidth)).build();
        RadioButton fitHeightButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Scale: Fit Height")).userData((Object)TeXExporter.ScaleEnum.FitHeight)).build();
        RadioButton fitRatioButton = ((RadioButtonBuilder)((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Scale: Fit Ratio")).selected(true)).userData((Object)TeXExporter.ScaleEnum.FitRatio)).build();
        final ListSpinner widthSpinner = new ListSpinner(1, 1000);
        final ListSpinner heightSpinner = new ListSpinner(1, 1000);
        widthSpinner.valueProperty().set((Object)80);
        heightSpinner.valueProperty().set((Object)120);
        widthSpinner.withPostfix("mm");
        heightSpinner.withPostfix("mm");
        widthSpinner.withEditable(Boolean.valueOf(true));
        widthSpinner.withStringConverter((StringConverter)new IntegerStringConverter());
        heightSpinner.withEditable(Boolean.valueOf(true));
        heightSpinner.withStringConverter((StringConverter)new IntegerStringConverter());
        widthSpinner.setMinWidth(100.0);
        widthSpinner.setMaxWidth(100.0);
        heightSpinner.setMinWidth(100.0);
        heightSpinner.setMaxWidth(100.0);
        ToggleGroup contextGroup = ToggleGroupBuilder.create().toggles(new Toggle[]{noneContextButton, ganterContextButton, tabularContextButton}).build();
        ToggleGroup diagramGroup = ToggleGroupBuilder.create().toggles(new Toggle[]{noneDiagramButton, ganterDiagramButton, conExpFXDiagramButton}).build();
        final ToggleGroup scaleGroup = ToggleGroupBuilder.create().toggles(new Toggle[]{fitButton, fitWidthButton, fitHeightButton, fitRatioButton}).build();
        arrowsCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ((TeXExporter.TeXOptions)TeXDialog.this.value).arrows = newValue;
            }
        });
        labelsCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ((TeXExporter.TeXOptions)TeXDialog.this.value).labels = newValue;
            }
        });
        standAloneCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ((TeXExporter.TeXOptions)TeXDialog.this.value).standAlone = newValue;
            }
        });
        contextGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldToggle, Toggle newToggle) {
                ((TeXExporter.TeXOptions)TeXDialog.this.value).contextTeXPackage = (TeXExporter.ContextTeXPackage)((Object)newToggle.getUserData());
            }
        });
        diagramGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldToggle, Toggle newToggle) {
                ((TeXExporter.TeXOptions)TeXDialog.this.value).diagramTeXPackage = (TeXExporter.DiagramTeXPackage)((Object)newToggle.getUserData());
            }
        });
        scaleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldToggle, Toggle newToggle) {
                ((TeXExporter.TeXOptions)TeXDialog.this.value).scale = ((TeXExporter.ScaleEnum)((Object)newToggle.getUserData())).toOption((Integer)widthSpinner.valueProperty().get(), (Integer)heightSpinner.valueProperty().get());
                widthSpinner.disableProperty().set((TeXExporter.ScaleEnum)((Object)newToggle.getUserData()) == TeXExporter.ScaleEnum.FitHeight);
                heightSpinner.disableProperty().set((TeXExporter.ScaleEnum)((Object)newToggle.getUserData()) == TeXExporter.ScaleEnum.FitWidth);
            }
        });
        widthSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                ((TeXExporter.TeXOptions)TeXDialog.this.value).scale = ((TeXExporter.ScaleEnum)((Object)((Toggle)scaleGroup.selectedToggleProperty().get()).getUserData())).toOption(newValue, (Integer)heightSpinner.valueProperty().get());
            }
        });
        heightSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                ((TeXExporter.TeXOptions)TeXDialog.this.value).scale = ((TeXExporter.ScaleEnum)((Object)((Toggle)scaleGroup.selectedToggleProperty().get()).getUserData())).toOption((Integer)widthSpinner.valueProperty().get(), newValue);
            }
        });
        box.getChildren().addAll((Object[])new Node[]{((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().padding(new Insets(2.0, 0.0, 2.0, 0.0))).spacing(4.0).children(new Node[]{arrowsCheckBox, labelsCheckBox, standAloneCheckBox})).build()});
        box.getChildren().addAll((Object[])new Node[]{((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().padding(new Insets(2.0, 0.0, 2.0, 0.0))).spacing(4.0).children(new Node[]{noneContextButton, ganterContextButton, tabularContextButton})).build()});
        box.getChildren().addAll((Object[])new Node[]{((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().padding(new Insets(2.0, 0.0, 2.0, 0.0))).spacing(4.0).children(new Node[]{noneDiagramButton, ganterDiagramButton, conExpFXDiagramButton})).build()});
        box.getChildren().addAll((Object[])new Node[]{((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().padding(new Insets(2.0, 0.0, 0.0, 0.0))).spacing(4.0).children(new Node[]{fitButton, fitWidthButton, fitHeightButton, fitRatioButton})).build()});
        box.getChildren().addAll((Object[])new Node[]{((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().padding(new Insets(0.0, 0.0, 2.0, 0.0))).spacing(4.0).children(new Node[]{widthSpinner, heightSpinner})).build()});
    }
}

