/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph;

import be.humphreys.simplevoronoi.GraphEdge;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.layout.LayoutEvolution;
import conexp.fx.core.math.GuavaIsomorphism;
import conexp.fx.core.math.VoronoiGenerator;
import conexp.fx.gui.graph.option.AnimationSpeed;
import conexp.fx.gui.graph.option.EdgeHighlight;
import conexp.fx.gui.graph.option.GraphTransformation;
import conexp.fx.gui.graph.transformation.PolarTransformation;
import conexp.fx.gui.graph.transformation.RotationXY;
import conexp.fx.gui.util.LaTeX;
import conexp.fx.gui.util.Platform2;
import conexp.fx.gui.util.SynchronizedPane;
import conexp.fx.gui.util.TransitionTimer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import javafx.animation.FadeTransitionBuilder;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.LabelBuilder;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.StackPaneBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.util.Duration;

public abstract class Graph<T, N extends Node>
extends BorderPane {
    public static final Color COLOR_DEFAULT = Color.valueOf((String)"#0576B0");
    public static final Color COLOR_LABEL_DEFAULT = Color.valueOf((String)"#EEEEEE");
    public final Controller controller;
    protected final Map<T, Vertex> vertices = new ConcurrentHashMap<T, Vertex>();
    protected final Map<Pair<T, T>, Edge> edges = new ConcurrentHashMap<Pair<T, T>, Edge>();
    protected final SynchronizedPane front = new SynchronizedPane();
    protected final SynchronizedPane back = new SynchronizedPane();
    protected AnimationSpeed speed = AnimationSpeed.DEFAULT;
    protected final ObjectProperty<GraphTransformation> transformation = new SimpleObjectProperty((Object)GraphTransformation.GRAPH_3D);
    protected final DoubleProperty zoom = new SimpleDoubleProperty(1.0);
    protected final IntegerProperty textSize = new SimpleIntegerProperty(12);
    protected final ObjectProperty<Point2D> pan = new SimpleObjectProperty((Object)new Point2D(0.0, 0.0));

    protected Graph(Observable ... observable) {
        this.controller = new Controller(observable);
        this.setCenter((Node)((StackPaneBuilder)StackPaneBuilder.create().children(new Node[]{this.back, this.front})).build());
        this.front.addEventHandler(ScrollEvent.SCROLL, (EventHandler)new EventHandler<ScrollEvent>(){

            public final void handle(ScrollEvent event) {
                if (event.getDeltaY() > 0.0) {
                    Graph.this.zoom.set(Graph.this.zoom.get() * 1.1);
                } else if (event.getDeltaY() < 0.0) {
                    Graph.this.zoom.set(Graph.this.zoom.get() / 1.1);
                }
            }
        });
        EventHandler<MouseEvent> panHandler = new EventHandler<MouseEvent>(){
            private double startX;
            private double startY;
            private double panX;
            private double panY;

            public final void handle(MouseEvent event) {
                if (!event.getButton().equals((Object)MouseButton.SECONDARY)) {
                    return;
                }
                if (event.getEventType().equals(MouseEvent.MOUSE_PRESSED)) {
                    this.startX = event.getSceneX();
                    this.startY = event.getSceneY();
                    this.panX = ((Point2D)Graph.this.pan.get()).getX();
                    this.panY = ((Point2D)Graph.this.pan.get()).getY();
                } else if (!event.getEventType().equals(MouseEvent.MOUSE_RELEASED) && event.getEventType().equals(MouseEvent.MOUSE_DRAGGED)) {
                    double deltaX = event.getSceneX() - this.startX;
                    double deltaY = event.getSceneY() - this.startY;
                    Graph.this.pan.set((Object)new Point2D(this.panX + deltaX, this.panY + deltaY));
                }
            }
        };
        this.front.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)panHandler);
        this.front.addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)panHandler);
        this.front.addEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)panHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Collection<Edge> lowerEdges(final T element) {
        Map<Pair<T, T>, Edge> map = this.edges;
        synchronized (map) {
            return Maps.filterKeys(this.edges, (Predicate)new Predicate<Pair<T, T>>(){

                public final boolean apply(Pair<T, T> p) {
                    return p.second().equals(element);
                }
            }).values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Collection<Edge> upperEdges(final T element) {
        Map<Pair<T, T>, Edge> map = this.edges;
        synchronized (map) {
            return Maps.filterKeys(this.edges, (Predicate)new Predicate<Pair<T, T>>(){

                public final boolean apply(Pair<T, T> p) {
                    return p.first().equals(element);
                }
            }).values();
        }
    }

    protected abstract BoundingBox getContentBoundingBox();

    protected abstract void initPolarBottom(Config var1, Timeline var2);

    protected abstract void drawPolarBottom(Config var1, Timeline var2);

    protected abstract void resetPolarBottom(Config var1, Timeline var2);

    public abstract void highlight(boolean var1, Iterable<HighlightRequest> ... var2);

    public void removeContent() {
        this.front.getChildren().clear();
        this.back.getChildren().clear();
        this.edges.clear();
        this.vertices.clear();
    }

    public class Controller {
        protected final ObjectBinding<Config> config;
        private boolean isLocked = false;
        private boolean isDragging = false;
        private AnimationSpeed speedBeforeDrag;
        protected final BooleanProperty showVoronoi = new SimpleBooleanProperty(false);
        protected final Queue<Vertex> addVertices = new ConcurrentLinkedQueue<Vertex>();
        protected final Queue<Edge> addEdges = new ConcurrentLinkedQueue<Edge>();
        protected final Queue<Label> addLabels = new ConcurrentLinkedQueue<Label>();
        protected final Queue<Tile> addTiles = new ConcurrentLinkedQueue<Tile>();
        protected final Queue<Pair<T, T>> removeVertices = new ConcurrentLinkedQueue();
        protected final Queue<Pair<T, T>> removeEdges = new ConcurrentLinkedQueue();
        protected final Queue<Label> removeLabels = new ConcurrentLinkedQueue<Label>();
        protected final Set<Vertex> pendingVertices = Collections3.newConcurrentHashSet();
        protected final Set<Edge> pendingEdges = Collections3.newConcurrentHashSet();
        public Vertex polarBottom = null;
        public boolean graphLock = false;

        protected Controller(final Observable ... observable) {
            this.config = new ObjectBinding<Config>(){
                private Config value;
                {
                    Arrays.asList(observable).forEach(xva$0 -> this.bind(new Observable[]{xva$0}));
                    this.bind(new Observable[]{Graph.this.front.widthProperty(), Graph.this.front.heightProperty(), Graph.this.transformation, Controller.this.showVoronoi, Graph.this.zoom, Graph.this.pan});
                }

                protected Config computeValue() {
                    if (!Controller.this.isDragging) {
                        double y0;
                        double x0;
                        double f;
                        GuavaIsomorphism iso;
                        BoundingBox box = Graph.this.getContentBoundingBox();
                        double w = Graph.this.front.widthProperty().get();
                        double h = Graph.this.front.heightProperty().get();
                        switch ((GraphTransformation)((Object)Graph.this.transformation.get())) {
                            case GRAPH_3D: 
                            case GRAPH_2D: {
                                iso = GuavaIsomorphism.identity();
                                double widthRatio = box.getWidth() < 0.001 ? Double.MAX_VALUE : w / box.getWidth();
                                double heightRatio = box.getHeight() < 0.001 ? Double.MAX_VALUE : h / box.getHeight();
                                double depthRatio = box.getDepth() < 0.001 ? Double.MAX_VALUE : w / box.getDepth();
                                double paneToLayoutRatio = Math.min(widthRatio, Math.min(heightRatio, depthRatio));
                                f = 0.9 * (paneToLayoutRatio == Double.MAX_VALUE ? 1.0 : paneToLayoutRatio);
                                x0 = -box.getMinX() * f + (w - box.getWidth() * f) / 2.0;
                                y0 = -box.getMinY() * f + (h - box.getHeight() * f) / 2.0;
                                break;
                            }
                            case XY: {
                                iso = new RotationXY(new Point3D(0.0, 0.0, 0.0), -2.356194490192345);
                                Point3D top2 = (Point3D)iso.apply(new Point3D(box.getMaxX(), box.getMaxY(), 0.0));
                                Point3D left = (Point3D)iso.apply(new Point3D(box.getMaxX(), box.getMinY(), 0.0));
                                Point3D right = (Point3D)iso.apply(new Point3D(box.getMinX(), box.getMaxY(), 0.0));
                                Point3D bot = (Point3D)iso.apply(new Point3D(box.getMinX(), box.getMinY(), 0.0));
                                double width = Math.abs(right.getX() - left.getX());
                                double height = Math.abs(top2.getY() - bot.getY());
                                f = 0.9 * Math.min(w / width, h / height);
                                x0 = -left.getX() * f + (w - width * f) / 2.0;
                                y0 = -top2.getY() * f + (h - height * f) / 2.0;
                                break;
                            }
                            case POLAR: {
                                iso = new PolarTransformation(box.getMinX(), box.getWidth());
                                f = box.getHeight() < 0.001 ? 1.0 : 0.9 * (Math.min(w, h) / (2.0 * box.getHeight()));
                                x0 = w / 2.0;
                                y0 = h / 2.0;
                                break;
                            }
                            default: {
                                iso = GuavaIsomorphism.identity();
                                f = 1.0;
                                x0 = 0.0;
                                y0 = 0.0;
                            }
                        }
                        this.value = new Config(iso, box, f * Graph.this.zoom.get(), x0 + ((Point2D)Graph.this.pan.get()).getX(), y0 + ((Point2D)Graph.this.pan.get()).getY(), w, h);
                    } else {
                        this.invalidate();
                    }
                    return this.value;
                }
            };
            this.config.addListener(new InvalidationListener(){

                public final void invalidated(Observable observable) {
                    Controller.this.refresh();
                }
            });
            this.showVoronoi.addListener((ChangeListener)new ChangeListener<Boolean>(){

                public final void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (!newValue.booleanValue()) {
                        Platform2.runOnFXThread(() -> Graph.this.back.getChildren().clear());
                    }
                }
            });
            this.refresh();
        }

        public final void drag() {
            this.isDragging = true;
            this.speedBeforeDrag = Graph.this.speed;
            Graph.this.speed = AnimationSpeed.FASTESTEST;
        }

        public final void dragDone() {
            this.isDragging = false;
            Graph.this.speed = this.speedBeforeDrag;
        }

        public final boolean isDragging() {
            return this.isDragging;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void disposeVertex(T element, T to) {
            Queue queue = this.removeVertices;
            synchronized (queue) {
                this.removeVertices.offer(Pair.of(element, to));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void disposeEdge(Pair<T, T> elements) {
            Queue queue = this.removeEdges;
            synchronized (queue) {
                this.removeEdges.offer(elements);
            }
        }

        protected final void clearBack() {
            Platform2.runOnFXThread(Graph.this.back::clear);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void clean() {
            Set children = Collections3.newConcurrentHashSet();
            Map<Object, Object> map = Graph.this.vertices;
            synchronized (map) {
                Graph.this.vertices.values().parallelStream().map(v -> v.node).forEach(children::add);
                Graph.this.vertices.values().parallelStream().map(v -> v.lowerLabels.parallelStream()).reduce(Stream::concat).ifPresent(s -> s.map(l -> l.content).forEach(children::add));
                Graph.this.vertices.values().parallelStream().map(v -> v.upperLabels.parallelStream()).reduce(Stream::concat).ifPresent(s -> s.map(l -> l.content).forEach(children::add));
            }
            map = Graph.this.edges;
            synchronized (map) {
                Graph.this.edges.values().parallelStream().map(e -> e.line).forEach(children::add);
            }
            Graph.this.front.getChildren().retainAll(children);
        }

        public final synchronized void refresh() {
            if (this.isLocked) {
                return;
            }
            Timeline t = new Timeline();
            Config c = (Config)this.config.get();
            this.removeContent(t);
            this.addContent(t);
            this.refreshBottom(c, t);
            this.refreshVertices(c, t);
            if (this.showVoronoi.get()) {
                this.refreshVoronoi(c, t);
            } else {
                this.refreshTiles(c, t);
            }
            t.setOnFinished(__ -> this.clean());
            Platform2.runOnFXThread(() -> ((Timeline)t).play());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addContent(Timeline t) {
            Transition fadeIn;
            Queue<Object> queue = this.addVertices;
            synchronized (queue) {
                while (!this.addVertices.isEmpty()) {
                    Vertex v = this.addVertices.poll();
                    fadeIn = this.fadeIn((Node)v.node);
                    t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, __ -> {
                        Graph.this.front.add(new Node[]{v.node});
                        fadeIn.play();
                    }, new KeyValue[0]));
                }
            }
            queue = this.addEdges;
            synchronized (queue) {
                while (!this.addEdges.isEmpty()) {
                    Edge e = this.addEdges.poll();
                    e.initialize();
                    t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, __ -> {
                        e.initialize();
                        Graph.this.front.add(new Node[]{e.line});
                        e.line.toBack();
                        this.fadeIn(e).play();
                    }, new KeyValue[0]));
                }
            }
            queue = this.addLabels;
            synchronized (queue) {
                while (!this.addLabels.isEmpty()) {
                    Label l = this.addLabels.poll();
                    l.content.opacityProperty().set(0.0);
                    fadeIn = FadeTransitionBuilder.create().node((Node)l.content).duration(Graph.this.speed.frameSize).toValue(0.0).build();
                    Transition fadeIn2 = this.fadeIn((Node)l.content);
                    fadeIn.setOnFinished(__ -> {
                        l.content.toFront();
                        l.content.layoutXProperty().set(((Point2D)l.shift.getValue()).getX() - l.content.widthProperty().get() / 2.0);
                        l.content.layoutYProperty().set(((Point2D)l.shift.getValue()).getY() + l.index.doubleValue() * l.content.heightProperty().get());
                        l.content.setVisible(true);
                        l.isInitialized = true;
                        fadeIn2.play();
                    });
                    t.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, __ -> {
                        l.content.setVisible(false);
                        Graph.this.front.add(new Node[]{l.content});
                        fadeIn.play();
                    }, new KeyValue[0]));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void removeContent(Timeline t) {
            Collection<Object> collection = this.removeVertices;
            synchronized (collection) {
                Object edge;
                Map map;
                Iterator<Vertex> iterator = this.removeEdges;
                synchronized (iterator) {
                    this.removeEdges.removeAll(this.removeVertices);
                    Pair e = this.removeEdges.poll();
                    while (e != null) {
                        map = Graph.this.edges;
                        synchronized (map) {
                            edge = Graph.this.edges.remove(e);
                        }
                        edge.isDisposing = true;
                        edge.line.opacityProperty().unbind();
                        map = this.pendingEdges;
                        synchronized (map) {
                            this.pendingEdges.add((Edge)edge);
                        }
                        e = this.removeEdges.poll();
                    }
                }
                Pair v = this.removeVertices.poll();
                while (v != null) {
                    Edge edge2;
                    Vertex to;
                    Vertex vertex;
                    edge = Graph.this.vertices;
                    synchronized (edge) {
                        vertex = Graph.this.vertices.remove(v.first());
                    }
                    edge = vertex.lowerLabels;
                    synchronized (edge) {
                        for (LowerLabel l : vertex.lowerLabels) {
                            l.dispose();
                        }
                    }
                    edge = vertex.upperLabels;
                    synchronized (edge) {
                        for (UpperLabel u : vertex.upperLabels) {
                            u.dispose();
                        }
                    }
                    if (v.second() == null) {
                        edge = this.pendingVertices;
                        synchronized (edge) {
                            this.pendingVertices.add(vertex);
                        }
                    }
                    map = Graph.this.vertices;
                    synchronized (map) {
                        to = Graph.this.vertices.get(v.second());
                    }
                    Object object = Graph.this.edges;
                    synchronized (object) {
                        edge2 = Graph.this.edges.remove(v);
                    }
                    edge2.isDisposing = true;
                    edge2.line.opacityProperty().unbind();
                    object = to.pendingVertices;
                    synchronized (object) {
                        to.pendingVertices.add(Pair.of(vertex, edge2));
                    }
                    v = this.removeVertices.poll();
                }
            }
            collection = this.pendingEdges;
            synchronized (collection) {
                for (Edge edge : this.pendingEdges) {
                    t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, this.dispose(edge), new KeyValue[]{this.fadeOut((Node)edge.line)}));
                }
            }
            collection = this.pendingVertices;
            synchronized (collection) {
                for (Vertex vertex : this.pendingVertices) {
                    t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, this.dispose(vertex), new KeyValue[]{this.fadeOut((Node)vertex.node)}));
                }
            }
            collection = this.removeLabels;
            synchronized (collection) {
                for (Label label : this.removeLabels) {
                    t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, this.dispose(label), new KeyValue[]{this.fadeOut((Node)label.content)}));
                }
            }
        }

        private final void refreshBottom(Config c, Timeline t) {
            switch ((GraphTransformation)((Object)Graph.this.transformation.get())) {
                case GRAPH_3D: 
                case GRAPH_2D: 
                case XY: {
                    if (this.polarBottom == null) break;
                    Graph.this.resetPolarBottom(c, t);
                    break;
                }
                case POLAR: {
                    if (this.polarBottom == null) {
                        Graph.this.initPolarBottom(c, t);
                    }
                    if (this.polarBottom == null) break;
                    Graph.this.drawPolarBottom(c, t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void refreshVertices(Config c, Timeline t) {
            Map map = Graph.this.vertices;
            synchronized (map) {
                for (Vertex v : Graph.this.vertices.values()) {
                    if (v.equals(this.polarBottom)) continue;
                    Point3D p = c.toPane((Point3D)v.position.getValue());
                    t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, new KeyValue[]{this.translateX((Node)v.node, p), this.translateY((Node)v.node, p), this.fadeZ((Node)v.node, p)}));
                    Object object = v.lowerLabels;
                    synchronized (object) {
                        for (LowerLabel l : v.lowerLabels) {
                            if (l.isInitialized) {
                                t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, new KeyValue[]{this.translateX((Node)l.content, p), this.translateY((Node)l.content, p), this.fadeZ((Node)l.content, p), this.layoutX(l), this.layoutY(l)}));
                                continue;
                            }
                            t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, new KeyValue[]{this.translateX((Node)l.content, p), this.translateY((Node)l.content, p), this.fadeZ((Node)l.content, p)}));
                        }
                    }
                    object = v.upperLabels;
                    synchronized (object) {
                        for (UpperLabel u : v.upperLabels) {
                            if (u.isInitialized) {
                                t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, new KeyValue[]{this.translateX((Node)u.content, p), this.translateY((Node)u.content, p), this.fadeZ((Node)u.content, p), this.layoutX(u), this.layoutY(u)}));
                                continue;
                            }
                            t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, new KeyValue[]{this.translateX((Node)u.content, p), this.translateY((Node)u.content, p), this.fadeZ((Node)u.content, p)}));
                        }
                    }
                    object = v.pendingVertices;
                    synchronized (object) {
                        for (Pair<Vertex, Edge> pv : v.pendingVertices) {
                            t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, this.dispose(v, pv), new KeyValue[]{this.translateX((Node)pv.first().node, p), this.translateY((Node)pv.first().node, p), this.fadeZ((Node)pv.first().node, p), this.fadeOut((Node)pv.first().node), this.fadeOut((Node)pv.second().line)}));
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void refreshTiles(Config c, Timeline t) {
            Queue<Tile> queue = this.addTiles;
            synchronized (queue) {
                while (!this.addTiles.isEmpty()) {
                    Tile tile = this.addTiles.poll();
                    Graph.this.back.add(new Node[]{tile});
                    t.getKeyFrames().add((Object)new KeyFrame(Graph.this.speed.frameSize, new KeyValue[]{new KeyValue((WritableValue)tile.translateXProperty(), (Object)(c.x0 + c.f * tile.rect.getMinX())), new KeyValue((WritableValue)tile.translateYProperty(), (Object)(c.y0 + c.f * tile.rect.getMinY())), new KeyValue((WritableValue)tile.widthProperty(), (Object)(c.f * tile.rect.getWidth())), new KeyValue((WritableValue)tile.heightProperty(), (Object)(c.f * tile.rect.getHeight()))}));
                }
            }
        }

        private final void refreshVoronoi(Config c, Timeline t) {
            t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, __ -> new TransitionTimer(Graph.this.speed.frameSize, (EventHandler<ActionEvent>)((EventHandler)___ -> {
                Graph.this.back.clear();
                Map map = Graph.this.vertices;
                synchronized (map) {
                    for (GraphEdge e : VoronoiGenerator.generate(Collections2.transform((Collection)Collections2.filter(Graph.this.vertices.values(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)this.polarBottom))), (Function)new Function<Vertex, Point3D>(){

                        public final Point3D apply(Vertex v) {
                            return new Point3D(v.node.translateXProperty().get(), v.node.translateYProperty().get(), 0.0);
                        }
                    }), 0.0, c.w, 0.0, c.h)) {
                        Line l = new Line(e.x1, e.y1, e.x2, e.y2);
                        l.setStroke((Paint)Color.RED);
                        Graph.this.back.add(new Node[]{l});
                    }
                }
            })).play(), new KeyValue[0]));
        }

        protected final KeyValue translateX(Node n, Point3D p) {
            return new KeyValue((WritableValue)n.translateXProperty(), (Object)p.getX());
        }

        protected final KeyValue translateY(Node n, Point3D p) {
            return new KeyValue((WritableValue)n.translateYProperty(), (Object)p.getY());
        }

        protected final KeyValue fadeZ(Node n, Point3D p) {
            return new KeyValue((WritableValue)n.opacityProperty(), (Object)Math.pow(1.0 - 0.9 * p.getZ(), 2.5));
        }

        private final KeyValue layoutX(Label label) {
            return new KeyValue((WritableValue)label.content.layoutXProperty(), (Object)(((Point2D)label.shift.getValue()).getX() - label.content.widthProperty().get() / 2.0));
        }

        private final KeyValue layoutY(Label label) {
            return new KeyValue((WritableValue)label.content.layoutYProperty(), (Object)(((Point2D)label.shift.getValue()).getY() + label.index.doubleValue() * label.content.heightProperty().get()));
        }

        protected final Transition fadeIn(Node n) {
            n.opacityProperty().set(0.0);
            return FadeTransitionBuilder.create().node(n).duration(Graph.this.speed.frameSize).toValue(1.0).build();
        }

        protected final Transition fadeIn(Edge e) {
            e.line.opacityProperty().set(0.0);
            return ((FadeTransitionBuilder)FadeTransitionBuilder.create().node((Node)e.line).duration(Graph.this.speed.frameSize).toValue(e.opacity.get()).onFinished(__ -> {
                if (!e.isDisposing) {
                    e.bindOpacity();
                }
            })).build();
        }

        protected final KeyValue fadeOut(Node n) {
            return new KeyValue((WritableValue)n.opacityProperty(), (Object)0.0);
        }

        private final EventHandler<ActionEvent> dispose(Vertex vertex) {
            return __ -> {
                Set<Object> set = this.pendingVertices;
                synchronized (set) {
                    this.pendingVertices.remove(vertex);
                }
                vertex.dispose();
                Graph.this.front.remove(new Node[]{vertex.node});
                set = vertex.pendingVertices;
                synchronized (set) {
                    if (!vertex.pendingVertices.isEmpty()) {
                        Set<Vertex> set2 = this.pendingVertices;
                        synchronized (set2) {
                            Set<Edge> set3 = this.pendingEdges;
                            synchronized (set3) {
                                for (Pair<Vertex, Edge> p : vertex.pendingVertices) {
                                    this.pendingVertices.add(p.first());
                                    this.pendingEdges.add(p.second());
                                }
                            }
                        }
                    }
                }
            };
        }

        private final EventHandler<ActionEvent> dispose(Edge edge) {
            return __ -> {
                Set<Edge> set = this.pendingEdges;
                synchronized (set) {
                    this.pendingEdges.remove(edge);
                }
                edge.dispose();
                Graph.this.front.remove(new Node[]{edge.line});
            };
        }

        private final EventHandler<ActionEvent> dispose(Vertex v, Pair<Vertex, Edge> pv) {
            return __ -> {
                Set<Pair<Vertex, Edge>> set = v.pendingVertices;
                synchronized (set) {
                    v.pendingVertices.remove(pv);
                }
                ((Edge)pv.second()).dispose();
                ((Vertex)pv.first()).dispose();
                Graph.this.front.remove(new Node[]{((Edge)pv.second()).line});
                Graph.this.front.remove(new Node[]{((Vertex)pv.first()).node});
                set = ((Vertex)pv.first()).pendingVertices;
                synchronized (set) {
                    if (!((Vertex)pv.first()).pendingVertices.isEmpty()) {
                        Set<Vertex> set2 = this.pendingVertices;
                        synchronized (set2) {
                            Set<Edge> set3 = this.pendingEdges;
                            synchronized (set3) {
                                for (Pair<Vertex, Edge> p : ((Vertex)pv.first()).pendingVertices) {
                                    this.pendingVertices.add(p.first());
                                    this.pendingEdges.add(p.second());
                                }
                            }
                        }
                    }
                }
            };
        }

        private final EventHandler<ActionEvent> dispose(Label label) {
            return __ -> {
                Queue<Label> queue = this.removeLabels;
                synchronized (queue) {
                    this.removeLabels.remove(label);
                }
                Graph.this.front.remove(new Node[]{label.content});
            };
        }
    }

    protected final class Config {
        public final GuavaIsomorphism<Point3D, Point3D> iso;
        public final BoundingBox box;
        public final double f;
        public final double x0;
        public final double y0;
        public final double w;
        public final double h;

        protected Config(GuavaIsomorphism<Point3D, Point3D> iso, BoundingBox box, double f, double x0, double y0, double w, double h) {
            this.iso = iso;
            this.box = box;
            this.f = f;
            this.x0 = x0;
            this.y0 = y0;
            this.w = w;
            this.h = h;
        }

        protected final Point3D toPane(Point3D p) {
            Point3D q = (Point3D)this.iso.apply(p);
            double z = (q.getZ() - this.box.getMinZ()) / (this.box.getMaxZ() - this.box.getMinZ());
            return new Point3D(q.getX() * this.f + this.x0, q.getY() * this.f + this.y0, z);
        }

        protected final Point3D toContent(Point3D p) {
            return this.iso.invert(new Point3D((p.getX() - this.x0) / this.f, (p.getY() - this.y0) / this.f, 0.0));
        }

        protected final Point3D toContent(Point2D p) {
            return this.iso.invert(new Point3D((p.getX() - this.x0) / this.f, (p.getY() - this.y0) / this.f, 0.0));
        }
    }

    protected class HighlightRequest {
        protected final Set<T> elements;
        protected final EdgeHighlight edgeHighlightOption;
        protected final Color vertexColor;
        protected final Color edgeColor;
        protected final Color objectLabelBackColor;
        protected final Color objectLabelTextColor;
        protected final Color attributeLabelBackColor;
        protected final Color attributeLabelTextColor;

        protected HighlightRequest(Set<T> elements, EdgeHighlight edgeHighlightPolicy, Color vertexColor, Color edgeColor, Color objectLabelBackColor, Color objectLabelTextColor, Color attributeLabelBackColor, Color attributeLabelTextColor) {
            this.elements = elements;
            this.edgeHighlightOption = edgeHighlightPolicy;
            this.vertexColor = vertexColor;
            this.edgeColor = edgeColor;
            this.objectLabelBackColor = objectLabelBackColor;
            this.objectLabelTextColor = objectLabelTextColor;
            this.attributeLabelBackColor = attributeLabelBackColor;
            this.attributeLabelTextColor = attributeLabelTextColor;
        }
    }

    protected class Tile
    extends Rectangle {
        protected final Rectangle2D rect;

        protected Tile(LayoutEvolution.Value value, Double initialX, Double initialY) {
            this(value.rectangle);
            if (value.result > 1.0) {
                this.setFill((Paint)Color.RED);
            } else {
                this.setFill((Paint)Color.rgb((int)((int)(255.0 * Math.pow(1.0 - value.result, 0.125))), (int)255, (int)255));
            }
            if (initialX != null) {
                this.translateXProperty().set(initialX.doubleValue());
            }
            if (initialY != null) {
                this.translateYProperty().set(initialY.doubleValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Tile(Rectangle2D rect) {
            this.rect = rect;
            Queue<Tile> queue = Graph.this.controller.addTiles;
            synchronized (queue) {
                Graph.this.controller.addTiles.add(this);
            }
        }
    }

    protected abstract class UpperLabel
    extends Label {
        protected UpperLabel(ObservableValue<T> element, ObservableValue<String> string, boolean showLaTeX) {
            super(element, string, showLaTeX);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void rebind(Vertex from, final Vertex to) {
            ObservableList<UpperLabel> observableList;
            if (from != null) {
                observableList = from.upperLabels;
                synchronized (observableList) {
                    from.upperLabels.remove((Object)this);
                }
            }
            observableList = to.upperLabels;
            synchronized (observableList) {
                to.upperLabels.add((Object)this);
            }
            this.index.bind((ObservableValue)new IntegerBinding(){
                {
                    this.bind(new Observable[]{to.upperLabels});
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected int computeValue() {
                    ObservableList<UpperLabel> observableList = to.upperLabels;
                    synchronized (observableList) {
                        return -to.upperLabels.indexOf((Object)UpperLabel.this) - 1;
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispose() {
            super.dispose();
            Vertex v = (Vertex)this.vertex.get();
            ObservableList<UpperLabel> observableList = v.upperLabels;
            synchronized (observableList) {
                v.upperLabels.remove((Object)this);
            }
        }
    }

    protected abstract class LowerLabel
    extends Label {
        protected LowerLabel(ObservableValue<T> element, ObservableValue<String> string, boolean showLaTeX) {
            super(element, string, showLaTeX);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void rebind(Vertex from, final Vertex to) {
            ObservableList<LowerLabel> observableList;
            if (from != null) {
                observableList = from.lowerLabels;
                synchronized (observableList) {
                    from.lowerLabels.remove((Object)this);
                }
            }
            observableList = to.lowerLabels;
            synchronized (observableList) {
                to.lowerLabels.add((Object)this);
            }
            this.index.bind((ObservableValue)new IntegerBinding(){
                {
                    this.bind(new Observable[]{to.lowerLabels});
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected int computeValue() {
                    ObservableList<LowerLabel> observableList = to.lowerLabels;
                    synchronized (observableList) {
                        return to.lowerLabels.indexOf((Object)LowerLabel.this);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispose() {
            super.dispose();
            Vertex v = (Vertex)this.vertex.get();
            ObservableList<LowerLabel> observableList = v.lowerLabels;
            synchronized (observableList) {
                v.lowerLabels.remove((Object)this);
            }
        }
    }

    protected abstract class Label {
        protected final ObservableValue<T> element;
        protected final ObjectBinding<Vertex> vertex;
        protected final ImageView tex = new ImageView();
        protected final Text text = new Text();
        protected final boolean showLaTeX;
        protected final Rectangle back = new Rectangle();
        protected final StackPane content = ((StackPaneBuilder)StackPaneBuilder.create().children(new Node[]{this.back})).build();
        protected final IntegerProperty index = new SimpleIntegerProperty(0);
        protected final ObjectProperty<Point2D> shift = new SimpleObjectProperty((Object)new Point2D(0.0, 0.0));
        protected boolean isInitialized = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Label(final ObservableValue<T> element, ObservableValue<String> string, boolean showLaTeX) {
            this.showLaTeX = showLaTeX;
            if (showLaTeX) {
                this.content.getChildren().add((Object)((LabelBuilder)LabelBuilder.create().graphic((Node)this.tex)).build());
            } else {
                this.content.getChildren().add((Object)this.text);
            }
            this.element = element;
            this.vertex = new ObjectBinding<Vertex>(){
                {
                    this.bind(new Observable[]{element});
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected final Vertex computeValue() {
                    Map map = Graph.this.vertices;
                    synchronized (map) {
                        return Graph.this.vertices.get(element.getValue());
                    }
                }
            };
            this.rebind(null, (Vertex)this.vertex.get());
            this.vertex.addListener((ChangeListener)new ChangeListener<Vertex>(){

                public final void changed(ObservableValue<? extends Vertex> observable, Vertex from, Vertex to) {
                    Label.this.rebind(from, to);
                }
            });
            if (showLaTeX) {
                this.tex.imageProperty().bind(LaTeX.toFXImageBinding(string, (ObservableValue<Number>)new FloatBinding(){
                    {
                        this.bind(new Observable[]{Graph.this.zoom, Graph.this.textSize});
                    }

                    protected final float computeValue() {
                        return (float)(Graph.this.zoom.get() * (double)Graph.this.textSize.get());
                    }
                }));
            } else {
                this.text.textProperty().bind(string);
            }
            this.createContent();
            Queue<Label> queue = Graph.this.controller.addLabels;
            synchronized (queue) {
                Graph.this.controller.addLabels.offer(this);
            }
        }

        protected abstract void rebind(Vertex var1, Vertex var2);

        private void createContent() {
            this.back.setFill((Paint)COLOR_LABEL_DEFAULT);
            this.back.setStrokeType(StrokeType.OUTSIDE);
            this.back.setStroke((Paint)Color.BLACK);
            this.back.setStrokeWidth(0.25);
            this.back.setOpacity(0.8);
            if (this.showLaTeX) {
                this.back.widthProperty().bind((ObservableValue)new DoubleBinding(){
                    {
                        this.bind(new Observable[]{Label.this.tex.boundsInLocalProperty()});
                    }

                    protected double computeValue() {
                        return ((Bounds)Label.this.tex.boundsInLocalProperty().getValue()).getWidth() + 4.0;
                    }
                });
                this.back.heightProperty().bind((ObservableValue)new DoubleBinding(){
                    {
                        this.bind(new Observable[]{Label.this.tex.boundsInLocalProperty()});
                    }

                    protected double computeValue() {
                        return ((Bounds)Label.this.tex.boundsInLocalProperty().getValue()).getHeight();
                    }
                });
            } else {
                this.back.widthProperty().bind((ObservableValue)new DoubleBinding(){
                    {
                        this.bind(new Observable[]{Label.this.text.boundsInLocalProperty()});
                    }

                    protected double computeValue() {
                        return ((Bounds)Label.this.text.boundsInLocalProperty().getValue()).getWidth() + 4.0;
                    }
                });
                this.back.heightProperty().bind((ObservableValue)new DoubleBinding(){
                    {
                        this.bind(new Observable[]{Label.this.text.boundsInLocalProperty()});
                    }

                    protected double computeValue() {
                        return ((Bounds)Label.this.text.boundsInLocalProperty().getValue()).getHeight();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispose() {
            this.index.unbind();
            Queue<Label> queue = Graph.this.controller.removeLabels;
            synchronized (queue) {
                Graph.this.controller.removeLabels.add(this);
            }
        }
    }

    protected abstract class Edge {
        protected Vertex lower;
        protected Vertex upper;
        protected final Pair<T, T> elements;
        protected final Line line = new Line();
        protected DoubleBinding opacity;
        private boolean isInitialized = false;
        protected boolean isDisposing = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Edge(Pair<T, T> elements) {
            this.elements = elements;
            this.line.setStrokeWidth(2.0);
            Object object = Graph.this.edges;
            synchronized (object) {
                Graph.this.edges.put(elements, this);
            }
            object = Graph.this.controller.addEdges;
            synchronized (object) {
                Graph.this.controller.addEdges.offer(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initialize() throws NullPointerException {
            if (this.isInitialized) {
                return;
            }
            Map map = Graph.this.vertices;
            synchronized (map) {
                this.lower = Graph.this.vertices.get(this.elements.x());
                if (this.lower == null) {
                    throw new NullPointerException();
                }
                this.upper = Graph.this.vertices.get(this.elements.y());
                if (this.upper == null) {
                    throw new NullPointerException();
                }
            }
            this.bindStart();
            this.bindEnd();
            this.opacity = new DoubleBinding(){
                {
                    this.bind(new Observable[]{Edge.this.lower.node.opacityProperty(), Edge.this.upper.node.opacityProperty()});
                }

                protected final double computeValue() {
                    return (Edge.this.lower.node.opacityProperty().get() + Edge.this.upper.node.opacityProperty().get()) / 2.0;
                }
            };
            this.isInitialized = true;
        }

        protected void dispose() {
            this.line.strokeWidthProperty().unbind();
            this.line.opacityProperty().unbind();
            this.unbindStart();
            this.unbindEnd();
        }

        protected final void bindOpacity() {
            this.line.opacityProperty().bind((ObservableValue)this.opacity);
        }

        protected final void bindStart() {
            this.line.startXProperty().bind((ObservableValue)this.lower.node.translateXProperty());
            this.line.startYProperty().bind((ObservableValue)this.lower.node.translateYProperty());
        }

        protected final void bindEnd() {
            this.line.endXProperty().bind((ObservableValue)this.upper.node.translateXProperty());
            this.line.endYProperty().bind((ObservableValue)this.upper.node.translateYProperty());
        }

        protected final void unbindStart() {
            this.line.startXProperty().unbind();
            this.line.startYProperty().unbind();
        }

        protected final void unbindEnd() {
            this.line.endXProperty().unbind();
            this.line.endYProperty().unbind();
        }
    }

    protected static abstract class Vertex {
        protected final T element;
        protected final N node;
        protected final ObservableValue<Point3D> position;
        protected final ObservableList<UpperLabel> upperLabels = FXCollections.observableList(new LinkedList());
        protected final ObservableList<LowerLabel> lowerLabels = FXCollections.observableList(new LinkedList());
        protected final Set<Pair<Vertex, Edge>> pendingVertices = new HashSet<Pair<Vertex, Edge>>();
        final /* synthetic */ Graph this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Vertex(T element, N node, ObservableValue<Point3D> position, Double layoutX, Double layoutY) {
            this.this$0 = this$0;
            this.element = element;
            this.node = node;
            this.position = position;
            this.node.translateXProperty().set(layoutX == null ? this$0.front.getWidth() / 2.0 : layoutX);
            this.node.translateYProperty().set(layoutY == null ? this$0.front.getHeight() / 2.0 : layoutY);
            Object object = this$0.vertices;
            synchronized (object) {
                this$0.vertices.put(element, this);
            }
            object = this$0.controller.addVertices;
            synchronized (object) {
                this$0.controller.addVertices.offer(this);
            }
        }

        protected abstract void init();

        protected abstract void dispose();
    }
}

