/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph;

import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcBuilder;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CircleBuilder;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;

public class SuperNode
extends Group {
    private State state;

    public final State getState() {
        return this.state;
    }

    public SuperNode(double radius, Paint fill) {
        this.toCircle(radius, fill);
    }

    public SuperNode(double innerRadius, double outerRadius, double startAngle, double length, Paint fill) {
        this.toArc(innerRadius, outerRadius, startAngle, length, fill);
    }

    public void toCircle(double radius, Paint fill) {
        this.getChildren().clear();
        this.getChildren().add((Object)((CircleBuilder)((CircleBuilder)((CircleBuilder)((CircleBuilder)CircleBuilder.create().radius(radius).fill(fill)).strokeType(StrokeType.OUTSIDE)).stroke((Paint)Color.BLACK)).strokeWidth(1.0)).build());
        this.state = State.CIRCLE;
    }

    public void toArc(double innerRadius, double outerRadius, double startAngle, double length, Paint fill) {
        this.getChildren().clear();
        this.getChildren().add((Object)this.newBackRectangle(2.0 * outerRadius));
        this.getChildren().add((Object)this.newCircularSegment(innerRadius, outerRadius, startAngle, length, fill));
        this.state = State.ARC;
    }

    private final Rectangle newBackRectangle(double size) {
        Rectangle back = RectangleBuilder.create().build();
        back.setWidth(size);
        back.setHeight(size);
        back.setFill((Paint)Color.TRANSPARENT);
        return back;
    }

    private final Shape newCircularSegment(double innerRadius, double outerRadius, double startAngle, double length, Paint fill) {
        Circle inner = CircleBuilder.create().centerX(outerRadius).centerY(outerRadius).radius(innerRadius).build();
        Arc outer = ArcBuilder.create().centerX(outerRadius).centerY(outerRadius).radiusX(outerRadius).radiusY(outerRadius).startAngle(startAngle).type(ArcType.ROUND).length(length).build();
        Shape segmentArc = Shape.subtract((Shape)outer, (Shape)inner);
        segmentArc.setFill(fill);
        segmentArc.setStrokeType(StrokeType.CENTERED);
        segmentArc.setStroke((Paint)Color.BLACK);
        segmentArc.setStrokeWidth(0.5);
        return segmentArc;
    }

    public static enum State {
        CIRCLE,
        ARC;

    }
}

