/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph.option;

import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.context.Context;

public enum EdgeStroke {
    NONE("None"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 0.0;
        }
    }
    ,
    TINY("Tiny"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 0.5;
        }
    }
    ,
    SMALL("Small"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 1.0;
        }
    }
    ,
    NORMAL("Normal"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 2.0;
        }
    }
    ,
    LARGE("Large"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 3.0;
        }
    }
    ,
    HUGE("Huge"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 4.0;
        }
    }
    ,
    EXTENT_DIFFERENCE("Extent Difference"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 1.0 + 6.0 * Math.sqrt(((double)concepts.second().extent().size() - (double)concepts.first().extent().size()) / (double)context.rowHeads().size());
        }
    }
    ,
    INTENT_DIFFERENCE("Intent Difference"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 1.0 + 6.0 * Math.sqrt(((double)concepts.first().intent().size() - (double)concepts.second().intent().size()) / (double)context.colHeads().size());
        }
    }
    ,
    EXTENT_RATIO("Extent Ratio"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 1.0 + 6.0 * (double)concepts.first().extent().size() / (double)concepts.second().extent().size();
        }
    }
    ,
    INTENT_RATIO("Intent Ratio"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 1.0 + 6.0 * (double)concepts.second().intent().size() / (double)concepts.first().intent().size();
        }
    }
    ,
    INVERSE_EXTENT_RATIO("Inverse Extent Ratio"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 1.0 + 6.0 * (1.0 - (double)concepts.first().extent().size() / (double)concepts.second().extent().size());
        }
    }
    ,
    INVERSE_INTENT_RATIO("Inverse Intent Ratio"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Pair<Concept<G, M>, Concept<G, M>> concepts) {
            return 1.0 + 6.0 * (1.0 - (double)concepts.second().intent().size() / (double)concepts.first().intent().size());
        }
    };

    private final String name;

    public abstract <G, M> double get(Context<G, M> var1, ConceptLattice<G, M> var2, Pair<Concept<G, M>, Concept<G, M>> var3);

    private EdgeStroke(String name) {
        this.name = name;
    }

    public final String toString() {
        return this.name;
    }
}

