/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph.option;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.context.Context;
import java.util.Set;

public enum VertexRadius {
    NONE("None"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 0.0;
        }
    }
    ,
    TINY("Tiny"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 3.0;
        }
    }
    ,
    SMALL("Small"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 4.0;
        }
    }
    ,
    NORMAL("Normal"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 5.0;
        }
    }
    ,
    LARGE("Large"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 7.0;
        }
    }
    ,
    HUGE("Huge"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 10.0;
        }
    }
    ,
    EXTENT("Extent Size"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 3.0 + 17.0 * Math.sqrt((double)concept.extent().size() / (double)context.rowHeads().size());
        }
    }
    ,
    INTENT("Intent Size"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 3.0 + 17.0 * Math.sqrt((double)concept.intent().size() / (double)context.colHeads().size());
        }
    }
    ,
    OBJECT_LABELS("Object Labels Size"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 3.0 + 17.0 * Math.sqrt((double)lattice.objectLabels(concept).size() / (double)context.rowHeads().size());
        }
    }
    ,
    ATTRIBUTE_LABELS("Attribute Labels Size"){

        @Override
        public <G, M> double get(Context<G, M> context, ConceptLattice<G, M> lattice, Concept<G, M> concept) {
            return 3.0 + 17.0 * Math.sqrt((double)lattice.attributeLabels(concept).size() / (double)context.colHeads().size());
        }
    }
    ,
    EXTENT_STABILITY("Extent Stability"){

        @Override
        public <G, M> double get(final Context<G, M> context, ConceptLattice<G, M> lattice, final Concept<G, M> concept) {
            if ((double)concept.intent().size() > 10.0) {
                return 5.0;
            }
            return 3.0 + 17.0 * (double)Sets.filter((Set)Sets.powerSet(concept.intent()), (Predicate)new Predicate<Set<M>>(){

                public boolean apply(Set<M> intentSubset) {
                    return context.colAnd(intentSubset).equals(concept.extent());
                }
            }).size() / (double)(1 << concept.intent().size());
        }
    }
    ,
    INTENT_STABILITY("Intent Stability"){

        @Override
        public <G, M> double get(final Context<G, M> context, ConceptLattice<G, M> lattice, final Concept<G, M> concept) {
            if ((double)concept.extent().size() > 10.0) {
                return 5.0;
            }
            return 3.0 + 17.0 * (double)Sets.filter((Set)Sets.powerSet(concept.extent()), (Predicate)new Predicate<Set<G>>(){

                public boolean apply(Set<G> extentSubset) {
                    return context.rowAnd(extentSubset).equals(concept.intent());
                }
            }).size() / (double)(1 << concept.extent().size());
        }
    };

    private final String name;

    private VertexRadius(String name) {
        this.name = name;
    }

    public abstract <G, M> double get(Context<G, M> var1, ConceptLattice<G, M> var2, Concept<G, M> var3);

    public final String toString() {
        return this.name;
    }
}

