/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph.transformation;

import conexp.fx.core.math.GuavaIsomorphism;
import javafx.geometry.Point3D;

public final class PolarTransformation
extends GuavaIsomorphism<Point3D, Point3D> {
    private final double width;
    private final double centerX;

    public PolarTransformation(double minX, double width) {
        this.width = width;
        this.centerX = minX + width / 2.0;
    }

    public final Point3D apply(Point3D p) {
        double a = (p.getX() - this.centerX) / this.width * 5.654866776461628;
        double r = p.getY();
        return new Point3D(r * Math.sin(a), r * Math.cos(a), 0.0);
    }

    @Override
    public final Point3D invert(Point3D q) {
        double a = Math.atan2(q.getX(), q.getY());
        double r = Math.sqrt(q.getX() * q.getX() + q.getY() * q.getY());
        double x = this.centerX + a * this.width / 5.654866776461628;
        double y = r;
        return new Point3D(x, y, 0.0);
    }
}

