/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph.transformation;

import conexp.fx.core.math.GuavaIsomorphism;
import javafx.geometry.Point3D;

public class RotationXY
extends GuavaIsomorphism<Point3D, Point3D> {
    private final double angle;
    private final Point3D center;

    public RotationXY(Point3D center, double angle) {
        this.angle = angle;
        this.center = center;
    }

    public final Point3D apply(Point3D p) {
        double dx = p.getX() - this.center.getX();
        double dy = p.getY() - this.center.getY();
        double r = Math.sqrt(dx * dx + dy * dy);
        double w = Math.atan2(dy, dx) + this.angle;
        return new Point3D(r * Math.cos(w) + this.center.getX(), r * Math.sin(w) + this.center.getY(), p.getZ());
    }

    @Override
    public final Point3D invert(Point3D q) {
        double dx = q.getX() - this.center.getX();
        double dy = q.getY() - this.center.getY();
        double r = Math.sqrt(dx * dx + dy * dy);
        double w = Math.atan2(dy, dx) - this.angle;
        return new Point3D(r * Math.cos(w) + this.center.getX(), r * Math.sin(w) + this.center.getY(), q.getZ());
    }
}

