/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.notification;

import conexp.fx.gui.util.CoordinateUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.Animation;
import javafx.animation.FadeTransitionBuilder;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransitionBuilder;
import javafx.animation.ScaleTransitionBuilder;
import javafx.animation.Transition;
import javafx.animation.TranslateTransitionBuilder;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPaneBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.util.Duration;
import javax.swing.JDialog;

public class Notification {
    private static final Duration DEFAULT_DURATION = Duration.seconds((double)10.0);
    protected final JDialog dialog = new JDialog();
    protected final JFXPanel panel = new JFXPanel();
    private final Timer timer = new Timer();
    private boolean isDisposed = false;
    private Transition showTransition;
    private Transition hideTransition;

    public Notification(Pane contentPane, Pos position, int xShift, int yShift, TransitionType type) {
        this(contentPane, position, xShift, yShift, type, DEFAULT_DURATION);
    }

    public Notification(Pane contentPane, Pos position, int xShift, int yShift, TransitionType type, Duration duration) {
        this();
        this.setContentPane(contentPane, position, xShift, yShift, type, duration);
    }

    protected Notification() {
    }

    public void show() {
        this.dialog.setVisible(true);
        this.showTransition.play();
    }

    public void hideAndDispose() {
        if (!this.isDisposed) {
            this.timer.cancel();
            this.isDisposed = true;
            this.hideTransition.play();
        }
    }

    protected final void setContentPane(Pane contentPane, Pos position, int xShift, int yShift, TransitionType type) {
        this.setContentPane(contentPane, position, xShift, yShift, type, DEFAULT_DURATION);
    }

    protected final void setContentPane(Pane contentPane, Pos position, int xShift, int yShift, TransitionType type, Duration duration) {
        int width = (int)contentPane.getMaxWidth();
        int height = (int)contentPane.getMaxHeight();
        Scene scene = new Scene((Parent)((StackPaneBuilder)StackPaneBuilder.create().alignment(CoordinateUtil.contraryPosition(position)).children(new Node[]{contentPane})).build(), (Paint)Color.TRANSPARENT);
        this.panel.setScene(scene);
        this.panel.setSize(width + xShift, height + yShift);
        this.dialog.add((Component)this.panel);
        this.dialog.setType(Window.Type.POPUP);
        this.dialog.setUndecorated(true);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.setResizable(false);
        this.dialog.setBackground(new java.awt.Color(0, 0, 0, 0));
        this.dialog.setLocation(this.getDialogX(position, width, xShift), this.getDialogY(position, height, yShift));
        this.dialog.setSize(width + xShift, height + yShift);
        this.createTransitions(contentPane, position, xShift, yShift, type);
        if (!duration.isIndefinite() && !duration.isUnknown()) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Notification.this.hideAndDispose();
                }
            }, (long)duration.toMillis());
        }
    }

    private final void createTransitions(Pane contentPane, Pos position, int xShift, int yShift, TransitionType type) {
        switch (type) {
            case FADE: {
                this.createFadeTransition(contentPane);
                break;
            }
            case TRANSLATE: {
                this.createTranslateTransition(contentPane, position, xShift, yShift);
            }
        }
    }

    private final void createFadeTransition(Pane contentPane) {
        contentPane.setOpacity(0.0);
        this.showTransition = ParallelTransitionBuilder.create().children(new Animation[]{((FadeTransitionBuilder)FadeTransitionBuilder.create().node((Node)contentPane).fromValue(0.0).toValue(1.0).interpolator(Interpolator.EASE_OUT)).duration(Duration.millis((double)700.0)).build(), ((ScaleTransitionBuilder)ScaleTransitionBuilder.create().node((Node)contentPane).fromX(0.0).fromY(0.0).toX(1.0).toY(1.0).interpolator(Interpolator.EASE_OUT)).duration(Duration.millis((double)700.0)).build()}).build();
        this.hideTransition = ((ParallelTransitionBuilder)ParallelTransitionBuilder.create().children(new Animation[]{((FadeTransitionBuilder)FadeTransitionBuilder.create().node((Node)contentPane).fromValue(1.0).toValue(0.0).interpolator(Interpolator.EASE_IN)).duration(Duration.millis((double)700.0)).build(), ((ScaleTransitionBuilder)ScaleTransitionBuilder.create().node((Node)contentPane).fromX(1.0).fromY(1.0).toX(0.0).toY(0.0).interpolator(Interpolator.EASE_IN)).duration(Duration.millis((double)700.0)).build()}).onFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Notification.this.dialog.setVisible(false);
                Notification.this.dialog.dispose();
            }
        })).build();
    }

    private final void createTranslateTransition(Pane contentPane, Pos position, int xShift, int yShift) {
        int translateX = 0;
        switch (position) {
            case BOTTOM_RIGHT: 
            case CENTER_RIGHT: 
            case TOP_RIGHT: {
                translateX = (int)contentPane.getMaxWidth() + xShift;
                break;
            }
            case BOTTOM_LEFT: 
            case CENTER_LEFT: 
            case TOP_LEFT: {
                translateX = (int)(-(contentPane.getMaxWidth() + (double)xShift));
                break;
            }
        }
        int translateY = 0;
        switch (position) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: {
                translateY = (int)contentPane.getMaxHeight() + yShift;
                break;
            }
            case TOP_RIGHT: 
            case TOP_LEFT: 
            case TOP_CENTER: {
                translateY = (int)(-(contentPane.getMaxHeight() + (double)yShift));
                break;
            }
        }
        contentPane.setTranslateX((double)translateX);
        contentPane.setTranslateY((double)translateY);
        this.showTransition = ((TranslateTransitionBuilder)TranslateTransitionBuilder.create().node((Node)contentPane).byX((double)(-translateX)).byY((double)(-translateY)).interpolator(Interpolator.EASE_OUT)).duration(Duration.millis((double)700.0)).build();
        this.hideTransition = ((TranslateTransitionBuilder)((TranslateTransitionBuilder)TranslateTransitionBuilder.create().node((Node)contentPane).byX((double)translateX).byY((double)translateY).interpolator(Interpolator.EASE_IN)).duration(Duration.millis((double)700.0)).onFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Notification.this.dialog.setVisible(false);
                Notification.this.dialog.dispose();
            }
        })).build();
    }

    private final int getDialogX(Pos position, int width, int shift) {
        switch (position) {
            case BOTTOM_RIGHT: 
            case CENTER_RIGHT: 
            case TOP_RIGHT: {
                return (int)Screen.getPrimary().getBounds().getWidth() - width - shift;
            }
            case BOTTOM_CENTER: 
            case TOP_CENTER: 
            case CENTER: {
                return (int)(Screen.getPrimary().getBounds().getWidth() - (double)width) / 2;
            }
        }
        return 0;
    }

    private final int getDialogY(Pos position, int height, int shift) {
        switch (position) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: {
                return (int)Screen.getPrimary().getBounds().getHeight() - height - shift;
            }
            case CENTER_RIGHT: 
            case CENTER_LEFT: 
            case CENTER: {
                return (int)(Screen.getPrimary().getBounds().getHeight() - (double)height) / 2;
            }
        }
        return 0;
    }

    public static enum TransitionType {
        TRANSLATE,
        FADE;

    }
}

