/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.task;

import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dataset.Dataset;
import conexp.fx.gui.dialog.ErrorDialog;
import conexp.fx.gui.task.TimeTask;
import conexp.fx.gui.util.Platform2;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;

public class BlockingExecutor {
    public final ExecutorService tpe = Executors.newWorkStealingPool();
    public final BooleanBinding isIdleBinding;
    public final DoubleBinding overallProgressBinding;
    public final ObservableList<TimeTask<?>> scheduledTasks = FXCollections.observableList(Collections.synchronizedList(new LinkedList()));
    public final Property<TimeTask<?>> currentTaskProperty = new SimpleObjectProperty();
    private final Map<Dataset, DoubleBinding> datasetProgressBindings = new ConcurrentHashMap<Dataset, DoubleBinding>();

    public BlockingExecutor() {
        this.overallProgressBinding = Bindings.createDoubleBinding(() -> {
            ObservableList<TimeTask<?>> observableList = this.scheduledTasks;
            synchronized (observableList) {
                if (this.scheduledTasks.isEmpty()) {
                    return 1.0;
                }
                double progress = 0.0;
                for (TimeTask task : this.scheduledTasks) {
                    if (task.isDone()) {
                        progress += 1.0;
                        continue;
                    }
                    if (!(task.getProgress() > 0.0)) continue;
                    progress += Math.max(0.0, Math.min(1.0, task.getProgress()));
                }
                return progress / (double)this.scheduledTasks.size();
            }
        }, (Observable[])new Observable[]{this.scheduledTasks, this.currentTaskProperty});
        this.isIdleBinding = Bindings.createBooleanBinding(() -> this.overallProgressBinding.get() == 1.0, (Observable[])new Observable[]{this.overallProgressBinding});
        this.currentTaskProperty.addListener((__, ___, task) -> {
            ObservableList<TimeTask<?>> observableList = this.scheduledTasks;
            synchronized (observableList) {
                if (task.isDone()) {
                    this.next();
                } else {
                    task.exceptionProperty().addListener((____, _____, exception) -> new ErrorDialog(ConExpFX.instance.primaryStage, (Throwable)exception).showAndWait());
                    EventHandler x = ____ -> this.next();
                    task.setOnCancelled(x);
                    task.setOnFailed(x);
                    task.setOnSucceeded(x);
                    if (task.onFXThread()) {
                        this.tpe.submit((Runnable)((Object)TimeTask.encapsulateTaskOnFXThread(task)));
                    } else {
                        this.tpe.submit((Runnable)((Object)task));
                    }
                }
            }
        });
    }

    public final void execute(TimeTask<?> task) {
        Platform2.runOnFXThread(() -> {
            ObservableList<TimeTask<?>> observableList = this.scheduledTasks;
            synchronized (observableList) {
                boolean wasIdle = this.isIdleBinding.get();
                this.scheduledTasks.add((Object)task);
                Arrays.asList(task.progressProperty(), task.stateProperty()).forEach(p -> p.addListener((__, ___, ____) -> {
                    this.overallProgressBinding.invalidate();
                    this.datasetProgressBindings.values().forEach(DoubleBinding::invalidate);
                }));
                if (wasIdle) {
                    this.currentTaskProperty.setValue((Object)task);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void next() {
        ObservableList<TimeTask<?>> observableList = this.scheduledTasks;
        synchronized (observableList) {
            if (!this.isIdleBinding.get()) {
                try {
                    TimeTask nextTask = (TimeTask)((Object)this.scheduledTasks.get(this.scheduledTasks.indexOf(this.currentTaskProperty.getValue()) + 1));
                    if (nextTask != null) {
                        this.currentTaskProperty.setValue((Object)nextTask);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.println("index out of bounds, task not found.");
                    System.err.println(this.scheduledTasks.size() + " tasks");
                    System.err.println(this.scheduledTasks.indexOf(this.currentTaskProperty.getValue()));
                }
            }
        }
    }

    public final DoubleBinding datasetProgressBinding(Dataset dataset) {
        if (this.datasetProgressBindings.containsKey(dataset)) {
            return this.datasetProgressBindings.get(dataset);
        }
        DoubleBinding datasetProgressBinding = Bindings.createDoubleBinding(() -> {
            ObservableList<TimeTask<?>> observableList = this.scheduledTasks;
            synchronized (observableList) {
                if (this.scheduledTasks.isEmpty()) {
                    return 1.0;
                }
                double progress = 0.0;
                double tasks = 0.0;
                for (TimeTask task : this.scheduledTasks) {
                    if (task.getDataset() == null || !task.getDataset().equals(dataset)) continue;
                    if (task.isDone()) {
                        progress += 1.0;
                    } else if (task.getProgress() > 0.0) {
                        progress += task.getProgress();
                    }
                    tasks += 1.0;
                }
                if (tasks > 0.0) {
                    return progress / tasks;
                }
                return 1.0;
            }
        }, (Observable[])new Observable[]{this.scheduledTasks, this.currentTaskProperty});
        this.datasetProgressBindings.put(dataset, datasetProgressBinding);
        return datasetProgressBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel(Dataset dataset) {
        ObservableList<TimeTask<?>> observableList = this.scheduledTasks;
        synchronized (observableList) {
            this.scheduledTasks.filtered(task -> task.getDataset() != null && task.getDataset().equals(dataset)).forEach(task -> task.cancel());
            this.scheduledTasks.removeIf(task -> task.getDataset() != null && task.getDataset().equals(dataset));
            this.datasetProgressBindings.remove(dataset);
        }
    }
}

