/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.task;

import conexp.fx.gui.dataset.Dataset;
import conexp.fx.gui.util.Platform2;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.concurrent.Task;

public abstract class TimeTask<T>
extends Task<T> {
    private final Dataset dataset;
    private final boolean onFXThread;
    private final ObservableTimer timer = new ObservableTimer();

    public static final TimeTask<Void> create(Dataset dataset, String title, RunnableWithException<?> runnable) {
        return TimeTask.create(dataset, title, runnable.toCallable());
    }

    public static final TimeTask<Void> create(Dataset dataset, String title, RunnableWithException<?> runnable, boolean onFXThread) {
        return TimeTask.create(dataset, title, runnable.toCallable(), onFXThread);
    }

    public static final <T> TimeTask<T> create(Dataset dataset, String title, Callable<T> callable) {
        return TimeTask.create(dataset, title, callable, false);
    }

    public static final <T> TimeTask<T> create(Dataset dataset, String title, final Callable<T> callable, boolean onFXThread) {
        return new TimeTask<T>(dataset, title, onFXThread){

            protected T call() throws Exception {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                Object result = callable.call();
                this.updateProgress(1.0, 1.0);
                return result;
            }
        };
    }

    @SafeVarargs
    public static final TimeTask<Void> compose(Dataset dataset, final String title, final TimeTask<Void> ... tasks) {
        return new TimeTask<Void>(dataset, title){

            protected Void call() throws Exception {
                for (TimeTask task : Arrays.asList(tasks)) {
                    this.updateTitle(title + " - " + task.getTitle());
                    task.progressProperty().addListener((__, ___, p) -> this.updateProgress(p.doubleValue(), 1.0));
                    task.messageProperty().addListener((__, ___, m) -> this.updateMessage((String)m));
                    task.call();
                }
                return null;
            }
        };
    }

    public static final <T> TimeTask<T> encapsulateTaskOnFXThread(final TimeTask<T> task) {
        return new TimeTask<T>(task.getDataset(), task.getTitle()){

            protected T call() throws Exception {
                CountDownLatch cdl = new CountDownLatch(1);
                task.progressProperty().addListener((____, _____, p) -> this.updateProgress(p.doubleValue(), 1.0));
                task.messageProperty().addListener((____, _____, m) -> this.updateMessage((String)m));
                Platform2.runOnFXThread(() -> {
                    task.run();
                    cdl.countDown();
                });
                cdl.await();
                return task.get();
            }
        };
    }

    public TimeTask(String title) {
        this(null, title);
    }

    public TimeTask(Dataset dataset, String title) {
        this(dataset, title, false);
    }

    public TimeTask(Dataset dataset, String title, boolean onFXThread) {
        this.dataset = dataset;
        if (dataset != null) {
            this.updateTitle((String)dataset.id.get() + " - " + title);
        } else {
            this.updateTitle(title);
        }
        this.onFXThread = onFXThread;
    }

    public final Dataset getDataset() {
        return this.dataset;
    }

    public final boolean onFXThread() {
        return this.onFXThread;
    }

    public final ReadOnlyLongProperty runTimeNanosProperty() {
        return this.timer.runTimeNanosProperty();
    }

    protected void running() {
        super.running();
        this.timer.start();
    }

    protected void succeeded() {
        super.succeeded();
        this.timer.stop();
    }

    protected void cancelled() {
        super.cancelled();
        if (this.getProgress() < 0.0) {
            this.updateProgress(0.0, 1.0);
        }
        this.timer.stop();
    }

    protected void failed() {
        super.failed();
        if (this.getProgress() < 0.0) {
            this.updateProgress(0.0, 1.0);
        }
        this.timer.stop();
    }

    private static final class ObservableTimer {
        private final ReadOnlyLongWrapper runTimeNanos = new ReadOnlyLongWrapper(0L);
        private long startTimeNanos;
        private Thread thread;
        private final long updateDelayMillis;

        public ObservableTimer(long updateDelayMillis) {
            this.updateDelayMillis = updateDelayMillis;
        }

        public ObservableTimer() {
            this(250L);
        }

        public final ReadOnlyLongProperty runTimeNanosProperty() {
            return this.runTimeNanos.getReadOnlyProperty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            ObservableTimer observableTimer = this;
            synchronized (observableTimer) {
                if (this.thread != null) {
                    return;
                }
                this.startTimeNanos = System.nanoTime();
                this.thread = new Thread(() -> {
                    try {
                        while (true) {
                            this.update();
                            Thread.sleep(this.updateDelayMillis);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                });
                this.thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stop() {
            ObservableTimer observableTimer = this;
            synchronized (observableTimer) {
                if (this.thread == null) {
                    return;
                }
                this.thread.interrupt();
                this.update();
                this.thread = null;
            }
        }

        public final void update() {
            if (this.thread == null) {
                return;
            }
            long currentTimeNanos = System.nanoTime();
            Platform.runLater(() -> this.runTimeNanos.set(currentTimeNanos - this.startTimeNanos));
        }
    }

    @FunctionalInterface
    public static interface RunnableWithException<E extends Exception> {
        public void run() throws E;

        default public Callable<Void> toCallable() {
            return () -> {
                this.run();
                return null;
            };
        }
    }
}

