/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.util;

import conexp.fx.gui.util.Colors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.scene.paint.Color;

public final class ColorScheme {
    public static final ColorScheme BASIC = new ColorScheme("Basic", Color.BLUE, Color.GREEN, Color.ALICEBLUE, Color.GREENYELLOW, Color.RED);
    public static final ColorScheme TUD = new ColorScheme("TU Dresden", Colors.TUD_DARKBLUE, Colors.TUD_BLUE, Colors.TUD_EXTRALIGHTBLUE, Color.rgb((int)250, (int)120, (int)48), Color.rgb((int)165, (int)74, (int)28));
    public static final ColorScheme JAVA_FX = new ColorScheme("JavaFX", Color.rgb((int)0, (int)100, (int)172), Color.rgb((int)44, (int)44, (int)44), Color.rgb((int)236, (int)236, (int)236), Color.rgb((int)56, (int)166, (int)246), Color.rgb((int)100, (int)100, (int)100));
    public static final ColorScheme WINDOWS_8 = new ColorScheme("Windows 8", Color.rgb((int)25, (int)121, (int)202), Color.rgb((int)41, (int)140, (int)225), Color.rgb((int)235, (int)235, (int)235), Color.rgb((int)0, (int)204, (int)255), Color.rgb((int)224, (int)67, (int)67));
    public static final ColorScheme WATERLIME = new ColorScheme("Waterlime", Color.rgb((int)92, (int)138, (int)45), Color.rgb((int)0, (int)195, (int)169), Color.rgb((int)255, (int)255, (int)255), Color.rgb((int)175, (int)214, (int)135), Color.rgb((int)0, (int)135, (int)152));
    public static final ColorScheme SALMON_ON_ICE = new ColorScheme("Salmon on Ice", Color.rgb((int)62, (int)69, (int)76), Color.rgb((int)33, (int)133, (int)197), Color.rgb((int)255, (int)246, (int)229), Color.rgb((int)126, (int)206, (int)253), Color.rgb((int)255, (int)127, (int)102));
    public static final ColorScheme DEFAULT = WINDOWS_8;
    private static final List<ColorScheme> availableColorSchemes = Collections.synchronizedList(new LinkedList());
    private final String name;
    private final List<Color> colors = new ArrayList<Color>(5);

    public static final List<ColorScheme> getAvailableColorSchemes() {
        return availableColorSchemes;
    }

    public ColorScheme(String name, Color color1, Color color2, Color color3, Color color4, Color color5) {
        this.name = name;
        this.colors.add(color1);
        this.colors.add(color2);
        this.colors.add(color3);
        this.colors.add(color4);
        this.colors.add(color5);
    }

    public final String getName() {
        return this.name;
    }

    public final Color getColor(int index) {
        if (index < 1 || index > 5) {
            return null;
        }
        return this.colors.get(index - 1);
    }

    static {
        availableColorSchemes.add(BASIC);
        availableColorSchemes.add(TUD);
        availableColorSchemes.add(JAVA_FX);
        availableColorSchemes.add(WINDOWS_8);
        availableColorSchemes.add(WATERLIME);
        availableColorSchemes.add(SALMON_ON_ICE);
    }
}

