/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.util;

import javafx.geometry.Pos;
import javafx.scene.Node;

public final class CoordinateUtil {
    public static final double getLocalX(Node node, double sceneX) {
        double minX = node.localToScene(node.getBoundsInLocal()).getMinX();
        double localX = sceneX - minX;
        return localX;
    }

    public static final double getLocalY(Node node, double sceneY) {
        double minY = node.localToScene(node.getBoundsInLocal()).getMinY();
        double localY = sceneY - minY;
        return localY;
    }

    public static final double getScreenX(Node node) {
        double windowX = node.getScene().getWindow().getX();
        double sceneX = node.getScene().getX();
        double nodeX = node.localToScene(node.getBoundsInLocal()).getMinX();
        return windowX + sceneX + nodeX;
    }

    public static final double getScreenY(Node node) {
        double windowY = node.getScene().getWindow().getY();
        double sceneY = node.getScene().getY();
        double nodeY = node.localToScene(node.getBoundsInLocal()).getMinY();
        return windowY + sceneY + nodeY;
    }

    public static final Pos contraryPosition(Pos position) {
        switch (position) {
            case BOTTOM_LEFT: {
                return Pos.TOP_RIGHT;
            }
            case BOTTOM_CENTER: {
                return Pos.TOP_CENTER;
            }
            case BOTTOM_RIGHT: {
                return Pos.TOP_LEFT;
            }
            case CENTER_LEFT: {
                return Pos.CENTER_RIGHT;
            }
            case CENTER: {
                return Pos.CENTER;
            }
            case CENTER_RIGHT: {
                return Pos.CENTER_LEFT;
            }
            case TOP_LEFT: {
                return Pos.BOTTOM_RIGHT;
            }
            case TOP_CENTER: {
                return Pos.BOTTOM_CENTER;
            }
            case TOP_RIGHT: {
                return Pos.BOTTOM_LEFT;
            }
        }
        return position;
    }
}

