/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.util;

import conexp.fx.gui.ConExpFX;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;

public class LaTeX {
    public static final Image toFXImage(String string, float height) {
        if (string == null) {
            return new Image(ConExpFX.class.getResourceAsStream("image/16x16/warning.png"));
        }
        try {
            BufferedImage texImage = (BufferedImage)new TeXFormula("\\sf\\mbox{" + string.replaceAll("\\\\kern-?\\d*(\\.\\d+)?[a-zA-Z]{2}", "").replace("%", "\\%").replace("@", "\\@").replace("&", "\\&") + "}").createBufferedImage(0, height, Color.BLACK, Color.WHITE);
            BufferedImage TeXImage = new BufferedImage(texImage.getWidth(), texImage.getHeight(), 2);
            Graphics2D graphics = TeXImage.createGraphics();
            graphics.drawImage(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(texImage.getSource(), new RGBImageFilter(){

                @Override
                public final int filterRGB(int x, int y, int rgb) {
                    if (-1118482 < rgb) {
                        return 0xFFFFFF;
                    }
                    return rgb;
                }
            })), 0, 0, null);
            graphics.dispose();
            return SwingFXUtils.toFXImage((BufferedImage)TeXImage, null);
        }
        catch (ParseException e) {
            System.err.println(string);
            e.printStackTrace();
            return null;
        }
    }

    public static final ObjectBinding<Image> toFXImageBinding(final ObservableValue<String> string, final float height) {
        return new ObjectBinding<Image>(){
            {
                this.bind(new Observable[]{string});
            }

            protected final Image computeValue() {
                return LaTeX.toFXImage((String)string.getValue(), height);
            }
        };
    }

    public static final ObjectBinding<Image> toFXImageBinding(final ObservableValue<String> string, final ObservableValue<Number> height) {
        return new ObjectBinding<Image>(){
            {
                this.bind(new Observable[]{string, height});
            }

            protected final Image computeValue() {
                return LaTeX.toFXImage((String)string.getValue(), ((Number)height.getValue()).floatValue());
            }
        };
    }
}

