/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.zoom;

import conexp.fx.gui.util.Colors;
import conexp.fx.gui.util.CoordinateUtil;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageViewBuilder;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.ColumnConstraintsBuilder;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;

public class ZoomWidget
extends Label {
    protected final Node owner;
    private boolean currentlyShown = false;
    private boolean hideRequested = false;
    private final Popup zoomPopup;
    private final ZoomPopupPane zoomPopupPane;
    protected final ObjectProperty<Color> color1 = new SimpleObjectProperty((Object)Colors.fromCSSColorString("#99bcfd"));
    protected final ObjectProperty<Color> color2 = new SimpleObjectProperty((Object)Colors.fromCSSColorString("#e2ecfe"));
    protected final ObjectProperty<Color> color3 = new SimpleObjectProperty((Object)Colors.fromCSSColorString("#99bcfd"));
    public final DoubleProperty zoomFactorProperty = new SimpleDoubleProperty(1.0);

    public ZoomWidget(final Node owner, Image image) {
        this.owner = owner;
        this.setAlignment(Pos.TOP_LEFT);
        this.setGraphic((Node)((ImageViewBuilder)ImageViewBuilder.create().image(image).preserveRatio(true).fitWidth(32.0).smooth(true).cache(true)).build());
        this.zoomPopupPane = new ZoomPopupPane();
        this.zoomPopup = new Popup();
        this.zoomPopup.getContent().add((Object)this.zoomPopupPane);
        this.zoomFactorProperty.bind((ObservableValue)this.zoomPopupPane.sizeSlider.valueProperty());
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ZoomWidget.this.zoomPopupPane.setVisible(true);
                ZoomWidget.this.zoomPopup.show(owner, CoordinateUtil.getScreenX((Node)ZoomWidget.this) - 40.0, CoordinateUtil.getScreenY((Node)ZoomWidget.this) - 20.0);
            }
        });
        this.zoomPopup.setAutoHide(true);
    }

    protected final class ZoomPopupPane
    extends GridPane {
        private final Button minusButton;
        private final Label label;
        private final Text text;
        private final Button plusButton;
        protected final Slider sizeSlider;
        private final int size1 = 26;
        private final int size2 = 42;

        public ZoomPopupPane() {
            this.setHgap(4.0);
            this.setVgap(4.0);
            this.getStyleClass().add((Object)"tooltip");
            this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{ColumnConstraintsBuilder.create().minWidth(26.0).maxWidth(26.0).build(), ColumnConstraintsBuilder.create().minWidth(42.0).maxWidth(42.0).build(), ColumnConstraintsBuilder.create().minWidth(26.0).maxWidth(26.0).build()});
            this.minusButton = new Button("-");
            this.plusButton = new Button("+");
            this.minusButton.setMinSize(26.0, 26.0);
            this.minusButton.setMaxSize(26.0, 26.0);
            this.plusButton.setMinSize(26.0, 26.0);
            this.plusButton.setMaxSize(26.0, 26.0);
            this.label = new Label();
            this.text = new Text("100%");
            this.text.setTextAlignment(TextAlignment.CENTER);
            this.label.setGraphic((Node)this.text);
            this.label.setAlignment(Pos.CENTER);
            this.label.setMinWidth(42.0);
            this.label.setPrefWidth(42.0);
            this.label.setMaxWidth(42.0);
            this.sizeSlider = new Slider();
            this.minusButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ZoomPopupPane.this.sizeSlider.decrement();
                }
            });
            this.plusButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (ZoomPopupPane.this.sizeSlider.getValue() == 2.0) {
                        ZoomPopupPane.this.sizeSlider.setValue(4.0);
                    } else {
                        ZoomPopupPane.this.sizeSlider.increment();
                    }
                }
            });
            this.add((Node)this.minusButton, 0, 0);
            this.add((Node)this.label, 1, 0);
            this.add((Node)this.plusButton, 2, 0);
            this.sizeSlider.setOrientation(Orientation.HORIZONTAL);
            this.sizeSlider.setMin(0.1);
            this.sizeSlider.setMax(2.0);
            this.sizeSlider.setValue(1.0);
            this.sizeSlider.setBlockIncrement(0.1);
            this.add((Node)this.sizeSlider, 0, 1, 3, 1);
            this.text.textProperty().bind((ObservableValue)new StringBinding(){
                {
                    super.bind(new Observable[]{ZoomPopupPane.this.sizeSlider.valueProperty()});
                }

                protected String computeValue() {
                    return (int)(100.0 * ZoomPopupPane.this.sizeSlider.valueProperty().get()) + "%";
                }
            });
        }
    }
}

