/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.exploration;

import com.google.common.collect.Lists;
import conexp.fx.core.algorithm.exploration.Expert;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.math.SetClosureOperator;
import conexp.fx.gui.exploration.HumanExpert;
import java.util.HashSet;
import java.util.Set;

public final class AttributeExploration<G, M> {
    protected final MatrixContext<G, M> context;
    protected final Expert<G, M> expert;
    protected Set<M> pseudoClosure = new HashSet<M>();
    protected final Set<Implication<G, M>> implications = new HashSet<Implication<G, M>>();
    private final SetClosureOperator<M> clop = SetClosureOperator.fromImplications(this.implications, true, true);
    private final SetList.LecticOrder<M> lecticOrder;

    public static final AttributeExploration<String, String> withHumanExpert(MatrixContext<String, String> context) {
        return new AttributeExploration<String, String>(context, new HumanExpert(context));
    }

    public static final <G, M> Set<Implication<G, M>> getCanonicalBase(MatrixContext<G, M> context) {
        AttributeExploration<G, M> attributeExploration = new AttributeExploration<G, M>(context, __ -> null);
        try {
            attributeExploration.start();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return attributeExploration.getImplicationalBase();
    }

    public AttributeExploration(MatrixContext<G, M> context, Expert<G, M> expert) {
        this.context = context;
        this.expert = expert;
        this.lecticOrder = context.colHeads().getLecticOrder();
    }

    public final void start() throws InterruptedException {
        while (this.pseudoClosure.size() < this.context.colHeads().size()) {
            Set closure = this.context.rowAnd(this.context.colAnd(this.pseudoClosure));
            if (closure.size() == this.pseudoClosure.size()) {
                this.nextPseudoClosure();
                continue;
            }
            closure.removeAll(this.pseudoClosure);
            Implication implication = new Implication(this.pseudoClosure, closure);
            Set counterExample = this.expert.getCounterExamples(implication);
            if (counterExample.isEmpty()) {
                this.implications.add(implication);
                this.nextPseudoClosure();
                continue;
            }
            counterExample.forEach(cex -> cex.insertIn(this.context));
        }
    }

    private final void nextPseudoClosure() {
        for (Object m : Lists.reverse(this.context.colHeads())) {
            Set<M> s = this.clop.closure(this.lecticOrder.oplus(this.pseudoClosure, m));
            if (!this.lecticOrder.isSmaller(this.pseudoClosure, s, m)) continue;
            this.pseudoClosure = s;
            return;
        }
        throw new RuntimeException();
    }

    public final Set<Implication<G, M>> getImplicationalBase() {
        return this.implications;
    }

    public final MatrixContext<G, M> getFormalContext() {
        return this.context;
    }
}

