/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.exploration;

import conexp.fx.core.algorithm.exploration.CounterExample;
import conexp.fx.core.context.Implication;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

@FunctionalInterface
public interface Expert<G, M> {
    public Set<CounterExample<G, M>> getCounterExamples(Implication<G, M> var1) throws InterruptedException;

    default public Future<Set<CounterExample<G, M>>> requestCounterExamples(final Implication<G, M> implication) {
        return new Future<Set<CounterExample<G, M>>>(){
            private final CountDownLatch cdl = new CountDownLatch(1);
            private final AtomicReference<Set<CounterExample<G, M>>> ref = new AtomicReference(Collections.emptySet());
            private boolean isCancelled = false;
            {
                new Thread(() -> {
                    try {
                        this.ref.set(Expert.this.getCounterExamples(implication));
                        this.cdl.countDown();
                    }
                    catch (InterruptedException __) {
                        this.cancel(true);
                    }
                }).start();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.isCancelled) {
                    return false;
                }
                this.isCancelled = true;
                this.cdl.countDown();
                return true;
            }

            @Override
            public boolean isCancelled() {
                return this.isCancelled;
            }

            @Override
            public boolean isDone() {
                return this.cdl.getCount() == 0L;
            }

            @Override
            public Set<CounterExample<G, M>> get() throws InterruptedException, ExecutionException {
                this.cdl.await();
                return this.ref.get();
            }

            @Override
            public Set<CounterExample<G, M>> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (this.cdl.await(timeout, unit)) {
                    return this.ref.get();
                }
                throw new TimeoutException();
            }
        };
    }
}

