/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.exploration;

import conexp.fx.core.algorithm.exploration.CounterExample;
import conexp.fx.core.algorithm.exploration.Expert;
import conexp.fx.core.context.Implication;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;

public class ExpertPool<G, M>
implements Expert<G, M> {
    private final ObservableMap<Expert<G, M>, Boolean> experts = FXCollections.observableMap(new ConcurrentHashMap());
    private final Strategy strategy;
    private final ExecutorService exe;

    public ExpertPool(Strategy strategy, ExecutorService executor) {
        this.strategy = strategy;
        this.exe = executor;
        this.experts.addListener(change -> {
            if (change.wasAdded() && change.wasRemoved()) {
                System.out.println(change.getKey() + " IS NOW " + ((Boolean)change.getValueAdded() != false ? "IDLE" : "BUSY"));
            } else if (change.wasAdded()) {
                System.out.println(change.getKey() + " WAS ADDED AND IS " + ((Boolean)change.getValueAdded() != false ? "IDLE" : "BUSY"));
            } else if (change.wasRemoved()) {
                System.out.println(change.getKey() + " WAS REMOVED AND WAS " + ((Boolean)change.getValueRemoved() != false ? "IDLE" : "BUSY"));
            }
        });
    }

    @Override
    public Set<CounterExample<G, M>> getCounterExamples(Implication<G, M> implication) throws InterruptedException {
        switch (this.strategy) {
            case ANSWER_FROM_FIRST_IDLE: {
                return this.getIdleExpert().getCounterExamples(implication);
            }
            case FIRST_ANSWER_FROM_IDLE: {
                try {
                    return (Set)this.exe.invokeAny(this.experts.entrySet().parallelStream().filter(entry -> ((Boolean)entry.getValue()).equals(true)).map(entry -> (Expert)entry.getKey()).map(expert -> () -> {
                        try {
                            return expert.getCounterExamples(implication);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }).collect(Collectors.toSet()));
                }
                catch (ExecutionException e) {
                    return null;
                }
            }
            case FIRST_ANSWER: {
                try {
                    return (Set)this.exe.invokeAny(this.experts.keySet().parallelStream().map(expert -> () -> {
                        try {
                            return expert.getCounterExamples(implication);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }).collect(Collectors.toSet()));
                }
                catch (ExecutionException e) {
                    return null;
                }
            }
            case SOME_CONFIRMS: {
                if (this.experts.keySet().parallelStream().map(expert -> {
                    try {
                        return expert.getCounterExamples(implication);
                    }
                    catch (Exception __) {
                        return null;
                    }
                }).anyMatch(cex -> cex.isEmpty())) {
                    return Collections.emptySet();
                }
            }
            case ALL_CONFIRM: {
                return this.experts.keySet().parallelStream().map(expert -> {
                    try {
                        return expert.getCounterExamples(implication);
                    }
                    catch (Exception __) {
                        return null;
                    }
                }).flatMap(Collection::parallelStream).collect(Collectors.toSet());
            }
        }
        return Collections.emptySet();
    }

    @SafeVarargs
    public final void add(Expert<G, M> ... experts) {
        this.add(Arrays.asList(experts));
    }

    public final void add(Iterable<Expert<G, M>> experts) {
        experts.forEach(expert -> {
            Boolean cfr_ignored_0 = (Boolean)this.experts.put(expert, (Object)true);
        });
    }

    @SafeVarargs
    public final void remove(Expert<G, M> ... experts) {
        this.remove(Arrays.asList(experts));
    }

    public final void remove(Iterable<Expert<G, M>> experts) {
        experts.forEach(expert -> {
            Boolean cfr_ignored_0 = (Boolean)this.experts.remove(expert);
        });
    }

    public final boolean isIdle(Expert<G, M> expert) {
        return (Boolean)this.experts.get(expert);
    }

    public final boolean allIdle() {
        return !this.experts.values().contains(false);
    }

    public final boolean someIdle() {
        return this.experts.values().contains(true);
    }

    public final void setBusy(Expert<G, M> expert) {
        if (!this.experts.containsKey(expert)) {
            throw new IllegalArgumentException();
        }
        this.experts.put(expert, (Object)false);
    }

    public final void setIdle(Expert<G, M> expert) {
        if (!this.experts.containsKey(expert)) {
            throw new IllegalArgumentException();
        }
        this.experts.put(expert, (Object)true);
    }

    public final Expert<G, M> getIdleExpert() throws NoSuchElementException {
        return this.experts.entrySet().parallelStream().filter(entry -> ((Boolean)entry.getValue()).equals(true)).map(entry -> (Expert)entry.getKey()).findAny().get();
    }

    public final Strategy getStrategy() {
        return this.strategy;
    }

    static enum Strategy {
        ANSWER_FROM_FIRST_IDLE("Chooses a random idle expert and returns its/his/her answer."),
        FIRST_ANSWER_FROM_IDLE("Use answer from fastest idle expert"),
        FIRST_ANSWER("Use answer from fastest expert"),
        SOME_CONFIRMS("Confirm all implications that are confirmed by at least one of the experts, i.e., reject all implications that are rejected by all experts."),
        ALL_CONFIRM("Confirm all implications that confirmed by all experts, i.e., reject all implications that are rejected by at least one of the experts.");

        private final String description;

        private Strategy(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

