/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosure;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import conexp.fx.core.collections.Either;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.math.SetClosureOperator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class NextClosure {
    public static <G, M> Iterable<Concept<G, M>> intents(MatrixContext<G, M> cxt) {
        Function<Set, Concept> clop = set -> {
            Set extent = cxt.colAnd((Collection<?>)set);
            Set intent = cxt.rowAnd(extent);
            return new Concept(extent, intent);
        };
        return NextClosure.enumerate(cxt.colHeads(), clop.apply(new HashSet()), clop, concept -> concept.getIntent());
    }

    public static <G, M> Iterable<Either<Concept<G, M>, Implication<G, M>>> implications(MatrixContext<G, M> cxt) {
        HashSet implications = Sets.newHashSet();
        SetClosureOperator clop = SetClosureOperator.fromImplications(implications, true, true);
        Function<Set, Either> clop2 = set -> {
            Set quasiIntent = clop.closure(set);
            Set extent = cxt.colAnd(quasiIntent);
            Set intent = cxt.rowAnd(extent);
            if (quasiIntent.size() != intent.size()) {
                intent.removeAll(quasiIntent);
                Implication implication = new Implication(quasiIntent, intent, extent);
                implications.add(implication);
                return Either.ofRight(implication);
            }
            return Either.ofLeft(new Concept(extent, intent));
        };
        return NextClosure.enumerate(cxt.colHeads(), clop2.apply(new HashSet()), clop2, e -> ((Optional)e.x()).isPresent() ? ((Concept)((Optional)e.x()).get()).getIntent() : ((Implication)((Object)((Object)((Optional)e.y()).get()))).getPremise());
    }

    public static <G, M> Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> conceptsAndImplications(MatrixContext<G, M> cxt) {
        HashSet concepts = Sets.newHashSet();
        HashSet implications = Sets.newHashSet();
        NextClosure.enumerate(cxt.colHeads(), SetClosureOperator.fromImplications(implications, true, true)).forEach(quasiIntent -> {
            Set extent = cxt.colAnd((Collection<?>)quasiIntent);
            Set intent = cxt.rowAnd(extent);
            if (quasiIntent.size() != intent.size()) {
                intent.removeAll((Collection<?>)quasiIntent);
                implications.add(new Implication(quasiIntent, intent, extent));
            } else {
                concepts.add(new Concept(extent, intent));
            }
        });
        return Pair.of(concepts, implications);
    }

    public static <T> Iterable<Set<T>> enumerate(SetList<T> base, SetClosureOperator<T> clop) {
        return NextClosure.enumerate(base, new HashSet(), clop::closure, t -> t);
    }

    public static <T, U> Iterable<U> enumerate(final SetList<T> base, final U first, final Function<Set<T>, U> clop, final Function<U, Set<T>> inverse) {
        return new Iterable<U>(){

            @Override
            public final Iterator<U> iterator() {
                return new UnmodifiableIterator<U>(){
                    private final SetList.LecticOrder<T> lecticOrder;
                    private U nextClosure;
                    private boolean isFirst;
                    {
                        this.lecticOrder = base.getLecticOrder();
                        this.nextClosure = first;
                        this.isFirst = true;
                    }

                    public final boolean hasNext() {
                        return this.isFirst || ((Set)inverse.apply(this.nextClosure)).size() < base.size();
                    }

                    public final U next() {
                        if (this.isFirst) {
                            this.isFirst = false;
                        } else if (((Set)inverse.apply(this.nextClosure)).size() < base.size()) {
                            for (Object m : Lists.reverse((List)base)) {
                                Object s = clop.apply(this.lecticOrder.oplus((Set)inverse.apply(this.nextClosure), m));
                                if (!this.lecticOrder.isSmaller((Set)inverse.apply(this.nextClosure), (Set)inverse.apply(s), m)) continue;
                                this.nextClosure = s;
                                return this.nextClosure;
                            }
                            throw new RuntimeException();
                        }
                        return this.nextClosure;
                    }
                };
            }
        };
    }
}

