/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosure;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.collections.setlist.SetLists;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.gui.task.TimeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;

public final class NextConcept<G, M>
implements Iterable<Concept<G, M>> {
    private final MatrixContext<G, M> context;

    public static final <G, M> TimeTask<Void> concepts(final ConceptLattice<G, M> lattice) {
        return new TimeTask<Void>("NextConcept"){
            private final Comparator<Concept<G, M>> intentSizeComparator;
            {
                super(title);
                this.intentSizeComparator = new Comparator<Concept<G, M>>(){

                    @Override
                    public final int compare(Concept<G, M> c1, Concept<G, M> c2) {
                        return (int)Math.signum(c1.intent().size() - c2.intent().size());
                    }
                };
            }

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateMessage("Computing Formal Concepts...");
                lattice.dispose();
                this.updateProgress(0.05, 1.0);
                double currentConceptNumber = 0.0;
                double maximalConceptNumber = Math.pow(2.0, Math.min(lattice.context.rowHeads().size(), lattice.context.colHeads().size()));
                HashSet hashSet = new HashSet();
                this.updateProgress(0.1, 1.0);
                Iterator iterator = new NextConcept(lattice.context).iterator();
                this.updateProgress(0.2, 1.0);
                while (iterator.hasNext()) {
                    Concept concept = iterator.next();
                    hashSet.add(concept);
                    this.updateProgress(0.2 + 0.5 * ((currentConceptNumber += 1.0) / maximalConceptNumber), 1.0);
                    this.updateMessage("computing concepts: " + currentConceptNumber + "...");
                }
                this.updateProgress(0.7, 1.0);
                ArrayList concepts = new ArrayList(hashSet);
                this.updateProgress(0.75, 1.0);
                this.updateMessage("sorting " + currentConceptNumber + " concepts...");
                Collections.sort(concepts, this.intentSizeComparator);
                this.updateProgress(0.9, 1.0);
                lattice.rowHeads().addAll(concepts);
                this.updateMessage("Pushing Changes...");
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }

    public NextConcept(MatrixContext<G, M> context) {
        this.context = context;
    }

    @Override
    public final Iterator<Concept<G, M>> iterator() {
        final MatrixContext selection = this.context.selection;
        MatrixRelation reduced = selection._reduced.clone();
        HullOperator<Integer> hullOp = new HullOperator<Integer>((MatrixContext)reduced){
            final /* synthetic */ MatrixContext val$reduced;
            {
                this.val$reduced = matrixContext;
            }

            @Override
            public Collection<Integer> closure(Iterable<Integer> set) {
                return this.val$reduced._extent(set);
            }
        };
        return Iterators.transform((Iterator)new UnmodifiableIterator<BitSetFX>((MatrixContext)reduced, (HullOperator)hullOp){
            private final int rows;
            private BitSetFX _A;
            final /* synthetic */ MatrixContext val$reduced;
            final /* synthetic */ HullOperator val$hullOp;
            {
                this.val$reduced = matrixContext;
                this.val$hullOp = hullOperator;
                this.rows = this.val$reduced.rowHeads().size();
                this._A = new BitSetFX(this.val$reduced._colAnd(SetLists.integers(this.val$reduced.colHeads().size())));
            }

            public final boolean hasNext() {
                return this._A != null;
            }

            public final BitSetFX next() {
                BitSetFX _nextExtent = this._A;
                this._APlus();
                return _nextExtent;
            }

            private final void _APlus() {
                for (int _g = this.rows - 1; _g > -1; --_g) {
                    BitSetFX _APlus;
                    if (this._A.contains(_g) || !this._AisLexicSmallerG(_APlus = this._APlusG(_g), _g)) continue;
                    this._A = _APlus;
                    return;
                }
                this._A = null;
            }

            private final BitSetFX _APlusG(int _g) {
                return new BitSetFX(this.val$hullOp.closure(Collections3.iterable(Iterators.concat((Iterator)Iterators.filter(this._A.iterator(), Collections3.isSmaller(_g)), (Iterator)Iterators.singletonIterator((Object)_g)))));
            }

            private final boolean _AisLexicSmallerG(BitSetFX _B, int _g) {
                int _h;
                Iterator<Integer> iterator = _B.iterator();
                while (iterator.hasNext() && (_h = iterator.next().intValue()) != _g) {
                    if (this._A.contains(_h)) continue;
                    return false;
                }
                return true;
            }
        }, (Function)new Function<BitSetFX, Concept<G, M>>((MatrixContext)reduced){
            final /* synthetic */ MatrixContext val$reduced;
            {
                this.val$reduced = matrixContext2;
            }

            public final Concept<G, M> apply(BitSetFX _extent) {
                return new Concept(selection.rowHeads().getAll(selection._colAnd(Collections3.iterable(Iterators.concat((Iterator)Iterators.transform(this.val$reduced.colHeads().getAll(this.val$reduced._rowAnd(_extent), true).iterator(), Collections3.setToIterator())))), true), selection.colHeads().getAll(selection._rowAnd(Collections3.iterable(Iterators.concat((Iterator)Iterators.transform(this.val$reduced.rowHeads().getAll(_extent, true).iterator(), Collections3.setToIterator())))), true));
            }
        });
    }

    private static interface HullOperator<M> {
        public Collection<Integer> closure(Iterable<M> var1);
    }
}

