/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosure;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.collections.setlist.SetLists;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.gui.task.TimeTask;
import de.tudresden.inf.tcs.fcalib.Implication;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;

public final class NextImplication<G, M>
implements Iterable<Implication<M>> {
    private final MatrixContext<G, M> context;

    public static final <G, M> TimeTask<Void> implications(final MatrixContext<G, M> context, final List<Implication<M>> implications) {
        return new TimeTask<Void>("NextImplication"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateMessage("Computing Formal Implications...");
                this.updateProgress(0.05, 1.0);
                double currentImplicationNumber = 0.0;
                this.updateProgress(0.1, 1.0);
                Iterator iterator = new NextImplication(context).iterator();
                this.updateProgress(0.2, 1.0);
                while (iterator.hasNext()) {
                    final Implication next = iterator.next();
                    if (Platform.isFxApplicationThread()) {
                        implications.add(next);
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                implications.add(next);
                            }
                        });
                    }
                    this.updateMessage("computing implications: " + (currentImplicationNumber += 1.0) + "...");
                }
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }

    public NextImplication(MatrixContext<G, M> context) {
        this.context = context;
    }

    @Override
    public final Iterator<Implication<M>> iterator() {
        MatrixRelation cleaned = this.context.selection._cleaned.clone();
        UnmodifiableIterator<BitImplication> it = new UnmodifiableIterator<BitImplication>((MatrixContext)cleaned){
            private final int cols;
            private BitSetFX _P;
            private final Set<BitImplication> impls;
            private final HullOperator<Integer> hullOp;
            final /* synthetic */ MatrixContext val$cleaned;
            {
                this.val$cleaned = matrixContext;
                this.cols = this.val$cleaned.colHeads().size();
                this._P = new BitSetFX(this.val$cleaned._colAnd(SetLists.integers(this.cols)));
                this.impls = new HashSet<BitImplication>();
                this.hullOp = new HullOperator<Integer>(){

                    @Override
                    public final Collection<Integer> closure(Collection<Integer> set) {
                        for (BitImplication impl : impls) {
                            if (!set.containsAll(impl.premise)) continue;
                            set.addAll(impl.conclusion);
                        }
                        return set;
                    }
                };
            }

            public final boolean hasNext() {
                return this._P != null;
            }

            public final BitImplication next() {
                BitImplication bitImplication;
                do {
                    BitSetFX _nextPseudoIntent = this._P;
                    bitImplication = this.toBitImplication(_nextPseudoIntent);
                    this._PPlus();
                } while (this._P != null && bitImplication.conclusion.isEmpty());
                this.impls.add(bitImplication);
                return bitImplication;
            }

            private final BitImplication toBitImplication(BitSetFX pseudoIntent) {
                BitSetFX conclusion = new BitSetFX(this.val$cleaned._intent(pseudoIntent));
                conclusion.removeAll(pseudoIntent);
                return new BitImplication(pseudoIntent, conclusion);
            }

            private final void _PPlus() {
                for (int _m = this.cols - 1; _m > -1; --_m) {
                    BitSetFX _PPlus;
                    if (this._P.contains(_m) || !this._PisLexicSmallerM(_PPlus = this._PPlusM(_m), _m)) continue;
                    this._P = _PPlus;
                    return;
                }
                this._P = null;
            }

            private final BitSetFX _PPlusM(int _m) {
                return new BitSetFX(this.hullOp.closure(Sets.newHashSet(Collections3.iterable(Iterators.concat((Iterator)Iterators.filter(this._P.iterator(), Collections3.isSmaller(_m)), (Iterator)Iterators.singletonIterator((Object)_m))))));
            }

            private final boolean _PisLexicSmallerM(BitSetFX _B, int _m) {
                int _n;
                Iterator<Integer> iterator = _B.iterator();
                while (iterator.hasNext() && (_n = iterator.next().intValue()) != _m) {
                    if (this._P.contains(_n)) continue;
                    return false;
                }
                return true;
            }
        };
        Function f = new Function<BitImplication, Implication<M>>((MatrixContext)cleaned){
            final /* synthetic */ MatrixContext val$cleaned;
            {
                this.val$cleaned = matrixContext;
            }

            public final Implication<M> apply(BitImplication _implication) {
                Collection p = ((NextImplication)NextImplication.this).context.selection.colHeads().getAll(Collections3.union(Collections2.transform((Collection)_implication.premise, (Function)new Function<Integer, Collection<Integer>>(){

                    public final Collection<Integer> apply(Integer index) {
                        return (Collection)val$cleaned.colHeads().get(index);
                    }
                })), false);
                Collection c = ((NextImplication)NextImplication.this).context.selection.colHeads().getAll(Collections3.union(Collections2.transform((Collection)_implication.conclusion, (Function)new Function<Integer, Collection<Integer>>(){

                    public final Collection<Integer> apply(Integer index) {
                        return (Collection)val$cleaned.colHeads().get(index);
                    }
                })), false);
                return new Implication((Set)Sets.newHashSet(p), (Set)Sets.newHashSet(c));
            }
        };
        return Iterators.transform((Iterator)it, (Function)f);
    }

    private static final class BitImplication {
        private final BitSetFX premise;
        private final BitSetFX conclusion;

        private BitImplication(BitSetFX premise, BitSetFX conclusion) {
            this.premise = premise;
            this.conclusion = conclusion;
        }
    }

    private static interface HullOperator<M> {
        public Collection<Integer> closure(Collection<M> var1);
    }
}

