/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Context;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class NextClosures1 {
    public static final <G, M> Result<G, M> compute(final Context<G, M> cxt, boolean verbose, ThreadPoolExecutor tpe) {
        if (verbose) {
            System.out.println("NextClosures running on " + tpe.getCorePoolSize() + " - " + tpe.getMaximumPoolSize() + " cores...");
        }
        final Result result = new Result();
        int maxCardinality = cxt.colHeads().size();
        while (result.cardinality <= maxCardinality) {
            if (verbose) {
                int p = (int)(100.0f * (float)result.cardinality / (float)maxCardinality);
                System.out.print("current cardinality: " + result.cardinality + "/" + maxCardinality + " (" + p + "%)");
            }
            HashSet candidatesN = new HashSet(Collections2.filter(result.candidates.keySet(), candidate -> candidate.size() == result.cardinality));
            if (verbose) {
                System.out.println("     " + candidatesN.size() + " candidates will be processed...");
            }
            HashSet futures = new HashSet();
            for (final Set set : candidatesN) {
                futures.add(tpe.submit(new Runnable(){

                    @Override
                    public final void run() {
                        Set closure = result.fastClosure(set, result.candidates.get(set));
                        if (closure.equals(set)) {
                            Set candidateI = cxt.colAnd(set);
                            Set candidateII = cxt.rowAnd(candidateI);
                            if (result.addToProcessed(candidateII)) {
                                for (Object m : Sets.difference(cxt.colHeads(), candidateII)) {
                                    HashSet candidateM = new HashSet(candidateII);
                                    candidateM.add(m);
                                    result.candidates.put(candidateM, 0);
                                }
                            }
                            if (candidateII.size() == set.size()) {
                                result.concepts.add(new Concept(candidateI, set));
                            } else {
                                result.concepts.add(new Concept(candidateI, candidateII));
                                candidateII.removeAll(set);
                                result.implications.put(set, candidateII);
                                result.supports.put(set, candidateI);
                            }
                        } else {
                            result.candidates.put(closure, result.cardinality);
                        }
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            result.candidates.keySet().removeAll(candidatesN);
            ++result.cardinality;
        }
        if (verbose) {
            System.out.println(result.concepts.size() + " concepts found");
            System.out.println(result.implications.size() + " implications found");
        }
        return result;
    }

    public static final <G, M> Result<G, M> compute(Context<G, M> cxt, boolean verbose, int cores) {
        if (cores > Runtime.getRuntime().availableProcessors()) {
            throw new IllegalArgumentException("Requested pool size is too large. VM has only " + Runtime.getRuntime().availableProcessors() + " available cpus, thus a thread pool with " + cores + " cores cannot be used here.");
        }
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(cores, cores, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        tpe.prestartAllCoreThreads();
        Result<G, M> result = NextClosures1.compute(cxt, verbose, tpe);
        tpe.purge();
        tpe.shutdown();
        return result;
    }

    public static final <G, M> Result<G, M> compute(Context<G, M> cxt, boolean verbose) {
        int maxc = Runtime.getRuntime().availableProcessors();
        int cores = maxc < 9 ? maxc : maxc * 3 / 4;
        return NextClosures1.compute(cxt, verbose, cores);
    }

    public static final class Result<G, M> {
        public final Set<Concept<G, M>> concepts = Collections3.newConcurrentHashSet();
        public final Map<Set<M>, Set<M>> implications = new ConcurrentHashMap<Set<M>, Set<M>>();
        public final Map<Set<M>, Set<G>> supports = new ConcurrentHashMap<Set<M>, Set<G>>();
        protected final Map<Set<M>, Integer> candidates = new ConcurrentHashMap<Set<M>, Integer>();
        private final Set<Set<M>> processed = Collections3.newConcurrentHashSet();
        protected int cardinality = 0;

        public Result() {
            this.candidates.put(new HashSet(), 0);
        }

        private final boolean isClosed(Set<M> candidate) {
            for (Map.Entry<Set<M>, Set<M>> implication : this.implications.entrySet()) {
                if (candidate.size() <= implication.getKey().size() || !candidate.containsAll((Collection)implication.getKey()) || candidate.containsAll((Collection)implication.getValue())) continue;
                return false;
            }
            return true;
        }

        final Set<M> fastClosure(Set<M> candidate, int c) {
            HashSet<M> closure = new HashSet<M>(candidate);
            boolean changed = false;
            for (Map.Entry<Set<M>, Set<M>> implication : this.implications.entrySet()) {
                if (implication.getKey().size() < c || closure.size() <= implication.getKey().size() || !closure.containsAll((Collection)implication.getKey()) || closure.containsAll((Collection)implication.getValue())) continue;
                closure.addAll((Collection)implication.getValue());
                changed = true;
            }
            while (changed) {
                changed = false;
                for (Map.Entry<Set<M>, Set<M>> implication : this.implications.entrySet()) {
                    if (closure.size() <= implication.getKey().size() || !closure.containsAll((Collection)implication.getKey()) || closure.containsAll((Collection)implication.getValue())) continue;
                    closure.addAll((Collection)implication.getValue());
                    changed = true;
                }
            }
            return closure;
        }

        private final Set<M> closure(Set<M> candidate) {
            HashSet<M> closure = new HashSet<M>(candidate);
            boolean changed = true;
            while (changed) {
                changed = false;
                for (Map.Entry<Set<M>, Set<M>> implication : this.implications.entrySet()) {
                    if (closure.size() <= implication.getKey().size() || !closure.containsAll((Collection)implication.getKey()) || closure.containsAll((Collection)implication.getValue())) continue;
                    closure.addAll((Collection)implication.getValue());
                    changed = true;
                }
            }
            return closure;
        }

        final boolean addToProcessed(Set<M> s) {
            try {
                return this.processed.add(s);
            }
            catch (ConcurrentModificationException e) {
                return this.addToProcessed(s);
            }
        }
    }
}

