/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import com.google.common.collect.Sets;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Implication;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class NextClosuresState<G, M, C extends Set<M>> {
    public final Set<Concept<G, M>> concepts = Collections3.newConcurrentHashSet();
    public final Set<Implication<G, M>> implications = Collections3.newConcurrentHashSet();
    public final Map<C, Integer> candidates = new ConcurrentHashMap<C, Integer>();
    private final Set<C> processed = Collections3.newConcurrentHashSet();
    public int cardinality = 0;
    private final Set<M> domain;
    private final Function<Set<M>, C> supplier;

    public static final <G, M> NextClosuresState<G, M, Set<M>> withHashSets(Set<M> domain) {
        return new NextClosuresState<G, M, Set>(domain, HashSet::new);
    }

    public static final NextClosuresState<Integer, Integer, BitSetFX> withBitSets(int max) {
        return new NextClosuresState<Integer, Integer, BitSetFX>(Collections3.integers(max), BitSetFX::new);
    }

    private NextClosuresState(Set<M> domain, Function<Set<M>, C> supplier) {
        this.domain = domain;
        this.supplier = supplier;
        this.candidates.put(supplier.apply(Collections.emptySet()), 0);
    }

    public final Set<C> getActualCandidates() {
        return this.candidates.keySet().parallelStream().filter(c -> c.size() == this.cardinality).collect(Collectors.toSet());
    }

    public final int getFirstPremiseSize(C candidate) {
        return this.candidates.get(candidate);
    }

    public final boolean isNewIntent(C s) {
        try {
            return this.processed.add(s);
        }
        catch (ConcurrentModificationException e) {
            return this.isNewIntent(s);
        }
    }

    public final void addNewCandidates(C intent) {
        for (Object m : Sets.difference(this.domain, intent)) {
            Set candidateM = (Set)this.supplier.apply((Set<M>)intent);
            candidateM.add(m);
            this.candidates.put(candidateM, 0);
        }
    }

    public final void addCandidate(C candidate) {
        this.candidates.put(candidate, this.cardinality);
    }

    public final Pair<Set<Concept<G, M>>, Set<Implication<G, M>>> getResultAndDispose() {
        this.candidates.clear();
        this.processed.clear();
        return Pair.of(this.concepts, this.implications);
    }

    public int getActualCardinality() {
        return this.cardinality;
    }

    public void increaseCardinality() {
        ++this.cardinality;
    }
}

