/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import conexp.fx.core.algorithm.nextclosures.NextClosures2;
import conexp.fx.core.algorithm.nextclosures.NextClosures2C;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.importer.CXTImporter;
import conexp.fx.core.math.SetClosureOperator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public final class ProbDLExample {
    private static Set<Implication<String, String>> bimp;

    public static final void main(String[] args) throws Exception {
        File file = new File("../../LaTeX/cla2015-prob-ijgs/example-pdl-induced.cxt");
        MatrixContext<String, String> cxt = CXTImporter.read(file);
        bimp = Sets.newHashSet((Object[])new Implication[]{new Implication("$\\bot$", "$A_1$"), new Implication("$\\bot$", "$A_2$"), new Implication("$\\bot$", "$A_3$"), new Implication("$\\bot$", "$r_1:C_1$"), new Implication("$\\bot$", "$r_1:C_7$"), new Implication("$\\bot$", "$r_2:C_1$"), new Implication("$\\bot$", "$r_2:C_7$"), new Implication("$r_1:C_1$", "$r_1:C_3$"), new Implication("$r_1:C_3$", "$r_1:C_5$"), new Implication("$r_1:C_5$", "$r_1:C_2$"), new Implication("$r_1:C_7$", "$r_1:C_6$"), new Implication("$r_1:C_6$", "$r_1:C_4$"), new Implication("$r_1:C_6$", "$r_1:C_5$"), new Implication("$r_1:C_4$", "$r_1:C_2$"), new Implication("$r_2:C_1$", "$r_2:C_3$"), new Implication("$r_2:C_3$", "$r_2:C_5$"), new Implication("$r_2:C_5$", "$r_2:C_2$"), new Implication("$r_2:C_7$", "$r_2:C_6$"), new Implication("$r_2:C_6$", "$r_2:C_4$"), new Implication("$r_2:C_6$", "$r_2:C_5$"), new Implication("$r_2:C_4$", "$r_2:C_2$")});
        Set<Double> probs = Sets.powerSet((Set)Sets.newHashSet((Object[])new Double[]{0.5, 0.3333333333333333, 0.16666666666666666})).stream().map(Collections3::sum).collect(Collectors.toSet());
        probs.remove(0.0);
        probs.forEach(System.out::println);
        Set i = NextClosures2.compute(cxt, bimp).second();
        i.stream().map(ProbDLExample::minimize).forEach(System.out::println);
        NextClosures2.compute(cxt, new Collection[0]).first().stream().map(Concept::getIntent).forEach(System.out::println);
        Set j = NextClosures2C.compute(cxt, SetClosureOperator.fromImplications(bimp)).second();
        System.out.println(i.size() == j.size());
        System.out.println(i.equals(j));
        System.out.println(Implication.equivalent(i, j));
    }

    private static final Implication<String, String> minimize(Implication<String, String> impl) {
        return new Implication(ProbDLExample.b(impl.getPremise()), ProbDLExample.b(impl.getConclusion()));
    }

    private static final Set<String> b(Set<String> s) {
        String a;
        ArrayList r = Lists.newArrayList(s);
        Collections.shuffle(r);
        do {
            a = null;
            for (String x : r) {
                if (!SetClosureOperator.fromImplications(bimp, false, true).closure(Sets.difference((Set)Sets.newHashSet((Iterable)r), Collections.singleton(x))).contains(x)) continue;
                a = x;
                break;
            }
            r.remove(a);
        } while (a != null);
        return Sets.newHashSet((Iterable)r);
    }
}

