/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.algorithm.nextclosures;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import conexp.fx.core.algorithm.nextclosures.NextClosures2;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.importer.CXTImporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public final class ProbExample {
    private static Set<Implication<String, String>> backgroundImplications;
    private static Map<String, Set<Integer>> elems;
    private static Map<String, Double> probs;

    private static final void e(String s, Integer ... es) {
        elems.put(s, Sets.newHashSet((Object[])es));
    }

    private static final void p(String s, Double p) {
        probs.put(s, p);
    }

    private static final void f(String p, String ... cs) {
        for (String c : Arrays.asList(cs)) {
            backgroundImplications.add(new Implication(Collections.singleton(p), Collections.singleton(c)));
        }
    }

    private static final void g(String p, String q, String c) {
        backgroundImplications.add(new Implication((Set<String>)Sets.newHashSet((Object[])new String[]{p, q}), Collections.singleton(c)));
    }

    public static final void main(String[] args) throws Exception {
        elems = new HashMap<String, Set<Integer>>();
        ProbExample.e("F", 2);
        ProbExample.e("G", 3);
        ProbExample.e("H", 1, 3);
        ProbExample.e("I", 2, 3);
        ProbExample.e("J", 1, 2, 3);
        ProbExample.e("K", 2);
        ProbExample.e("L", 3);
        ProbExample.e("M", 1, 3);
        ProbExample.e("N", 2, 3);
        ProbExample.e("O", 1, 2, 3);
        ProbExample.e("P", 2);
        ProbExample.e("Q", 3);
        ProbExample.e("R", 1, 3);
        ProbExample.e("S", 2, 3);
        ProbExample.e("T", 1, 2, 3);
        ProbExample.e("U", 2);
        ProbExample.e("V", 3);
        ProbExample.e("W", 1, 3);
        ProbExample.e("X", 2, 3);
        ProbExample.e("Y", 1, 2, 3);
        ProbExample.e("Z", 2);
        ProbExample.e("0", 3);
        ProbExample.e("1", 1, 3);
        ProbExample.e("2", 2, 3);
        ProbExample.e("3", 1, 2, 3);
        probs = new HashMap<String, Double>();
        ProbExample.p("F", 0.16666666666666666);
        ProbExample.p("G", 0.16666666666666666);
        ProbExample.p("H", 0.16666666666666666);
        ProbExample.p("I", 0.16666666666666666);
        ProbExample.p("J", 0.16666666666666666);
        ProbExample.p("K", 0.3333333333333333);
        ProbExample.p("L", 0.3333333333333333);
        ProbExample.p("M", 0.3333333333333333);
        ProbExample.p("N", 0.3333333333333333);
        ProbExample.p("O", 0.3333333333333333);
        ProbExample.p("P", 0.6666666666666666);
        ProbExample.p("Q", 0.6666666666666666);
        ProbExample.p("R", 0.6666666666666666);
        ProbExample.p("S", 0.6666666666666666);
        ProbExample.p("T", 0.6666666666666666);
        ProbExample.p("U", 0.8333333333333334);
        ProbExample.p("V", 0.8333333333333334);
        ProbExample.p("W", 0.8333333333333334);
        ProbExample.p("X", 0.8333333333333334);
        ProbExample.p("Y", 0.8333333333333334);
        ProbExample.p("Z", 1.0);
        ProbExample.p("0", 1.0);
        ProbExample.p("1", 1.0);
        ProbExample.p("2", 1.0);
        ProbExample.p("3", 1.0);
        backgroundImplications = new HashSet<Implication<String, String>>();
        for (String p : elems.keySet()) {
            for (String q : elems.keySet()) {
                if (p.equals(q) || !(probs.get(p) >= probs.get(q)) || !elems.get(p).containsAll((Collection)elems.get(q))) continue;
                ProbExample.f(p, q);
            }
        }
        for (String p : elems.keySet()) {
            for (String q : elems.keySet()) {
                if (p.equals(q)) continue;
                for (String c : elems.keySet()) {
                    if (c.equals(p) || c.equals(q) || !(probs.get(p) + probs.get(q) - 1.0 > 0.0) || probs.get(c) != probs.get(p) + probs.get(q) - 1.0 || !elems.get(c).containsAll((Collection<?>)Sets.union(elems.get(p), elems.get(q))) || !Sets.union(elems.get(p), elems.get(q)).containsAll((Collection)elems.get(c))) continue;
                    ProbExample.g(p, q, c);
                }
            }
        }
        backgroundImplications.forEach(System.out::println);
        MatrixContext<String, String> cxt = CXTImporter.read(new File("../../LaTeX/cla2015-prob-ijgs/example-scaling-2.cxt"));
        Pair<Set<Concept<String, String>>, Set<Implication<String, String>>> result2 = NextClosures2.compute(cxt, backgroundImplications);
        Set<Implication<String, String>> impls2 = result2.second();
        ((Stream)impls2.stream().map(i -> new Implication(ProbExample.b(i.getPremise()), ProbExample.b(i.getConclusion()))).sequential()).forEach(System.out::println);
    }

    private static final Set<String> b(Set<String> s) {
        String a;
        ArrayList r = Lists.newArrayList(s);
        Collections.shuffle(r);
        do {
            a = null;
            block1: for (String x : r) {
                if (a != null) break;
                block2: for (String y : r) {
                    if (a != null) continue block1;
                    if (backgroundImplications.contains((Object)new Implication(x, y))) {
                        a = y;
                        continue block1;
                    }
                    for (String z : r) {
                        if (!backgroundImplications.contains((Object)new Implication((String)((Object)Sets.newHashSet((Object[])new String[]{x, y})), z))) continue;
                        a = z;
                        continue block2;
                    }
                }
            }
            r.remove(a);
        } while (a != null);
        return Sets.newHashSet((Iterable)r);
    }
}

