/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.builder;

import conexp.fx.core.builder.FileRequest;
import conexp.fx.core.builder.Request;
import conexp.fx.core.builder.StringRequest;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.collections.setlist.SetLists;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.importer.CEXImporter;
import conexp.fx.core.importer.CFXImporter;
import conexp.fx.core.importer.CSVImporter;
import conexp.fx.core.importer.CXTImporter;
import conexp.fx.core.importer.RDFImporter;
import conexp.fx.core.math.BooleanMatrices;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrdf.repository.Repository;
import org.ujmp.core.booleanmatrix.BooleanMatrix;

public final class Requests {

    public static final class Construct {

        public static final class SubstitutionSum<G, H, M, N>
        extends Request<Pair<G, H>, Pair<M, N>> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<H, N> context2;
            private final G object;
            private final M attribute;

            public SubstitutionSum(MatrixContext<G, M> context1, MatrixContext<H, N> context2, G object, M attribute) {
                super(Type.SUBSTITUTION_SUM, Source.CONTEXT_CONTEXT_OBJECT_OBJECT);
                this.context1 = context1;
                this.context2 = context2;
                this.object = object;
                this.attribute = attribute;
            }

            @Override
            public final void setContent() {
                System.out.println("substitution sum");
                int i = this.context1.rowHeads().indexOf(this.object);
                int j = this.context1.colHeads().indexOf(this.attribute);
                System.out.println(i + ":" + j);
                BooleanMatrix matrix = BooleanMatrices.substitutionSum(this.context1.matrix(), this.context2.matrix(), i, j, this.context1._row(i), this.context1._col(j));
                System.out.println(matrix);
                this.context.setContent(SetLists.disjointUnion(SetLists.difference(this.context1.rowHeads(), Collections.singleton(this.object)), this.context2.rowHeads()), SetLists.disjointUnion(SetLists.difference(this.context1.colHeads(), Collections.singleton(this.attribute)), this.context2.colHeads()), matrix);
                System.out.println(this.context);
            }
        }

        public static final class SemiProduct<G, H, M, N>
        extends Request<Pair<G, H>, Pair<M, N>> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<H, N> context2;

            public SemiProduct(MatrixContext<G, M> context1, MatrixContext<H, N> context2) {
                super(Type.SEMI_PRODUCT, Source.CONTEXT_CONTEXT);
                this.context1 = context1;
                this.context2 = context2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.cartesianProduct(this.context1.rowHeads(), this.context2.rowHeads()), SetLists.disjointUnion(this.context1.colHeads(), this.context2.colHeads()), BooleanMatrices.semiProduct(this.context1.matrix(), this.context2.matrix()));
            }
        }

        public static final class BiProduct<G, H, M, N>
        extends Request<Pair<G, H>, Pair<M, N>> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<H, N> context2;

            public BiProduct(MatrixContext<G, M> context1, MatrixContext<H, N> context2) {
                super(Type.BI_PRODUCT, Source.CONTEXT_CONTEXT);
                this.context1 = context1;
                this.context2 = context2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.cartesianProduct(this.context1.rowHeads(), this.context2.rowHeads()), SetLists.cartesianProduct(this.context1.colHeads(), this.context2.colHeads()), BooleanMatrices.biProduct(this.context1.matrix(), this.context2.matrix()));
            }
        }

        public static final class DirectProduct<G, H, M, N>
        extends Request<Pair<G, H>, Pair<M, N>> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<H, N> context2;

            public DirectProduct(MatrixContext<G, M> context1, MatrixContext<H, N> context2) {
                super(Type.DIRECT_PRODUCT, Source.CONTEXT_CONTEXT);
                this.context1 = context1;
                this.context2 = context2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.cartesianProduct(this.context1.rowHeads(), this.context2.rowHeads()), SetLists.cartesianProduct(this.context1.colHeads(), this.context2.colHeads()), BooleanMatrices.directProduct(this.context1.matrix(), this.context2.matrix()));
            }
        }

        public static final class DirectSum<G, H, M, N>
        extends Request<Pair<G, H>, Pair<M, N>> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<H, N> context2;

            public DirectSum(MatrixContext<G, M> context1, MatrixContext<H, N> context2) {
                super(Type.DIRECT_SUM, Source.CONTEXT_CONTEXT);
                this.context1 = context1;
                this.context2 = context2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.disjointUnion(this.context1.rowHeads(), this.context2.rowHeads()), SetLists.disjointUnion(this.context1.colHeads(), this.context2.colHeads()), BooleanMatrices.directSum(this.context1.matrix(), this.context2.matrix()));
            }
        }

        public static final class VerticalSum<G, H, M, N>
        extends Request<Pair<G, H>, Pair<M, N>> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<H, N> context2;

            public VerticalSum(MatrixContext<G, M> context1, MatrixContext<H, N> context2) {
                super(Type.VERTICAL_SUM, Source.CONTEXT_CONTEXT);
                this.context1 = context1;
                this.context2 = context2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.disjointUnion(this.context1.rowHeads(), this.context2.rowHeads()), SetLists.disjointUnion(this.context1.colHeads(), this.context2.colHeads()), BooleanMatrices.verticalSum(this.context1.matrix(), this.context2.matrix()));
            }
        }

        public static final class HorizontalSum<G, H, M, N>
        extends Request<Pair<G, H>, Pair<M, N>> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<H, N> context2;

            public HorizontalSum(MatrixContext<G, M> context1, MatrixContext<H, N> context2) {
                super(Type.HORIZONTAL_SUM, Source.CONTEXT_CONTEXT);
                this.context1 = context1;
                this.context2 = context2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.disjointUnion(this.context1.rowHeads(), this.context2.rowHeads()), SetLists.disjointUnion(this.context1.colHeads(), this.context2.colHeads()), BooleanMatrices.horizontalSum(this.context1.matrix(), this.context2.matrix()));
            }
        }

        public static final class Quadposition<G, H, M, N>
        extends Request<Pair<G, H>, Pair<M, N>> {
            private final MatrixContext<G, M> upperLeft;
            private final MatrixContext<G, N> upperRight;
            private final MatrixContext<H, M> lowerLeft;
            private final MatrixContext<H, N> lowerRight;

            public Quadposition(MatrixContext<G, M> upperLeft, MatrixContext<G, N> upperRight, MatrixContext<H, M> lowerLeft, MatrixContext<H, N> lowerRight) {
                super(Type.QUADPOSITION, Source.CONTEXT_CONTEXT_CONTEXT_CONTEXT);
                this.upperLeft = upperLeft;
                this.upperRight = upperRight;
                this.lowerLeft = lowerLeft;
                this.lowerRight = lowerRight;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.disjointUnion(SetLists.intersection(this.upperLeft.rowHeads(), this.upperRight.rowHeads()), SetLists.intersection(this.lowerLeft.rowHeads(), this.lowerRight.rowHeads())), SetLists.intersection(SetLists.disjointUnion(this.upperLeft.colHeads(), this.upperRight.colHeads()), SetLists.disjointUnion(this.lowerLeft.colHeads(), this.lowerRight.colHeads())), BooleanMatrices.subposition(BooleanMatrices.apposition(this.upperLeft.matrix(), this.upperRight.matrix()), BooleanMatrices.apposition(this.lowerLeft.matrix(), this.lowerRight.matrix())));
            }
        }

        public static final class Subposition<G, H, M>
        extends Request<Pair<G, H>, M> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<H, M> context2;

            public Subposition(MatrixContext<G, M> context1, MatrixContext<H, M> context2) {
                super(Type.APPOSITION, Source.CONTEXT_CONTEXT);
                this.context1 = context1;
                this.context2 = context2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.disjointUnion(this.context1.rowHeads(), this.context2.rowHeads()), SetLists.intersection(this.context1.colHeads(), this.context2.colHeads()), BooleanMatrices.subposition(this.context1.matrix(), this.context2.matrix()));
            }
        }

        public static final class Apposition<G, M, N>
        extends Request<G, Pair<M, N>> {
            private final MatrixContext<G, M> context1;
            private final MatrixContext<G, N> context2;

            public Apposition(MatrixContext<G, M> context1, MatrixContext<G, N> context2) {
                super(Type.APPOSITION, Source.CONTEXT_CONTEXT);
                this.context1 = context1;
                this.context2 = context2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.intersection(this.context1.rowHeads(), this.context2.rowHeads()), SetLists.disjointUnion(this.context1.colHeads(), this.context2.colHeads()), BooleanMatrices.apposition(this.context1.matrix(), this.context2.matrix()));
            }
        }

        public static final class Contrary<G, M>
        extends Request<M, G> {
            private final MatrixContext<G, M> c;

            public Contrary(MatrixContext<G, M> c) {
                super(Type.CONTRARY, Source.CONTEXT);
                this.c = c;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.c.colHeads(), this.c.rowHeads(), BooleanMatrices.complement(BooleanMatrices.dual(this.c.matrix())));
            }
        }

        public static final class Dual<G, M>
        extends Request<M, G> {
            private final MatrixContext<G, M> c;

            public Dual(MatrixContext<G, M> c) {
                super(Type.DUAL, Source.CONTEXT);
                this.c = c;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.c.colHeads(), this.c.rowHeads(), BooleanMatrices.dual(this.c.matrix()));
            }
        }

        public static final class Complement<G, M>
        extends Request<G, M> {
            private final MatrixContext<G, M> c;

            public Complement(MatrixContext<G, M> c) {
                super(Type.COMPLEMENT, Source.CONTEXT);
                this.c = c;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.c.rowHeads(), this.c.colHeads(), BooleanMatrices.complement(this.c.matrix()));
            }
        }
    }

    public static final class Scale {

        public static final class GridScale<E, T>
        extends Request<Pair<E, T>, Pair<E, T>> {
            private final MatrixContext<E, E> order1;
            private final MatrixContext<T, T> order2;

            public GridScale(MatrixContext<E, E> order1, MatrixContext<T, T> order2) {
                super(Type.GRID, Source.ORDER_ORDER);
                this.order1 = order1;
                this.order2 = order2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.cartesianProduct(this.order1.rowHeads(), this.order2.rowHeads()), SetLists.disjointUnion(this.order1.colHeads(), this.order2.colHeads()), BooleanMatrices.semiProduct(this.order1.matrix(), this.order2.matrix()));
            }
        }

        public static final class BiOrdinalScale<E, T>
        extends Request<Pair<E, T>, Pair<E, T>> {
            private final MatrixContext<E, E> order1;
            private final MatrixContext<T, T> order2;

            public BiOrdinalScale(MatrixContext<E, E> order1, MatrixContext<T, T> order2) {
                super(Type.BI_ORDINAL, Source.ORDER_ORDER);
                this.order1 = order1;
                this.order2 = order2;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.disjointUnion(this.order1.rowHeads(), this.order2.rowHeads()), SetLists.disjointUnion(this.order1.colHeads(), this.order2.colHeads()), BooleanMatrices.horizontalSum(this.order1.matrix(), this.order2.matrix()));
            }
        }

        public static final class ConvexOrdinalScaleFromOrder<E>
        extends Request<E, Pair<E, E>> {
            private final MatrixContext<E, E> c;

            public ConvexOrdinalScaleFromOrder(MatrixContext<E, E> c) {
                super(Type.CONVEX_ORDINAL, Source.ORDER);
                this.c = c;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.c.rowHeads(), SetLists.disjointUnion(this.c.colHeads(), this.c.colHeads()), BooleanMatrices.apposition(BooleanMatrices.complement(BooleanMatrices.dual(this.c.matrix())), BooleanMatrices.complement(this.c.matrix())));
            }
        }

        public static final class ConvexOrdinalScaleFromSetList<E>
        extends Request<E, Pair<E, E>> {
            private final SetList<E> s;

            public ConvexOrdinalScaleFromSetList(SetList<E> s) {
                super(Type.CONVEX_ORDINAL, Source.STRINGS);
                this.s = s;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.s, SetLists.disjointUnion(this.s, this.s), BooleanMatrices.apposition(BooleanMatrices.complement(BooleanMatrices.dual(BooleanMatrices.upperDiagonal(this.s.size()))), BooleanMatrices.complement(BooleanMatrices.upperDiagonal(this.s.size()))));
            }
        }

        public static final class ConvexOrdinalScaleFromInt
        extends Request<Integer, Pair<Integer, Integer>> {
            private final int n;

            public ConvexOrdinalScaleFromInt(int n) {
                super(Type.CONVEX_ORDINAL, Source.INT_LIST);
                this.n = n;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.integers(this.n), SetLists.disjointUnion(SetLists.integers(this.n), SetLists.integers(this.n)), BooleanMatrices.apposition(BooleanMatrices.complement(BooleanMatrices.dual(BooleanMatrices.upperDiagonal(this.n))), BooleanMatrices.complement(BooleanMatrices.upperDiagonal(this.n))));
            }
        }

        public static final class InterOrdinalScaleFromOrder<E>
        extends Request<E, Pair<E, E>> {
            private final MatrixContext<E, E> c;

            public InterOrdinalScaleFromOrder(MatrixContext<E, E> c) {
                super(Type.INTER_ORDINAL, Source.ORDER);
                this.c = c;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.c.rowHeads(), SetLists.disjointUnion(this.c.colHeads(), this.c.colHeads()), BooleanMatrices.apposition(this.c.matrix(), BooleanMatrices.dual(this.c.matrix())));
            }
        }

        public static final class InterOrdinalScaleFromSetList<E>
        extends Request<E, Pair<E, E>> {
            private final SetList<E> s;

            public InterOrdinalScaleFromSetList(SetList<E> s) {
                super(Type.INTER_ORDINAL, Source.STRINGS);
                this.s = s;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.s, SetLists.disjointUnion(this.s, this.s), BooleanMatrices.apposition(BooleanMatrices.upperDiagonal(this.s.size()), BooleanMatrices.dual(BooleanMatrices.upperDiagonal(this.s.size()))));
            }
        }

        public static final class InterOrdinalScaleFromInt
        extends Request<Integer, Pair<Integer, Integer>> {
            private final int n;

            public InterOrdinalScaleFromInt(int n) {
                super(Type.INTER_ORDINAL, Source.INT_LIST);
                this.n = n;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.integers(this.n), SetLists.disjointUnion(SetLists.integers(this.n), SetLists.integers(this.n)), BooleanMatrices.apposition(BooleanMatrices.upperDiagonal(this.n), BooleanMatrices.dual(BooleanMatrices.upperDiagonal(this.n))));
            }
        }

        public static final class ContraOrdinalScaleFromOrder<E>
        extends Request<E, E> {
            private final MatrixContext<E, E> c;

            public ContraOrdinalScaleFromOrder(MatrixContext<E, E> c) {
                super(Type.CONTRA_ORDINAL, Source.ORDER);
                this.c = c;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.c.rowHeads(), null, BooleanMatrices.complement(BooleanMatrices.dual(this.c.matrix())));
            }
        }

        public static final class ContraOrdinalScaleFromSetList<E>
        extends Request<E, E> {
            private final SetList<E> s;

            public ContraOrdinalScaleFromSetList(SetList<E> s) {
                super(Type.CONTRA_ORDINAL, Source.STRINGS);
                this.s = s;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.s, null, BooleanMatrices.complement(BooleanMatrices.dual(BooleanMatrices.upperDiagonal(this.s.size()))));
            }
        }

        public static final class ContraOrdinalScaleFromInt
        extends Request<Integer, Integer> {
            private final int n;

            public ContraOrdinalScaleFromInt(int n) {
                super(Type.CONTRA_ORDINAL, Source.INT_LIST);
                this.n = n;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.integers(this.n), null, BooleanMatrices.complement(BooleanMatrices.dual(BooleanMatrices.upperDiagonal(this.n))));
            }
        }

        public static final class OrdinalScaleFromSetList<E>
        extends Request<E, E> {
            private final SetList<E> s;

            public OrdinalScaleFromSetList(SetList<E> s) {
                super(Type.ORDINAL, Source.STRINGS);
                this.s = s;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.s, null, BooleanMatrices.upperDiagonal(this.s.size()));
            }
        }

        public static final class OrdinalScaleFromInt
        extends Request<Integer, Integer> {
            private final int n;

            public OrdinalScaleFromInt(int n) {
                super(Type.ORDINAL, Source.INT_LIST);
                this.n = n;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.integers(this.n), null, BooleanMatrices.upperDiagonal(this.n));
            }
        }

        public static final class ContraNominalScaleFromSetList<E>
        extends Request<E, E> {
            private final SetList<E> s;

            public ContraNominalScaleFromSetList(SetList<E> s) {
                super(Type.CONTRA_NOMINAL, Source.STRINGS);
                this.s = s;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.s, null, BooleanMatrices.negativeIdentity(this.s.size()));
            }
        }

        public static final class ContraNominalScaleFromInt
        extends Request<Integer, Integer> {
            private final int n;

            public ContraNominalScaleFromInt(int n) {
                super(Type.CONTRA_NOMINAL, Source.INT_LIST);
                this.n = n;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.integers(this.n), null, BooleanMatrices.negativeIdentity(this.n));
            }
        }

        public static final class NominalScaleFromSetList<E>
        extends Request<E, E> {
            private final SetList<E> s;

            public NominalScaleFromSetList(SetList<E> s) {
                super(Type.NOMINAL, Source.STRINGS);
                this.s = s;
            }

            @Override
            public final void setContent() {
                this.context.setContent(this.s, null, BooleanMatrices.identity(this.s.size()));
            }
        }

        public static final class NominalScaleFromInt
        extends Request<Integer, Integer> {
            private final int n;

            public NominalScaleFromInt(int n) {
                super(Type.NOMINAL, Source.INT_LIST);
                this.n = n;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.integers(this.n), null, BooleanMatrices.identity(this.n));
            }
        }

        public static final class BooleanScaleFromSetList<E>
        extends Request<SetList<E>, SetList<E>> {
            private final SetList<E> s;

            public BooleanScaleFromSetList(SetList<E> s) {
                super(Type.BOOLEAN, Source.STRINGS);
                this.s = s;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.powerSet(this.s), null, BooleanMatrices.booleann(this.s.size()));
            }
        }

        public static final class BooleanScaleFromInt
        extends Request<SetList<Integer>, SetList<Integer>> {
            private final int n;

            public BooleanScaleFromInt(int n) {
                super(Type.BOOLEAN, Source.INT_LIST);
                this.n = n;
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.powerSet(SetLists.integers(this.n)), null, BooleanMatrices.booleann(this.n));
            }
        }

        public static final class DichtomicScale
        extends Request<Boolean, Boolean> {
            public DichtomicScale() {
                super(Type.DICHTOMIC, Source.NULL);
            }

            @Override
            public final void setContent() {
                this.context.setContent(SetLists.create(true, false), null, BooleanMatrices.identity(2L));
            }
        }
    }

    public static final class Import {

        public static final class ImportSPARQLFromRepository
        extends StringRequest {
            private final Repository repo;
            private final String query;

            public ImportSPARQLFromRepository(Repository repo, String query) {
                super(Type.IMPORT_SPARQL_CONTEXT, Source.SPARQL_AND_ONTOLOGYREPOSITORY);
                this.repo = repo;
                this.query = query;
            }

            @Override
            public final void setContent() {
                RDFImporter.importRepository(this.context, this.repo, this.query);
            }
        }

        public static final class ImportSPARQLFromFile
        extends StringRequest {
            private final File file;
            private final String query;

            public ImportSPARQLFromFile(File file, String query) {
                super(Type.IMPORT_SPARQL_CONTEXT, Source.SPARQL_AND_ONTOLOGYFILE);
                this.file = file;
                this.query = query;
            }

            @Override
            public final void setContent() {
                RDFImporter.importFile(this.context, this.file, this.query);
            }
        }

        public static final class ImportSPARQLFromURL
        extends StringRequest {
            private final String url;
            private final String query;

            public ImportSPARQLFromURL(String url, String query) {
                super(Type.IMPORT_SPARQL_CONTEXT, Source.SPARQL_AND_ONTOLOGYURL);
                this.url = url;
                this.query = query;
            }

            @Override
            public final void setContent() {
                RDFImporter.importURL(this.context, this.url, this.query);
            }
        }

        public static final class ImportSPARQLFromEndpoint
        extends StringRequest {
            private final String url;
            private final String query;

            public ImportSPARQLFromEndpoint(String url, String query) {
                super(Type.IMPORT_SPARQL_CONTEXT, Source.SPARQL_AND_XMLURL);
                this.url = url;
                this.query = query;
            }

            @Override
            public final void setContent() {
                RDFImporter.importXML(this.context, this.url, this.query);
            }
        }

        public static final class ImportCEX
        extends StringRequest {
            private final File file;

            public ImportCEX(File file) {
                super(Type.IMPORT_CEX_CONTEXT, Source.FILE);
                this.file = file;
            }

            @Override
            public final void setContent() {
                CEXImporter.importt(this.context, null, this.file);
            }
        }

        public static final class ImportCSVB
        extends FileRequest {
            public ImportCSVB(File file) {
                super(Type.IMPORT_CSV_CONTEXT, file);
            }

            @Override
            public void setContent() {
                try {
                    CSVImporter.importContext(this.file, this.context, ";");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public static final class ImportCXT
        extends FileRequest {
            public ImportCXT(File file) {
                super(Type.IMPORT_CXT_CONTEXT, file);
            }

            @Override
            public final void setContent() throws Exception {
                CXTImporter.read(this.context, this.file);
            }
        }

        public static final class ImportCFX
        extends FileRequest {
            public ImportCFX(File file) {
                super(Type.IMPORT_CFX_CONTEXT, file);
            }

            @Override
            public final void setContent() {
                CFXImporter.importt(this.context, null, this.file);
            }
        }
    }

    public static final class New {

        public static final class NewOrder
        extends StringRequest {
            private final int elements;

            public NewOrder(int elements) {
                super(Type.NEW_ORDER, Source.INT);
                this.elements = elements;
            }

            @Override
            public final void setContent() {
                for (int row = 0; row < this.elements; ++row) {
                    this.context.rowHeads().add("Element " + row);
                }
                this.context.pushAllChangedEvent();
            }
        }

        public static final class NewContext
        extends StringRequest {
            private final int objects;
            private final int attributes;

            public NewContext(int objects, int attributes) {
                super(Type.NEW_CONTEXT, Source.INT_INT);
                this.objects = objects;
                this.attributes = attributes;
            }

            @Override
            public final void setContent() {
                for (int row = 0; row < this.objects; ++row) {
                    this.context.rowHeads().add("Object " + row);
                }
                for (int column = 0; column < this.attributes; ++column) {
                    this.context.colHeads().add("Attribute " + column);
                }
                this.context.pushAllChangedEvent();
            }
        }
    }

    public static enum Source {
        NULL("No source needed"),
        INT_INT("Custom Size"),
        INT("Custom Size"),
        INT_LIST("Create from natural numbers {0, ..., n}"),
        STRINGS("Create from custom set list"),
        ORDER("Create from existing order context"),
        ORDER_ORDER("Create from two existing order contexts"),
        CONTEXT("Create from existing formal context"),
        CONTEXT_CONTEXT("Create from two existing formal contexts"),
        CONTEXT_CONTEXT_CONTEXT_CONTEXT("Create from four existing formal contexts"),
        CONTEXT_SET_SET("TODO"),
        CONTEXT_DOUBLE("Create from existing formal context"),
        CONTEXT_CONTEXT_OBJECT_OBJECT("Create from two existing formal contexts"),
        FILE("Concept Explorer File Import"),
        SPARQL_AND_XMLURL("SPARQL Import from XML Endpoint"),
        SPARQL_AND_ONTOLOGYFILE("SPARQL Import from Ontology File"),
        SPARQL_AND_ONTOLOGYURL("SPARQL Import from Ontology URL"),
        SPARQL_AND_ONTOLOGYREPOSITORY("SPARQL Import from Sesame Repository");

        public final String title;

        private Source(String title) {
            this.title = title;
        }
    }

    public static enum Type {
        NEW_CONTEXT("New Context", "Creates a new empty Formal Context of desired size.", Metatype.NEW, false, Source.INT_INT),
        NEW_ORDER("New Order (experimental)", "Creates a new empty Order Context of desired size.", Metatype.NEW, true, Source.INT),
        IMPORT_CXT_CONTEXT("Local File (Burmeister Format, *.cxt)", "Imports a Formal Context from a *.cxt File.", Metatype.IMPORT, false, Source.FILE),
        IMPORT_CEX_CONTEXT("Local File (Concept Explorer Format, *.cex)", "Imports a Formal Context from a *.cex File.", Metatype.IMPORT, false, Source.FILE),
        IMPORT_CFX_CONTEXT("Local File (Concept Explorer FX Format, *.cfx)", "Imports a Formal Context from a *.cfx File.", Metatype.IMPORT, false, Source.FILE),
        IMPORT_CSV_CONTEXT("Local File (Comma Separated Values, *.csv)", "Imports a Formal Context from a *.csv File.", Metatype.IMPORT, false, Source.FILE),
        IMPORT_SPARQL_CONTEXT("SPARQL Result from an Ontology", "Imports a Formal Context from an Ontology.", Metatype.IMPORT, false, Source.SPARQL_AND_XMLURL, Source.SPARQL_AND_ONTOLOGYFILE, Source.SPARQL_AND_ONTOLOGYURL, Source.SPARQL_AND_ONTOLOGYREPOSITORY),
        DICHTOMIC("Dichtomic Scale", "Creates a new formal context that is the nominal scale of the two boolean values true and false", Metatype.SCALE, true, Source.NULL),
        BOOLEAN("Boolean Scale", "", Metatype.SCALE, true, Source.INT_LIST, Source.STRINGS),
        NOMINAL("Nominal Scale", "", Metatype.SCALE, true, Source.INT_LIST, Source.STRINGS),
        CONTRA_NOMINAL("Contra-Nominal Scale", "", Metatype.SCALE, true, Source.INT_LIST, Source.STRINGS),
        ORDINAL("Ordinal Scale", "", Metatype.SCALE, true, Source.INT_LIST, Source.STRINGS),
        CONTRA_ORDINAL("Contra-Ordinal Scale", "", Metatype.SCALE, true, Source.INT_LIST, Source.STRINGS, Source.ORDER),
        INTER_ORDINAL("Inter-Ordinal Scale", "", Metatype.SCALE, false, Source.INT_LIST, Source.STRINGS, Source.ORDER),
        CONVEX_ORDINAL("Convex-Ordinal Scale", "", Metatype.SCALE, false, Source.INT_LIST, Source.STRINGS, Source.ORDER),
        BI_ORDINAL("Bi-Ordinal Scale", "", Metatype.SCALE, false, Source.ORDER_ORDER),
        GRID("Grid Scale", "", Metatype.SCALE, false, Source.ORDER_ORDER),
        COMPLEMENT("Complement Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT),
        DUAL("Dual Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT),
        CONTRARY("Contrary Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT),
        APPOSITION("Apposition Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT),
        SUBPOSITION("Subposition Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT),
        QUADPOSITION("Juxtaposition Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT_CONTEXT_CONTEXT),
        HORIZONTAL_SUM("Horizontal Sum Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT),
        VERTICAL_SUM("Vertical Sum Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT),
        DIRECT_SUM("Direct Sum Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT),
        DIRECT_PRODUCT("Direct Product Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT),
        BI_PRODUCT("Bi-Product Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT),
        SEMI_PRODUCT("Semi-Product Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT),
        SUBSTITUTION_SUM("Substitution Sum Context", "", Metatype.CONSTRUCT, false, Source.CONTEXT_CONTEXT_OBJECT_OBJECT);

        public final String title;
        public final String description;
        public final Metatype type;
        public final boolean homogen;
        public final List<Source> sources;

        private Type(String title, String description, Metatype type, boolean homogen, Source ... sources) {
            this.title = title;
            this.description = description;
            this.type = type;
            this.homogen = homogen;
            this.sources = Arrays.asList(sources);
        }
    }

    public static enum Metatype {
        NEW("New Context", ""),
        IMPORT("Import Context", ""),
        SCALE("Scale Context", ""),
        CONSTRUCT("Construction Context", "");

        public final String title;
        public final String description;

        private Metatype(String title, String description) {
            this.title = title;
            this.description = description;
        }
    }
}

