/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.math.GuavaIsomorphism;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Collections3 {
    public static final <E> Set<Set<E>> quotient(Set<E> set, BiPredicate<E, E> pred) {
        return set.parallelStream().map(x -> set.parallelStream().filter(y -> pred.test(x, y)).collect(Collectors.toSet())).collect(Collectors.toSet());
    }

    public static final <E> Set<E> representatives(Set<E> set, BiPredicate<E, E> pred) {
        return Collections3.quotient(set, pred).parallelStream().map(eqclass -> eqclass.iterator().next()).collect(Collectors.toSet());
    }

    public static final <E> Set<E> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static final BitSetFX integers(int n) {
        BitSetFX s = new BitSetFX();
        s.addRange(0, n);
        return s;
    }

    public static final <E extends Number> double sum(Collection<? extends E> c) {
        double s = 0.0;
        for (Number e : c) {
            s += e.doubleValue();
        }
        return s;
    }

    public static final <E extends Number> double avg(Collection<? extends E> c) {
        return Collections3.sum(c) / (double)c.size();
    }

    public static final <E> Collection<E> union(final Collection<Collection<E>> c) {
        return new AbstractCollection<E>(){

            @Override
            public final Iterator<E> iterator() {
                return Iterables.concat((Iterable)c).iterator();
            }

            @Override
            public final int size() {
                int size = 0;
                for (Collection _c : c) {
                    size += _c.size();
                }
                return size;
            }
        };
    }

    @SafeVarargs
    public static final <E> Collection<E> union(Collection<E> ... c) {
        return Collections3.union(Arrays.asList(c));
    }

    public static final <E> Collection<E> union(final Collection<? extends E> c1, final Collection<? extends E> c2) {
        return new AbstractCollection<E>(){

            @Override
            public final Iterator<E> iterator() {
                return Iterators.concat(c1.iterator(), c2.iterator());
            }

            @Override
            public final int size() {
                return c1.size() + c2.size();
            }
        };
    }

    public static final <E> Collection<E> intersection(Collection<E> c1, Collection<? extends E> c2) {
        return Collections2.filter(c1, (Predicate)Predicates.in(c2));
    }

    public static final <E> Collection<E> difference(Collection<E> c1, Collection<? extends E> c2) {
        return Collections2.filter(c1, (Predicate)Predicates.not((Predicate)Predicates.in(c2)));
    }

    public static final <T, E> Set<E> transform(final Set<T> s, final GuavaIsomorphism<T, E> f) {
        return new AbstractSet<E>(){

            @Override
            public final Iterator<E> iterator() {
                return Iterators.transform(s.iterator(), (Function)f);
            }

            @Override
            public final int size() {
                return s.size();
            }
        };
    }

    public static final <E> E random(Collection<? extends E> c, Random rng) {
        if (c.isEmpty()) {
            throw new NoSuchElementException();
        }
        int i = rng.nextInt(c.size());
        if (c instanceof List) {
            List l = (List)c;
            return l.get(i);
        }
        int j = 0;
        for (E e : c) {
            if (j++ != i) continue;
            return e;
        }
        throw new NoSuchElementException();
    }

    public static final <E> E random(Collection<? extends E> c, Predicate<E> p, Random rng) {
        E e;
        while (!p.apply(e = Collections3.random(c, rng))) {
        }
        return e;
    }

    public static final <E extends Comparable<E>> List<E> sort(Iterable<? extends E> i) {
        ArrayList l = Lists.newArrayList(i);
        Collections.sort(l);
        return l;
    }

    public static final <E> List<E> sort(Iterable<? extends E> i, Comparator<? super E> c) {
        ArrayList l = Lists.newArrayList(i);
        Collections.sort(l, c);
        return l;
    }

    public static final <E, T extends E> Collection<T> elementsBySubClass(Collection<E> c, final Class<T> clazz) {
        return Collections2.transform((Collection)Collections2.filter(c, (Predicate)Predicates.instanceOf(clazz)), (Function)new Function<E, T>(){

            public final T apply(E e) {
                return clazz.cast(e);
            }
        });
    }

    public static final <E> Function<Set<E>, Iterator<E>> setToIterator() {
        return new Function<Set<E>, Iterator<E>>(){

            public final Iterator<E> apply(Set<E> it) {
                return it.iterator();
            }
        };
    }

    public static final <E> Set<E> fromIterator(final Supplier<Iterator<E>> its) {
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                return (Iterator)its.get();
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    public static final <E> Iterable<E> iterable(final Iterator<E> it) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return it;
            }
        };
    }

    public static final Predicate<Integer> isSmaller(final int n) {
        return new Predicate<Integer>(){

            public final boolean apply(Integer m) {
                return m < n;
            }
        };
    }

    public static final <E> E firstElement(Iterable<E> it) {
        return it.iterator().next();
    }

    public static final <E> Function<Iterable<E>, E> firstElement() {
        return new Function<Iterable<E>, E>(){

            public final E apply(Iterable<E> it) {
                return it.iterator().next();
            }
        };
    }

    public static final <E> List<E> filter(final List<E> l, final Predicate<E> p) {
        return new AbstractList<E>(){

            @Override
            public final E get(int index) {
                return Iterables.get((Iterable)Iterables.filter((Iterable)l, (Predicate)p), (int)index);
            }

            @Override
            public final int size() {
                return Iterables.size((Iterable)Iterables.filter((Iterable)l, (Predicate)p));
            }
        };
    }

    public static final <T> void writeToFile(File file, Collection<T> collection, String prefix, String ... suffix) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.append(prefix);
        writer.append("size: " + collection.size());
        for (T element : collection) {
            writer.append(element.toString());
        }
        if (suffix.length > 0) {
            writer.append(suffix[0]);
        }
        writer.close();
    }
}

