/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;

public final class ConcurrentHashSetMultimap<K, V>
implements SetMultimap<K, V> {
    private final Map<K, Set<V>> map = new ConcurrentHashMap<K, Set<V>>();

    public int size() {
        return this.map.keySet().parallelStream().map(key -> this.map.get(key).size()).reduce(0, Integer::sum);
    }

    public boolean isEmpty() {
        return this.map.values().parallelStream().allMatch(Collection::isEmpty);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key) && !this.map.get(key).isEmpty();
    }

    public boolean containsValue(Object value) {
        return this.map.values().parallelStream().anyMatch(set -> set.contains(value));
    }

    public boolean containsEntry(Object key, Object value) {
        return this.map.containsKey(key) && this.map.get(key).contains(value);
    }

    public boolean put(K key, V value) {
        return this.map.computeIfAbsent(key, __ -> Sets.newConcurrentHashSet()).add(value);
    }

    public boolean remove(Object key, Object value) {
        return this.map.containsKey(key) && this.map.get(key).remove(value);
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        Set set = this.map.computeIfAbsent(key, __ -> Sets.newConcurrentHashSet());
        AtomicBoolean result = new AtomicBoolean(false);
        StreamSupport.stream(values.spliterator(), true).forEach(value -> {
            if (set.add(value)) {
                result.lazySet(true);
            }
        });
        return result.get();
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        AtomicBoolean result = new AtomicBoolean(false);
        multimap.entries().parallelStream().forEach(entry -> {
            if (this.put(entry.getKey(), entry.getValue())) {
                result.lazySet(true);
            }
        });
        return result.get();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Multiset<K> keys() {
        throw new UnsupportedOperationException("Operation is not implemented.");
    }

    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return Iterators.concat(Collections2.transform(ConcurrentHashSetMultimap.this.map.keySet(), key -> ((Set)ConcurrentHashSetMultimap.this.map.get(key)).iterator()).iterator());
            }

            @Override
            public int size() {
                return ConcurrentHashSetMultimap.this.size();
            }
        };
    }

    public Set<V> get(K key) {
        return this.map.get(key);
    }

    public Set<V> removeAll(Object key) {
        return this.map.remove(key);
    }

    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        Set set = this.map.computeIfAbsent(key, __ -> Sets.newConcurrentHashSet());
        StreamSupport.stream(values.spliterator(), true).forEach(value -> set.add(value));
        return set;
    }

    public Set<Map.Entry<K, V>> entries() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return Iterators.concat(Collections2.transform(ConcurrentHashSetMultimap.this.map.keySet(), key -> Iterators.transform(((Set)ConcurrentHashSetMultimap.this.map.get(key)).iterator(), value -> new AbstractMap.SimpleEntry<Object, Object>(key, value))).iterator());
            }

            @Override
            public int size() {
                return ConcurrentHashSetMultimap.this.size();
            }
        };
    }

    public Map<K, Collection<V>> asMap() {
        return Maps.transformValues(this.map, set -> set);
    }
}

