/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Iterator;
import javafx.beans.value.ObservableValue;

public final class GuavaFunctions {
    public static final Function<Iterable<Double>, Double> sum = GuavaFunctions.toGuavaFunction(doubles -> {
        double s = 0.0;
        for (Double d : doubles) {
            s += d.doubleValue();
        }
        return s;
    });
    public static final Function<Iterable<Double>, Double> product = GuavaFunctions.toGuavaFunction(doubles -> {
        double s = 1.0;
        for (Double d : doubles) {
            s *= d.doubleValue();
        }
        return s;
    });

    public static final <X> Predicate<X> toGuavaPredicate(final java.util.function.Predicate<X> p) {
        return new Predicate<X>(){

            public final boolean apply(X x) {
                return p.test(x);
            }
        };
    }

    public static final <X> java.util.function.Predicate<X> toJavaPredicate(Predicate<X> p) {
        return arg_0 -> p.apply(arg_0);
    }

    public static final <X, Y> Function<X, Y> toGuavaFunction(final java.util.function.Function<X, Y> f) {
        return new Function<X, Y>(){

            public final Y apply(X x) {
                return f.apply(x);
            }
        };
    }

    public static final <X, Y> java.util.function.Function<X, Y> toJavaFunction(Function<X, Y> f) {
        return arg_0 -> f.apply(arg_0);
    }

    public static final <T> Function<ObservableValue<T>, T> observableValueToCurrentValueFunction() {
        return GuavaFunctions.toGuavaFunction(ObservableValue::getValue);
    }

    public static final Function<Iterable<Double>, Double> wsum(Iterable<Double> weighs) {
        return GuavaFunctions.toGuavaFunction(doubles -> {
            Iterator weigh = weighs.iterator();
            double s = 0.0;
            for (Double d : doubles) {
                s += (Double)weigh.next() * d;
            }
            return s;
        });
    }

    public static final Function<Iterable<Double>, Double> wproduct(Iterable<Double> weighs) {
        return GuavaFunctions.toGuavaFunction(doubles -> {
            Iterator weigh = weighs.iterator();
            double s = 1.0;
            for (Double d : doubles) {
                s *= Math.pow(d, (Double)weigh.next());
            }
            return s;
        });
    }

    public static final Function<Double, Double> power(double p) {
        return GuavaFunctions.toGuavaFunction(x -> Math.pow(x, p));
    }

    public static final Function<Double, Double> root(double p) {
        return GuavaFunctions.toGuavaFunction(x -> Math.pow(x, 1.0 / p));
    }

    public static final <E> Predicate<Collection<E>> isEmpty() {
        return GuavaFunctions.toGuavaPredicate(Collection::isEmpty);
    }
}

