/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections;

import conexp.fx.core.collections.Pair;
import java.util.Comparator;

public class IntPair
extends Pair<Integer, Integer>
implements Cloneable {
    public static final Comparator<IntPair> CANTORIAN_COMPARATOR = new Comparator<IntPair>(){

        @Override
        public int compare(IntPair o1, IntPair o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            if (IntPair.cantorianSum((Integer)o1.x, (Integer)o1.y) < IntPair.cantorianSum((Integer)o2.x, (Integer)o2.y)) {
                return -1;
            }
            return 1;
        }
    };
    public static final Comparator<IntPair> POSITIVE_CANTORIAN_COMPARATOR = new Comparator<IntPair>(){

        @Override
        public int compare(IntPair o1, IntPair o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            if (IntPair.positiveCantorianSum((Integer)o1.x, (Integer)o1.y) < IntPair.positiveCantorianSum((Integer)o2.x, (Integer)o2.y)) {
                return -1;
            }
            return 1;
        }
    };

    public static final IntPair valueOf(int x, int y) {
        return new IntPair(x, y);
    }

    public static final IntPair zero() {
        return new IntPair();
    }

    public static final int cantorianSum(int m, int n) {
        int shift = 0;
        if (m < 0) {
            ++shift;
        }
        if (n < 0) {
            shift += 2;
        }
        return 4 * IntPair.positiveCantorianSum(Math.abs(m), Math.abs(n)) + shift;
    }

    public static final int positiveCantorianSum(int m, int n) {
        if (m < 0 || n < 0) {
            throw new RuntimeException("positive cantorian sum can only be calculated for positive integers!");
        }
        return m + (m + n + 1) * (m + n + 2) / 2;
    }

    public static final IntPair findPositiveCantorianSum(int sum) {
        int m = sum;
        for (int n = 0; n < Integer.MAX_VALUE; ++n) {
            if (IntPair.positiveCantorianSum(m, n) != sum) continue;
            return IntPair.valueOf(m, n);
        }
        return null;
    }

    public IntPair(int x, int y) {
        super(x, y);
    }

    public IntPair() {
        super(0, 0);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IntPair)) {
            return false;
        }
        IntPair other = (IntPair)object;
        return other.x() == this.x() && other.y() == this.y();
    }

    @Override
    public int hashCode() {
        return IntPair.cantorianSum((Integer)this.x(), (Integer)this.y());
    }

    public final IntPair clone() {
        return new IntPair((Integer)this.x(), (Integer)this.y());
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final void set(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public final void set(IntPair coordinates) {
        this.set((Integer)coordinates.x(), (Integer)coordinates.y());
    }

    public final IntPair negate() {
        this.setX(-((Integer)this.x()).intValue());
        this.setY(-((Integer)this.y()).intValue());
        return this;
    }

    public final IntPair add(int x, int y) {
        IntPair intPair = this;
        intPair.x = (Integer)intPair.x + Integer.valueOf(x);
        intPair = this;
        intPair.y = (Integer)intPair.y + Integer.valueOf(y);
        return this;
    }

    public final IntPair add(IntPair coordinates) {
        this.add((Integer)coordinates.x(), (Integer)coordinates.y());
        return this;
    }

    public final IntPair subtract(int x, int y) {
        IntPair intPair = this;
        intPair.x = (Integer)intPair.x - Integer.valueOf(x);
        intPair = this;
        intPair.y = (Integer)intPair.y - Integer.valueOf(y);
        return this;
    }

    public final IntPair subtract(IntPair coordinates) {
        this.subtract((Integer)coordinates.x(), (Integer)coordinates.y());
        return this;
    }

    public final IntPair delta(int x, int y) {
        return new IntPair(x, y).minus(this);
    }

    public final IntPair delta(IntPair coordinates) {
        return coordinates.clone().minus(this);
    }

    public final IntPair plus(int x, int y) {
        return this.clone().add(x, y);
    }

    public final IntPair plus(IntPair coordinates) {
        return this.clone().add(coordinates);
    }

    public final IntPair minus(int x, int y) {
        return this.clone().subtract(x, y);
    }

    public final IntPair minus(IntPair coordinates) {
        return this.clone().subtract(coordinates);
    }

    public final IntPair negative() {
        return this.clone().negate();
    }
}

