/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.SimpleListIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class ListIterators {
    public static final <E> ListIterator<E> empty() {
        return new UnmodifiableListIterator<E>(){

            public final boolean hasNext() {
                return false;
            }

            public final E next() {
                return null;
            }

            public final boolean hasPrevious() {
                return false;
            }

            public final E previous() {
                return null;
            }

            public final int nextIndex() {
                return 0;
            }

            public final int previousIndex() {
                return -1;
            }
        };
    }

    public static final ListIterator<Integer> integers(int size) {
        return ListIterators.integers(0, size);
    }

    public static final ListIterator<Integer> integers(final int i, final int size) {
        return new UnmodifiableListIterator<Integer>(){
            private int j;
            {
                this.j = i - 1;
            }

            public final synchronized boolean hasNext() {
                return this.j < size - 1;
            }

            public final synchronized Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ++this.j;
            }

            public final boolean hasPrevious() {
                return this.j > -1;
            }

            public final Integer previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.j--;
            }

            public final synchronized int nextIndex() {
                return this.j + 1;
            }

            public final int previousIndex() {
                return this.j;
            }
        };
    }

    public static final <E> UnmodifiableListIterator<E> unmodifiable(final ListIterator<E> it) {
        if (it instanceof UnmodifiableListIterator) {
            return (UnmodifiableListIterator)it;
        }
        return new UnmodifiableListIterator<E>(){

            public final boolean hasNext() {
                return it.hasNext();
            }

            public final E next() {
                return it.next();
            }

            public final boolean hasPrevious() {
                return it.hasPrevious();
            }

            public final E previous() {
                return it.previous();
            }

            public final int nextIndex() {
                return it.nextIndex();
            }

            public final int previousIndex() {
                return it.previousIndex();
            }
        };
    }

    public static final <T, E> ListIterator<E> transform(final ListIterator<? extends T> it, final Function<? super T, E> f) {
        return new UnmodifiableListIterator<E>(){

            public final boolean hasNext() {
                return it.hasNext();
            }

            public final E next() {
                return f.apply(it.next());
            }

            public final boolean hasPrevious() {
                return it.hasPrevious();
            }

            public final E previous() {
                return f.apply(it.previous());
            }

            public final int nextIndex() {
                return it.nextIndex();
            }

            public final int previousIndex() {
                return it.previousIndex();
            }
        };
    }

    public static final <E> ListIterator<E> filter(ListIterator<? extends E> it, Predicate<? super E> p) {
        return ListIterators.filter(it, p, 0);
    }

    public static final <E> ListIterator<E> filter(final ListIterator<? extends E> it, final Predicate<? super E> p, int i) {
        return new SimpleListIterator<E>(i){

            @Override
            protected final E createNext() {
                while (it.hasNext()) {
                    Object next = it.next();
                    if (!p.apply(next)) continue;
                    return next;
                }
                return null;
            }

            @Override
            protected final E createPrevious() {
                while (it.hasPrevious()) {
                    Object prev = it.previous();
                    if (!p.apply(prev)) continue;
                    return prev;
                }
                return null;
            }
        };
    }

    public static final <E> ListIterator<E> concat(final ListIterator<? extends E> it1, final ListIterator<? extends E> it2, int i) {
        return new SimpleListIterator<E>(i){

            @Override
            protected final E createNext() {
                if (it1.hasNext()) {
                    return it1.next();
                }
                if (it2.hasNext()) {
                    return it2.next();
                }
                return null;
            }

            @Override
            protected final E createPrevious() {
                if (it2.hasPrevious()) {
                    return it2.previous();
                }
                if (it1.hasPrevious()) {
                    return it1.previous();
                }
                return null;
            }
        };
    }

    public static final <T, E> ListIterator<Pair<T, E>> disjointUnion(final ListIterator<T> it1, final ListIterator<E> it2, int i) {
        return new SimpleListIterator<Pair<T, E>>(i){

            @Override
            protected final Pair<T, E> createNext() {
                if (it1.hasNext()) {
                    return new Pair(it1.next(), null);
                }
                if (it2.hasNext()) {
                    return new Pair(null, it2.next());
                }
                return null;
            }

            @Override
            protected final Pair<T, E> createPrevious() {
                if (it2.hasPrevious()) {
                    return new Pair(null, it2.previous());
                }
                if (it1.hasPrevious()) {
                    return new Pair(it1.previous(), null);
                }
                return null;
            }
        };
    }

    public static final <T, E> ListIterator<Pair<T, E>> cartesianProduct(final ListIterator<T> it1, final ListIterator<E> it2, final int i) {
        return new SimpleListIterator<Pair<T, E>>(true){
            private T t;
            {
                super(dontCreateFirst);
                this.t = it1.hasNext() ? it1.next() : null;
                this.createFirst(i);
            }

            @Override
            protected final Pair<T, E> createNext() {
                if (this.t != null && it2.hasNext()) {
                    return new Pair(this.t, it2.next());
                }
                if (it1.hasNext()) {
                    this.t = it1.next();
                    while (it2.hasPrevious()) {
                        it2.previous();
                    }
                    if (it2.hasNext()) {
                        return new Pair(this.t, it2.next());
                    }
                }
                return null;
            }

            @Override
            protected final Pair<T, E> createPrevious() {
                if (this.t != null && it2.hasPrevious()) {
                    return new Pair(this.t, it2.previous());
                }
                if (it1.hasPrevious()) {
                    this.t = it1.previous();
                    while (it2.hasNext()) {
                        it2.next();
                    }
                    if (it2.hasPrevious()) {
                        return new Pair(this.t, it2.previous());
                    }
                }
                return null;
            }
        };
    }

    public static final <E> Iterable<Pair<E, E>> upperCartesianDiagonal(final Iterable<E> it) {
        return new Iterable<Pair<E, E>>(){

            @Override
            public final Iterator<Pair<E, E>> iterator() {
                if (!it.iterator().hasNext()) {
                    return ListIterators.empty();
                }
                return new UnmodifiableIterator<Pair<E, E>>(){
                    private final Iterator<E> it1;
                    private Iterator<E> it2;
                    private E e1;
                    private int skip2;
                    {
                        this.it1 = it.iterator();
                        this.it2 = it.iterator();
                        this.e1 = this.it1.next();
                        this.skip2 = 0;
                    }

                    public final boolean hasNext() {
                        return this.e1 != null;
                    }

                    public final Pair<E, E> next() {
                        if (!this.it2.hasNext()) {
                            this.e1 = this.it1.next();
                            this.it2 = it.iterator();
                            ++this.skip2;
                            for (int i = 0; i < this.skip2; ++i) {
                                this.it2.next();
                            }
                        }
                        Pair p = Pair.of(this.e1, this.it2.next());
                        if (!this.it2.hasNext() && !this.it1.hasNext()) {
                            this.e1 = null;
                        }
                        return p;
                    }
                };
            }
        };
    }

    public static final <E> Iterable<Pair<E, E>> upperCartesianDiagonalStrict(final Iterable<E> it) {
        return new Iterable<Pair<E, E>>(){

            @Override
            public final Iterator<Pair<E, E>> iterator() {
                Iterator _it = it.iterator();
                if (!_it.hasNext()) {
                    return ListIterators.empty();
                }
                _it.next();
                if (!_it.hasNext()) {
                    return ListIterators.empty();
                }
                return new UnmodifiableIterator<Pair<E, E>>(){
                    private final Iterator<E> it1;
                    private Iterator<E> it2;
                    private E e1;
                    private int skip2;
                    {
                        this.it1 = it.iterator();
                        this.it2 = it.iterator();
                        this.e1 = this.it1.next();
                        this.skip2 = 1;
                        this.it2.next();
                    }

                    public final boolean hasNext() {
                        return this.e1 != null;
                    }

                    public final Pair<E, E> next() {
                        Pair p = Pair.of(this.e1, this.it2.next());
                        if (!this.it2.hasNext()) {
                            if (this.it1.hasNext()) {
                                this.e1 = this.it1.next();
                                if (!this.it1.hasNext()) {
                                    this.e1 = null;
                                } else {
                                    this.it2 = it.iterator();
                                    ++this.skip2;
                                    for (int i = 0; i < this.skip2; ++i) {
                                        this.it2.next();
                                    }
                                }
                            } else {
                                this.e1 = null;
                            }
                        }
                        return p;
                    }
                };
            }
        };
    }
}

