/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections.relation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.ListIterators;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.relation.AbstractRelation;
import conexp.fx.core.collections.relation.Relation;
import conexp.fx.core.collections.relation.RelationEvent;
import conexp.fx.core.collections.relation.RelationEventHandler;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.collections.setlist.SetLists;
import conexp.fx.core.math.BooleanMatrices;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.ujmp.core.Matrix;
import org.ujmp.core.booleanmatrix.BooleanMatrix;
import org.ujmp.core.booleanmatrix.BooleanMatrix2D;
import org.ujmp.core.calculation.Calculation;

public class MatrixRelation<R, C>
extends AbstractRelation<R, C> {
    protected BooleanMatrix matrix;
    private final Map<RelationEvent.Type, List<RelationEventHandler<R, C>>> eventHandlers = new ConcurrentHashMap<RelationEvent.Type, List<RelationEventHandler<R, C>>>();

    public MatrixRelation(boolean homogen) {
        this(SetLists.empty(), SetLists.empty(), (BooleanMatrix)BooleanMatrix2D.Factory.zeros(0L, 0L), homogen);
    }

    public MatrixRelation(SetList<R> rowHeads, SetList<C> colHeads, boolean homogen) {
        this(rowHeads, colHeads, (BooleanMatrix)BooleanMatrix2D.Factory.zeros((long)rowHeads.size(), (long)colHeads.size()), homogen);
    }

    public MatrixRelation(SetList<R> rowHeads, SetList<C> colHeads, BooleanMatrix matrix, boolean homogen) {
        super(homogen);
        if (homogen) {
            if (!rowHeads.equals(colHeads)) {
                throw new Relation.NoHomogenRelationException();
            }
            this.colHeads = this.rowHeads = new Heads(rowHeads);
        } else {
            this.rowHeads = new RowHeads(rowHeads);
            this.colHeads = new ColHeads(colHeads);
        }
        this.matrix = matrix;
    }

    @Override
    public final boolean add(R row, C col) {
        int j;
        boolean changed;
        int i;
        if (this.rowHeads.add(row)) {
            i = this.rowHeads.size() - 1;
            changed = true;
        } else {
            i = this.rowHeads.indexOf(row);
            changed = false;
        }
        if (this.colHeads.add(col)) {
            j = this.colHeads.size() - 1;
            changed = true;
        } else {
            j = this.colHeads.indexOf(col);
        }
        if (changed || !this.matrix.getBoolean(new long[]{i, j})) {
            this.matrix.setBoolean(true, new long[]{i, j});
            this.push(new RelationEvent<R, C>(RelationEvent.ENTRIES_ADDED, null, null, Collections.singleton(new Pair<R, C>(row, col))));
            return true;
        }
        return false;
    }

    @Override
    public boolean addFast(Object o1, Object o2) {
        int i = this.rowHeads.indexOf(o1);
        int j = this.colHeads.indexOf(o2);
        if (!this.matrix.getBoolean(new long[]{i, j})) {
            this.matrix.setBoolean(true, new long[]{i, j});
            this.push(new RelationEvent(RelationEvent.ENTRIES_ADDED, null, null, Collections.singleton(new Pair<Object, Object>(o1, o2))));
            return true;
        }
        return false;
    }

    public void addFastSilent(Object o1, Object o2) {
        int i = this.rowHeads.indexOf(o1);
        int j = this.colHeads.indexOf(o2);
        this.matrix.setBoolean(true, new long[]{i, j});
    }

    @Override
    public final boolean addAll(Relation<? extends R, ? extends C> r) {
        boolean changed = false;
        if (r instanceof MatrixRelation) {
            MatrixRelation _r = (MatrixRelation)r;
            this.rowHeads.addAll(_r.rowHeads);
            this.colHeads.addAll(_r.colHeads);
            this.matrix.selectRows(Calculation.Ret.LINK, this.rowHeads.indicesOf(_r.rowHeads, true)).selectColumns(Calculation.Ret.LINK, this.colHeads.indicesOf(_r.colHeads, true)).or(Calculation.Ret.ORIG, (Matrix)_r.matrix);
            changed = true;
            this.push(new RelationEvent(RelationEvent.ALL_CHANGED, null, null, null));
        } else {
            for (Pair pair : r) {
                changed |= this.add(pair.x(), pair.y());
            }
        }
        return changed;
    }

    @Override
    public final boolean addAllFast(Relation<?, ?> r) {
        boolean changed = false;
        if (r instanceof MatrixRelation) {
            MatrixRelation _r = (MatrixRelation)r;
            this.matrix.selectRows(Calculation.Ret.LINK, this.rowHeads.indicesOf(_r.rowHeads, false)).selectColumns(Calculation.Ret.LINK, this.colHeads.indicesOf(_r.colHeads, false)).or(Calculation.Ret.ORIG, _r.matrix.selectRows(Calculation.Ret.LINK, _r.rowHeads.indicesOf(this.rowHeads, false)).selectColumns(Calculation.Ret.LINK, _r.colHeads.indicesOf(this.colHeads, false)));
            this.push(new RelationEvent(RelationEvent.ALL_CHANGED, null, null, null));
            changed = true;
        } else {
            for (Pair pair : r) {
                changed |= this.addFast(pair.x(), pair.y());
            }
        }
        return changed;
    }

    @Override
    public boolean remove(Object o1, Object o2) {
        int j;
        int i = this.rowHeads.indexOf(o1);
        if (i != -1 && (j = this.colHeads.indexOf(o2)) != -1 && this.matrix.getBoolean(new long[]{i, j})) {
            this.matrix.setBoolean(false, new long[]{i, j});
            this.push(new RelationEvent(RelationEvent.ENTRIES_REMOVED, null, null, Collections.singleton(new Pair<Object, Object>(o1, o2))));
            return true;
        }
        return false;
    }

    @Override
    public final boolean removeAll(Relation<?, ?> r) {
        boolean changed = false;
        if (r instanceof MatrixRelation) {
            MatrixRelation _r = (MatrixRelation)r;
            this.matrix.selectRows(Calculation.Ret.LINK, this.rowHeads.indicesOf(_r.rowHeads, false)).selectColumns(Calculation.Ret.LINK, this.colHeads.indicesOf(_r.colHeads, false)).and(Calculation.Ret.ORIG, _r.matrix.selectRows(Calculation.Ret.LINK, _r.rowHeads.indicesOf(this.rowHeads, false)).selectColumns(Calculation.Ret.LINK, _r.colHeads.indicesOf(this.colHeads, false)).not(Calculation.Ret.LINK));
            this.push(new RelationEvent(RelationEvent.ALL_CHANGED, null, null, null));
            changed = true;
        } else {
            for (Pair pair : r) {
                changed |= this.remove(pair.x(), pair.y());
            }
        }
        return changed;
    }

    @Override
    public final boolean retainAll(Relation<?, ?> r) {
        boolean changed = false;
        if (r instanceof MatrixRelation) {
            MatrixRelation _r = (MatrixRelation)r;
            Collection<Integer> i = this.rowHeads.indicesOf(_r.rowHeads, false);
            Collection<Integer> j = this.colHeads.indicesOf(_r.colHeads, false);
            Collection i0 = Collections2.filter(SetLists.integers(this.rowHeads.size()), (Predicate)Predicates.not((Predicate)Predicates.in(i)));
            Collection j0 = Collections2.filter(SetLists.integers(this.colHeads.size()), (Predicate)Predicates.not((Predicate)Predicates.in(j)));
            this.matrix.selectRows(Calculation.Ret.LINK, i0).selectColumns(Calculation.Ret.LINK, j0).and(Calculation.Ret.ORIG, false);
            this.matrix.selectRows(Calculation.Ret.LINK, i0).selectColumns(Calculation.Ret.LINK, j).and(Calculation.Ret.ORIG, false);
            this.matrix.selectRows(Calculation.Ret.LINK, i).selectColumns(Calculation.Ret.LINK, j0).and(Calculation.Ret.ORIG, false);
            this.matrix.selectRows(Calculation.Ret.LINK, i).selectColumns(Calculation.Ret.LINK, j).and(Calculation.Ret.ORIG, _r.matrix.selectRows(Calculation.Ret.LINK, _r.rowHeads.indicesOf(this.rowHeads, false)).selectColumns(Calculation.Ret.LINK, _r.colHeads.indicesOf(this.colHeads, false)));
            this.push(new RelationEvent(RelationEvent.ALL_CHANGED, null, null, null));
            changed = true;
        } else {
            for (Object col : this.colHeads) {
                Set<R> column = this.col(col);
                if (r.colHeads().contains(col)) {
                    changed |= column.retainAll(r.col(col));
                    continue;
                }
                changed |= !column.isEmpty();
                column.clear();
            }
        }
        return changed;
    }

    @Override
    public final boolean contains(Object o1, Object o2) {
        int i = this.rowHeads.indexOf(o1);
        if (i == -1) {
            return false;
        }
        int j = this.colHeads.indexOf(o2);
        return j != -1 && this.matrix.getBoolean(new long[]{i, j});
    }

    @Override
    public final boolean containsAll(Relation<?, ?> r) {
        if (this.rowHeads.containsAll(r.rowHeads()) && this.colHeads.containsAll(r.colHeads())) {
            if (r instanceof MatrixRelation) {
                MatrixRelation _r = (MatrixRelation)r;
                return this.matrix.selectRows(Calculation.Ret.LINK, this.rowHeads.indicesOf(_r.rowHeads, true)).selectColumns(Calculation.Ret.LINK, this.colHeads.indicesOf(_r.colHeads, true)).equals(_r.matrix);
            }
            for (Pair pair : r) {
                if (this.contains(pair.x(), pair.y())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final Set<C> row(final Object o) {
        return new AbstractSet<C>(){
            private final int i;
            {
                this.i = MatrixRelation.this.rowHeads.indexOf(o);
            }

            @Override
            public final boolean add(C col) {
                int j = MatrixRelation.this.colHeads.indexOf(col);
                if (MatrixRelation.this.matrix.getBoolean(new long[]{this.i, j})) {
                    return false;
                }
                MatrixRelation.this.matrix.setBoolean(true, new long[]{this.i, j});
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_ADDED, null, null, Collections.singleton(new Pair(o, col))));
                return true;
            }

            @Override
            public final boolean addAll(Collection<? extends C> c) {
                boolean changed = false;
                HashSet changes = new HashSet(Collections3.difference(c, this));
                for (Object col : c) {
                    int j = MatrixRelation.this.colHeads.indexOf(col);
                    if (MatrixRelation.this.matrix.getBoolean(new long[]{this.i, j})) continue;
                    MatrixRelation.this.matrix.setBoolean(true, new long[]{this.i, j});
                    changed = true;
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_ADDED, null, null, new HashSet(Collections2.transform(changes, (Function)new Function<C, Pair<R, C>>(){

                        public final Pair<R, C> apply(C col) {
                            return new Pair(o, col);
                        }
                    }))));
                }
                return changed;
            }

            @Override
            public final boolean contains(Object o2) {
                return MatrixRelation.this.matrix.getBoolean(new long[]{this.i, MatrixRelation.this.colHeads.indexOf(o2)});
            }

            @Override
            public final boolean remove(Object o2) {
                int j = MatrixRelation.this.colHeads.indexOf(o2);
                if (!MatrixRelation.this.matrix.getBoolean(new long[]{this.i, j})) {
                    return false;
                }
                MatrixRelation.this.matrix.setBoolean(false, new long[]{this.i, j});
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_REMOVED, null, null, Collections.singleton(new Pair<Object, Object>(o, o2))));
                return true;
            }

            @Override
            public final boolean removeAll(Collection<?> c) {
                boolean changed = false;
                HashSet changes = new HashSet();
                for (Object col : this) {
                    if (!c.contains(col)) continue;
                    changes.add(col);
                }
                for (Object o2 : c) {
                    int j = MatrixRelation.this.colHeads.indexOf(o2);
                    if (!MatrixRelation.this.matrix.getBoolean(new long[]{this.i, j})) continue;
                    MatrixRelation.this.matrix.setBoolean(false, new long[]{this.i, j});
                    changed = true;
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_REMOVED, null, null, new HashSet(Collections2.transform(changes, (Function)new Function<C, Pair<R, C>>(){

                        public final Pair<R, C> apply(C col) {
                            return new Pair(o, col);
                        }
                    }))));
                }
                return changed;
            }

            @Override
            public final boolean retainAll(Collection<?> c) {
                boolean changed = false;
                HashSet changes = new HashSet();
                for (Object col : this) {
                    if (c.contains(col)) continue;
                    changes.add(col);
                }
                for (Object o2 : Collections2.filter((Collection)MatrixRelation.this.colHeads, (Predicate)Predicates.not((Predicate)Predicates.in(c)))) {
                    int j = MatrixRelation.this.colHeads.indexOf(o2);
                    if (!MatrixRelation.this.matrix.getBoolean(new long[]{this.i, j})) continue;
                    MatrixRelation.this.matrix.setBoolean(false, new long[]{this.i, j});
                    changed = true;
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_REMOVED, null, null, new HashSet(Collections2.transform(changes, (Function)new Function<C, Pair<R, C>>(){

                        public final Pair<R, C> apply(C col) {
                            return new Pair(o, col);
                        }
                    }))));
                }
                return changed;
            }

            @Override
            public final void clear() {
                for (int j = 0; j < MatrixRelation.this.colHeads.size(); ++j) {
                    MatrixRelation.this.matrix.setBoolean(false, new long[]{this.i, j});
                }
            }

            @Override
            public final Iterator<C> iterator() {
                return Iterators.transform((Iterator)Iterators.filter(ListIterators.integers(0, MatrixRelation.this.colHeads.size()), (Predicate)new Predicate<Integer>(){

                    public final boolean apply(Integer j) {
                        return MatrixRelation.this.matrix.getBoolean(new long[]{i, j.intValue()});
                    }
                }), (Function)new Function<Integer, C>(){

                    public final C apply(Integer j) {
                        return MatrixRelation.this.colHeads.get(j);
                    }
                });
            }

            @Override
            public final int size() {
                int size = 0;
                if (this.i != -1) {
                    for (int j = 0; j < MatrixRelation.this.colHeads.size(); ++j) {
                        if (!MatrixRelation.this.matrix.getBoolean(new long[]{this.i, j})) continue;
                        ++size;
                    }
                }
                return size;
            }

            public final HashSet<C> clone() {
                return new HashSet(this);
            }
        };
    }

    @Override
    public final Set<R> col(final Object o) {
        return new AbstractSet<R>(){
            private final int j;
            {
                this.j = MatrixRelation.this.colHeads.indexOf(o);
            }

            @Override
            public final boolean add(R row) {
                int i = MatrixRelation.this.rowHeads.indexOf(row);
                if (MatrixRelation.this.matrix.getBoolean(new long[]{i, this.j})) {
                    return false;
                }
                MatrixRelation.this.matrix.setBoolean(true, new long[]{i, this.j});
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_ADDED, null, null, Collections.singleton(new Pair(row, o))));
                return true;
            }

            @Override
            public final boolean addAll(Collection<? extends R> c) {
                boolean changed = false;
                HashSet changes = new HashSet(Collections3.difference(c, this));
                for (Object row : c) {
                    int i = MatrixRelation.this.rowHeads.indexOf(row);
                    if (MatrixRelation.this.matrix.getBoolean(new long[]{i, this.j})) continue;
                    MatrixRelation.this.matrix.setBoolean(true, new long[]{i, this.j});
                    changed = true;
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_ADDED, null, null, new HashSet(Collections2.transform(changes, (Function)new Function<R, Pair<R, C>>(){

                        public final Pair<R, C> apply(R row) {
                            return new Pair(row, o);
                        }
                    }))));
                }
                return changed;
            }

            @Override
            public final boolean contains(Object o1) {
                return MatrixRelation.this.matrix.getBoolean(new long[]{MatrixRelation.this.rowHeads.indexOf(o1), this.j});
            }

            @Override
            public final boolean remove(Object o1) {
                int i = MatrixRelation.this.rowHeads.indexOf(o1);
                if (!MatrixRelation.this.matrix.getBoolean(new long[]{i, this.j})) {
                    return false;
                }
                MatrixRelation.this.matrix.setBoolean(false, new long[]{i, this.j});
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_REMOVED, null, null, Collections.singleton(new Pair<Object, Object>(o1, o))));
                return true;
            }

            @Override
            public final boolean removeAll(Collection<?> c) {
                boolean changed = false;
                HashSet changes = new HashSet();
                for (Object row : this) {
                    if (!c.contains(row)) continue;
                    changes.add(row);
                }
                for (Object o1 : c) {
                    int i = MatrixRelation.this.rowHeads.indexOf(o1);
                    if (!MatrixRelation.this.matrix.getBoolean(new long[]{i, this.j})) continue;
                    MatrixRelation.this.matrix.setBoolean(false, new long[]{i, this.j});
                    changed = true;
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_REMOVED, null, null, new HashSet(Collections2.transform(changes, (Function)new Function<R, Pair<R, C>>(){

                        public final Pair<R, C> apply(R row) {
                            return new Pair(row, o);
                        }
                    }))));
                }
                return changed;
            }

            @Override
            public final boolean retainAll(Collection<?> c) {
                boolean changed = false;
                HashSet changes = new HashSet();
                for (Object row : this) {
                    if (c.contains(row)) continue;
                    changes.add(row);
                }
                for (Object o1 : Collections2.filter((Collection)MatrixRelation.this.rowHeads, (Predicate)Predicates.not((Predicate)Predicates.in(c)))) {
                    int i = MatrixRelation.this.rowHeads.indexOf(o1);
                    if (!MatrixRelation.this.matrix.getBoolean(new long[]{i, this.j})) continue;
                    MatrixRelation.this.matrix.setBoolean(false, new long[]{i, this.j});
                    changed = true;
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.ENTRIES_REMOVED, null, null, new HashSet(Collections2.transform(changes, (Function)new Function<R, Pair<R, C>>(){

                        public final Pair<R, C> apply(R row) {
                            return new Pair(row, o);
                        }
                    }))));
                }
                return changed;
            }

            @Override
            public final void clear() {
                for (int i = 0; i < MatrixRelation.this.rowHeads.size(); ++i) {
                    MatrixRelation.this.matrix.setBoolean(false, new long[]{i, this.j});
                }
            }

            @Override
            public final Iterator<R> iterator() {
                return Iterators.transform((Iterator)Iterators.filter(ListIterators.integers(0, MatrixRelation.this.rowHeads.size()), (Predicate)new Predicate<Integer>(){

                    public final boolean apply(Integer i) {
                        return MatrixRelation.this.matrix.getBoolean(new long[]{i.intValue(), j});
                    }
                }), (Function)new Function<Integer, R>(){

                    public final R apply(Integer i) {
                        return MatrixRelation.this.rowHeads.get(i);
                    }
                });
            }

            @Override
            public final int size() {
                int size = 0;
                if (this.j != -1) {
                    for (int i = 0; i < MatrixRelation.this.rowHeads.size(); ++i) {
                        if (!MatrixRelation.this.matrix.getBoolean(new long[]{i, this.j})) continue;
                        ++size;
                    }
                }
                return size;
            }

            public final HashSet<R> clone() {
                return new HashSet(this);
            }
        };
    }

    @Override
    public final Set<C> rowAnd(Collection<?> c) {
        if (this.rowHeads().size() == 0 || this.colHeads().size() == 0) {
            return new HashSet(this.colHeads());
        }
        return this.colHeads().parallelStream().filter(col -> c.parallelStream().allMatch(row -> this.contains(row, col))).collect(Collectors.toSet());
    }

    @Override
    public final Set<R> colAnd(Collection<?> c) {
        if (this.rowHeads().size() == 0 || this.colHeads().size() == 0) {
            return new HashSet(this.rowHeads());
        }
        return this.rowHeads().parallelStream().filter(row -> c.parallelStream().allMatch(col -> this.contains(row, col))).collect(Collectors.toSet());
    }

    public final void _add(int i, int j) {
        this.matrix.setBoolean(true, new long[]{i, j});
        this.push(new RelationEvent(RelationEvent.ENTRIES_ADDED, null, null, Collections.singleton(new Pair(this.rowHeads().get(i), this.colHeads().get(j)))));
    }

    public final void _remove(int i, int j) {
        this.matrix.setBoolean(false, new long[]{i, j});
    }

    public final void _flip(int i, int j) {
        this.matrix.setBoolean(this.matrix.getBoolean(new long[]{i, j}), new long[]{i, j});
    }

    public final boolean _contains(int i, int j) {
        return this.matrix.getBoolean(new long[]{i, j});
    }

    public final Collection<Integer> _row(int i) {
        return this._row(i, SetLists.integers(this.colHeads.size()));
    }

    public final Collection<Integer> _col(int j) {
        return this._col(j, SetLists.integers(this.rowHeads.size()));
    }

    public final Collection<Integer> _row(int i, Collection<Integer> js) {
        BitSetFX _row = new BitSetFX();
        for (int j : js) {
            if (!this.matrix.getBoolean(new long[]{i, j})) continue;
            _row.set(j);
        }
        return _row;
    }

    public final Collection<Integer> _col(int j, Collection<Integer> is) {
        BitSetFX _col = new BitSetFX();
        for (int i : is) {
            if (!this.matrix.getBoolean(new long[]{i, j})) continue;
            _col.set(i);
        }
        return _col;
    }

    public final Collection<Integer> _rowAnd(int ... i) {
        if (i.length == 1) {
            return this._row(i[0]);
        }
        return this._rowAnd(Ints.asList((int[])i));
    }

    public final Collection<Integer> _colAnd(int ... j) {
        if (j.length == 1) {
            return this._col(j[0]);
        }
        return this._colAnd(Ints.asList((int[])j));
    }

    public final synchronized BitSetFX _rowAnd(Iterable<Integer> i) {
        if (this.rowHeads().size() == 0 || this.colHeads().size() == 0) {
            return Collections3.integers(this.colHeads.size());
        }
        BooleanMatrix rowAnd = BooleanMatrices.andRow(this.matrix, i);
        BitSetFX _rowAnd = new BitSetFX();
        for (int j = 0; j < this.colHeads.size(); ++j) {
            if (!rowAnd.getBoolean(new long[]{0L, j})) continue;
            _rowAnd.add(j);
        }
        return _rowAnd;
    }

    public final synchronized BitSetFX _colAnd(Iterable<Integer> j) {
        if (this.rowHeads().size() == 0 || this.colHeads().size() == 0) {
            return Collections3.integers(this.rowHeads().size());
        }
        BooleanMatrix colAnd = BooleanMatrices.andCol(this.matrix, j);
        BitSetFX _colAnd = new BitSetFX();
        for (int i = 0; i < this.rowHeads.size(); ++i) {
            if (!colAnd.getBoolean(new long[]{i, 0L})) continue;
            _colAnd.add(i);
        }
        return _colAnd;
    }

    public final BitSetFX _rowAnd(Iterable<Integer> i, Collection<Integer> j) {
        if (this.rowHeads().size() == 0 || this.colHeads().size() == 0) {
            return Collections3.integers(this.colHeads.size());
        }
        BooleanMatrix rowAnd = BooleanMatrices.andRow(this.matrix, i);
        return j.parallelStream().filter(_j -> rowAnd.getBoolean(new long[]{0L, _j.intValue()})).collect(BitSetFX::new, BitSetFX::add, BitSetFX::addAll);
    }

    public final BitSetFX _colAnd(Iterable<Integer> j, Collection<Integer> i) {
        if (this.rowHeads().size() == 0 || this.colHeads().size() == 0) {
            return Collections3.integers(this.rowHeads().size());
        }
        BooleanMatrix colAnd = BooleanMatrices.andCol(this.matrix, j);
        return i.parallelStream().filter(_i -> colAnd.getBoolean(new long[]{_i.intValue(), 0L})).collect(BitSetFX::new, BitSetFX::add, BitSetFX::addAll);
    }

    @Override
    public final void empty() {
        this.matrix = BooleanMatrices.empty(Math.max(this.rowHeads.size(), 1), Math.max(this.colHeads.size(), 1));
        this.push(new RelationEvent(RelationEvent.ALL_CHANGED));
    }

    @Override
    public final void fill() {
        this.matrix = BooleanMatrices.full(Math.max(this.rowHeads.size(), 1), Math.max(this.colHeads.size(), 1));
        this.push(new RelationEvent(RelationEvent.ALL_CHANGED));
    }

    @Override
    public final boolean isEmpty() {
        return !this.matrix.containsBoolean(true);
    }

    @Override
    public final boolean isFull() {
        return !this.matrix.containsBoolean(false);
    }

    @Override
    public final int size() {
        int size = 0;
        for (int i = 0; i < this.rowHeads.size(); ++i) {
            for (int j = 0; j < this.colHeads.size(); ++j) {
                if (!this.matrix.getBoolean(new long[]{i, j})) continue;
                ++size;
            }
        }
        return size;
    }

    @Override
    public final Iterator<Pair<R, C>> iterator() {
        return Iterators.transform((Iterator)Iterators.filter(this.matrix.allCoordinates().iterator(), (Predicate)new Predicate<long[]>(){

            public final boolean apply(long[] ij) {
                return MatrixRelation.this.matrix.getBoolean(ij) && ij[0] < (long)MatrixRelation.this.rowHeads.size() && ij[1] < (long)MatrixRelation.this.colHeads.size();
            }
        }), (Function)new Function<long[], Pair<R, C>>(){

            public final Pair<R, C> apply(long[] ij) {
                return new Pair(MatrixRelation.this.rowHeads.get((int)ij[0]), MatrixRelation.this.colHeads.get((int)ij[1]));
            }
        });
    }

    @Override
    public Relation<R, C> subRelation(final Collection<?> rows, final Collection<?> cols) {
        return new AbstractRelation<R, C>(SetLists.intersection(this.rowHeads, rows), SetLists.intersection(this.colHeads, cols), false){

            @Override
            public final boolean contains(Object o1, Object o2) {
                return this.rowHeads().contains(o1) && this.colHeads().contains(o2) && MatrixRelation.this.contains(o1, o2);
            }

            @Override
            public final MatrixRelation<R, C> clone() {
                return new MatrixRelation(this.rowHeads(), this.colHeads(), (BooleanMatrix)MatrixRelation.this.matrix.selectRows(Calculation.Ret.NEW, MatrixRelation.this.rowHeads().indicesOf(rows, false)).selectColumns(Calculation.Ret.NEW, MatrixRelation.this.colHeads().indicesOf(cols, false)), false);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushAllChangedEvent() {
        Map<RelationEvent.Type, List<RelationEventHandler<R, C>>> map = this.eventHandlers;
        synchronized (map) {
            this.push(RelationEvent.ALL_CHANGED, new RelationEvent(RelationEvent.ALL_CHANGED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void push(RelationEvent<R, C> event) {
        Map<RelationEvent.Type, List<RelationEventHandler<R, C>>> map = this.eventHandlers;
        synchronized (map) {
            RelationEvent.Type type = event.getType();
            this.push(type, event);
            while ((type = type.getSuperType()) != null) {
                this.push(type, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void push(RelationEvent.Type type, RelationEvent<R, C> event) {
        Map<RelationEvent.Type, List<RelationEventHandler<R, C>>> map = this.eventHandlers;
        synchronized (map) {
            if (this.eventHandlers.containsKey((Object)type)) {
                for (RelationEventHandler<R, C> eventHandler : this.eventHandlers.get((Object)type)) {
                    eventHandler.handle(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEventHandler(RelationEventHandler<R, C> eventHandler, RelationEvent.Type ... types) {
        Map<RelationEvent.Type, List<RelationEventHandler<R, C>>> map = this.eventHandlers;
        synchronized (map) {
            for (RelationEvent.Type type : types) {
                if (!this.eventHandlers.containsKey((Object)type)) {
                    this.eventHandlers.put(type, new CopyOnWriteArrayList());
                }
                this.eventHandlers.get((Object)type).add(eventHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeEventHandler(RelationEvent.Type type, RelationEventHandler<R, C> eventHandler) {
        Map<RelationEvent.Type, List<RelationEventHandler<R, C>>> map = this.eventHandlers;
        synchronized (map) {
            this.eventHandlers.remove((Object)type, eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasEventHandlers(RelationEvent.Type type) {
        Map<RelationEvent.Type, List<RelationEventHandler<R, C>>> map = this.eventHandlers;
        synchronized (map) {
            RelationEvent.Type type_ = type;
            if (!this.eventHandlers.get((Object)type_).isEmpty()) {
                return true;
            }
            while ((type_ = type_.getSuperType()) != null) {
                if (this.eventHandlers.get((Object)type_).isEmpty()) continue;
                return true;
            }
            return false;
        }
    }

    public final BooleanMatrix matrix() {
        return this.matrix;
    }

    public final void setMatrix(BooleanMatrix matrix) {
        if (matrix.getSize(0) != (long)this.rowHeads.size() || matrix.getSize(1) != (long)this.colHeads.size()) {
            throw new IllegalArgumentException();
        }
        this.matrix = matrix;
        this.pushAllChangedEvent();
    }

    @Deprecated
    public final void rewriteMatrix() {
        BooleanMatrix copy = BooleanMatrices.clone(this.matrix);
        this.setMatrix(BooleanMatrices.empty(this.matrix.getRowCount(), this.matrix.getColumnCount()));
        this.matrix.or(Calculation.Ret.ORIG, (Matrix)copy);
    }

    public final void setContent(SetList<R> rows, SetList<C> cols, BooleanMatrix matrix) {
        this.rowHeads.addAll(rows);
        if (!this.homogen) {
            this.colHeads.addAll(cols);
        }
        this.setMatrix(matrix);
    }

    @Override
    public void dispose() {
        this.rowHeads.clear();
        this.colHeads.clear();
    }

    @Override
    public MatrixRelation<R, C> clone() {
        return new MatrixRelation<R, C>(this.rowHeads, this.colHeads, BooleanMatrices.clone(this.matrix), this.homogen);
    }

    public int hashCode() {
        return 7 * this.rowHeads.hashCode() + 11 * this.colHeads.hashCode() + 13 * this.matrix.hashCode();
    }

    @Override
    public final boolean[][] toArray() {
        return this.matrix.toBooleanArray();
    }

    public Relation<R, R> subRelation(final Collection<?> c) {
        return new AbstractRelation<R, R>(SetLists.intersection(this.rowHeads, c), SetLists.intersection(this.rowHeads, c), true){

            @Override
            public boolean contains(Object o1, Object o2) {
                return this.rowHeads().contains(o1) && this.rowHeads().contains(o2) && MatrixRelation.this.contains(o1, o2);
            }

            @Override
            public MatrixRelation<R, R> clone() {
                return new MatrixRelation(this.rowHeads(), this.rowHeads(), (BooleanMatrix)MatrixRelation.this.matrix.selectRows(Calculation.Ret.NEW, MatrixRelation.this.rowHeads().indicesOf(c, false)).selectColumns(Calculation.Ret.NEW, MatrixRelation.this.colHeads().indicesOf(c, false)), true);
            }
        };
    }

    @Override
    public MatrixRelation<R, R> neighborhood() {
        this.checkHomogen();
        return new MatrixRelation(this.rowHeads(), this.rowHeads(), BooleanMatrices.transitiveReduction(BooleanMatrices.reflexiveReduction(this.matrix)), true);
    }

    @Override
    public MatrixRelation<R, R> order() {
        this.checkHomogen();
        return new MatrixRelation(this.rowHeads(), this.rowHeads(), BooleanMatrices.reflexiveClosure(BooleanMatrices.transitiveClosure(this.matrix)), true);
    }

    public final boolean isReflexive() {
        return this.matrix.ge(Calculation.Ret.NEW, (Matrix)BooleanMatrices.identity(this.size())).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isIrreflexive() {
        return this.matrix.and(Calculation.Ret.NEW, (Matrix)BooleanMatrices.identity(this.size())).equals(BooleanMatrices.empty(this.size()));
    }

    public final boolean isSymmetric() {
        return this.matrix.equals(this.matrix.transpose(Calculation.Ret.NEW));
    }

    public final boolean isAsymmetric() {
        return this.matrix.and(Calculation.Ret.NEW, this.matrix.transpose(Calculation.Ret.NEW)).equals(BooleanMatrices.empty(this.size()));
    }

    public final boolean isConnex() {
        return this.matrix.or(Calculation.Ret.NEW, this.matrix.transpose(Calculation.Ret.NEW)).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isAntisymmetric() {
        return this.matrix.and(Calculation.Ret.NEW, this.matrix.transpose(Calculation.Ret.NEW)).le(Calculation.Ret.NEW, (Matrix)BooleanMatrices.identity(this.size())).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isQuasiconnex() {
        return this.matrix.or(Calculation.Ret.NEW, this.matrix.transpose(Calculation.Ret.NEW)).ge(Calculation.Ret.NEW, (Matrix)BooleanMatrices.negativeIdentity(this.size())).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isAlternative() {
        return this.isAntisymmetric() && this.isQuasiconnex();
    }

    public final boolean isTransitive() {
        return this.matrix.mtimes(Calculation.Ret.NEW, false, (Matrix)this.matrix).toBooleanMatrix().le(Calculation.Ret.NEW, (Matrix)this.matrix).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isNegativeTransitive() {
        BooleanMatrix2D not = (BooleanMatrix2D)this.matrix.not(Calculation.Ret.NEW);
        return not.mtimes(Calculation.Ret.NEW, false, (Matrix)not).toBooleanMatrix().le(Calculation.Ret.NEW, (Matrix)not).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isAtransitive() {
        return this.matrix.mtimes(Calculation.Ret.NEW, false, (Matrix)this.matrix).toBooleanMatrix().and(Calculation.Ret.NEW, (Matrix)this.matrix).equals(BooleanMatrices.empty(this.size()));
    }

    public final boolean isNegativAtransitive() {
        BooleanMatrix2D not = (BooleanMatrix2D)this.matrix.not(Calculation.Ret.NEW);
        return not.mtimes(Calculation.Ret.NEW, false, (Matrix)not).toBooleanMatrix().and(Calculation.Ret.NEW, (Matrix)not).equals(BooleanMatrices.empty(this.size()));
    }

    public final boolean isNCyclic(int n) {
        return BooleanMatrices.power(this.matrix(), n).le(Calculation.Ret.NEW, this.matrix.transpose(Calculation.Ret.NEW)).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isCyclic() {
        return BooleanMatrices.transitiveClosure(this.matrix()).le(Calculation.Ret.NEW, this.matrix.transpose(Calculation.Ret.NEW)).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isNAcyclic(int n) {
        return BooleanMatrices.power(this.matrix(), n).le(Calculation.Ret.NEW, this.matrix.transpose(Calculation.Ret.NEW).not(Calculation.Ret.NEW)).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isAcyclic() {
        return BooleanMatrices.transitiveClosure(this.matrix()).le(Calculation.Ret.NEW, this.matrix.transpose(Calculation.Ret.NEW).not(Calculation.Ret.NEW)).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isNTransitive(int n) {
        return BooleanMatrices.power(this.matrix(), n).le(Calculation.Ret.NEW, (Matrix)this.matrix).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isNAtransitive(int n) {
        return BooleanMatrices.power(this.matrix(), n).le(Calculation.Ret.NEW, this.matrix.not(Calculation.Ret.NEW)).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isLeftComparative() {
        return this.matrix.transpose(Calculation.Ret.NEW).mtimes(Calculation.Ret.NEW, false, (Matrix)this.matrix).toBooleanMatrix().le(Calculation.Ret.NEW, (Matrix)this.matrix).equals(BooleanMatrices.full(this.size()));
    }

    public final boolean isRightComparative() {
        return this.matrix.mtimes(Calculation.Ret.NEW, false, this.matrix.transpose(Calculation.Ret.NEW)).toBooleanMatrix().le(Calculation.Ret.NEW, (Matrix)this.matrix).equals(BooleanMatrices.full(this.size()));
    }

    private final class Heads
    extends HashSetArrayList<R> {
        private Heads(Collection<? extends R> c) {
            super(c);
        }

        @Override
        public final boolean add(R head) {
            if (super.add(head)) {
                this.append(this.size() - 1, 1);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, head, null));
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, head));
                return true;
            }
            return false;
        }

        @Override
        public final void add(int i, R head) {
            int size0 = this.size();
            super.add(i, head);
            if (size0 != this.size()) {
                this.insert(i, size0, 1);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, head, null));
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, head));
            }
        }

        @Override
        public final boolean addAll(Collection<? extends R> c) {
            int size0 = this.size();
            HashSet changes = new HashSet(Collections3.difference(c, this));
            if (super.addAll(c)) {
                this.append(size0, this.size() - size0);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, changes, null, null));
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, changes, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean addAll(int i, Collection<? extends R> c) {
            int size0 = this.size();
            HashSet changes = new HashSet(Collections3.difference(c, this));
            if (super.addAll(i, c)) {
                this.insert(i, size0, this.size() - size0);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, changes, null, null));
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, changes, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean set(Object o, R head) {
            if (super.set(o, head)) {
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_SET, new Pair(o, head), null));
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_SET, null, new Pair(o, head)));
                return true;
            }
            return false;
        }

        @Override
        public final R set(int i, R head) {
            Object head0 = super.set(i, head);
            MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_SET, new Pair(head0, head), null));
            MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_SET, null, new Pair(head0, head)));
            return head0;
        }

        @Override
        public final boolean remove(Object o) {
            int i = this.indexOf(o);
            if (i == -1) {
                return false;
            }
            super.remove(o);
            MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteRows(Calculation.Ret.NEW, new long[]{i}).deleteColumns(Calculation.Ret.NEW, new long[]{i});
            MatrixRelation.this.push(new RelationEvent<Object, Object>(RelationEvent.ROWS_REMOVED, o, null));
            MatrixRelation.this.push(new RelationEvent<Object, Object>(RelationEvent.COLUMNS_REMOVED, null, o));
            return true;
        }

        @Override
        public final R remove(int i) {
            Object head = super.remove(i);
            if (head != null) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteRows(Calculation.Ret.NEW, new long[]{i}).deleteColumns(Calculation.Ret.NEW, new long[]{i});
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_REMOVED, head, null));
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_REMOVED, null, head));
            }
            return head;
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            HashSet i = Sets.newHashSet(this.indicesOf(c, false));
            HashSet changes = new HashSet();
            for (Object head : this) {
                if (!c.contains(head)) continue;
                changes.add(head);
            }
            if (super.removeAll(c)) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteRows(Calculation.Ret.NEW, (Collection)i).deleteColumns(Calculation.Ret.NEW, (Collection)i);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_REMOVED, changes, null, null));
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_REMOVED, null, changes, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            Collection<Integer> i = this.indicesOf(c, false);
            HashSet changes = new HashSet();
            for (Object head : this) {
                if (!c.contains(head)) continue;
                changes.add(head);
            }
            if (super.removeAll(c)) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.selectRows(Calculation.Ret.NEW, i).selectColumns(Calculation.Ret.NEW, i);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_REMOVED, changes, null, null));
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_REMOVED, null, changes, null));
                return true;
            }
            return false;
        }

        @Override
        public final ListIterator<R> listIterator(final int i) {
            return new ListIterator<R>(){
                private final ListIterator<R> it;
                private R pointer;
                private int j;
                {
                    this.it = Heads.super.listIterator(i);
                }

                @Override
                public final boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public final int nextIndex() {
                    return this.it.nextIndex();
                }

                @Override
                public final R next() {
                    this.j = this.it.nextIndex();
                    this.pointer = this.it.next();
                    return this.pointer;
                }

                @Override
                public final boolean hasPrevious() {
                    return this.it.hasPrevious();
                }

                @Override
                public final int previousIndex() {
                    return this.it.previousIndex();
                }

                @Override
                public final R previous() {
                    this.j = this.it.previousIndex();
                    this.pointer = this.it.previous();
                    return this.pointer;
                }

                @Override
                public final void add(R head) {
                    this.pointer = head;
                    int size0 = Heads.this.size();
                    this.it.add(head);
                    if (size0 != Heads.this.size()) {
                        ++this.j;
                        Heads.this.insert(this.j, size0, 1);
                        MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, head, null));
                        MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, head));
                    }
                }

                @Override
                public final void set(R head) {
                    this.pointer = head;
                    this.it.set(head);
                }

                @Override
                public final void remove() {
                    this.it.remove();
                    MatrixRelation.this.matrix = Heads.this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteRows(Calculation.Ret.NEW, new long[]{this.j}).deleteColumns(Calculation.Ret.NEW, new long[]{this.j});
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_REMOVED, this.pointer, null));
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_REMOVED, null, this.pointer));
                }
            };
        }

        @Override
        public final void clear() {
            super.clear();
            MatrixRelation.this.matrix = BooleanMatrix2D.Factory.zeros(0L, 0L);
            MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_CLEARED));
            MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_CLEARED));
        }

        private final void append(int size0, int heads) {
            if (size0 == 0) {
                MatrixRelation.this.matrix = BooleanMatrix2D.Factory.zeros((long)heads, (long)heads);
                return;
            }
            BooleanMatrix2D rows = BooleanMatrix2D.Factory.zeros((long)heads, (long)size0);
            BooleanMatrix2D cols = BooleanMatrix2D.Factory.zeros((long)(size0 + heads), (long)heads);
            MatrixRelation.this.matrix = (BooleanMatrix)MatrixRelation.this.matrix.appendVertically(Calculation.Ret.NEW, new Matrix[]{rows}).appendHorizontally(Calculation.Ret.NEW, new Matrix[]{cols});
        }

        private final void insert(int i, int size0, int heads) {
            if (size0 == 0) {
                MatrixRelation.this.matrix = BooleanMatrix2D.Factory.zeros((long)heads, (long)heads);
                return;
            }
            BooleanMatrix2D rows = BooleanMatrix2D.Factory.zeros((long)heads, (long)size0);
            BooleanMatrix2D cols = BooleanMatrix2D.Factory.zeros((long)(size0 + heads), (long)heads);
            if (i == 0) {
                MatrixRelation.this.matrix = (BooleanMatrix)cols.appendHorizontally(Calculation.Ret.NEW, new Matrix[]{rows.appendVertically(Calculation.Ret.NEW, new Matrix[]{MatrixRelation.this.matrix})});
            } else if (i == size0) {
                MatrixRelation.this.matrix = (BooleanMatrix)MatrixRelation.this.matrix.appendVertically(Calculation.Ret.NEW, new Matrix[]{rows}).appendHorizontally(Calculation.Ret.NEW, new Matrix[]{cols});
            } else {
                BooleanMatrix upper = (BooleanMatrix)MatrixRelation.this.matrix.subMatrix(Calculation.Ret.LINK, new long[]{0L, 0L, i - 1, size0 - 1});
                BooleanMatrix lower = (BooleanMatrix)MatrixRelation.this.matrix.subMatrix(Calculation.Ret.LINK, new long[]{i, 0L, size0 - 1, size0 - 1});
                MatrixRelation.this.matrix = (BooleanMatrix)upper.appendVertically(Calculation.Ret.NEW, new Matrix[]{rows}).appendVertically(Calculation.Ret.NEW, new Matrix[]{lower});
                BooleanMatrix left = (BooleanMatrix)MatrixRelation.this.matrix.subMatrix(Calculation.Ret.LINK, new long[]{0L, 0L, size0 + heads - 1, i - 1});
                BooleanMatrix right = (BooleanMatrix)MatrixRelation.this.matrix.subMatrix(Calculation.Ret.LINK, new long[]{0L, i, size0 + heads - 1, size0 - 1});
                MatrixRelation.this.matrix = (BooleanMatrix)left.appendHorizontally(Calculation.Ret.NEW, new Matrix[]{cols}).appendHorizontally(Calculation.Ret.NEW, new Matrix[]{right});
            }
        }
    }

    private final class ColHeads
    extends HashSetArrayList<C> {
        private ColHeads(Collection<? extends C> c) {
            super(c);
        }

        @Override
        public final boolean add(C col) {
            boolean wasEmpty = this.isEmpty();
            if (super.add(col)) {
                this.append(wasEmpty, 1);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, col));
                return true;
            }
            return false;
        }

        @Override
        public final void add(int i, C col) {
            int size0 = this.size();
            super.add(i, col);
            if (size0 != this.size()) {
                this.insert(i, size0, 1);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, col));
            }
        }

        @Override
        public final boolean addAll(Collection<? extends C> c) {
            int size0 = this.size();
            HashSet changes = new HashSet(Collections3.difference(c, this));
            if (super.addAll(c)) {
                this.append(size0 == 0, this.size() - size0);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, changes, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean addAll(int i, Collection<? extends C> c) {
            int size0 = this.size();
            HashSet changes = new HashSet(Collections3.difference(c, this));
            if (super.addAll(i, c)) {
                this.insert(i, size0, this.size() - size0);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, changes, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean set(Object o, C col) {
            if (super.set(o, col)) {
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_SET, null, new Pair(o, col)));
                return true;
            }
            return false;
        }

        @Override
        public final C set(int i, C col) {
            Object col0 = super.set(i, col);
            MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_SET, null, new Pair(col0, col)));
            return col0;
        }

        @Override
        public final boolean remove(Object o) {
            int i = this.indexOf(o);
            if (i == -1) {
                return false;
            }
            super.remove(o);
            MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteColumns(Calculation.Ret.NEW, new long[]{i});
            MatrixRelation.this.push(new RelationEvent<Object, Object>(RelationEvent.COLUMNS_REMOVED, null, o));
            return true;
        }

        @Override
        public final C remove(int i) {
            Object col = super.remove(i);
            if (col != null) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteColumns(Calculation.Ret.NEW, new long[]{i});
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_REMOVED, null, col));
            }
            return col;
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            Collection<Integer> i = this.indicesOf(c, false);
            HashSet changes = new HashSet();
            for (Object col : this) {
                if (!c.contains(col)) continue;
                changes.add(col);
            }
            if (super.removeAll(c)) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteColumns(Calculation.Ret.NEW, i);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_REMOVED, null, changes, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            Collection<Integer> i = this.indicesOf(c, false);
            HashSet changes = new HashSet();
            for (Object col : this) {
                if (c.contains(col)) continue;
                changes.add(col);
            }
            if (super.retainAll(c)) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.selectColumns(Calculation.Ret.NEW, i);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_REMOVED, null, changes, null));
                return true;
            }
            return false;
        }

        @Override
        public final ListIterator<C> listIterator(final int i) {
            return new ListIterator<C>(){
                private final ListIterator<C> it;
                private C pointer;
                private int j;
                {
                    this.it = ColHeads.super.listIterator(i);
                }

                @Override
                public final boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public final C next() {
                    this.j = this.it.nextIndex();
                    this.pointer = this.it.next();
                    return this.pointer;
                }

                @Override
                public final boolean hasPrevious() {
                    return this.it.hasPrevious();
                }

                @Override
                public final C previous() {
                    this.j = this.it.previousIndex();
                    this.pointer = this.it.previous();
                    return this.pointer;
                }

                @Override
                public final int nextIndex() {
                    return this.it.nextIndex();
                }

                @Override
                public final int previousIndex() {
                    return this.it.previousIndex();
                }

                @Override
                public final void remove() {
                    this.it.remove();
                    MatrixRelation.this.matrix = ColHeads.this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteColumns(Calculation.Ret.NEW, new long[]{this.j});
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_REMOVED, null, this.pointer));
                }

                @Override
                public final void set(C col) {
                    this.pointer = col;
                    this.it.set(col);
                }

                @Override
                public final void add(C col) {
                    this.pointer = col;
                    int size0 = ColHeads.this.size();
                    this.it.add(col);
                    if (size0 != ColHeads.this.size()) {
                        ColHeads.this.insert(++this.j, size0, 1);
                        MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_ADDED, null, col));
                    }
                }
            };
        }

        @Override
        public final void clear() {
            super.clear();
            MatrixRelation.this.matrix = BooleanMatrix2D.Factory.zeros(0L, 0L);
            MatrixRelation.this.push(new RelationEvent(RelationEvent.COLUMNS_CLEARED));
        }

        private final void append(boolean wasEmpty, int cols) {
            BooleanMatrix2D zeros = BooleanMatrix2D.Factory.zeros((long)MatrixRelation.this.rowHeads.size(), (long)cols);
            MatrixRelation.this.matrix = wasEmpty ? zeros : (BooleanMatrix)MatrixRelation.this.matrix.appendHorizontally(Calculation.Ret.NEW, new Matrix[]{zeros});
        }

        private final void insert(int i, int size0, int cols) {
            int rows = MatrixRelation.this.rowHeads.size();
            BooleanMatrix2D zeros = BooleanMatrix2D.Factory.zeros((long)rows, (long)cols);
            if (size0 == 0) {
                MatrixRelation.this.matrix = zeros;
            } else if (i == 0) {
                MatrixRelation.this.matrix = (BooleanMatrix)zeros.appendHorizontally(Calculation.Ret.NEW, new Matrix[]{MatrixRelation.this.matrix});
            } else if (i == size0) {
                MatrixRelation.this.matrix = (BooleanMatrix)MatrixRelation.this.matrix.appendHorizontally(Calculation.Ret.NEW, new Matrix[]{zeros});
            } else {
                BooleanMatrix left = MatrixRelation.this.matrix.subMatrix(Calculation.Ret.LINK, new long[]{0L, 0L, rows - 1, i - 1}).toBooleanMatrix();
                BooleanMatrix right = MatrixRelation.this.matrix.subMatrix(Calculation.Ret.LINK, new long[]{0L, i, rows - 1, size0 - 1}).toBooleanMatrix();
                MatrixRelation.this.matrix = (BooleanMatrix)left.appendHorizontally(Calculation.Ret.NEW, new Matrix[]{zeros}).appendHorizontally(Calculation.Ret.NEW, new Matrix[]{right});
            }
        }
    }

    private final class RowHeads
    extends HashSetArrayList<R> {
        private RowHeads(Collection<? extends R> c) {
            super(c);
        }

        @Override
        public final boolean add(R row) {
            boolean wasEmpty = this.isEmpty();
            if (super.add(row)) {
                this.append(wasEmpty, 1);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, row, null));
                return true;
            }
            return false;
        }

        @Override
        public final void add(int i, R row) {
            int size0 = this.size();
            super.add(i, row);
            if (size0 != this.size()) {
                this.insert(i, size0, 1);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, row, null));
            }
        }

        @Override
        public final boolean addAll(Collection<? extends R> c) {
            int size0 = this.size();
            HashSet changes = new HashSet(Collections3.difference(c, this));
            if (super.addAll(c)) {
                this.append(size0 == 0, this.size() - size0);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, changes, null, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean addAll(int i, Collection<? extends R> c) {
            int size0 = this.size();
            HashSet changes = new HashSet(Collections3.difference(c, this));
            if (super.addAll(i, c)) {
                this.insert(i, size0, this.size() - size0);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, changes, null, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean set(Object o, R row) {
            if (super.set(o, row)) {
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_SET, new Pair(o, row), null));
                return true;
            }
            return false;
        }

        @Override
        public final R set(int i, R row) {
            Object row0 = super.set(i, row);
            MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_SET, new Pair(row0, row), null));
            return row0;
        }

        @Override
        public final boolean remove(Object o) {
            int i = this.indexOf(o);
            if (i == -1) {
                return false;
            }
            super.remove(o);
            MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteRows(Calculation.Ret.NEW, new long[]{i});
            MatrixRelation.this.push(new RelationEvent<Object, Object>(RelationEvent.ROWS_REMOVED, o, null));
            return true;
        }

        @Override
        public final R remove(int i) {
            Object row = super.remove(i);
            if (row != null) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteRows(Calculation.Ret.NEW, new long[]{i});
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_REMOVED, row, null));
            }
            return row;
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            Collection<Integer> i = this.indicesOf(c, false);
            HashSet changes = new HashSet();
            for (Object row : this) {
                if (!c.contains(row)) continue;
                changes.add(row);
            }
            if (super.removeAll(c)) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteRows(Calculation.Ret.NEW, i);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_REMOVED, changes, null, null));
                return true;
            }
            return false;
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            Collection<Integer> i = this.indicesOf(c, false);
            HashSet changes = new HashSet();
            for (Object row : this) {
                if (c.contains(row)) continue;
                changes.add(row);
            }
            if (super.retainAll(c)) {
                MatrixRelation.this.matrix = this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.selectRows(Calculation.Ret.NEW, i);
                MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_REMOVED, changes, null, null));
                return true;
            }
            return false;
        }

        @Override
        public final ListIterator<R> listIterator(final int i) {
            return new ListIterator<R>(){
                private final ListIterator<R> it;
                private R pointer;
                private int j;
                {
                    this.it = RowHeads.super.listIterator(i);
                }

                @Override
                public final boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public final int nextIndex() {
                    return this.it.nextIndex();
                }

                @Override
                public final R next() {
                    this.j = this.it.nextIndex();
                    this.pointer = this.it.next();
                    return this.pointer;
                }

                @Override
                public final boolean hasPrevious() {
                    return this.it.hasPrevious();
                }

                @Override
                public final int previousIndex() {
                    return this.it.previousIndex();
                }

                @Override
                public final R previous() {
                    this.j = this.it.previousIndex();
                    this.pointer = this.it.previous();
                    return this.pointer;
                }

                @Override
                public final void add(R row) {
                    this.pointer = row;
                    int size0 = RowHeads.this.size();
                    this.it.add(row);
                    if (size0 != RowHeads.this.size()) {
                        RowHeads.this.insert(++this.j, size0, 1);
                        MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_ADDED, row, null));
                    }
                }

                @Override
                public final void set(R row) {
                    this.pointer = row;
                    this.it.set(row);
                }

                @Override
                public final void remove() {
                    this.it.remove();
                    MatrixRelation.this.matrix = RowHeads.this.isEmpty() ? BooleanMatrix2D.Factory.zeros(0L, 0L) : (BooleanMatrix)MatrixRelation.this.matrix.deleteRows(Calculation.Ret.NEW, new long[]{this.j});
                    MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_REMOVED, this.pointer, null));
                }
            };
        }

        @Override
        public final void clear() {
            super.clear();
            MatrixRelation.this.matrix = BooleanMatrix2D.Factory.zeros(0L, 0L);
            MatrixRelation.this.push(new RelationEvent(RelationEvent.ROWS_CLEARED));
        }

        private final void append(boolean wasEmpty, int rows) {
            if (MatrixRelation.this.colHeads == null) {
                return;
            }
            BooleanMatrix2D zeros = BooleanMatrix2D.Factory.zeros((long)rows, (long)MatrixRelation.this.colHeads.size());
            MatrixRelation.this.matrix = wasEmpty ? zeros : (BooleanMatrix)MatrixRelation.this.matrix.appendVertically(Calculation.Ret.NEW, new Matrix[]{zeros});
        }

        private final void insert(int i, int size0, int rows) {
            if (MatrixRelation.this.colHeads == null) {
                return;
            }
            int cols = MatrixRelation.this.colHeads.size();
            BooleanMatrix2D zeros = BooleanMatrix2D.Factory.zeros((long)rows, (long)cols);
            if (size0 == 0) {
                MatrixRelation.this.matrix = zeros;
            } else if (i == 0) {
                MatrixRelation.this.matrix = (BooleanMatrix)zeros.appendVertically(Calculation.Ret.NEW, new Matrix[]{MatrixRelation.this.matrix});
            } else if (i == size0) {
                MatrixRelation.this.matrix = (BooleanMatrix)MatrixRelation.this.matrix.appendVertically(Calculation.Ret.NEW, new Matrix[]{zeros});
            } else {
                BooleanMatrix upper = MatrixRelation.this.matrix.subMatrix(Calculation.Ret.LINK, new long[]{0L, 0L, i - 1, cols - 1}).toBooleanMatrix();
                BooleanMatrix lower = MatrixRelation.this.matrix.subMatrix(Calculation.Ret.LINK, new long[]{i, 0L, size0 - 1, cols - 1}).toBooleanMatrix();
                MatrixRelation.this.matrix = (BooleanMatrix)upper.appendVertically(Calculation.Ret.NEW, new Matrix[]{zeros}).appendVertically(Calculation.Ret.NEW, new Matrix[]{lower});
            }
        }
    }
}

