/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections.setlist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.GuavaFunctions;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.collections.setlist.SetLists;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public abstract class AbstractSetList<E>
implements SetList<E> {
    public AbstractSetList() {
    }

    public AbstractSetList(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        try {
            this.add(this.size(), e);
            return true;
        }
        catch (IllegalArgumentException x) {
            return false;
        }
    }

    @Override
    public void add(int i, E e) {
        this.listIterator(i).add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> c) {
        boolean changed = false;
        ListIterator<E> it = this.listIterator(i);
        for (E e : c) {
            try {
                it.add(e);
                changed = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return changed;
    }

    @Override
    public boolean set(Object o, E e) {
        if (o == null && e == null || o.equals(e)) {
            return false;
        }
        ListIterator<E> it = this.listIterator();
        while (it.hasNext()) {
            if (!it.next().equals(o)) continue;
            it.set(e);
            return true;
        }
        return false;
    }

    @Override
    public E set(int i, E e) {
        ListIterator<E> it = this.listIterator(i);
        if (it.hasNext()) {
            E oldElement = it.next();
            it.set(e);
            return oldElement;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E remove(int i) {
        ListIterator<E> it = this.listIterator(i);
        if (it.hasNext()) {
            E e = it.next();
            it.remove();
            return e;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(o)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int i) {
        return this.listIterator(i).next();
    }

    @Override
    public final Collection<E> getAll(Collection<Integer> c, boolean includeNull) {
        if (includeNull) {
            return Collections2.transform(c, (Function)new Function<Integer, E>(){

                public final E apply(Integer i) {
                    return AbstractSetList.this.get(i);
                }
            });
        }
        return Collections2.filter((Collection)Collections2.transform(c, (Function)new Function<Integer, E>(){

            public final E apply(Integer i) {
                return AbstractSetList.this.get(i);
            }
        }), (Predicate)Predicates.notNull());
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        for (E e : this) {
            if (e.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final Collection<Integer> indicesOf(Collection<?> c, boolean includeMinusOne) {
        if (includeMinusOne) {
            return Collections2.transform(c, GuavaFunctions.toGuavaFunction(this::indexOf));
        }
        return Collections2.filter((Collection)Collections2.transform(c, GuavaFunctions.toGuavaFunction(this::indexOf)), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)-1)));
    }

    @Override
    @Deprecated
    public final int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public final SetList<E> subList(final int from, final int to) {
        return this.filter(new Predicate<E>(){

            public final boolean apply(E e) {
                int i = AbstractSetList.this.indexOf(e);
                return from <= i && i < to;
            }
        });
    }

    @Override
    public final BitSetFX subBitSet(Collection<?> c) {
        BitSetFX b = new BitSetFX(this.size());
        for (int i : this.indicesOf(c, true)) {
            b.flip(i);
        }
        return b;
    }

    @Override
    public final SetList<E> filter(Predicate<? super E> p) {
        return SetLists.filter(this, p);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public abstract ListIterator<E> listIterator(int var1);

    @Override
    public boolean isEmpty() {
        return this.iterator().hasNext();
    }

    @Override
    public int size() {
        return Iterators.size(this.iterator());
    }

    @Override
    public void clear() {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public final HashSetArrayList<E> clone() {
        return new HashSetArrayList(this);
    }

    @Override
    public final boolean equals(Object o) {
        return o != null && (this == o || o instanceof SetList && this.size() == ((SetList)o).size() && this.containsAll((SetList)o));
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 23 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (E e : this) {
            a[i++] = e;
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        try {
            if (a.length < this.size()) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            }
            int i = 0;
            for (E e : this) {
                a[i++] = e;
            }
            if (a.length > this.size()) {
                a[this.size()] = null;
            }
            return a;
        }
        catch (ClassCastException x) {
            throw new ArrayStoreException();
        }
    }

    public final String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{");
        Iterator<E> it = this.iterator();
        if (it.hasNext()) {
            s.append(it.next().toString());
        }
        while (it.hasNext()) {
            s.append(", " + it.next().toString());
        }
        s.append("}");
        return s.toString();
    }
}

