/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.collections.setlist;

import conexp.fx.core.collections.setlist.AbstractSetList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Spliterator;

public class HashSetArrayList<E>
extends AbstractSetList<E> {
    private final HashSet<E> s = new HashSet();
    private final ArrayList<E> l = new ArrayList();

    public HashSetArrayList() {
    }

    public HashSetArrayList(Collection<? extends E> c) {
        this.addAll(c);
    }

    private final void checkIndex(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean add(E e) {
        return this.s.add(e) && this.l.add(e);
    }

    @Override
    public void add(int i, E e) {
        if (!this._add(i, e)) {
            throw new IllegalArgumentException();
        }
    }

    public boolean _add(int i, E e) {
        this.checkIndex(i);
        if (this.s.add(e)) {
            this.l.add(i, e);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            changed |= this.s.add(e) && this.l.add(e);
        }
        return changed;
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> c) {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        boolean changed = false;
        int j = i;
        for (E e : c) {
            if (!this.s.add(e)) continue;
            this.l.add(j++, e);
            changed = true;
        }
        return changed;
    }

    @Override
    public E set(int i, E e) {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.s.add(e)) {
            E x = this.l.set(i, e);
            this.s.remove(x);
            return x;
        }
        return e;
    }

    @Override
    public boolean remove(Object o) {
        return this.l.remove(o) && this.s.remove(o);
    }

    @Override
    public E remove(int i) {
        E e = this.l.remove(i);
        this.s.remove(e);
        return e;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.l.removeAll(c) && this.s.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.l.retainAll(c) && this.s.retainAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.s.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.s.containsAll(c);
    }

    @Override
    public E get(int i) {
        return this.l.get(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.l.indexOf(o);
    }

    @Override
    public ListIterator<E> listIterator(final int i) {
        return new ListIterator<E>(){
            private final ListIterator<E> it;
            private E pointer;
            private boolean illegal;
            {
                this.it = HashSetArrayList.this.l.listIterator(i);
                this.pointer = null;
                this.illegal = true;
            }

            @Override
            public final boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public final E next() {
                this.pointer = this.it.next();
                this.illegal = false;
                return this.pointer;
            }

            @Override
            public final boolean hasPrevious() {
                return this.it.hasPrevious();
            }

            @Override
            public final E previous() {
                this.pointer = this.it.previous();
                this.illegal = false;
                return this.pointer;
            }

            @Override
            public final int nextIndex() {
                return this.it.nextIndex();
            }

            @Override
            public final int previousIndex() {
                return this.it.previousIndex();
            }

            @Override
            public final void remove() {
                if (this.illegal) {
                    throw new IllegalStateException();
                }
                HashSetArrayList.this.s.remove(this.pointer);
                this.it.remove();
                this.illegal = true;
                this.pointer = null;
            }

            @Override
            public final void set(E e) {
                if (this.illegal) {
                    throw new IllegalStateException();
                }
                if (this.pointer.equals(e)) {
                    return;
                }
                if (!HashSetArrayList.this.s.add(e)) {
                    throw new IllegalArgumentException();
                }
                HashSetArrayList.this.s.remove(this.pointer);
                this.it.set(e);
                this.pointer = e;
            }

            @Override
            public final void add(E e) {
                if (!HashSetArrayList.this.s.add(e)) {
                    throw new IllegalArgumentException();
                }
                this.it.add(e);
                this.illegal = true;
                this.pointer = null;
            }
        };
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Object[] a = this.toArray();
        this.s.clear();
        Arrays.sort(a, c);
        ListIterator<Object> i = this.listIterator();
        for (Object e : a) {
            i.next();
            i.set(e);
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.l.spliterator();
    }

    @Override
    public boolean isEmpty() {
        return this.s.isEmpty();
    }

    @Override
    public int size() {
        return this.l.size();
    }

    @Override
    public void clear() {
        this.s.clear();
        this.l.clear();
    }

    @Override
    public int hashCode() {
        return this.s.hashCode() + this.l.hashCode();
    }

    @Override
    public Object[] toArray() {
        return this.l.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.l.toArray(a);
    }
}

