/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import conexp.fx.core.collections.relation.MatrixRelation;
import conexp.fx.core.collections.relation.RelationEvent;
import conexp.fx.core.collections.relation.RelationEventHandler;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;

public final class ConceptLattice<G, M>
extends MatrixRelation<Concept<G, M>, Concept<G, M>> {
    public final MatrixContext<G, M> context;
    public final ObservableMap<G, Concept<G, M>> objectConcepts = FXCollections.observableMap(new ConcurrentHashMap());
    public final ObservableMap<M, Concept<G, M>> attributeConcepts = FXCollections.observableMap(new ConcurrentHashMap());
    private MatrixRelation<Concept<G, M>, Concept<G, M>> order;

    public ConceptLattice(MatrixContext<G, M> context) {
        super(true);
        this.context = context;
        this.order = this.order();
        this.addEventHandler(new RelationEventHandler<Concept<G, M>, Concept<G, M>>(){

            @Override
            public final void handle(RelationEvent<Concept<G, M>, Concept<G, M>> event) {
                ConceptLattice.this.order = ConceptLattice.this.order();
            }
        }, RelationEvent.ALL_CHANGED);
    }

    public final Set<Concept<G, M>> lowerNeighbors(Concept<G, M> concept) {
        return this.col(concept);
    }

    public final Set<Concept<G, M>> upperNeighbors(Concept<G, M> concept) {
        return this.row(concept);
    }

    public final Set<Concept<G, M>> ideal(Concept<G, M> concept) {
        return this.order.col(concept);
    }

    public final Set<Concept<G, M>> filter(Concept<G, M> concept) {
        return this.order.row(concept);
    }

    public final Set<Concept<G, M>> interval(Concept<G, M> lower, Concept<G, M> upper) {
        return Sets.intersection(this.filter(lower), this.ideal(upper));
    }

    public final Set<Concept<G, M>> complement(Set<Concept<G, M>> concepts) {
        return Sets.difference(this.rowHeads(), concepts);
    }

    @SafeVarargs
    public final Concept<G, M> supremum(Concept<G, M> ... concepts) {
        HashSet intent = new HashSet(this.context.colHeads());
        for (Concept<G, M> concept : concepts) {
            intent.retainAll((Collection<?>)concept.intent());
        }
        HashSet extent = new HashSet(this.context.colAnd(intent));
        return new Concept(extent, intent);
    }

    public final Concept<G, M> supremum(Iterable<Concept<G, M>> concepts) {
        HashSet intent = new HashSet(this.context.colHeads());
        for (Concept<G, M> concept : concepts) {
            intent.retainAll((Collection<?>)concept.intent());
        }
        HashSet extent = new HashSet(this.context.colAnd(intent));
        return new Concept(extent, intent);
    }

    @SafeVarargs
    public final Concept<G, M> infimum(Concept<G, M> ... concepts) {
        HashSet extent = new HashSet(this.context.rowHeads());
        for (Concept<G, M> concept : concepts) {
            extent.retainAll((Collection<?>)concept.extent());
        }
        HashSet intent = new HashSet(this.context.rowAnd(extent));
        return new Concept(extent, intent);
    }

    public final Concept<G, M> infimum(Iterable<Concept<G, M>> concepts) {
        HashSet extent = new HashSet(this.context.rowHeads());
        for (Concept<G, M> concept : concepts) {
            extent.retainAll((Collection<?>)concept.extent());
        }
        HashSet intent = new HashSet(this.context.rowAnd(extent));
        return new Concept(extent, intent);
    }

    public final Set<G> objectLabels(Concept<G, M> concept) {
        return Maps.filterValues(this.objectConcepts, (Predicate)Predicates.equalTo(concept)).keySet();
    }

    public final Set<M> attributeLabels(Concept<G, M> concept) {
        return Maps.filterValues(this.attributeConcepts, (Predicate)Predicates.equalTo(concept)).keySet();
    }

    public final Collection<Implication<G, M>> luxenburgerBase(double minConfidence, boolean sorted) {
        if (minConfidence < 0.0 || minConfidence > 1.0) {
            throw new IllegalArgumentException("Confidence must be in range [0,1].");
        }
        Stream<Object> s = new LuxenburgerBaseExtractor().get().parallelStream();
        if (minConfidence > 0.0) {
            s = s.filter((? super T i) -> i.getConfidence() >= minConfidence);
        }
        if (sorted) {
            return s.sorted((i, j) -> (int)Math.signum(j.getConfidence() - i.getConfidence())).collect(Collectors.toList());
        }
        return s.collect(Collectors.toSet());
    }

    private final class LuxenburgerBaseExtractor {
        private final Set<Implication<G, M>> set = Collections.newSetFromMap(new ConcurrentHashMap());

        private LuxenburgerBaseExtractor() {
        }

        private final Set<Implication<G, M>> get() {
            this.recursion(ConceptLattice.this.context.selection.topConcept());
            return this.set;
        }

        private final void recursion(Concept<G, M> concept) {
            ConceptLattice.this.col(concept).parallelStream().forEach(lowerNeighbor -> {
                this.set.add(new Implication(concept.getIntent(), Sets.newHashSet((Iterable)Sets.difference(lowerNeighbor.getIntent(), concept.getIntent())), lowerNeighbor.getExtent(), (double)lowerNeighbor.getExtent().size() / (double)concept.getExtent().size()));
                this.recursion((Concept)lowerNeighbor);
            });
        }
    }
}

