/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import conexp.fx.core.context.MatrixContext;
import de.tudresden.inf.tcs.fcaapi.Expert;
import de.tudresden.inf.tcs.fcaapi.FCAImplication;
import de.tudresden.inf.tcs.fcaapi.FCAObject;
import de.tudresden.inf.tcs.fcaapi.exception.IllegalAttributeException;
import de.tudresden.inf.tcs.fcaapi.exception.IllegalObjectException;
import de.tudresden.inf.tcs.fcaapi.utils.IndexedSet;
import de.tudresden.inf.tcs.fcalib.AbstractContext;
import de.tudresden.inf.tcs.fcalib.FullObject;
import de.tudresden.inf.tcs.fcalib.FullObjectDescription;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class FCALibContext<G, M>
extends AbstractContext<M, G, FCAObject<M, G>> {
    private final MatrixContext<G, M> cxt;
    private Expert<M, G, FCAObject<M, G>> expert;

    public FCALibContext(MatrixContext<G, M> cxt) {
        this.cxt = cxt;
        this.getAttributes().addAll(cxt.colHeads());
    }

    public FCAObject<M, G> getObject(G id) {
        return new FullObject(id, this.cxt.row(id));
    }

    public FCAObject<M, G> getObjectAtIndex(int index) {
        return this.getObject(this.cxt.rowHeads().get(index));
    }

    public boolean objectHasAttribute(FCAObject<M, G> object, M attribute) {
        return this.cxt.contains(object.getIdentifier(), attribute);
    }

    public Set<FCAImplication<M>> getDuquenneGuiguesBase() {
        return null;
    }

    public Expert<M, G, FCAObject<M, G>> getExpert() {
        return this.expert;
    }

    public void setExpert(Expert<M, G, FCAObject<M, G>> e) {
        this.expert = e;
    }

    public IndexedSet<FCAObject<M, G>> getObjects() {
        return new IndexedSet<FCAObject<M, G>>(){

            public int size() {
                return FCALibContext.this.cxt.rowHeads().size();
            }

            public boolean isEmpty() {
                return FCALibContext.this.cxt.rowHeads().isEmpty();
            }

            public boolean contains(Object o) {
                if (o instanceof FCAObject) {
                    return FCALibContext.this.cxt.rowHeads().contains(((FCAObject)o).getIdentifier());
                }
                return FCALibContext.this.cxt.rowHeads().contains(o);
            }

            public Iterator<FCAObject<M, G>> iterator() {
                return Iterators.transform(FCALibContext.this.cxt.rowHeads().iterator(), (Function)new Function<G, FCAObject<M, G>>(){

                    public FCAObject<M, G> apply(G object) {
                        return FCALibContext.this.getObject(object);
                    }
                });
            }

            public Object[] toArray() {
                return FCALibContext.this.cxt.rowHeads().toArray();
            }

            public <T> T[] toArray(T[] a) {
                return FCALibContext.this.cxt.rowHeads().toArray(a);
            }

            public boolean add(FCAObject<M, G> e) {
                return FCALibContext.this.cxt.rowHeads().add(e.getIdentifier()) && FCALibContext.this.cxt.row(e.getIdentifier()).addAll(((FullObjectDescription)e.getDescription()).getAttributes());
            }

            public boolean remove(Object o) {
                if (o instanceof FCAObject) {
                    return FCALibContext.this.cxt.rowHeads().remove(((FCAObject)o).getIdentifier());
                }
                return FCALibContext.this.cxt.rowHeads().remove(o);
            }

            public boolean containsAll(Collection<?> c) {
                boolean b = false;
                for (Object o : c) {
                    b |= this.contains(o);
                }
                return b;
            }

            public boolean addAll(Collection<? extends FCAObject<M, G>> c) {
                boolean b = false;
                for (FCAObject o : c) {
                    b |= this.add(o);
                }
                return b;
            }

            public boolean retainAll(Collection<?> c) {
                return false;
            }

            public boolean removeAll(Collection<?> c) {
                boolean b = false;
                for (Object o : c) {
                    b |= this.remove(o);
                }
                return b;
            }

            public void clear() {
                FCALibContext.this.cxt.rowHeads().clear();
            }

            public int getIndexOf(FCAObject<M, G> e) {
                return FCALibContext.this.cxt.rowHeads().indexOf(e.getIdentifier());
            }

            public FCAObject<M, G> getElementAt(int index) throws IndexOutOfBoundsException {
                return FCALibContext.this.getObjectAtIndex(index);
            }

            public void changeOrder() {
            }
        };
    }

    public boolean addObject(FCAObject<M, G> e) throws IllegalObjectException {
        return this.cxt.rowHeads().add(e.getIdentifier()) && this.cxt.row(e.getIdentifier()).addAll(((FullObjectDescription)e.getDescription()).getAttributes());
    }

    public boolean removeObject(G id) throws IllegalObjectException {
        return this.cxt.rowHeads().remove(id);
    }

    public boolean removeObject(FCAObject<M, G> object) throws IllegalObjectException {
        return this.cxt.rowHeads().remove(object.getIdentifier());
    }

    public boolean addAttributeToObject(M attribute, G id) throws IllegalAttributeException, IllegalObjectException {
        return this.cxt.add(id, attribute);
    }

    public Set<M> doublePrime(Set<M> x) {
        return this.cxt.intent(x);
    }

    public Set<FCAImplication<M>> getStemBase() {
        return null;
    }

    public boolean refutes(FCAImplication<M> imp) {
        return false;
    }

    public boolean isCounterExampleValid(FCAObject<M, G> counterExample, FCAImplication<M> imp) {
        return false;
    }

    protected boolean followsFromBackgroundKnowledge(FCAImplication<M> implication) {
        return false;
    }
}

