/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.context.temporal;

import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.context.temporal.LTL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TemporalContext<G, M> {
    private final List<MatrixContext<G, M>> cuts = new LinkedList<MatrixContext<G, M>>();

    public final MatrixContext<G, M> addTimepoint() {
        MatrixContext cxt = new MatrixContext(false);
        this.cuts.add(cxt);
        return cxt;
    }

    public final MatrixContext<G, M> atTimepoint(int t) {
        return this.cuts.get(t);
    }

    public final boolean hasTimepoint(int t) {
        return t < this.cuts.size();
    }

    public final int lastTimepoint() {
        return this.cuts.size() - 1;
    }

    public final int getLength() {
        return this.cuts.size();
    }

    public final boolean normalize() {
        boolean changed = false;
        HashSet objects = new HashSet();
        HashSet attributes = new HashSet();
        for (MatrixContext<G, M> cxt : this.cuts) {
            objects.addAll(cxt.rowHeads());
            attributes.addAll(cxt.colHeads());
        }
        for (MatrixContext<G, M> cxt : this.cuts) {
            changed |= cxt.rowHeads().addAll(objects);
            changed |= cxt.colHeads().addAll(attributes);
        }
        return changed;
    }

    public final boolean contains(G g, M m, Integer t) {
        return this.cuts.get(t).contains(g, m);
    }

    public final boolean contains(G g, LTL<M> m, Integer t) {
        switch (m.getType()) {
            case NOW: {
                return this.hasTimepoint(t) && this.atTimepoint(t).contains(g, m.getM());
            }
            case NEXTW: {
                return this.hasTimepoint(t + 1) && this.atTimepoint(t + 1).contains(g, m.getM());
            }
            case NEXTS: {
                return this.hasTimepoint(t + 1) && this.atTimepoint(t + 1).contains(g, m.getM()) || t.intValue() == this.lastTimepoint();
            }
            case SOMETIMES: {
                break;
            }
            case ALWAYS: 
            case UNTILW: {
                break;
            }
            case UNTILS: {
                break;
            }
        }
        return false;
    }

    public final MatrixContext<Pair<G, Integer>, LTL<M>> temporalScaling(Set<Integer> timepoints, Set<LTL<M>> ltlAttributes) {
        MatrixContext<Pair<G, Integer>, LTL<M>> cxt = new MatrixContext<Pair<G, Integer>, LTL<M>>(false);
        cxt.colHeads().addAll(ltlAttributes);
        for (Object g : this.cuts.get(0).rowHeads()) {
            if (timepoints == null) {
                for (int t = 0; t <= this.lastTimepoint(); ++t) {
                    Pair p = new Pair(g, t);
                    cxt.rowHeads().add(p);
                    for (LTL<M> m : ltlAttributes) {
                        if (!this.contains(g, m, (Integer)t)) continue;
                        cxt.addFastSilent(p, m);
                    }
                }
                continue;
            }
            for (int t : timepoints) {
                Pair p = new Pair(g, t);
                cxt.rowHeads().add(p);
                for (LTL<M> m : ltlAttributes) {
                    if (!this.contains(g, m, (Integer)t)) continue;
                    cxt.addFastSilent(p, m);
                }
            }
        }
        return cxt;
    }

    public final MatrixContext<Pair<G, Integer>, LTL<M>> temporalScaling(Set<LTL<M>> ltlAttributes) {
        return this.temporalScaling(null, ltlAttributes);
    }

    public final MatrixContext<Pair<G, Integer>, LTL<M>> temporalScaling() {
        return this.temporalScaling(null, this.getAllLTLAttributes());
    }

    public Set<LTL<M>> getAllLTLAttributes() {
        return this.getLTLAttributes(LTL.Type.values());
    }

    public Set<LTL<M>> getLTLAttributes(LTL.Type ... types) {
        HashSet<LTL<M>> ltlAttributes = new HashSet<LTL<M>>();
        block4: for (LTL.Type type : types) {
            switch (type) {
                case NOW: 
                case NEXTW: 
                case NEXTS: 
                case SOMETIMES: 
                case ALWAYS: {
                    for (Object m : this.cuts.get(0).colHeads()) {
                        ltlAttributes.add(new LTL(type, m));
                    }
                    continue block4;
                }
                case UNTILW: 
                case UNTILS: {
                    for (Object m : this.cuts.get(0).colHeads()) {
                        for (Object n : this.cuts.get(0).colHeads()) {
                            if (m.equals(n)) continue;
                            ltlAttributes.add(new LTL(type, m, n));
                        }
                    }
                    continue block4;
                }
            }
        }
        return ltlAttributes;
    }
}

